/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dao.mongo.links;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import de.taimos.dao.mongo.JongoFactory;
import de.taimos.dao.mongo.links.AReferenceableEntity;
import de.taimos.dao.mongo.links.DocumentLink;
import de.taimos.dao.mongo.links.IDLinkDAO;
import javax.annotation.PostConstruct;
import org.bson.types.ObjectId;
import org.jongo.Jongo;
import org.jongo.MongoCollection;
import org.springframework.beans.factory.annotation.Autowired;

public class DLinkDAO
implements IDLinkDAO {
    @Autowired
    private MongoClient mongo;
    private Jongo jongo;

    @PostConstruct
    public final void init() {
        String dbName = System.getProperty("mongodb.name");
        if (dbName == null) {
            throw new RuntimeException("Missing database name; Set system property 'mongodb.name'");
        }
        DB db = this.mongo.getDB(dbName);
        this.jongo = JongoFactory.createDefault(db);
    }

    @Override
    public <T extends AReferenceableEntity<T>> T resolve(DocumentLink<T> link) {
        MongoCollection collection = this.jongo.getCollection(link.getTargetClass().getSimpleName());
        return (T)((AReferenceableEntity)collection.findOne(new ObjectId(link.getObjectId())).as(link.getTargetClass()));
    }
}

