/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.notification.aws;

import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient;
import com.amazonaws.services.simpleemail.model.Body;
import com.amazonaws.services.simpleemail.model.Content;
import com.amazonaws.services.simpleemail.model.Destination;
import com.amazonaws.services.simpleemail.model.Message;
import com.amazonaws.services.simpleemail.model.SendEmailRequest;
import com.amazonaws.services.simpleemail.model.SendEmailResult;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import de.taimos.daemon.spring.annotations.ProdComponent;
import de.taimos.dvalin.cloud.aws.AWSClient;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.MailException;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;

@ProdComponent
public class AmazonSESMailSender
implements MailSender {
    public static final Logger LOGGER = LoggerFactory.getLogger(AmazonSESMailSender.class);
    @AWSClient(region="${aws.mailregion:}")
    private AmazonSimpleEmailServiceClient sesClient;

    public void send(SimpleMailMessage message) throws MailException {
        Preconditions.checkNotNull((Object)message);
        Preconditions.checkNotNull((Object)message.getTo());
        Preconditions.checkNotNull((Object)message.getFrom());
        Preconditions.checkNotNull((Object)message.getSubject());
        Preconditions.checkNotNull((Object)message.getText());
        SendEmailRequest req = new SendEmailRequest();
        req.setSource(message.getFrom());
        if (message.getReplyTo() != null && !message.getReplyTo().isEmpty()) {
            req.setReplyToAddresses((Collection)Lists.newArrayList((Object[])new String[]{message.getReplyTo()}));
        }
        Destination dest = new Destination();
        dest.withToAddresses(message.getTo());
        if (message.getCc() != null) {
            dest.withCcAddresses(message.getCc());
        }
        if (message.getBcc() != null) {
            dest.withBccAddresses(message.getBcc());
        }
        req.setDestination(dest);
        Body sesBody = new Body().withHtml(new Content(message.getText()));
        Content subject = new Content(message.getSubject());
        req.setMessage(new Message().withSubject(subject).withBody(sesBody));
        SendEmailResult emailResult = this.sesClient.sendEmail(req);
        LOGGER.info("Sent mail over SES with message id {}", (Object)emailResult.getMessageId());
    }

    public void send(SimpleMailMessage ... simpleMailMessages) throws MailException {
        for (SimpleMailMessage message : simpleMailMessages) {
            this.send(message);
        }
    }
}

