/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.jaxrs.websocket;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.taimos.dvalin.jaxrs.MapperFactory;
import java.io.IOException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServerJSONWebSocketAdapter<T>
extends WebSocketAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerJSONWebSocketAdapter.class);
    private final ObjectMapper mapper = MapperFactory.createDefault();

    public final void onWebSocketText(String message) {
        if (message == null || message.isEmpty()) {
            LOGGER.info("Got empty socket data");
            this.onWebSocketEmptyMessage();
            return;
        }
        try {
            Object msg = this.mapper.readValue(message, this.getObjectType());
            this.onWebSocketObject(msg);
        }
        catch (IOException e1) {
            LOGGER.info("Got invalid message", (Throwable)e1);
            this.onWebSocketInvalidMessage(message);
            return;
        }
    }

    protected void onWebSocketEmptyMessage() {
    }

    protected void onWebSocketInvalidMessage(String message) {
    }

    protected abstract Class<T> getObjectType();

    protected abstract void onWebSocketObject(T var1);

    protected <C> C convert(Object object, Class<C> targetClass) {
        return (C)this.mapper.convertValue(object, targetClass);
    }

    protected final void sendObjectToSocket(final Object objectToSend) {
        this.sendObjectToSocket(objectToSend, new WriteCallback(){

            public void writeSuccess() {
                LOGGER.debug("Send data to socket: {}", objectToSend);
            }

            public void writeFailed(Throwable x) {
                LOGGER.error("Error sending message to socket", x);
            }
        });
    }

    protected final void sendObjectToSocket(Object objectToSend, WriteCallback cb) {
        Session sess = this.getSession();
        if (sess != null) {
            String json;
            try {
                json = this.mapper.writeValueAsString(objectToSend);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Failed to serialize object", e);
            }
            sess.getRemote().sendString(json, cb);
        }
    }
}

