/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.jaxrs.swagger;

import de.taimos.dvalin.jaxrs.ServiceAnnotationClassesProvider;
import io.swagger.config.Scanner;
import io.swagger.config.ScannerFactory;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SwaggerScanner
implements Scanner {
    @Autowired
    private ServiceAnnotationClassesProvider annotationProvider;

    @PostConstruct
    public void init() {
        ScannerFactory.setScanner((Scanner)this);
    }

    public Set<Class<?>> classes() {
        HashSet classes = new HashSet();
        for (Class<?> clz : this.annotationProvider.getClasses()) {
            if (this.hasAnnotation(clz, Provider.class) || !clz.isAnnotationPresent(Path.class)) continue;
            classes.add(clz);
        }
        return classes;
    }

    private boolean hasAnnotation(Class<?> clz, Class<? extends Annotation> ann) {
        if (clz.isAnnotationPresent(ann)) {
            return true;
        }
        for (Class<?> iface : clz.getInterfaces()) {
            if (!this.hasAnnotation(iface, ann)) continue;
            return true;
        }
        return clz.getSuperclass() != null && this.hasAnnotation(clz.getSuperclass(), ann);
    }

    public boolean getPrettyPrint() {
        return false;
    }

    public void setPrettyPrint(boolean shouldPrettyPrint) {
    }
}

