/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.jaxrs.security.basicauth;

import de.taimos.daemon.spring.conditional.BeanAvailable;
import de.taimos.dvalin.jaxrs.JaxRsComponent;
import de.taimos.dvalin.jaxrs.providers.AuthorizationProvider;
import de.taimos.dvalin.jaxrs.security.basicauth.IBasicAuthUserDAO;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.HttpHeaders;
import org.apache.commons.codec.binary.Base64;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.SecurityContext;
import org.springframework.beans.factory.annotation.Autowired;

@JaxRsComponent
@BeanAvailable(value=IBasicAuthUserDAO.class)
public class BasicAuthFilter
extends AuthorizationProvider {
    @Autowired
    private IBasicAuthUserDAO basicAuthUserDAO;

    @Override
    protected boolean isAuthorizationMandatory() {
        return false;
    }

    @Override
    protected SecurityContext handleAuthHeader(ContainerRequestContext requestContext, Message msg, String type, String auth) {
        if (auth != null && type.toLowerCase().equals("basic")) {
            String decoded = new String(Base64.decodeBase64((String)auth));
            if (decoded == null || !decoded.contains(":")) {
                return null;
            }
            String username = decoded.substring(0, decoded.indexOf(":"));
            String pwd = decoded.substring(decoded.indexOf(":") + 1);
            return this.loginUser(msg, this.basicAuthUserDAO.getUserByNameAndPassword(username, pwd));
        }
        return null;
    }

    @Override
    protected SecurityContext handleOther(ContainerRequestContext requestContext, Message msg, HttpHeaders head) {
        return null;
    }
}

