/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.jaxrs.security;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import de.taimos.dvalin.jaxrs.JaxRsAnnotationScanner;
import de.taimos.dvalin.jaxrs.JaxRsComponent;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Priority;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@JaxRsComponent
@Priority(value=2000)
public class RolesFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RolesFilter.class);

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Message m = JAXRSUtils.getCurrentMessage();
        Method method = (Method)m.get((Object)"org.apache.cxf.resource.method");
        List<RolesAllowed> list = JaxRsAnnotationScanner.searchForAnnotation(method, RolesAllowed.class);
        ArrayList needed = new ArrayList();
        for (RolesAllowed rolesAllowed : list) {
            needed.addAll(Lists.newArrayList((Object[])rolesAllowed.value()));
        }
        if (needed.isEmpty()) {
            LOGGER.debug("No roles needed");
            return;
        }
        LOGGER.debug("Needs: {}", (Object)Joiner.on((String)",").join(needed));
        SecurityContext securityContext = (SecurityContext)m.get(SecurityContext.class);
        if (securityContext != null) {
            for (String need : needed) {
                if (!securityContext.isUserInRole(need)) continue;
                LOGGER.debug("Passed with role {}", (Object)need);
                return;
            }
        }
        String string = "Missing at least one of the following roles: " + Joiner.on((String)",").join(needed);
        requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)string).build());
    }
}

