/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.jaxrs.security;

import de.taimos.dvalin.jaxrs.JaxRsAnnotationScanner;
import de.taimos.dvalin.jaxrs.JaxRsComponent;
import de.taimos.dvalin.jaxrs.security.annotation.LoggedIn;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@JaxRsComponent
@Priority(value=2000)
public class LoggedInFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggedInFilter.class);

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Message m = JAXRSUtils.getCurrentMessage();
        Method method = (Method)m.get((Object)"org.apache.cxf.resource.method");
        if (!JaxRsAnnotationScanner.hasAnnotation(method, LoggedIn.class)) {
            LOGGER.debug("No login mandatory");
            return;
        }
        LOGGER.debug("Login mandatory");
        SecurityContext securityContext = (SecurityContext)m.get(SecurityContext.class);
        if (securityContext == null || securityContext.getUserPrincipal() == null) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }
}

