/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.jaxrs.security;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;

public class HashedPassword {
    private static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();
    private static final int DEFAULT_ROUNDOFFSET = 5000;
    private static final int PW_ROUNDBYTES = 2;
    private int roundOffset;
    private String hash;
    private String salt;

    public HashedPassword() {
    }

    public HashedPassword(String password) {
        SHA512Digest sha512Digest = new SHA512Digest();
        this.setSalt(HashedPassword.asHex(HashedPassword.getRandomBytes(sha512Digest.getDigestSize())));
        this.setRoundOffset(5000);
        this.setHash(HashedPassword.hashPassword(password, this.salt, this.roundOffset));
    }

    public HashedPassword(int roundOffset, String hash, String salt) {
        this.roundOffset = roundOffset;
        this.hash = hash;
        this.salt = salt;
    }

    public int getRoundOffset() {
        return this.roundOffset;
    }

    public void setRoundOffset(int roundOffset) {
        this.roundOffset = roundOffset;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)hash) ? 1 : 0) != 0);
        this.hash = hash;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)salt) ? 1 : 0) != 0);
        this.salt = salt;
    }

    public boolean validate(String password) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)password) ? 1 : 0) != 0);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.hash) ? 1 : 0) != 0);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.salt) ? 1 : 0) != 0);
        return HashedPassword.hashPassword(password, this.salt, this.roundOffset).equals(this.hash);
    }

    private static byte[] getRandomBytes(int size) {
        SecureRandom sr = new SecureRandom();
        byte[] result = new byte[size];
        sr.nextBytes(result);
        return result;
    }

    private static String hashPassword(String password, String salt, int roundOffset) {
        int pwRounds;
        int totalRounds;
        byte[] saltBytes;
        SHA512Digest digest = new SHA512Digest();
        byte[] passwordBytes = HashedPassword.stringToUTF8Bytes(password);
        PBEParametersGenerator generator = HashedPassword.getGenerator((Digest)digest, passwordBytes, saltBytes = salt == null ? new byte[]{} : HashedPassword.stringToUTF8Bytes(salt), totalRounds = roundOffset + (pwRounds = HashedPassword.roundsFromPassword((Digest)digest, passwordBytes, saltBytes, 2)));
        CipherParameters cp = generator.generateDerivedMacParameters(digest.getDigestSize() * 8);
        if (cp instanceof KeyParameter) {
            KeyParameter kp = (KeyParameter)cp;
            return HashedPassword.asHex(kp.getKey());
        }
        throw new RuntimeCryptoException("Invalid CipherParameter: " + cp);
    }

    private static String asHex(byte[] bytes) {
        char[] chars = new char[2 * bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            chars[2 * i] = HEX_CHARS[(bytes[i] & 0xF0) >>> 4];
            chars[2 * i + 1] = HEX_CHARS[bytes[i] & 0xF];
        }
        return new String(chars);
    }

    private static byte[] stringToUTF8Bytes(String s) {
        return PBEParametersGenerator.PKCS5PasswordToUTF8Bytes((char[])s.toCharArray());
    }

    private static PBEParametersGenerator getGenerator(Digest digest, byte[] pwBytes, byte[] saltBytes, int rounds) {
        PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator(digest);
        generator.init(pwBytes, saltBytes, rounds);
        return generator;
    }

    private static int roundsFromPassword(Digest digest, byte[] pwBytes, byte[] saltBytes, int pwRoundBytes) {
        PBEParametersGenerator generator = HashedPassword.getGenerator(digest, pwBytes, saltBytes, 1);
        CipherParameters cp = generator.generateDerivedMacParameters(Math.min(pwRoundBytes * 8, 31));
        if (cp instanceof KeyParameter) {
            KeyParameter kp = (KeyParameter)cp;
            String key = HashedPassword.asHex(kp.getKey());
            return Integer.valueOf(key, 16);
        }
        throw new RuntimeCryptoException("Invalid CipherParameter: " + cp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashedPassword that = (HashedPassword)o;
        if (this.roundOffset != that.roundOffset) {
            return false;
        }
        if (this.hash != null ? !this.hash.equals(that.hash) : that.hash != null) {
            return false;
        }
        return this.salt != null ? this.salt.equals(that.salt) : that.salt == null;
    }

    public int hashCode() {
        int result = this.roundOffset;
        result = 31 * result + (this.hash != null ? this.hash.hashCode() : 0);
        result = 31 * result + (this.salt != null ? this.salt.hashCode() : 0);
        return result;
    }
}

