/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.jaxrs.remote;

import de.taimos.dvalin.jaxrs.remote.RemoteService;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringValueResolver;

@Component
public class RemoteServiceBeanPostProcessor
implements InstantiationAwareBeanPostProcessor,
EmbeddedValueResolverAware,
BeanFactoryAware,
Serializable {
    private transient ConfigurableListableBeanFactory beanFactory;
    private transient StringValueResolver resolver;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) throws BeansException {
        return null;
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        return true;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        InjectionMetadata metadata = this.buildResourceMetadata(bean.getClass());
        try {
            metadata.inject(bean, beanName, pvs);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Injection of resource dependencies failed", ex);
        }
        return pvs;
    }

    private InjectionMetadata buildResourceMetadata(Class<?> clazz) {
        LinkedList elements = new LinkedList();
        Class<?> targetClass = clazz;
        do {
            LinkedList<RemoteServiceElement> currElements = new LinkedList<RemoteServiceElement>();
            for (Field field : targetClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(RemoteService.class)) continue;
                if (Modifier.isStatic(field.getModifiers())) {
                    throw new IllegalStateException("@RemoteService annotation is not supported on static fields");
                }
                currElements.add(new RemoteServiceElement(field, field, null));
            }
            for (AccessibleObject accessibleObject : targetClass.getDeclaredMethods()) {
                Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)accessibleObject);
                if (!BridgeMethodResolver.isVisibilityBridgeMethodPair((Method)accessibleObject, (Method)bridgedMethod) || !((Method)accessibleObject).equals(ClassUtils.getMostSpecificMethod((Method)accessibleObject, clazz)) || !bridgedMethod.isAnnotationPresent(RemoteService.class)) continue;
                if (Modifier.isStatic(((Method)accessibleObject).getModifiers())) {
                    throw new IllegalStateException("@RemoteService annotation is not supported on static methods");
                }
                if (((Method)accessibleObject).getParameterTypes().length != 1) {
                    throw new IllegalStateException("@RemoteService annotation requires a single-arg method: " + accessibleObject);
                }
                PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)bridgedMethod, clazz);
                currElements.add(new RemoteServiceElement((Member)((Object)accessibleObject), bridgedMethod, pd));
            }
            elements.addAll(0, currElements);
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return new InjectionMetadata(clazz, elements);
    }

    private class RemoteServiceElement
    extends InjectionMetadata.InjectedElement {
        private final String serviceName;
        private final String baseURL;

        public RemoteServiceElement(Member member, AnnotatedElement ae, PropertyDescriptor pd) {
            super(member, pd);
            RemoteService resource = ae.getAnnotation(RemoteService.class);
            this.serviceName = resource.name();
            this.baseURL = resource.baseURL();
        }

        private DependencyDescriptor getDependencyDescriptor() {
            if (this.isField) {
                return new DependencyDescriptor((Field)this.member, true);
            }
            return new DependencyDescriptor(new MethodParameter((Method)this.member, 0), true);
        }

        protected Object getResourceToInject(Object target, String requestingBeanName) {
            Object value;
            try {
                value = RemoteServiceBeanPostProcessor.this.beanFactory.resolveDependency(this.getDependencyDescriptor(), requestingBeanName);
            }
            catch (NoSuchBeanDefinitionException notFound) {
                String url;
                if (this.serviceName != null && !this.serviceName.isEmpty()) {
                    String proto = RemoteServiceBeanPostProcessor.this.resolver.resolveStringValue(String.format("${%s.protocol:http}", this.serviceName));
                    String host = RemoteServiceBeanPostProcessor.this.resolver.resolveStringValue(String.format("${%s.host:localhost}", this.serviceName));
                    String port = RemoteServiceBeanPostProcessor.this.resolver.resolveStringValue(String.format("${%s.port}", this.serviceName));
                    url = String.format("%s://%s:%s", proto, host, port);
                } else if (this.baseURL != null && !this.baseURL.isEmpty()) {
                    url = this.baseURL;
                } else {
                    throw new RuntimeException("Either service name or base URL must not be empty");
                }
                value = JAXRSClientFactory.create((String)url, (Class)this.getDependencyDescriptor().getDependencyType());
            }
            return value;
        }
    }
}

