/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.jaxrs.providers;

import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=4000)
public class WebExceptionMapper
implements ExceptionMapper<WebApplicationException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebExceptionMapper.class);

    public Response toResponse(WebApplicationException ex) {
        Response r = ex.getResponse();
        if (r == null) {
            r = Response.serverError().build();
        }
        if (this.logError(ex, r)) {
            LOGGER.warn(ex.getMessage(), (Throwable)ex);
        }
        return r;
    }

    protected boolean logError(WebApplicationException ex, Response r) {
        return r.getStatus() >= 500 && r.getStatus() <= 599;
    }
}

