/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.jaxrs;

public final class URLUtils {
    private URLUtils() {
    }

    public static SplitURL splitURL(String url) {
        int startHost;
        int iPath;
        int iPort;
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("Invalid URL");
        }
        String scheme = null;
        String host = null;
        String port = null;
        String path = null;
        int iScheme = url.indexOf("://");
        if (iScheme != -1) {
            scheme = url.substring(0, iScheme);
            int beginIndex = iScheme + 3;
            String schemeless = url.substring(beginIndex);
            iPort = schemeless.contains(":") ? schemeless.indexOf(58) + beginIndex : -1;
            iPath = schemeless.contains("/") ? schemeless.indexOf(47) + beginIndex : -1;
        } else {
            scheme = "http";
            iPort = url.lastIndexOf(":");
            iPath = url.indexOf(47);
        }
        int n = startHost = iScheme == -1 ? 0 : iScheme + 3;
        int endHost = iPort == -1 ? (iPath == -1 ? url.length() : iPath) : iPort;
        host = url.substring(startHost, endHost);
        if (iPort != -1) {
            port = url.substring(iPort + 1, iPath == -1 ? url.length() : iPath);
        } else {
            switch (scheme) {
                case "http": 
                case "ws": {
                    port = "80";
                    break;
                }
                case "https": 
                case "wss": {
                    port = "443";
                    break;
                }
                default: {
                    port = "";
                }
            }
        }
        path = iPath != -1 ? url.substring(iPath) : "/";
        return new SplitURL(scheme, host, port, path);
    }

    public static class SplitURL {
        private final String scheme;
        private final String host;
        private final String port;
        private final String path;

        private SplitURL(String scheme, String host, String port, String path) {
            this.scheme = scheme;
            this.host = host;
            this.port = port;
            this.path = path;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public String getPath() {
            return this.path;
        }
    }
}

