/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.jaxrs;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JaxRsAnnotationScanner {
    public static final Logger LOGGER = LoggerFactory.getLogger(JaxRsAnnotationScanner.class);

    private JaxRsAnnotationScanner() {
    }

    public static boolean hasAnnotation(Method method, Class<? extends Annotation> annotation) {
        return !JaxRsAnnotationScanner.searchForAnnotation(method, annotation).isEmpty();
    }

    public static <T extends Annotation> List<T> searchForAnnotation(Method method, Class<T> annotation) {
        if (method == null) {
            return Lists.newArrayList();
        }
        return JaxRsAnnotationScanner.searchClasses(method, annotation, method.getDeclaringClass());
    }

    private static <T extends Annotation> List<T> searchClasses(Method m, Class<T> annotation, Class<?> ... classes) {
        ArrayList<T> annotations = new ArrayList<T>();
        for (Class<?> clazz : classes) {
            if (clazz.isAnnotationPresent(annotation)) {
                annotations.add(clazz.getAnnotation(annotation));
            }
            try {
                Method iMeth = clazz.getMethod(m.getName(), m.getParameterTypes());
                if (iMeth.isAnnotationPresent(annotation)) {
                    annotations.add(iMeth.getAnnotation(annotation));
                }
            }
            catch (NoSuchMethodException | SecurityException iMeth) {
                // empty catch block
            }
            if (clazz.getInterfaces().length != 0) {
                Class<?>[] interfaces = clazz.getInterfaces();
                annotations.addAll(JaxRsAnnotationScanner.searchClasses(m, annotation, interfaces));
            }
            if (clazz.getSuperclass() == null || clazz.getSuperclass().equals(Object.class)) continue;
            annotations.addAll(JaxRsAnnotationScanner.searchClasses(m, annotation, clazz.getSuperclass()));
        }
        return annotations;
    }
}

