/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.jaxrs;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.taimos.dvalin.jaxrs.MapperFactory;
import de.taimos.dvalin.jaxrs.ServiceAnnotationClassesProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;

@Configuration
@ImportResource(value={"classpath*:spring/jaxrs-server.xml", "classpath*:spring/jetty.xml"})
public class JAXRSConfig {
    @Value(value="${jaxrs.annotation:de.taimos.dvalin.jaxrs.JaxRsComponent}")
    private String serviceAnnotation;

    @Bean(name={"objectMapper"})
    public ObjectMapper createMapper() {
        return MapperFactory.createDefault();
    }

    @Bean(name={"classesProvider"})
    public ServiceAnnotationClassesProvider createServiceAnnotationClassesProvider() {
        ServiceAnnotationClassesProvider provider = new ServiceAnnotationClassesProvider();
        try {
            provider.setServiceAnnotation(Class.forName(this.serviceAnnotation));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load JAX-RS service annotation", e);
        }
        return provider;
    }
}

