/*
 * Decompiled with CFR 0.152.
 */
package de.svenkubiak.jpushover;

import de.svenkubiak.jpushover.JPushoverResponse;
import de.svenkubiak.jpushover.enums.Constants;
import de.svenkubiak.jpushover.enums.Priority;
import de.svenkubiak.jpushover.enums.Sound;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JPushover {
    private static final Logger LOG = LogManager.getLogger(JPushover.class);
    private static final int HTTP_OK = 200;
    private String pushoverToken;
    private String pushoverUser;
    private String pushoverMessage;
    private String pushoverDevice;
    private String pushoverTitle;
    private String pushoverUrl;
    private String pushoverUrlTitle;
    private String pushoverTimestamp;
    private String pushoverRetry;
    private String pushoverExpire;
    private String pushoverCallback;
    private File pushoverAttachment;
    private boolean pushoverHtml;
    private Priority pushoverPriority;
    private Sound pushoverSound;

    public JPushover() {
        this.withSound(Sound.PUSHOVER);
        this.withPriority(Priority.NORMAL);
    }

    public static JPushover build() {
        return new JPushover();
    }

    public final JPushover withToken(String string) {
        this.pushoverToken = string;
        return this;
    }

    public final JPushover withUser(String string) {
        this.pushoverUser = string;
        return this;
    }

    public final JPushover withRetry(String string) {
        this.pushoverRetry = string;
        return this;
    }

    public final JPushover withAttachment(File file) {
        this.pushoverAttachment = file;
        return this;
    }

    public final JPushover withExpire(String string) {
        this.pushoverExpire = string;
        return this;
    }

    public final JPushover withMessage(String string) {
        this.pushoverMessage = string;
        return this;
    }

    public final JPushover withDevice(String string) {
        this.pushoverDevice = string;
        return this;
    }

    public final JPushover withTitle(String string) {
        this.pushoverTitle = string;
        return this;
    }

    public final JPushover withUrl(String string) {
        this.pushoverUrl = string;
        return this;
    }

    public final JPushover enableHtml() {
        this.pushoverHtml = true;
        return this;
    }

    public final JPushover withUrlTitle(String string) {
        this.pushoverUrlTitle = string;
        return this;
    }

    public final JPushover withTimestamp(String string) {
        this.pushoverTimestamp = string;
        return this;
    }

    public final JPushover withPriority(Priority priority) {
        this.pushoverPriority = priority;
        return this;
    }

    public final JPushover withSound(Sound sound) {
        this.pushoverSound = sound;
        return this;
    }

    public final JPushover withCallback(String string) {
        this.pushoverCallback = string;
        return this;
    }

    public boolean validate() {
        Objects.requireNonNull(this.pushoverToken, "Token is required for validation");
        Objects.requireNonNull(this.pushoverUser, "User is required for validation");
        List list = Form.form().add(Constants.TOKEN.toString(), this.pushoverToken).add(Constants.USER.toString(), this.pushoverUser).add(Constants.DEVICE.toString(), this.pushoverDevice).build();
        boolean bl = false;
        try {
            String string;
            HttpResponse httpResponse = Request.Post((String)Constants.VALIDATION_URL.toString()).bodyForm((Iterable)list, Consts.UTF_8).execute().returnResponse();
            if (httpResponse != null && httpResponse.getStatusLine().getStatusCode() == 200 && StringUtils.isNotBlank((CharSequence)(string = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)Consts.UTF_8))) && string.contains("\"status\":1")) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            LOG.error("Failed to send validation requeste to pushover", (Throwable)iOException);
        }
        return bl;
    }

    public final JPushoverResponse push() {
        Objects.requireNonNull(this.pushoverToken, "Token is required for a message");
        Objects.requireNonNull(this.pushoverUser, "User is required for a message");
        Objects.requireNonNull(this.pushoverMessage, "Message is required for a message");
        if (Priority.EMERGENCY.equals((Object)this.pushoverPriority)) {
            Objects.requireNonNull(this.pushoverRetry, "Retry is required on priority emergency");
            Objects.requireNonNull(this.pushoverExpire, "Expire is required on priority emergency");
        }
        HttpPost httpPost = new HttpPost(Constants.MESSAGES_URL.toString());
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.addTextBody(Constants.TOKEN.toString(), this.pushoverToken);
        multipartEntityBuilder.addTextBody(Constants.USER.toString(), this.pushoverUser);
        multipartEntityBuilder.addTextBody(Constants.MESSAGE.toString(), this.pushoverMessage);
        if (StringUtils.isNotBlank((CharSequence)this.pushoverDevice)) {
            multipartEntityBuilder.addTextBody(Constants.DEVICE.toString(), this.pushoverDevice);
        }
        if (StringUtils.isNotBlank((CharSequence)this.pushoverTitle)) {
            multipartEntityBuilder.addTextBody(Constants.DEVICE.toString(), this.pushoverTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)this.pushoverTitle)) {
            multipartEntityBuilder.addTextBody(Constants.TITLE.toString(), this.pushoverTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)this.pushoverUrl)) {
            multipartEntityBuilder.addTextBody(Constants.URL.toString(), this.pushoverUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.pushoverRetry)) {
            multipartEntityBuilder.addTextBody(Constants.RETRY.toString(), this.pushoverRetry);
        }
        if (StringUtils.isNotBlank((CharSequence)this.pushoverExpire)) {
            multipartEntityBuilder.addTextBody(Constants.EXPIRE.toString(), this.pushoverExpire);
        }
        if (StringUtils.isNotBlank((CharSequence)this.pushoverCallback)) {
            multipartEntityBuilder.addTextBody(Constants.CALLBACK.toString(), this.pushoverCallback);
        }
        if (StringUtils.isNotBlank((CharSequence)this.pushoverUrlTitle)) {
            multipartEntityBuilder.addTextBody(Constants.URLTITLE.toString(), this.pushoverUrlTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)this.pushoverPriority.toString())) {
            multipartEntityBuilder.addTextBody(Constants.PRIORITY.toString(), this.pushoverPriority.toString());
        }
        if (StringUtils.isNotBlank((CharSequence)this.pushoverTimestamp)) {
            multipartEntityBuilder.addTextBody(Constants.TIMESTAMP.toString(), this.pushoverTimestamp);
        }
        if (StringUtils.isNotBlank((CharSequence)this.pushoverSound.toString())) {
            multipartEntityBuilder.addTextBody(Constants.SOUND.toString(), this.pushoverSound.toString());
        }
        if (this.pushoverAttachment != null) {
            multipartEntityBuilder.addBinaryBody(Constants.ATTACHMENT.toString(), this.pushoverAttachment, ContentType.APPLICATION_OCTET_STREAM, "file.ext");
        }
        multipartEntityBuilder.addTextBody(Constants.SOUND.toString(), this.pushoverHtml ? "1" : "0");
        HttpEntity httpEntity = multipartEntityBuilder.build();
        httpPost.setEntity(httpEntity);
        JPushoverResponse jPushoverResponse = new JPushoverResponse().isSuccessful(false);
        try {
            CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            if (closeableHttpResponse != null) {
                int n = closeableHttpResponse.getStatusLine().getStatusCode();
                jPushoverResponse = jPushoverResponse.httpStatus(n).response(IOUtils.toString((InputStream)closeableHttpResponse.getEntity().getContent(), (Charset)Consts.UTF_8)).isSuccessful(n == 200);
            }
            closeableHttpClient.close();
        }
        catch (IOException iOException) {
            LOG.error("Failed to send message to pushover", (Throwable)iOException);
        }
        return null;
    }

    public String getToken() {
        return this.pushoverToken;
    }

    public String getUser() {
        return this.pushoverUser;
    }

    public String getMessage() {
        return this.pushoverMessage;
    }

    public String getDevice() {
        return this.pushoverDevice;
    }

    public String getTitle() {
        return this.pushoverTitle;
    }

    public String getUrl() {
        return this.pushoverUrl;
    }

    public String getUrlTitle() {
        return this.pushoverUrlTitle;
    }

    public String getTimestamp() {
        return this.pushoverTimestamp;
    }

    public String getRetry() {
        return this.pushoverRetry;
    }

    public File getAttachment() {
        return this.pushoverAttachment;
    }

    public String getExpire() {
        return this.pushoverExpire;
    }

    public String getCallback() {
        return this.pushoverCallback;
    }

    public Priority getPriority() {
        return this.pushoverPriority;
    }

    public Sound getSound() {
        return this.pushoverSound;
    }

    public boolean isHtml() {
        return this.pushoverHtml;
    }
}

