/*
 * Decompiled with CFR 0.152.
 */
package de.svenkubiak.embeddedmongodb;

import com.mongodb.MongoClient;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodProcess;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.MongodConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.slf4j.LoggerFactory;

public enum EmbeddedMongo {
    DB;

    private static final int MIN_PORT = 1025;
    private static final int MAX_PORT = 50000;
    private static final String ALGORITHM = "SHA1PRNG";
    private transient MongodProcess mongodProcess;
    private boolean active;
    private boolean mongoIPv6;
    private String mongoHost = "localhost";
    private int mongoPort;

    private EmbeddedMongo() {
        try {
            this.mongoPort = SecureRandom.getInstance(ALGORITHM).nextInt(50000) + 1025;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LoggerFactory.getLogger(EmbeddedMongo.class).error("Failed to init EmbeddedMongo", (Throwable)noSuchAlgorithmException);
        }
    }

    public EmbeddedMongo port(int n) {
        this.mongoPort = n;
        return this;
    }

    public EmbeddedMongo host(String string) {
        this.mongoHost = string;
        return this;
    }

    public EmbeddedMongo ipv6(boolean bl) {
        this.mongoIPv6 = bl;
        return this;
    }

    public void start() {
        if (!this.active) {
            try {
                this.mongodProcess = (MongodProcess)((MongodExecutable)MongodStarter.getDefaultInstance().prepare((IExecutableProcessConfig)new MongodConfigBuilder().version((IFeatureAwareVersion)Version.Main.V3_3).net(new Net(this.mongoHost, this.mongoPort, this.mongoIPv6)).build())).start();
                LoggerFactory.getLogger(EmbeddedMongo.class).info("Successfully started EmbeddedMongoDB @ {}:{}", (Object)this.mongoHost, (Object)this.mongoPort);
                this.active = true;
            }
            catch (IOException iOException) {
                LoggerFactory.getLogger(EmbeddedMongo.class).error("Failed to start EmbeddedMongoDB", (Throwable)iOException);
            }
        }
    }

    public void stop() {
        if (this.active) {
            this.mongodProcess.stop();
            this.active = false;
            LoggerFactory.getLogger(EmbeddedMongo.class).info("Successfully stopped EmbeddedMongoDB @ {}:{}", (Object)this.mongoHost, (Object)this.mongoPort);
        }
    }

    public MongoClient getMongoClient() {
        return new MongoClient(this.getHost(), this.getPort());
    }

    public int getPort() {
        return this.mongoPort;
    }

    public String getHost() {
        return this.mongoHost;
    }

    public boolean isIPv6() {
        return this.mongoIPv6;
    }
}

