/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.isolator.Driver;
import de.sormuras.junit.platform.isolator.GroupArtifact;
import de.sormuras.junit.platform.isolator.TestMode;
import de.sormuras.junit.platform.isolator.Version;
import de.sormuras.junit.platform.maven.plugin.Isolation;
import de.sormuras.junit.platform.maven.plugin.JUnitPlatformMojo;
import de.sormuras.junit.platform.maven.plugin.Tweaks;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;

class MavenDriver
implements Driver {
    private final JUnitPlatformMojo mojo;
    private final List<RemoteRepository> repositories;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession session;

    MavenDriver(JUnitPlatformMojo mojo) {
        this.mojo = mojo;
        this.repositories = new ArrayList<RemoteRepository>();
        this.repositories.addAll(mojo.getMavenProject().getRemotePluginRepositories());
        this.repositories.addAll(mojo.getMavenProject().getRemoteProjectRepositories());
        this.repositorySystem = mojo.getMavenResolver();
        this.session = mojo.getMavenRepositorySession();
    }

    public void debug(String format, Object ... objects) {
        this.mojo.debug(format, objects);
    }

    public void info(String format, Object ... objects) {
        this.mojo.info(format, objects);
    }

    public void warn(String format, Object ... objects) {
        this.mojo.warn(format, objects);
    }

    public void error(String format, Object ... objects) {
        this.mojo.error(format, objects);
    }

    Map<String, Set<String>> buildPathMap(Path targetPath) {
        MavenProject project = this.mojo.getMavenProject();
        Tweaks tweaks = this.mojo.getTweaks();
        LinkedHashSet<String> mainPaths = new LinkedHashSet<String>();
        LinkedHashSet<String> testPaths = new LinkedHashSet<String>();
        LinkedHashSet<String> launcherPaths = new LinkedHashSet<String>();
        LinkedHashSet<String> isolatorPaths = new LinkedHashSet<String>();
        try {
            MavenDriver.addAll(project.getCompileClasspathElements(), mainPaths);
            MavenDriver.addAll(project.getRuntimeClasspathElements(), mainPaths);
            LinkedHashSet<String> excludePaths = new LinkedHashSet<String>(project.getCompileClasspathElements());
            if (tweaks.moveTestEnginesToLauncherClassLoader) {
                this.locate(GroupArtifact.JUNIT_JUPITER).ifPresent(excludePaths::add);
                this.locate(GroupArtifact.JUNIT_JUPITER_ENGINE).ifPresent(excludePaths::add);
                this.locate("org.junit.platform:junit-platform-engine").ifPresent(excludePaths::add);
            }
            MavenDriver.addAll(project.getTestClasspathElements(), excludePaths, testPaths);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new RuntimeException("Resolution required!", e);
        }
        if (this.mojo.getProjectModules().getMode() == TestMode.MODULAR_PATCHED_TEST_RUNTIME) {
            Iterator<String> patchedDirectory = targetPath.resolve("patched-test-runtime").toString();
            String mainDirectory = project.getBuild().getOutputDirectory();
            String testDirectory = project.getBuild().getTestOutputDirectory();
            mainPaths.remove(project.getBuild().getOutputDirectory());
            testPaths.remove(project.getBuild().getTestOutputDirectory());
            testPaths.add((String)((Object)patchedDirectory));
            try {
                Path patchedDirPath = Paths.get(patchedDirectory, new String[0]);
                if (Files.exists(patchedDirPath, new LinkOption[0])) {
                    try (Stream<Path> pathStream = Files.walk(patchedDirPath, new FileVisitOption[0]);){
                        pathStream.sorted(Comparator.reverseOrder()).forEach(p -> p.toFile().delete());
                    }
                }
                this.copyDirectoryStructure(mainDirectory, (String)((Object)patchedDirectory), false);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Populating patched directory with main one failed: " + patchedDirectory, e);
            }
            try {
                this.copyDirectoryStructure(testDirectory, (String)((Object)patchedDirectory), true);
            }
            catch (IOException e) {
                if (tweaks.failIfNoTests) {
                    throw new UncheckedIOException("Populating patched directory with test one failed: " + patchedDirectory, e);
                }
                this.debug("Patched directory {0} was not found and failIfNoTests is set to false", patchedDirectory);
            }
        }
        MavenDriver.addAll(tweaks.additionalTestPathElements, testPaths);
        MavenDriver.addAll(tweaks.additionalLauncherPathElements, launcherPaths);
        try {
            for (String coordinates : tweaks.additionalTestDependencies) {
                testPaths.addAll(this.resolve(coordinates));
            }
            for (String coordinates : tweaks.additionalLauncherDependencies) {
                launcherPaths.addAll(this.resolve(coordinates));
            }
            if (this.missing(GroupArtifact.JUNIT_PLATFORM_LAUNCHER)) {
                launcherPaths.addAll(this.resolve(GroupArtifact.JUNIT_PLATFORM_LAUNCHER));
            }
            if (this.missing(GroupArtifact.JUNIT_PLATFORM_REPORTING)) {
                ComparableVersion ver14m1 = new ComparableVersion("1.4.0-m1");
                ComparableVersion current = new ComparableVersion(this.mojo.version(Version.JUNIT_PLATFORM_VERSION).toLowerCase());
                if (current.compareTo(ver14m1) >= 0) {
                    launcherPaths.addAll(this.resolve(GroupArtifact.JUNIT_PLATFORM_REPORTING));
                }
            }
            if (this.mojo.getExecutor().isInjectConsole() && this.missing(GroupArtifact.JUNIT_PLATFORM_CONSOLE)) {
                launcherPaths.addAll(this.resolve(GroupArtifact.JUNIT_PLATFORM_CONSOLE));
            }
            if (this.contains(GroupArtifact.JUNIT_JUPITER_API) && this.missing(GroupArtifact.JUNIT_JUPITER_ENGINE)) {
                launcherPaths.addAll(this.resolve(GroupArtifact.JUNIT_JUPITER_ENGINE));
            }
            if (this.contains(GroupArtifact.JUNIT_JUPITER_API) && tweaks.moveTestEnginesToLauncherClassLoader) {
                launcherPaths.addAll(this.resolve(GroupArtifact.JUNIT_JUPITER_ENGINE));
            }
            if (this.contains("junit:junit") && this.missing(GroupArtifact.JUNIT_VINTAGE_ENGINE)) {
                launcherPaths.addAll(this.resolve(GroupArtifact.JUNIT_VINTAGE_ENGINE));
            }
            if (this.mojo.getExecutor().isInjectWorker() && this.missing(GroupArtifact.ISOLATOR_WORKER)) {
                isolatorPaths.addAll(this.resolve(GroupArtifact.ISOLATOR_WORKER.toStringWithDefaultVersion()));
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Resolution failed!", e);
        }
        this.mojo.removeExcludedArtifacts(mainPaths, testPaths, launcherPaths, isolatorPaths);
        LinkedHashMap<String, Set<String>> paths = new LinkedHashMap<String, Set<String>>();
        Isolation isolation = this.mojo.getIsolation();
        switch (isolation) {
            case ALMOST: {
                String mainClasses = Paths.get(project.getBuild().getOutputDirectory(), new String[0]).toString();
                mainPaths.remove(mainClasses);
                testPaths.add(mainClasses);
            }
            case ABSOLUTE: {
                MavenDriver.put(paths, "main", mainPaths);
                MavenDriver.put(paths, "test", testPaths);
                MavenDriver.put(paths, "launcher", launcherPaths);
                MavenDriver.put(paths, "isolator", isolatorPaths);
                break;
            }
            case MERGED: {
                LinkedHashSet<String> mergedPaths = new LinkedHashSet<String>();
                mergedPaths.addAll(testPaths);
                mergedPaths.addAll(mainPaths);
                MavenDriver.put(paths, "merged(test+main)", mergedPaths);
                MavenDriver.put(paths, "launcher", launcherPaths);
                MavenDriver.put(paths, "isolator", isolatorPaths);
                break;
            }
            case NONE: {
                LinkedHashSet<String> allPaths = new LinkedHashSet<String>();
                allPaths.addAll(mainPaths);
                allPaths.addAll(testPaths);
                allPaths.addAll(launcherPaths);
                allPaths.addAll(isolatorPaths);
                paths.put("all", allPaths);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported isolation constant: " + (Object)((Object)isolation)));
            }
        }
        MavenDriver.pruneDuplicates(paths);
        return paths;
    }

    private boolean missing(GroupArtifact groupArtifact) {
        return !this.contains(groupArtifact);
    }

    private boolean contains(GroupArtifact groupArtifact) {
        return this.contains(groupArtifact.toString());
    }

    private boolean contains(String groupArtifact) {
        return this.mojo.getMavenProject().getArtifactMap().containsKey(groupArtifact);
    }

    private Optional<String> locate(GroupArtifact groupArtifact) {
        return this.locate(groupArtifact.toString());
    }

    private Optional<String> locate(String groupArtifact) {
        Artifact artifact = (Artifact)this.mojo.getMavenProject().getArtifactMap().get(groupArtifact);
        if (artifact == null) {
            return Optional.empty();
        }
        return Optional.of(artifact.getFile().toPath().toString());
    }

    private Set<String> resolve(GroupArtifact groupArtifact) throws RepositoryException {
        return this.resolve(groupArtifact.toString(this.mojo::version));
    }

    private Set<String> resolve(String coordinates) throws RepositoryException {
        return this.resolve(coordinates, "", (all, ways) -> true).stream().map(org.eclipse.aether.artifact.Artifact::getFile).map(File::toPath).map(Objects::toString).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private List<org.eclipse.aether.artifact.Artifact> resolve(String coordinates, String scope, DependencyFilter filter) throws RepositoryException {
        DefaultArtifact artifact = new DefaultArtifact(coordinates);
        this.debug("Resolving artifact {0} from {1}...", artifact, this.repositories);
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency((org.eclipse.aether.artifact.Artifact)artifact, scope));
        collectRequest.setRepositories(this.repositories);
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, filter);
        return this.repositorySystem.resolveDependencies(this.session, dependencyRequest).getArtifactResults().stream().map(ArtifactResult::getArtifact).collect(Collectors.toList());
    }

    private void copyDirectoryStructure(String srcFldr, String dstFldr, boolean ignoreNonEmpty) throws IOException {
        Path srcPath = Paths.get(srcFldr, new String[0]);
        try (Stream<Path> walk = Files.walk(srcPath, new FileVisitOption[0]);){
            walk.forEach(currentPath -> {
                Path destPath = Paths.get(dstFldr, currentPath.toString().substring(srcFldr.length()));
                try {
                    Files.copy(currentPath, destPath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException ioe) {
                    if (ioe instanceof DirectoryNotEmptyException && ignoreNonEmpty) {
                        this.debug("ignoring non-empty folder {0} - continuing with content", currentPath.toString());
                    }
                    throw new UncheckedIOException(String.format("copying %s to %s failed", srcFldr, dstFldr), ioe);
                }
            });
        }
    }

    private static void addAll(Collection<String> source, Collection<String> target) {
        MavenDriver.addAll(source, Collections.emptySet(), target);
    }

    private static void addAll(Collection<String> source, Set<String> exclude, Collection<String> target) {
        source.stream().filter(a -> !exclude.contains(a)).forEach(target::add);
    }

    private static void put(Map<String, Set<String>> paths, String key, Set<String> value) {
        if (value.isEmpty()) {
            return;
        }
        paths.put(key, value);
    }

    static <T> void pruneDuplicates(Map<String, ? extends Collection<T>> paths) {
        Set<String> keys = paths.keySet();
        for (String outer : keys) {
            for (String inner : keys) {
                if (outer.equals(inner)) continue;
                paths.get(inner).removeAll(paths.get(outer));
            }
        }
    }
}

