/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.xml;

import de.smartics.maven.plugin.jboss.modules.descriptor.ApplyToDependencies;
import de.smartics.maven.plugin.jboss.modules.descriptor.ApplyToModule;
import de.smartics.maven.plugin.jboss.modules.descriptor.DependenciesDescriptor;
import de.smartics.maven.plugin.jboss.modules.descriptor.ModuleDescriptor;
import de.smartics.maven.plugin.jboss.modules.domain.ExecutionContext;
import de.smartics.maven.plugin.jboss.modules.domain.SlotStrategy;
import de.smartics.maven.plugin.jboss.modules.util.XmlUtils;
import de.smartics.maven.plugin.jboss.modules.xml.XmlFragmentParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public final class ModuleXmlBuilder {
    public static final Namespace MODULE_NS_1_1 = Namespace.getNamespace((String)"urn:jboss:module:1.1");
    public static final String MODULE_NS_1_1_URI = "urn:jboss:module:1.1";
    private final ExecutionContext context;
    private final ModuleDescriptor module;
    private final Collection<Dependency> dependencies;
    private final Document document;
    private final Element root;
    private final XmlFragmentParser xmlFragmentParser = new XmlFragmentParser();

    public ModuleXmlBuilder(ExecutionContext context, ModuleDescriptor module, Collection<Dependency> dependencies) {
        this.context = context;
        this.module = module;
        this.dependencies = dependencies;
        this.root = new Element("module", context.getTargetNamespace());
        this.root.setAttribute("name", module.getName());
        String slot = ModuleXmlBuilder.calcSlot(context, module, dependencies);
        if (!"main".equals(slot)) {
            this.root.setAttribute("slot", slot);
        }
        this.document = new Document(this.root);
    }

    private static String calcSlot(ExecutionContext context, ModuleDescriptor module, Collection<Dependency> dependencies) {
        SlotStrategy strategy = context.getSlotStrategy();
        String moduleSlot = module.getSlot();
        String defaultSlot = context.getDefaultSlot();
        Artifact artifact = ModuleXmlBuilder.calcArtifact(dependencies);
        String slot = strategy.calcSlot(defaultSlot, moduleSlot, artifact);
        return slot;
    }

    private static Artifact calcArtifact(Collection<Dependency> dependencies) {
        if (dependencies != null && !dependencies.isEmpty()) {
            Dependency dependency = dependencies.iterator().next();
            Artifact artifact = dependency.getArtifact();
            return artifact;
        }
        return null;
    }

    public Document build() {
        this.addMainClass(this.module);
        this.addProperties(this.module);
        this.addResources(this.module, this.dependencies);
        this.addDependencies(this.module, this.dependencies);
        this.addExports(this.module);
        return this.document;
    }

    private void addMainClass(ModuleDescriptor module) {
        String xml = module.getApplyToModule().getMainClassXml();
        if (xml != null) {
            Element element = this.adopt(xml);
            this.root.addContent((Content)element);
        }
    }

    private void addProperties(ModuleDescriptor module) {
        List<String> xmls = module.getApplyToModule().getPropertiesXml();
        if (xmls.isEmpty()) {
            return;
        }
        Element propertiesElement = new Element("properties", this.context.getTargetNamespace());
        for (String xml : xmls) {
            Element element = this.adopt(xml);
            propertiesElement.addContent((Content)element);
        }
        this.root.addContent((Content)propertiesElement);
    }

    private void addResources(ModuleDescriptor module, Collection<Dependency> dependencies) {
        Element resources = new Element("resources", this.context.getTargetNamespace());
        List<String> resourceRootsXml = module.getApplyToModule().getResourceRootsXml();
        for (String xml : resourceRootsXml) {
            Element element = this.adopt(xml);
            resources.addContent((Content)element);
        }
        if (!dependencies.isEmpty()) {
            List<SortElement> sorted = this.createSortedResources(dependencies);
            for (SortElement sortElement : sorted) {
                Artifact depart = sortElement.dependency.getArtifact();
                if (this.context.isGenerateFeaturePackDefinition().booleanValue()) {
                    Element artifact = new Element("artifact", this.context.getTargetNamespace());
                    artifact.setAttribute("name", "${" + depart.getGroupId() + ":" + depart.getArtifactId() + "}");
                    String filter = module.getMatcher().findFilter(depart);
                    if (filter != null) {
                        Element filterElement = this.adopt(filter);
                        artifact.addContent((Content)filterElement);
                    }
                    resources.addContent((Content)artifact);
                    continue;
                }
                Element resource = new Element("resource-root", this.context.getTargetNamespace());
                String fileName = depart.getFile().getName();
                resource.setAttribute("path", fileName);
                String filter = module.getMatcher().findFilter(depart);
                if (filter != null) {
                    Element filterElement = this.adopt(filter);
                    resource.addContent((Content)filterElement);
                }
                resources.addContent((Content)resource);
            }
        }
        if (!resources.getChildren().isEmpty()) {
            this.root.addContent((Content)resources);
        }
    }

    private List<SortElement> createSortedResources(Collection<Dependency> dependencies) {
        ArrayList<SortElement> sorted = new ArrayList<SortElement>(dependencies.size());
        for (Dependency dependency : dependencies) {
            Artifact artifact = dependency.getArtifact();
            File file = artifact.getFile();
            if (file == null) continue;
            String sortKey = file.getName() + ":" + dependency.getArtifact().getGroupId();
            sorted.add(new SortElement(sortKey, dependency));
        }
        Collections.sort(sorted);
        return sorted;
    }

    private void addDependencies(ModuleDescriptor module, Collection<Dependency> dependencies) {
        ApplyToModule applyToModule = module.getApplyToModule();
        List<String> staticDependencies = applyToModule.getDependenciesXml();
        if (!dependencies.isEmpty() || !staticDependencies.isEmpty()) {
            Element dependenciesElement = new Element("dependencies", this.context.getTargetNamespace());
            List<ModuleDependencyElement> staticDependencyElements = this.getStaticDependencyElements(staticDependencies);
            List<ModuleDependencyElement> resolvedDependencyElements = this.getResolvedDependencyElements(module, dependencies);
            ArrayList<ModuleDependencyElement> combinedDependencies = new ArrayList<ModuleDependencyElement>();
            resolvedDependencyElements.removeAll(staticDependencyElements);
            combinedDependencies.addAll(staticDependencyElements);
            combinedDependencies.addAll(resolvedDependencyElements);
            for (ModuleDependencyElement element : combinedDependencies) {
                dependenciesElement.addContent((Content)element.getModuleElement());
            }
            this.root.addContent((Content)dependenciesElement);
        }
    }

    private List<ModuleDependencyElement> getResolvedDependencyElements(ModuleDescriptor module, Collection<Dependency> dependencies) {
        Set<SortElement> sorted = this.createSortedDependencies(module, dependencies);
        ApplyToDependencies apply = module.getApplyToDependencies();
        ArrayList<ModuleDependencyElement> moduleDependencyElements = new ArrayList<ModuleDependencyElement>();
        for (SortElement element : sorted) {
            String name = element.key;
            Element moduleElement = new Element("module", this.context.getTargetNamespace());
            moduleElement.setAttribute("name", name);
            DependenciesDescriptor dd = apply.getDescriptorThatMatches(name);
            if (!this.isIncludableDependency(element, dd)) continue;
            this.handleOptional(element, moduleElement, dd);
            this.handleExport(moduleElement, dd);
            this.handleServices(moduleElement, dd);
            this.handleSlot(module, element, moduleElement);
            moduleDependencyElements.add(new ModuleDependencyElement(moduleElement));
        }
        return moduleDependencyElements;
    }

    private boolean isIncludableDependency(SortElement element, DependenciesDescriptor dd) {
        boolean isOptional;
        boolean isSkipped = dd.getSkip() != null && dd.getSkip() == true;
        boolean bl = isOptional = dd.getOptional() != null && dd.getOptional() == true || element.dependency.isOptional();
        if (isSkipped) {
            return false;
        }
        return !isOptional || this.context.isIgnoreOptionalDependencies() == false;
    }

    private void handleOptional(SortElement element, Element moduleElement, DependenciesDescriptor dd) {
        Boolean ddOptional = dd.getOptional();
        if (ddOptional != null && ddOptional.booleanValue() || ddOptional == null || element.dependency.isOptional()) {
            moduleElement.setAttribute("optional", "true");
        }
    }

    private void handleExport(Element moduleElement, DependenciesDescriptor dd) {
        Boolean ddExport = dd.getExport();
        if (ddExport != null && ddExport.booleanValue()) {
            moduleElement.setAttribute("export", "true");
        }
    }

    private void handleServices(Element moduleElement, DependenciesDescriptor dd) {
        String services = dd.getServices();
        if (services != null && !"none".equals(services)) {
            moduleElement.setAttribute("services", services);
        }
    }

    private void handleSlot(ModuleDescriptor module, SortElement element, Element moduleElement) {
        SlotStrategy slotStrategy = this.context.getSlotStrategy();
        Dependency dependency = element.dependency;
        String defaultSlot = this.calcDefaultSlot(module, dependency);
        String slot = slotStrategy.calcSlot(dependency.getArtifact(), defaultSlot);
        if (!"main".equals(slot)) {
            moduleElement.setAttribute("slot", slot);
        }
    }

    private Set<SortElement> createSortedDependencies(ModuleDescriptor module, Collection<Dependency> dependencies) {
        TreeSet<SortElement> sorted = new TreeSet<SortElement>();
        for (Dependency dependency : dependencies) {
            List<Dependency> resolvedDependencies = this.context.resolve(dependency);
            this.addSortedDependencies(sorted, module, resolvedDependencies);
        }
        return sorted;
    }

    private String calcDefaultSlot(ModuleDescriptor module, Dependency dependency) {
        String moduleSlot;
        ModuleDescriptor depModule = this.context.getModule(dependency);
        String depModuleSlot = depModule.getSlot();
        if (StringUtils.isNotBlank((String)depModuleSlot)) {
            return depModuleSlot;
        }
        boolean inheritSlot = module.getDirectives().getInheritSlot();
        if (inheritSlot && StringUtils.isNotBlank((String)(moduleSlot = module.getSlot()))) {
            return moduleSlot;
        }
        String defaultSlot = this.context.getDefaultSlot();
        return defaultSlot;
    }

    private List<ModuleDependencyElement> getStaticDependencyElements(List<String> staticDependencies) {
        ArrayList<ModuleDependencyElement> moduleElements = new ArrayList<ModuleDependencyElement>();
        if (!staticDependencies.isEmpty()) {
            for (String xml : staticDependencies) {
                ModuleDependencyElement element = new ModuleDependencyElement(this.adopt(xml));
                moduleElements.add(element);
            }
        }
        return moduleElements;
    }

    private void addSortedDependencies(Set<SortElement> sorted, ModuleDescriptor owningModule, List<Dependency> dependencies) {
        for (Dependency dependency : dependencies) {
            try {
                ModuleDescriptor module = this.context.getModule(dependency);
                String name = module.getName();
                if (name.equals(owningModule.getName())) continue;
                SortElement e = new SortElement(name, dependency);
                if (sorted.contains(e)) {
                    for (SortElement current : sorted) {
                        if (!current.equals(e) || !current.dependency.isOptional() || dependency.isOptional()) continue;
                        sorted.remove(current);
                        break;
                    }
                }
                sorted.add(e);
            }
            catch (IllegalArgumentException e) {
                this.context.getLog().error((CharSequence)String.format("Skipping '%s' referenced from module '%s'.", dependency.getArtifact().getArtifactId(), owningModule.getName()));
            }
        }
    }

    private void addExports(ModuleDescriptor module2) {
        String xml = this.module.getApplyToModule().getExportsXml();
        if (xml != null) {
            Element element = this.adopt(xml);
            this.root.addContent((Content)element);
        }
    }

    private Element adopt(String xml) {
        Element element = this.xmlFragmentParser.parse(xml);
        XmlUtils.adjustNamespaces(element, this.context.getTargetNamespace());
        return element;
    }

    private static final class ModuleDependencyElement {
        private final Element moduleElement;
        private final String moduleName;

        public ModuleDependencyElement(Element moduleElement) {
            this.moduleElement = moduleElement;
            this.moduleName = moduleElement.getAttributeValue("name");
        }

        protected Element getModuleElement() {
            return this.moduleElement;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModuleDependencyElement that = (ModuleDependencyElement)o;
            return ObjectUtils.equals((Object)this.moduleName, (Object)that.moduleName);
        }

        public int hashCode() {
            return ObjectUtils.hashCode((Object)this.moduleName);
        }
    }

    private static final class SortElement
    implements Comparable<SortElement> {
        private final String key;
        private final Dependency dependency;

        private SortElement(String key, Dependency dependency) {
            this.key = key;
            this.dependency = dependency;
        }

        public int hashCode() {
            return ObjectUtils.hashCode((Object)this.key);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SortElement other = (SortElement)object;
            return ObjectUtils.equals((Object)this.key, (Object)other.key);
        }

        @Override
        public int compareTo(SortElement o) {
            return this.key.compareTo(o.key);
        }

        public String toString() {
            return String.valueOf(this.key) + ": " + String.valueOf(this.dependency);
        }
    }
}

