/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.util.classpath;

import de.smartics.maven.plugin.jboss.modules.util.Arg;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.lang.ObjectUtils;

public final class ClassPathContext {
    private final ClassLoader classLoader;
    private final String archiveRoot;

    public ClassPathContext(ClassLoader classLoader, String archiveRoot) throws NullPointerException {
        Arg.checkNotNull("classLoader", classLoader);
        this.classLoader = classLoader;
        this.archiveRoot = archiveRoot;
    }

    public URL getResource(String resource) {
        if (this.archiveRoot == null) {
            return this.classLoader.getResource(resource);
        }
        try {
            Enumeration<URL> en = this.classLoader.getResources(resource);
            while (en.hasMoreElements()) {
                URL current = en.nextElement();
                String urlString = current.toExternalForm();
                if (!urlString.startsWith(this.archiveRoot)) continue;
                return current;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public InputStream getResourceAsStream(String resource) {
        URL url = this.getResource(resource);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public URL createUrl(String resource) throws IllegalArgumentException {
        try {
            String urlString = (this.archiveRoot != null ? this.archiveRoot : "") + resource;
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Cannot construct URL with resource '" + resource + "'.", e);
        }
    }

    public int hashCode() {
        return ObjectUtils.hashCode((Object)this.archiveRoot);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClassPathContext other = (ClassPathContext)object;
        return ObjectUtils.equals((Object)this.archiveRoot, (Object)other.archiveRoot);
    }

    public String toString() {
        return this.archiveRoot != null ? this.archiveRoot : "<unspecified archive root>";
    }
}

