/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.domain;

import de.smartics.maven.plugin.jboss.modules.aether.DependencyTraverserGenerator;
import de.smartics.maven.plugin.jboss.modules.aether.PruningDependencyTraverser;
import de.smartics.maven.plugin.jboss.modules.descriptor.ArtifactClusion;
import de.smartics.maven.plugin.jboss.modules.descriptor.ModuleDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.aether.collection.DependencyTraverser;

public class PrunerGenerator
implements DependencyTraverserGenerator {
    private final List<ArtifactClusion> dependencyExcludes;
    private final List<ModuleDescriptor> skipModules;
    private final boolean ignoreDependencyExclusions;

    @Override
    public boolean isIgnoreDependencyExclusions() {
        return this.ignoreDependencyExclusions;
    }

    public PrunerGenerator(List<ArtifactClusion> dependencyExcludes, List<ModuleDescriptor> modules, boolean ignoreDependencyExclusions) {
        this.dependencyExcludes = dependencyExcludes != null ? dependencyExcludes : new ArrayList();
        this.skipModules = this.calcSkipModules(modules);
        this.ignoreDependencyExclusions = ignoreDependencyExclusions;
    }

    private List<ModuleDescriptor> calcSkipModules(List<ModuleDescriptor> modules) {
        if (modules == null) {
            return new ArrayList<ModuleDescriptor>();
        }
        ArrayList<ModuleDescriptor> skipModules = new ArrayList<ModuleDescriptor>(modules.size());
        for (ModuleDescriptor module : modules) {
            if (!module.getDirectives().getSkip().booleanValue()) continue;
            skipModules.add(module);
        }
        return skipModules;
    }

    @Override
    public DependencyTraverser createDependencyTraverser(DependencyTraverser delegate) throws NullPointerException {
        return new PruningDependencyTraverser(delegate, this.dependencyExcludes, this.skipModules);
    }
}

