/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.domain;

import de.smartics.maven.plugin.jboss.modules.descriptor.ModuleDescriptor;
import de.smartics.maven.plugin.jboss.modules.domain.ModuleMap;
import de.smartics.maven.plugin.jboss.modules.domain.SlotStrategy;
import de.smartics.maven.plugin.jboss.modules.domain.TransitiveDependencyResolver;
import de.smartics.maven.plugin.jboss.modules.util.Arg;
import de.smartics.maven.plugin.jboss.modules.xml.ModuleXmlBuilder;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.jdom2.Namespace;

public final class ExecutionContext {
    private final Log log;
    private final File targetFolder;
    private final TransitiveDependencyResolver resolver;
    private final SlotStrategy slotStrategy;
    private final String defaultSlot;
    private final ModuleMap moduleMap;
    private final Boolean ignoreOptionalDependencies;
    private Boolean generateFeaturePackDefinition;
    private final Namespace targetNamespace;

    private ExecutionContext(Builder builder) {
        this.log = builder.log;
        this.targetFolder = builder.targetFolder;
        this.resolver = builder.resolver;
        this.slotStrategy = builder.slotStrategy;
        this.defaultSlot = builder.defaultSlot;
        this.moduleMap = builder.moduleMap;
        this.ignoreOptionalDependencies = builder.ignoreOptionalDependencies;
        this.generateFeaturePackDefinition = builder.generateFeaturePackDefinition;
        this.targetNamespace = builder.targetNamespace;
    }

    public Log getLog() {
        return this.log;
    }

    public File getTargetFolder() {
        return this.targetFolder;
    }

    public TransitiveDependencyResolver getResolver() {
        return this.resolver;
    }

    public SlotStrategy getSlotStrategy() {
        return this.slotStrategy;
    }

    public String getDefaultSlot() {
        return this.defaultSlot;
    }

    public ModuleMap getModuleMap() {
        return this.moduleMap;
    }

    public Boolean isIgnoreOptionalDependencies() {
        return this.ignoreOptionalDependencies;
    }

    public Boolean isGenerateFeaturePackDefinition() {
        return this.generateFeaturePackDefinition;
    }

    public List<Dependency> resolve(Dependency dependency) {
        try {
            return this.resolver.resolveDirect(dependency);
        }
        catch (DependencyResolutionException e) {
            this.log.error((CharSequence)("Cannot resolve dependency '" + dependency.getArtifact().getArtifactId() + "': " + e.getMessage()));
            return Collections.emptyList();
        }
    }

    public ModuleDescriptor getModule(Dependency dependency) throws IllegalArgumentException {
        ModuleDescriptor module = this.moduleMap.getModule(dependency);
        if (module == null) {
            throw new IllegalArgumentException("Cannot find module for dependency: " + dependency);
        }
        return module;
    }

    public Namespace getTargetNamespace() {
        return this.targetNamespace;
    }

    public static final class Builder {
        private Log log;
        private File targetFolder;
        private TransitiveDependencyResolver resolver;
        private SlotStrategy slotStrategy;
        private String defaultSlot;
        private ModuleMap moduleMap;
        private Boolean ignoreOptionalDependencies;
        private Boolean generateFeaturePackDefinition;
        private Namespace targetNamespace = ModuleXmlBuilder.MODULE_NS_1_1;

        public Builder with(Log log) {
            this.log = log;
            return this;
        }

        public Builder withTargetFolder(File targetFolder) {
            this.targetFolder = targetFolder;
            return this;
        }

        public Builder with(TransitiveDependencyResolver resolver) {
            this.resolver = resolver;
            return this;
        }

        public Builder with(SlotStrategy slotStrategy) {
            this.slotStrategy = slotStrategy;
            return this;
        }

        public Builder withDefaultSlot(String defaultSlot) {
            this.defaultSlot = defaultSlot;
            return this;
        }

        public Builder with(ModuleMap moduleMap) {
            this.moduleMap = moduleMap;
            return this;
        }

        public Builder withIgnoreOptionalDependencies(Boolean ignoreOptionalDependencies) {
            this.ignoreOptionalDependencies = ignoreOptionalDependencies;
            return this;
        }

        public Builder withGenerateFeaturePackDefinition(Boolean generateFeaturePackDefinition) {
            this.generateFeaturePackDefinition = generateFeaturePackDefinition;
            return this;
        }

        public Builder withTargetNamespace(Namespace targetNamespace) {
            this.targetNamespace = targetNamespace;
            return this;
        }

        public Builder withTargetNamespaceUri(String targetNamespaceUri) {
            this.targetNamespace = Namespace.getNamespace((String)targetNamespaceUri);
            return this;
        }

        public ExecutionContext build() throws NullPointerException {
            Arg.checkNotNull("targetFolder", this.targetFolder);
            Arg.checkNotNull("resolver", this.resolver);
            Arg.checkNotNull("slotStrategy", this.slotStrategy);
            Arg.checkNotNull("moduleMap", this.moduleMap);
            return new ExecutionContext(this);
        }
    }
}

