/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.descriptor;

import de.smartics.maven.plugin.jboss.modules.domain.MatchContext;
import de.smartics.maven.plugin.jboss.modules.domain.matching.DoubleMatchContext;
import de.smartics.maven.plugin.jboss.modules.domain.matching.SingleMatchContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.aether.artifact.Artifact;

public class ArtifactClusion {
    private final String groupId;
    private final Pattern groupIdPattern;
    private final String artifactId;
    private final Pattern artifactIdPattern;
    private final String filter;

    public static List<ArtifactClusion> buildList(List<Builder> builders) {
        if (builders == null) {
            return Collections.emptyList();
        }
        ArrayList<ArtifactClusion> result = new ArrayList<ArtifactClusion>(builders.size());
        for (Builder b : builders) {
            result.add(b.build());
        }
        return Collections.unmodifiableList(result);
    }

    public ArtifactClusion(String groupId, String artifactId) {
        this(groupId, artifactId, null);
    }

    public ArtifactClusion(String groupId, String artifactId, String filter) {
        if (StringUtils.isNotBlank((String)groupId)) {
            this.groupId = groupId;
            this.groupIdPattern = ArtifactClusion.compilePattern(groupId);
        } else {
            this.groupId = null;
            this.groupIdPattern = null;
        }
        if (StringUtils.isNotBlank((String)artifactId)) {
            this.artifactId = artifactId;
            this.artifactIdPattern = ArtifactClusion.compilePattern(artifactId);
        } else {
            this.artifactId = null;
            this.artifactIdPattern = null;
        }
        this.filter = filter;
    }

    public String getGroupId() {
        return this.groupId;
    }

    private static Pattern compilePattern(String pattern) {
        if (StringUtils.isNotBlank((String)pattern)) {
            try {
                return Pattern.compile(pattern);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getFilter() {
        return this.filter;
    }

    public MatchContext matches(Artifact artifact) {
        SingleMatchContext matchesGroupId = this.matches(this.groupIdPattern, this.groupId, artifact.getGroupId());
        if (matchesGroupId != null && !matchesGroupId.isMatched()) {
            return new SingleMatchContext(false, this);
        }
        SingleMatchContext matchesArtifactId = this.matches(this.artifactIdPattern, this.artifactId, artifact.getArtifactId());
        boolean result = matchesGroupId != null && matchesGroupId.isMatched() && (matchesArtifactId == null || matchesArtifactId.isMatched()) || matchesArtifactId != null && matchesArtifactId.isMatched();
        DoubleMatchContext context = new DoubleMatchContext(result, matchesGroupId, matchesArtifactId, this);
        return context;
    }

    private SingleMatchContext matches(Pattern pattern, String id, String inputId) {
        if (pattern != null) {
            Matcher matcher = pattern.matcher(inputId);
            return new SingleMatchContext(matcher, this);
        }
        if (StringUtils.isNotBlank((String)id)) {
            return new SingleMatchContext(id.equals(inputId), this);
        }
        return null;
    }

    public String toString() {
        return ObjectUtils.toString((Object)this.groupId) + ':' + ObjectUtils.toString((Object)this.artifactId) + ':' + ObjectUtils.toString((Object)this.filter);
    }

    public static class Builder {
        public String groupId;
        public String artifactId;
        public String filter;

        public ArtifactClusion build() {
            return new ArtifactClusion(this.groupId, this.artifactId, this.filter);
        }
    }
}

