/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.aether;

import de.smartics.maven.plugin.jboss.modules.aether.DependencyTraverserGenerator;
import de.smartics.maven.plugin.jboss.modules.aether.FilterSession;
import de.smartics.maven.plugin.jboss.modules.aether.MavenResponse;
import de.smartics.maven.plugin.jboss.modules.aether.RepositoryBuilder;
import de.smartics.maven.plugin.jboss.modules.aether.filter.DependencyFlagger;
import de.smartics.maven.plugin.jboss.modules.aether.filter.DirectDependenciesOnlyFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.filter.AndDependencyFilter;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MavenRepository {
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession session;
    private final List<RemoteRepository> remoteRepositories;
    private final List<DependencyFilter> dependencyFilters;
    private final List<Dependency> managedDependencies;
    private final boolean offline;
    private final DependencyTraverserGenerator traverserGenerator;
    private final Logger log = LoggerFactory.getLogger(MavenRepository.class);

    MavenRepository(RepositoryBuilder builder) {
        this.remoteRepositories = builder.getRemoteRepositories();
        this.session = builder.getSession();
        this.repositorySystem = builder.getRepositorySystem();
        this.dependencyFilters = builder.getDependencyFilters();
        this.managedDependencies = builder.getManagedDependencies();
        this.offline = builder.isOffline();
        this.traverserGenerator = builder.getTraverserGenerator();
    }

    public MavenResponse resolve(Dependency dependency) throws DependencyResolutionException {
        DependencyRequest dependencyRequest = this.createRequest(dependency, true);
        return this.configureRequest(dependencyRequest, false);
    }

    public MavenResponse resolveDirect(Dependency dependency) throws DependencyResolutionException {
        DependencyRequest dependencyRequest = this.createRequest(dependency, false);
        return this.configureRequest(dependencyRequest, false);
    }

    private DependencyRequest createRequest(Dependency dependency, boolean transitive) {
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(dependency);
        collectRequest.setManagedDependencies(this.managedDependencies);
        return this.configureRequest(collectRequest, transitive);
    }

    private static MavenResponse createResult(PreorderNodeListGenerator generator) {
        MavenResponse response = new MavenResponse();
        List nodes = generator.getNodes();
        for (DependencyNode node : nodes) {
            Dependency dependency = node.getDependency();
            Artifact artifact = dependency.getArtifact();
            if (artifact.getFile() == null || DependencyFlagger.INSTANCE.isFlagged(dependency)) continue;
            response.add(dependency);
        }
        return response;
    }

    public MavenResponse resolve(List<Dependency> dependencies) throws DependencyResolutionException {
        DependencyRequest dependencyRequest = this.createRequest(dependencies, true);
        return this.configureRequest(dependencyRequest, true);
    }

    private MavenResponse configureRequest(DependencyRequest dependencyRequest, boolean isRootDependencies) throws DependencyResolutionException {
        try {
            DependencyResult result;
            DependencyTraverser traverser = this.traverserGenerator.createDependencyTraverser(this.session.getDependencyTraverser());
            FilterSession filterSession = new FilterSession(this.session, traverser, this.traverserGenerator.isIgnoreDependencyExclusions());
            try {
                result = this.repositorySystem.resolveDependencies((RepositorySystemSession)filterSession, dependencyRequest);
            }
            catch (DependencyResolutionException e) {
                if (isRootDependencies) {
                    throw e;
                }
                this.log.warn("Cannot resolve dependency: " + e.getMessage());
                result = e.getResult();
            }
            DependencyNode rootNode = result.getRoot();
            PreorderNodeListGenerator generator = new PreorderNodeListGenerator();
            rootNode.accept((DependencyVisitor)generator);
            MavenResponse response = MavenRepository.createResult(generator);
            return response;
        }
        catch (NullPointerException e) {
            throw new DependencyResolutionException(new DependencyResult(dependencyRequest), (Throwable)e);
        }
    }

    private DependencyRequest createRequest(List<Dependency> dependencies, boolean transitive) {
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setDependencies(dependencies);
        return this.configureRequest(collectRequest, transitive);
    }

    private DependencyRequest configureRequest(CollectRequest collectRequest, boolean transitive) {
        if (!this.offline && !this.remoteRepositories.isEmpty()) {
            collectRequest.setRepositories(this.remoteRepositories);
        }
        DependencyRequest dependencyRequest = new DependencyRequest();
        dependencyRequest.setCollectRequest(collectRequest);
        this.applyFilters(dependencyRequest, transitive);
        return dependencyRequest;
    }

    private void applyFilters(DependencyRequest dependencyRequest, boolean transitive) {
        ArrayList<DependencyFilter> filters = new ArrayList<DependencyFilter>();
        if (this.dependencyFilters != null) {
            filters.addAll(this.dependencyFilters);
        }
        if (!transitive) {
            filters.add(DirectDependenciesOnlyFilter.INSTANCE);
        }
        if (!filters.isEmpty()) {
            AndDependencyFilter dependencyFilter = new AndDependencyFilter(filters);
            dependencyRequest.setFilter((DependencyFilter)dependencyFilter);
        }
    }
}

