/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import de.siegmar.logbackgelf.AbstractGelfAppender;
import de.siegmar.logbackgelf.AddressResolver;
import de.siegmar.logbackgelf.CompressionMethod;
import de.siegmar.logbackgelf.GelfUdpChunker;
import de.siegmar.logbackgelf.MessageIdSupplier;
import de.siegmar.logbackgelf.compressor.Compressor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Objects;
import java.util.function.LongSupplier;

public class GelfUdpAppender
extends AbstractGelfAppender {
    private Integer maxChunkSize;
    private CompressionMethod compressionMethod = CompressionMethod.GZIP;
    private LongSupplier messageIdSupplier = new MessageIdSupplier();
    private RobustChannel robustChannel;
    private GelfUdpChunker chunker;
    private AddressResolver addressResolver;
    private Compressor compressor;

    public Integer getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public void setMaxChunkSize(Integer maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }

    public CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    public void setCompressionMethod(CompressionMethod compressionMethod) {
        this.compressionMethod = Objects.requireNonNull(compressionMethod, "compressionMethod must not be null");
    }

    public LongSupplier getMessageIdSupplier() {
        return this.messageIdSupplier;
    }

    public void setMessageIdSupplier(LongSupplier messageIdSupplier) {
        this.messageIdSupplier = Objects.requireNonNull(messageIdSupplier, "messageIdSupplier must not be null");
    }

    @Override
    protected void startAppender() throws IOException {
        this.robustChannel = new RobustChannel();
        this.chunker = new GelfUdpChunker(this.messageIdSupplier, this.maxChunkSize);
        this.addressResolver = new AddressResolver(this.getGraylogHost());
        this.compressor = this.compressionMethod.getCompressor();
    }

    @Override
    protected void appendMessage(byte[] binMessage) throws IOException {
        byte[] messageToSend = this.compressor.compress(binMessage);
        InetSocketAddress remote = new InetSocketAddress(this.addressResolver.resolve(), this.getGraylogPort());
        for (ByteBuffer byteBuffer : this.chunker.chunks(messageToSend)) {
            while (byteBuffer.hasRemaining()) {
                this.robustChannel.send(byteBuffer, remote);
            }
        }
    }

    @Override
    protected void close() throws IOException {
        this.robustChannel.close();
    }

    private static final class RobustChannel {
        private volatile DatagramChannel channel = DatagramChannel.open();
        private volatile boolean stopped;

        RobustChannel() throws IOException {
        }

        void send(ByteBuffer src, SocketAddress target) throws IOException {
            this.getChannel().send(src, target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DatagramChannel getChannel() throws IOException {
            DatagramChannel tmp = this.channel;
            if (!tmp.isOpen()) {
                RobustChannel robustChannel = this;
                synchronized (robustChannel) {
                    tmp = this.channel;
                    if (!tmp.isOpen() && !this.stopped) {
                        this.channel = tmp = DatagramChannel.open();
                    }
                }
            }
            return tmp;
        }

        synchronized void close() throws IOException {
            this.channel.close();
            this.stopped = true;
        }
    }
}

