/*
 * Decompiled with CFR 0.152.
 */
package de.saly.javamail.mock2;

import de.saly.javamail.mock2.MockMailbox;
import de.saly.javamail.mock2.MockMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.search.SearchTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailboxFolder
implements MockMessage.FlagChangeListener {
    public static final char SEPARATOR = '/';
    private final List<MailboxFolder> children = new ArrayList<MailboxFolder>();
    private boolean exists = true;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MockMailbox mailbox;
    private volatile List<MailboxEventListener> mailboxEventListeners = Collections.synchronizedList(new ArrayList());
    private final Map<Long, MockMessage> messages = new HashMap<Long, MockMessage>();
    private String name;
    private MailboxFolder parent;
    private boolean simulateError = false;
    private boolean subscribed;
    private long uidValidity = 50L;
    private long uniqueMessageId = 10L;

    protected MailboxFolder(String name, MockMailbox mb, boolean exists) {
        this.name = name == null ? "" : name;
        this.mailbox = mb;
        this.exists = exists;
        this.logger.debug("Created " + name + " (exists: " + exists + ")");
    }

    public synchronized Message add(MimeMessage e) throws MessagingException {
        this.checkExists();
        ++this.uniqueMessageId;
        MockMessage mockMessage = new MockMessage(e, this.uniqueMessageId, this, this);
        mockMessage.setSpecialHeader("Message-ID", String.valueOf(this.uniqueMessageId));
        mockMessage.setSpecialHeader("X-Mock-Folder", this.getFullName());
        mockMessage.setFlags(new Flags(Flags.Flag.RECENT), true);
        this.messages.put(this.uniqueMessageId, mockMessage);
        for (MailboxEventListener mailboxEventListener : this.mailboxEventListeners) {
            mailboxEventListener.messageAdded(this, mockMessage);
        }
        this.logger.debug("Message ID " + this.uniqueMessageId + " to " + this.getFullName() + " added for user " + this.mailbox.getAddress());
        return mockMessage;
    }

    public synchronized void addMailboxEventListener(MailboxEventListener l) {
        if (l != null) {
            this.mailboxEventListeners.add(l);
        }
    }

    protected MailboxFolder addSpecialSubFolder(String name) {
        MailboxFolder mbt = new MailboxFolder(name, this.mailbox, true);
        mbt.parent = this;
        this.children.add(mbt);
        return mbt;
    }

    protected void checkExists() {
        if (!this.exists) {
            throw new IllegalStateException("folder does not exist");
        }
    }

    protected void checkFolderName(String name) {
        this.checkFolderName(name, true);
    }

    protected void checkFolderName(String name, boolean checkSeparator) {
        if (name == null || name.trim().equals("") || name.equalsIgnoreCase("inbox") || checkSeparator && name.contains(String.valueOf('/'))) {
            throw new IllegalArgumentException("name '" + name + "' is not valid");
        }
    }

    public synchronized MailboxFolder create() {
        if (this.isExists()) {
            throw new IllegalStateException("already exists");
        }
        this.checkFolderName(this.name);
        this.exists = true;
        if (this.parent != null && !this.parent.isExists()) {
            this.parent.create();
        }
        for (MailboxEventListener mailboxEventListener : this.mailboxEventListeners) {
            mailboxEventListener.folderCreated(this);
        }
        this.logger.debug("Folder " + this.getFullName() + " created");
        return this;
    }

    public synchronized void deleteFolder(boolean recurse) {
        this.checkExists();
        this.checkFolderName(this.name);
        if (this.isRoot()) {
            throw new IllegalArgumentException("root cannot be deleted");
        }
        this.messages.clear();
        if (recurse) {
            for (MailboxFolder mf : this.getChildren()) {
                mf.deleteFolder(recurse);
            }
        }
        this.parent.children.remove(this);
        this.exists = false;
        for (MailboxEventListener mailboxEventListener : this.mailboxEventListeners) {
            mailboxEventListener.folderDeleted(this);
        }
        this.logger.debug("Folder " + this.getFullName() + " deleted");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MailboxFolder other = (MailboxFolder)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }

    public synchronized Message[] expunge() throws MessagingException {
        this.checkExists();
        ArrayList<MockMessage> expunged = new ArrayList<MockMessage>();
        for (Message msg : this.getByFlags(new Flags(Flags.Flag.DELETED), true)) {
            expunged.add(this.messages.remove(((MockMessage)msg).getMockid()));
            ((MockMessage)msg).setExpunged(true);
            for (MailboxEventListener mailboxEventListener : this.mailboxEventListeners) {
                mailboxEventListener.messageExpunged(this, (MockMessage)msg, true);
            }
        }
        this.logger.debug(expunged.size() + " messages expunged (deleted) from" + this.getFullName());
        return expunged.toArray(new Message[expunged.size()]);
    }

    public synchronized Message[] expunge(Message[] msgs) throws MessagingException {
        this.checkExists();
        ArrayList<Long> toExpunge = new ArrayList<Long>();
        for (Message msg : msgs) {
            toExpunge.add(((MockMessage)msg).getMockid());
        }
        ArrayList<MockMessage> expunged = new ArrayList<MockMessage>();
        for (Message msg : this.getByFlags(new Flags(Flags.Flag.DELETED), true)) {
            if (!toExpunge.contains(new Long(((MockMessage)msg).getMockid()))) continue;
            expunged.add(this.messages.remove(((MockMessage)msg).getMockid()));
            ((MockMessage)msg).setExpunged(true);
            for (MailboxEventListener mailboxEventListener : this.mailboxEventListeners) {
                mailboxEventListener.messageExpunged(this, (MockMessage)msg, true);
            }
        }
        this.logger.debug(expunged.size() + " messages expunged (deleted) from " + this.getFullName());
        return expunged.toArray(new Message[expunged.size()]);
    }

    public synchronized Message[] getByFlags(Flags flags, boolean mustSet) throws MessagingException {
        this.checkExists();
        ArrayList<MockMessage> sms = new ArrayList<MockMessage>();
        int num = 0;
        for (MockMessage mockMessage : new TreeSet<MockMessage>(this.messages.values())) {
            if ((!mustSet || !mockMessage.getFlags().contains(flags)) && (mustSet || mockMessage.getFlags().contains(flags))) continue;
            mockMessage.setMessageNumber(++num);
            sms.add(mockMessage);
        }
        this.logger.debug("getByFlags() for " + this.getFullName() + " returns " + sms.size());
        return sms.toArray(new Message[sms.size()]);
    }

    public synchronized Message getById(long id) {
        this.checkExists();
        Message m = (Message)this.messages.get(id);
        if (m == null) {
            this.logger.debug("No message with id " + id + ", return null");
            return null;
        }
        this.logger.debug("getById(" + id + ") for " + this.getFullName() + " returns successful");
        return m;
    }

    public synchronized Message[] getByIds(long start, long end) {
        this.checkExists();
        ArrayList<MockMessage> sms = new ArrayList<MockMessage>();
        int num = 0;
        MockMessage lastMsg = null;
        Iterator<MockMessage> i$ = new TreeSet<MockMessage>(this.messages.values()).iterator();
        while (i$.hasNext()) {
            MockMessage mockMessage;
            lastMsg = mockMessage = i$.next();
            if (end == -1L ? this.getMessageCount() != 1 && mockMessage.getMockid() < start : mockMessage.getMockid() < start || mockMessage.getMockid() > end) continue;
            mockMessage.setMessageNumber(++num);
            sms.add(mockMessage);
        }
        if (end == -1L && sms.size() == 0) {
            lastMsg.setMessageNumber(++num);
            sms.add(lastMsg);
        }
        this.logger.debug("getByIds(" + start + "," + end + " for " + this.getFullName() + " returns " + sms.size());
        return sms.toArray(new Message[sms.size()]);
    }

    public synchronized Message[] getByIds(long[] id) {
        this.checkExists();
        ArrayList<Long> idlist = new ArrayList<Long>();
        for (long value : id) {
            idlist.add(value);
        }
        ArrayList<MockMessage> sms = new ArrayList<MockMessage>();
        int num = 0;
        for (MockMessage mockMessage : new TreeSet<MockMessage>(this.messages.values())) {
            if (!idlist.contains(mockMessage.getMockid())) continue;
            mockMessage.setMessageNumber(++num);
            sms.add(mockMessage);
        }
        this.logger.debug("getByIds(" + Arrays.toString(id) + ") for " + this.getFullName() + " returns " + sms.size());
        return sms.toArray(new Message[sms.size()]);
    }

    public synchronized Message getByMsgNum(int msgnum) {
        this.checkExists();
        ArrayList<MockMessage> sms = new ArrayList<MockMessage>();
        int num = 0;
        for (MockMessage mockMessage : new TreeSet<MockMessage>(this.messages.values())) {
            mockMessage.setMessageNumber(++num);
            sms.add(mockMessage);
        }
        this.logger.debug("getByMsgNum(" + msgnum + "), size is " + sms.size());
        if (msgnum - 1 < 0 || msgnum > sms.size()) {
            throw new ArrayIndexOutOfBoundsException("message number (" + msgnum + ") out of bounds (" + sms.size() + ") for " + this.getFullName());
        }
        Message m = (Message)sms.get(msgnum - 1);
        return m;
    }

    public synchronized List<MailboxFolder> getChildren() {
        this.checkExists();
        return Collections.unmodifiableList(new ArrayList<MailboxFolder>(this.children));
    }

    public synchronized String getFullName() {
        if (this.isRoot()) {
            return "";
        }
        return this.parent.isRoot() ? this.name : this.parent.getFullName() + '/' + this.name;
    }

    public MockMailbox getMailbox() {
        return this.mailbox;
    }

    public synchronized int getMessageCount() {
        this.checkExists();
        this.logger.debug("getMessageCount() for " + this.getFullName() + " returns " + this.messages.size());
        return this.messages.size();
    }

    public synchronized Message[] getMessages() {
        this.checkExists();
        ArrayList<MockMessage> sms = new ArrayList<MockMessage>();
        int num = 0;
        for (MockMessage mockMessage : new TreeSet<MockMessage>(this.messages.values())) {
            mockMessage.setMessageNumber(++num);
            sms.add(mockMessage);
        }
        this.logger.debug("getMessages() for " + this.getFullName() + " returns " + sms.size());
        return sms.toArray(new Message[sms.size()]);
    }

    public String getName() {
        return this.name;
    }

    public MailboxFolder getOrAddSubFolder(String name) throws MessagingException {
        if (name == null || "".equals(name.trim())) {
            throw new MessagingException("cannot get or add root folder");
        }
        this.logger.debug("getOrAddSubFolder(" + name + ") on " + this.getFullName());
        String[] path = name.split(String.valueOf('/'));
        MailboxFolder last = this;
        for (int i = 0; i < path.length; ++i) {
            MailboxFolder tmp;
            String element = path[i];
            if ("inbox".equalsIgnoreCase(element)) {
                last = this.mailbox.getInbox();
                continue;
            }
            this.checkFolderName(element);
            MailboxFolder mbt = new MailboxFolder(element, this.mailbox, false);
            mbt.parent = last;
            int index = -1;
            index = last.children.indexOf(mbt);
            if (index != -1 && (tmp = last.children.get(index)).isExists()) {
                last = tmp;
                continue;
            }
            last.children.add(mbt);
            this.logger.debug("Subfolder " + mbt.getFullName() + " added");
            last = mbt;
        }
        return last;
    }

    public synchronized MailboxFolder getParent() {
        this.checkExists();
        return this.parent;
    }

    public synchronized int getSizeInBytes() throws MessagingException {
        this.checkExists();
        int size = 0;
        for (MockMessage mockMessage : new TreeSet<MockMessage>(this.messages.values())) {
            if (mockMessage.getSize() <= 0) continue;
            size += mockMessage.getSize();
        }
        return size;
    }

    public synchronized long getUID(Message msg) {
        this.checkExists();
        return ((MockMessage)msg).getMockid();
    }

    public synchronized long getUidValidity() {
        this.checkExists();
        return this.uidValidity;
    }

    protected long getUniqueMessageId() {
        return this.uniqueMessageId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public synchronized boolean hasMessages() {
        this.checkExists();
        return this.messages.isEmpty();
    }

    public synchronized void invalidateUid() {
        this.checkExists();
        this.uidValidity += 10L;
        for (MailboxEventListener mailboxEventListener : this.mailboxEventListeners) {
            mailboxEventListener.uidInvalidated();
        }
        this.logger.debug("UidValidity invalidated, new UidValidity is " + this.uidValidity);
    }

    public boolean isExists() {
        return this.exists;
    }

    public boolean isInbox() {
        return this.name != null && this.name.equalsIgnoreCase("inbox");
    }

    public boolean isRoot() {
        return this.name == null || this.name.equals("") || this.parent == null;
    }

    public boolean isSimulateError() {
        return this.simulateError;
    }

    protected boolean isSubscribed() {
        return this.subscribed;
    }

    public synchronized void markMessageAsDeleted(Message e) throws MessagingException {
        this.checkExists();
        ((MockMessage)e).setFlag(Flags.Flag.DELETED, true);
        this.logger.debug("Mark message " + ((MockMessage)e).getMockid() + " as deleted (Flag DELETED set)");
    }

    public synchronized void markMessageAsSeen(Message e) throws MessagingException {
        this.checkExists();
        ((MockMessage)e).setFlag(Flags.Flag.SEEN, true);
        this.logger.debug("Mark message " + ((MockMessage)e).getMockid() + " as seen (Flag SEEN set)");
    }

    @Override
    public void onFlagChange(MockMessage msg, Flags flags, boolean set) {
        for (MailboxEventListener mailboxEventListener : this.mailboxEventListeners) {
            mailboxEventListener.messageChanged(this, msg, false, true);
        }
        this.logger.debug("Flags of message " + msg.getMockid() + " change");
        if (this.messages.size() > 0 && this.messages.get(msg.getMockid()) != null) {
            try {
                if (set && this.messages.get(msg.getMockid()).getFlags().contains(flags)) {
                    return;
                }
                if (set && !this.messages.get(msg.getMockid()).getFlags().contains(flags)) {
                    this.messages.get(msg.getMockid()).setFlags(flags, set);
                }
                if (!set && this.messages.get(msg.getMockid()).getFlags().contains(flags)) {
                    this.messages.get(msg.getMockid()).setFlags(flags, set);
                }
                if (!set && !this.messages.get(msg.getMockid()).getFlags().contains(flags)) {
                    return;
                }
            }
            catch (Exception e) {
                this.logger.error("Error while changing flags " + e.toString(), (Throwable)e);
            }
        }
    }

    public synchronized void removeMailboxEventListener(MailboxEventListener l) {
        if (l != null) {
            this.mailboxEventListeners.remove(l);
        }
    }

    public synchronized void renameFolder(String newName) {
        this.checkExists();
        this.checkFolderName(this.name);
        this.checkFolderName(newName);
        String tmpOldName = this.name;
        this.name = newName;
        for (MailboxEventListener mailboxEventListener : this.mailboxEventListeners) {
            mailboxEventListener.folderRenamed(tmpOldName, this);
        }
        this.logger.debug("Folder " + tmpOldName + " renamed to " + newName + newName + " - New Fullname is " + this.getFullName());
    }

    public Message[] search(SearchTerm term, Message[] msgsToSearch) {
        ArrayList<MockMessage> sms = new ArrayList<MockMessage>();
        ArrayList<Message> msgsToSearchL = new ArrayList<Message>();
        if (msgsToSearch != null) {
            msgsToSearchL.addAll(Arrays.asList(msgsToSearch));
        }
        for (Message msg : this.getMessages()) {
            if (term == null || !term.match(msg) || msgsToSearch != null && !msgsToSearchL.contains(msg)) continue;
            sms.add((MockMessage)msg);
        }
        return sms.toArray(new Message[sms.size()]);
    }

    public void setSimulateError(boolean simulateError) {
        this.simulateError = simulateError;
    }

    protected void setSubscribed(boolean subscribed) {
        this.subscribed = subscribed;
    }

    public static interface MailboxEventListener {
        public void folderCreated(MailboxFolder var1);

        public void folderDeleted(MailboxFolder var1);

        public void folderRenamed(String var1, MailboxFolder var2);

        public void messageAdded(MailboxFolder var1, MockMessage var2);

        public void messageChanged(MailboxFolder var1, MockMessage var2, boolean var3, boolean var4);

        public void messageExpunged(MailboxFolder var1, MockMessage var2, boolean var3);

        public void uidInvalidated();
    }
}

