/*
 * Decompiled with CFR 0.152.
 */
package de.saly.javamail.mock2;

import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.AppendUID;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.imap.ResyncData;
import com.sun.mail.imap.SortTerm;
import de.saly.javamail.mock2.IMAPMockStore;
import de.saly.javamail.mock2.MailboxFolder;
import de.saly.javamail.mock2.MockMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Quota;
import javax.mail.event.MailEvent;
import javax.mail.internet.MimeMessage;
import javax.mail.search.SearchTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMAPMockFolder
extends IMAPFolder
implements MailboxFolder.MailboxEventListener {
    private static final int ABORTING = 2;
    private static final int IDLE = 1;
    private static final int RUNNING = 0;
    private final Semaphore idleLock = new Semaphore(0, true);
    private int idleState = 0;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MailboxFolder mailboxFolder;
    private final UUID objectId = UUID.randomUUID();
    private volatile boolean opened = false;
    private int openMode;
    private final IMAPMockStore store;

    protected IMAPMockFolder(IMAPMockStore store, MailboxFolder mailboxFolder) {
        super("DUMMY_NAME_WHICH_MUST_NOT_BE_VISIBLE", '/', (IMAPStore)store, Boolean.valueOf(false));
        this.mailboxFolder = mailboxFolder;
        this.mailboxFolder.addMailboxEventListener(this);
        this.store = store;
        this.logger.debug("Folder created " + this.objectId);
    }

    protected synchronized void abortIdle() {
        if (this.idleState == 1) {
            this.logger.trace("Abort idle");
            if (this.logger.isTraceEnabled()) {
                try {
                    throw new RuntimeException();
                }
                catch (Exception e) {
                    this.logger.trace("TRACE stacktrace ", (Throwable)e);
                }
            }
            this.idleState = 2;
            this.idleLock.release();
        }
    }

    public void appendMessages(Message[] msgs) throws MessagingException {
        this.abortIdle();
        this.checkExists();
        for (Message m : msgs) {
            this.mailboxFolder.add((MimeMessage)m);
        }
        this.logger.debug("Append " + msgs.length + " to " + this.getFullName());
    }

    public synchronized AppendUID[] appendUIDMessages(Message[] msgs) throws MessagingException {
        this.abortIdle();
        this.checkExists();
        AppendUID[] uids = new AppendUID[msgs.length];
        int i = 0;
        for (Message m : msgs) {
            MockMessage mockMessage = (MockMessage)this.mailboxFolder.add((MimeMessage)m);
            uids[i++] = new AppendUID(this.mailboxFolder.getUidValidity(), mockMessage.getMockid());
        }
        this.logger.debug("Append " + msgs.length + " to " + this.getFullName());
        return uids;
    }

    protected void checkClosed() {
        if (this.opened) {
            throw new IllegalStateException("This operation is not allowed on an open folder:" + this.getFullName() + " (" + this.objectId + ")");
        }
    }

    protected void checkExists() throws MessagingException {
        if (!this.exists()) {
            throw new FolderNotFoundException((Folder)this, this.getFullName() + " not found");
        }
    }

    protected void checkOpened() throws FolderClosedException {
        if (!this.opened) {
            throw new IllegalStateException("This operation is not allowed on a closed folder: " + this.getFullName() + " (" + this.objectId + ")");
        }
    }

    protected void checkWriteMode() {
        if (this.openMode != 2) {
            throw new IllegalStateException("Folder " + this.getFullName() + " is readonly" + " (" + this.objectId + ")");
        }
    }

    public synchronized void close(boolean expunge) throws MessagingException {
        this.abortIdle();
        this.checkOpened();
        this.checkExists();
        if (expunge) {
            this.expunge();
        }
        this.opened = false;
        this.logger.debug("Folder " + this.getFullName() + " closed (" + this.objectId + ")");
        this.notifyConnectionListeners(3);
    }

    public synchronized void copyMessages(Message[] msgs, Folder folder) throws MessagingException {
        this.abortIdle();
        this.checkOpened();
        this.checkExists();
        if (msgs == null || folder == null || msgs.length == 0) {
            return;
        }
        if (!folder.exists()) {
            throw new FolderNotFoundException(folder.getFullName() + " does not exist", folder);
        }
        folder.appendMessages(msgs);
    }

    public synchronized AppendUID[] copyUIDMessages(Message[] msgs, Folder folder) throws MessagingException {
        this.abortIdle();
        this.checkExists();
        this.checkOpened();
        if (msgs == null || folder == null || msgs.length == 0) {
            return null;
        }
        AppendUID[] uids = new AppendUID[msgs.length];
        int i = 0;
        for (Message m : msgs) {
            MockMessage mockMessage = (MockMessage)this.mailboxFolder.add((MimeMessage)m);
            uids[i++] = new AppendUID(this.mailboxFolder.getUidValidity(), mockMessage.getMockid());
        }
        this.logger.debug("Copied " + msgs.length + " to " + this.getFullName());
        return uids;
    }

    public synchronized boolean create(int type) throws MessagingException {
        this.abortIdle();
        if (this.exists()) {
            return true;
        }
        this.mailboxFolder.create();
        this.notifyFolderListeners(1);
        return this.mailboxFolder.isExists();
    }

    public synchronized boolean delete(boolean recurse) throws MessagingException {
        this.abortIdle();
        this.checkExists();
        this.checkClosed();
        this.mailboxFolder.deleteFolder(recurse);
        this.notifyFolderListeners(2);
        return true;
    }

    public synchronized Object doCommand(IMAPFolder.ProtocolCommand cmd) throws MessagingException {
        throw new MessagingException("no protocol for mock class - you should never see this exception. Please file a bugrfeport and include stacktrace");
    }

    public synchronized Object doCommandIgnoreFailure(IMAPFolder.ProtocolCommand cmd) throws MessagingException {
        throw new MessagingException("no protocol for mock class - you should never see this exception. Please file a bugrfeport and include stacktrace");
    }

    public synchronized Object doOptionalCommand(String err, IMAPFolder.ProtocolCommand cmd) throws MessagingException {
        throw new MessagingException("Optional command not supported: " + err);
    }

    protected synchronized Object doProtocolCommand(IMAPFolder.ProtocolCommand cmd) throws ProtocolException {
        throw new ProtocolException("no protocol for mock class - you should never see this exception. Please file a bugrfeport and include stacktrace");
    }

    public synchronized boolean exists() throws MessagingException {
        this.abortIdle();
        return this.mailboxFolder.isExists();
    }

    public synchronized Message[] expunge() throws MessagingException {
        this.abortIdle();
        this.checkExists();
        this.checkOpened();
        this.checkWriteMode();
        Message[] removed = this.wrap(this.mailboxFolder.expunge());
        if (removed.length > 0) {
            this.notifyMessageRemovedListeners(true, removed);
        }
        return removed;
    }

    public synchronized Message[] expunge(Message[] msgs) throws MessagingException {
        this.abortIdle();
        this.checkExists();
        this.checkOpened();
        this.checkWriteMode();
        Message[] removed = this.wrap(this.mailboxFolder.expunge(msgs));
        if (removed.length > 0) {
            this.notifyMessageRemovedListeners(true, removed);
        }
        return removed;
    }

    public synchronized void fetch(Message[] msgs, FetchProfile fp) throws MessagingException {
        this.abortIdle();
    }

    @Override
    public void folderCreated(MailboxFolder mf) {
    }

    @Override
    public void folderDeleted(MailboxFolder mf) {
    }

    @Override
    public void folderRenamed(String from, MailboxFolder to) {
    }

    public synchronized void forceClose() throws MessagingException {
        this.close(false);
    }

    public synchronized String[] getAttributes() throws MessagingException {
        this.checkExists();
        return new String[0];
    }

    public synchronized int getDeletedMessageCount() throws MessagingException {
        this.abortIdle();
        this.checkExists();
        if (!this.opened) {
            return -1;
        }
        return this.mailboxFolder.getByFlags(new Flags(Flags.Flag.DELETED), false).length;
    }

    public synchronized Folder getFolder(String name) throws MessagingException {
        this.abortIdle();
        this.logger.debug("getFolder(" + name + ") on " + this.getFullName());
        if ("inbox".equalsIgnoreCase(name)) {
            return new IMAPMockFolder(this.store, this.mailboxFolder.getMailbox().getInbox());
        }
        return new IMAPMockFolder(this.store, this.mailboxFolder.getOrAddSubFolder(name));
    }

    public synchronized String getFullName() {
        return this.mailboxFolder.getFullName();
    }

    public synchronized long getHighestModSeq() throws MessagingException {
        throw new MessagingException("CONDSTORE not supported");
    }

    public Message getMessage(int msgnum) throws MessagingException {
        this.abortIdle();
        this.checkExists();
        this.checkOpened();
        return new MockMessage(this.mailboxFolder.getByMsgNum(msgnum), (Folder)this);
    }

    public synchronized Message getMessageByUID(long uid) throws MessagingException {
        this.abortIdle();
        this.checkExists();
        this.checkOpened();
        return new MockMessage(this.mailboxFolder.getById(uid), (Folder)this);
    }

    public int getMessageCount() throws MessagingException {
        this.abortIdle();
        this.checkExists();
        return this.mailboxFolder.getMessageCount();
    }

    public Message[] getMessages(int low, int high) throws MessagingException {
        this.abortIdle();
        this.checkExists();
        this.checkOpened();
        ArrayList<MockMessage> messages = new ArrayList<MockMessage>();
        for (int i = low; i <= high; ++i) {
            Message m = this.mailboxFolder.getByMsgNum(i);
            messages.add(new MockMessage(m, (Folder)this));
        }
        return messages.toArray(new Message[messages.size()]);
    }

    public synchronized Message[] getMessagesByUID(long start, long end) throws MessagingException {
        this.abortIdle();
        this.checkExists();
        this.checkOpened();
        return this.wrap(this.mailboxFolder.getByIds(start, end));
    }

    public synchronized Message[] getMessagesByUID(long[] uids) throws MessagingException {
        this.abortIdle();
        this.checkExists();
        this.checkOpened();
        return this.wrap(this.mailboxFolder.getByIds(uids));
    }

    public synchronized Message[] getMessagesByUIDChangedSince(long start, long end, long modseq) throws MessagingException {
        throw new MessagingException("CONDSTORE not supported");
    }

    public synchronized String getName() {
        return this.mailboxFolder.getName();
    }

    public int getNewMessageCount() throws MessagingException {
        this.abortIdle();
        this.checkExists();
        return this.mailboxFolder.getByFlags(new Flags(Flags.Flag.RECENT), true).length;
    }

    public Folder getParent() throws MessagingException {
        this.checkExists();
        if (this.mailboxFolder.getParent() == null) {
            throw new MessagingException("no parent, is already default root");
        }
        return new IMAPMockFolder(this.store, this.mailboxFolder.getParent());
    }

    public Flags getPermanentFlags() {
        return null;
    }

    public Quota[] getQuota() throws MessagingException {
        throw new MessagingException("QUOTA not supported");
    }

    public char getSeparator() throws MessagingException {
        this.abortIdle();
        return '/';
    }

    public synchronized Message[] getSortedMessages(SortTerm[] term) throws MessagingException {
        throw new MessagingException("SORT not supported");
    }

    public synchronized Message[] getSortedMessages(SortTerm[] term, SearchTerm sterm) throws MessagingException {
        throw new MessagingException("SORT not supported");
    }

    public int getType() throws MessagingException {
        return this.mailboxFolder.isRoot() ? 2 : 3;
    }

    public synchronized long getUID(Message message) throws MessagingException {
        this.abortIdle();
        return this.mailboxFolder.getUID(message);
    }

    public synchronized long getUIDNext() throws MessagingException {
        this.abortIdle();
        return this.mailboxFolder.getUniqueMessageId() + 10L;
    }

    public synchronized long getUIDValidity() throws MessagingException {
        this.abortIdle();
        return this.mailboxFolder.getUidValidity();
    }

    public synchronized int getUnreadMessageCount() throws MessagingException {
        this.abortIdle();
        this.checkExists();
        return this.mailboxFolder.getByFlags(new Flags(Flags.Flag.SEEN), false).length;
    }

    public void handleResponse(Response r) {
        throw new RuntimeException("not implemented/should not happen");
    }

    public boolean hasNewMessages() throws MessagingException {
        this.checkExists();
        return this.getNewMessageCount() > 0;
    }

    public Map<String, String> id(Map<String, String> clientParams) throws MessagingException {
        return this.store.id(clientParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void idle(boolean once) throws MessagingException {
        if (Thread.holdsLock(this)) {
            this.logger.error("Thread already hold folder lock, thats not supposed to be the case");
        }
        IMAPMockFolder iMAPMockFolder = this;
        synchronized (iMAPMockFolder) {
            this.checkOpened();
            if (this.idleState != 0) {
                this.logger.trace("Another thread is idle, return from idle()");
                return;
            }
            this.idleState = 1;
        }
        this.logger.trace("Now idle ...");
        try {
            while (this.idleState != 2 && this.opened && this.mailboxFolder.isExists()) {
                this.logger.trace("wait for folder actions");
                this.idleLock.acquire();
                this.logger.trace("folder action happend");
                if (!once) continue;
                this.logger.trace("once =0 true, so return from idle()");
                break;
            }
            this.logger.trace("while loop end with idle state " + this.idleState);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.logger.trace("set idle state to: running");
            this.idleState = 0;
        }
        this.logger.trace("return from idle()");
    }

    public boolean isOpen() {
        return this.opened;
    }

    public synchronized boolean isSubscribed() {
        this.abortIdle();
        return this.mailboxFolder.isSubscribed();
    }

    public Folder[] list(String pattern) throws MessagingException {
        this.abortIdle();
        this.checkExists();
        List<MailboxFolder> children = this.mailboxFolder.getChildren();
        ArrayList<IMAPMockFolder> ret = new ArrayList<IMAPMockFolder>();
        for (MailboxFolder mf : children) {
            if (!mf.isExists()) continue;
            ret.add(new IMAPMockFolder(this.store, mf));
        }
        this.logger.debug("Folder (" + this.getFullName() + ") list return " + ret);
        return ret.toArray(new Folder[ret.size()]);
    }

    public Folder[] listSubscribed(String pattern) throws MessagingException {
        this.abortIdle();
        this.checkExists();
        List<MailboxFolder> children = this.mailboxFolder.getChildren();
        ArrayList<IMAPMockFolder> ret = new ArrayList<IMAPMockFolder>();
        for (MailboxFolder mf : children) {
            if (!mf.isExists() || !mf.isSubscribed()) continue;
            ret.add(new IMAPMockFolder(this.store, mf));
        }
        this.logger.debug("Folder (" + this.getFullName() + ") list subscribed return " + ret);
        return ret.toArray(new Folder[ret.size()]);
    }

    @Override
    public void messageAdded(MailboxFolder mf, MockMessage msg) {
        this.notifyMessageAddedListeners(new Message[]{msg});
        this.idleLock.release();
    }

    @Override
    public void messageChanged(MailboxFolder mf, MockMessage msg, boolean headerChanged, boolean flagsChanged) {
        this.notifyMessageChangedListeners(1, (Message)msg);
        this.idleLock.release();
    }

    @Override
    public void messageExpunged(MailboxFolder mf, MockMessage msg, boolean removed) {
        this.idleLock.release();
    }

    public void open(int mode) throws MessagingException {
        this.checkClosed();
        this.checkExists();
        this.opened = true;
        this.openMode = mode;
        this.logger.debug("Open folder " + this.getFullName() + " (" + this.objectId + ")");
        this.notifyConnectionListeners(1);
    }

    public synchronized List<MailEvent> open(int mode, ResyncData rd) throws MessagingException {
        if (rd == null) {
            this.open(mode);
            return null;
        }
        throw new MessagingException("CONDSTORE and QRESYNC not supported");
    }

    public synchronized boolean renameTo(Folder f) throws MessagingException {
        this.abortIdle();
        this.checkClosed();
        this.checkExists();
        if (f.getStore() != this.store) {
            throw new MessagingException("Can't rename across Stores");
        }
        this.mailboxFolder.renameFolder(f.getName());
        this.notifyFolderRenamedListeners(f);
        return true;
    }

    public Message[] search(SearchTerm term) throws MessagingException {
        this.abortIdle();
        this.checkOpened();
        return this.mailboxFolder.search(term, null);
    }

    public Message[] search(SearchTerm term, Message[] msgs) throws MessagingException {
        this.abortIdle();
        this.checkOpened();
        return this.mailboxFolder.search(term, msgs);
    }

    public synchronized void setFlags(Message[] msgs, Flags flag, boolean value) throws MessagingException {
        this.abortIdle();
        this.checkOpened();
        for (Message message : msgs) {
            Message m = this.mailboxFolder.getById(((MockMessage)message).getMockid());
            if (m == null) continue;
            m.setFlags(flag, value);
        }
    }

    public void setQuota(Quota quota) throws MessagingException {
        throw new MessagingException("QUOTA not supported");
    }

    public synchronized void setSubscribed(boolean subscribe) throws MessagingException {
        this.abortIdle();
        this.mailboxFolder.setSubscribed(subscribe);
    }

    @Override
    public void uidInvalidated() {
    }

    private Message[] wrap(Message[] msgs) throws MessagingException {
        Message[] ret = new Message[msgs.length];
        int i = 0;
        for (Message message : msgs) {
            ret[i++] = new MockMessage(message, (Folder)this);
        }
        return ret;
    }
}

