/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.serializers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.serializers.FSTCollectionSerializer;
import org.nustaq.serialization.util.FSTUtil;

public class FSTUnmodifiableCollectionSerializer
extends FSTCollectionSerializer {
    public static final Class<?> UNMODIFIABLE_COLLECTION_CLASS;
    public static final Class<?> UNMODIFIABLE_LIST_CLASS;
    public static final Class<?> UNMODIFIABLE_SET_CLASS;

    @Override
    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPosition) throws Exception {
        try {
            int len = in.readInt();
            if (UNMODIFIABLE_LIST_CLASS.isAssignableFrom(objectClass)) {
                ArrayList res = new ArrayList(len);
                this.fillArray(in, serializationInfo, referencee, streamPosition, res, len);
                return Collections.unmodifiableList(res);
            }
            if (UNMODIFIABLE_SET_CLASS.isAssignableFrom(objectClass)) {
                HashSet res = new HashSet(len);
                this.fillArray(in, serializationInfo, referencee, streamPosition, res, len);
                return Collections.unmodifiableSet(res);
            }
        }
        catch (Throwable th) {
            FSTUtil.rethrow(th);
        }
        return null;
    }

    private void fillArray(FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPosition, Object res, int len) throws ClassNotFoundException, IOException, IllegalAccessException, InstantiationException {
        in.registerObject(res, streamPosition, serializationInfo, referencee);
        Collection col = (Collection)res;
        if (col instanceof ArrayList) {
            ((ArrayList)col).ensureCapacity(len);
        }
        for (int i = 0; i < len; ++i) {
            Object o = in.readObjectInternal(null);
            col.add(o);
        }
    }

    static {
        try {
            UNMODIFIABLE_COLLECTION_CLASS = Class.forName("java.util.Collections$UnmodifiableCollection");
            UNMODIFIABLE_LIST_CLASS = Class.forName("java.util.Collections$UnmodifiableList");
            UNMODIFIABLE_SET_CLASS = Class.forName("java.util.Collections$UnmodifiableSet");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot load java.util.Collections classes", e);
        }
    }
}

