/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.coders;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTCrossPlatformSerialzer;
import org.nustaq.serialization.FSTEncoder;
import org.nustaq.serialization.FSTObjectOutput;
import org.nustaq.serialization.minbin.MBOut;
import org.nustaq.serialization.minbin.MinBin;

public class FSTMinBinEncoder
implements FSTEncoder {
    MBOut out = new MBOut();
    OutputStream outputStream;
    FSTConfiguration conf;
    private int offset = 0;

    public FSTMinBinEncoder(FSTConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public void writeRawBytes(byte[] bufferedName, int off, int length) throws IOException {
        this.out.writeArray(bufferedName, off, length);
    }

    @Override
    public void setConf(FSTConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public void writePrimitiveArray(Object array, int start, int length) throws IOException {
        this.out.writeArray(array, start, length);
    }

    @Override
    public void writeStringUTF(String str) throws IOException {
        this.out.writeTag(str);
    }

    @Override
    public void writeFShort(short c) throws IOException {
        this.out.writeInt((byte)2, c);
    }

    @Override
    public void writeFChar(char c) throws IOException {
        this.out.writeInt((byte)10, c);
    }

    @Override
    public void writeFByte(int v) throws IOException {
        this.out.writeInt((byte)1, v);
    }

    @Override
    public void writeFInt(int anInt) throws IOException {
        this.out.writeInt((byte)3, anInt);
    }

    @Override
    public void writeFLong(long anInt) throws IOException {
        this.out.writeInt((byte)4, anInt);
    }

    @Override
    public void writeFFloat(float value) throws IOException {
        this.out.writeTag(Float.valueOf(value));
    }

    @Override
    public void writeFDouble(double value) throws IOException {
        this.out.writeTag(value);
    }

    @Override
    public int getWritten() {
        return this.out.getWritten() + this.offset;
    }

    @Override
    public void skip(int i) {
        throw new RuntimeException("not supported");
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }

    @Override
    public void reset(byte[] bytez) {
        this.offset = 0;
        if (bytez != null) {
            this.out.reset(bytez);
        } else {
            this.out.reset();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.write(this.out.getBytez(), 0, this.out.getWritten());
            this.offset = this.out.getWritten();
            this.out.resetPosition();
        }
    }

    @Override
    public void writeInt32At(int position, int v) {
        throw new RuntimeException("not supported");
    }

    @Override
    public void setOutstream(OutputStream outstream) {
        this.outputStream = outstream;
    }

    @Override
    public void ensureFree(int bytes) throws IOException {
    }

    @Override
    public byte[] getBuffer() {
        return this.out.getBytez();
    }

    @Override
    public void registerClass(Class possible) {
    }

    @Override
    public void writeClass(Class cl) {
    }

    @Override
    public void writeClass(FSTClazzInfo clInf) {
    }

    @Override
    public void writeAttributeName(FSTClazzInfo.FSTFieldInfo subInfo) {
        byte[] bufferedName = (byte[])subInfo.getBufferedName();
        if (bufferedName != null) {
            this.out.writeRaw(bufferedName, 0, bufferedName.length);
        } else {
            int pos = this.out.getWritten();
            this.out.writeTag(subInfo.getName());
            int len = this.out.getWritten() - pos;
            bufferedName = new byte[len];
            System.arraycopy(this.out.getBytez(), pos, bufferedName, 0, len);
            subInfo.setBufferedName(bufferedName);
        }
    }

    @Override
    public boolean writeTag(byte tag, Object infoOrObject, long somValue, Object toWrite, FSTObjectOutput oout) throws IOException {
        switch (tag) {
            case -7: {
                this.out.writeTagHeader((byte)9);
                this.out.writeInt((byte)3, somValue);
                return true;
            }
            case -1: {
                this.out.writeTag(null);
                return true;
            }
            case -3: 
            case 0: {
                FSTClazzInfo clzInfo = (FSTClazzInfo)infoOrObject;
                if (clzInfo.useCompatibleMode() && clzInfo.getSer() == null) {
                    throw new RuntimeException("Unsupported backward compatibility mode for class '" + clzInfo.getClazz().getName() + "'. Pls register a Custom Serializer to fix");
                }
                if (clzInfo.getClazz() == String.class || clzInfo.getClazz() == Double.class || clzInfo.getClazz() == Float.class || clzInfo.getClazz() == Byte.class || clzInfo.getClazz() == Short.class || clzInfo.getClazz() == Integer.class || clzInfo.getClazz() == Long.class || clzInfo.getClazz() == Character.class || clzInfo.getClazz() == Boolean.class) break;
                if (clzInfo.getSer() != null || clzInfo.isExternalizable()) {
                    this.out.writeTagHeader((byte)6);
                    this.writeSymbolicClazz(clzInfo.getClazz());
                    this.out.writeIntPacked(-1L);
                    break;
                }
                this.out.writeTagHeader((byte)5);
                this.writeSymbolicClazz(clzInfo.getClazz());
                this.out.writeIntPacked(clzInfo.getFieldInfo().length);
                break;
            }
            case -18: {
                throw new RuntimeException("not implemented");
            }
            case -4: {
                break;
            }
            case -17: {
                this.out.writeTag(Boolean.FALSE);
                break;
            }
            case -16: {
                this.out.writeTag(Boolean.TRUE);
                break;
            }
            case -10: {
                break;
            }
            case -9: {
                break;
            }
            case -5: {
                Class<?> clz = infoOrObject.getClass();
                Class<?> componentType = clz.getComponentType();
                if (clz.isArray() && componentType.isPrimitive()) {
                    if (componentType == Double.TYPE) {
                        this.out.writeTagHeader((byte)6);
                        this.writeSymbolicClazz(clz);
                        int length = Array.getLength(infoOrObject);
                        this.out.writeIntPacked(length);
                        for (int i = 0; i < length; ++i) {
                            this.out.writeTag(Array.getDouble(infoOrObject, i));
                        }
                    } else if (componentType == Float.TYPE) {
                        this.out.writeTagHeader((byte)6);
                        this.writeSymbolicClazz(clz);
                        int length = Array.getLength(infoOrObject);
                        this.out.writeIntPacked(length);
                        for (int i = 0; i < length; ++i) {
                            this.out.writeTag(Float.valueOf(Array.getFloat(infoOrObject, i)));
                        }
                    } else {
                        this.out.writeArray(infoOrObject, 0, Array.getLength(infoOrObject));
                    }
                    return true;
                }
                this.out.writeTagHeader((byte)6);
                this.writeSymbolicClazz(clz);
                break;
            }
            case -6: {
                this.out.writeTagHeader((byte)6);
                boolean isEnumClass = toWrite.getClass().isEnum();
                Class<?> c = toWrite.getClass();
                if (!isEnumClass) {
                    while (c != null && !c.isEnum()) {
                        c = toWrite.getClass().getSuperclass();
                    }
                    if (c == null) {
                        throw new RuntimeException("Can't handle this enum: " + toWrite.getClass());
                    }
                    this.writeSymbolicClazz(c);
                } else {
                    this.writeSymbolicClazz(c);
                }
                this.out.writeIntPacked(1L);
                this.out.writeObject(toWrite.toString());
                return true;
            }
            default: {
                throw new RuntimeException("unexpected tag " + tag);
            }
        }
        return false;
    }

    private void writeSymbolicClazz(Class<?> clz) {
        byte[] b = this.conf.getCrossPlatformBinaryCache(clz.getName());
        if (b == null) {
            int pos = this.out.getWritten();
            this.out.writeTag(this.classToString(clz));
            int len = this.out.getWritten() - pos;
            b = new byte[len];
            System.arraycopy(this.out.getBytez(), pos, b, 0, len);
            this.conf.registerCrossPlatformClassBinaryCache(clz.getName(), b);
        } else {
            this.out.writeRaw(b, 0, b.length);
        }
    }

    protected String classToString(Class clz) {
        return this.conf.getCPNameForClass(clz);
    }

    @Override
    public void externalEnd(FSTClazzInfo clz) {
        if (clz == null || clz.isExternalizable() || clz.getSer() instanceof FSTCrossPlatformSerialzer && ((FSTCrossPlatformSerialzer)clz.getSer()).writeTupleEnd()) {
            this.out.writeTag(MinBin.END_MARKER);
        }
    }

    @Override
    public boolean isWritingAttributes() {
        return true;
    }

    @Override
    public boolean isPrimitiveArray(Object array, Class<?> componentType) {
        return componentType.isPrimitive() && !(array instanceof double[]) && !(array instanceof float[]);
    }

    @Override
    public boolean isTagMultiDimSubArrays() {
        return true;
    }

    @Override
    public void writeVersionTag(int version) throws IOException {
    }

    @Override
    public boolean isByteArrayBased() {
        return true;
    }

    @Override
    public void writeArrayEnd() {
    }

    @Override
    public void writeFieldsEnd(FSTClazzInfo serializationInfo) {
    }
}

