/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.nustaq.offheap.bytez.onheap.HeapBytez;
import org.nustaq.offheap.structs.FSTStruct;
import org.nustaq.serialization.FSTClassInstantiator;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTClazzInfoRegistry;
import org.nustaq.serialization.FSTClazzNameRegistry;
import org.nustaq.serialization.FSTDecoder;
import org.nustaq.serialization.FSTDefaultClassInstantiator;
import org.nustaq.serialization.FSTEncoder;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.nustaq.serialization.FSTObjectSerializer;
import org.nustaq.serialization.FSTObjenesisInstantiator;
import org.nustaq.serialization.FSTSerializerRegistry;
import org.nustaq.serialization.FSTSerializerRegistryDelegate;
import org.nustaq.serialization.coders.FSTBytezDecoder;
import org.nustaq.serialization.coders.FSTBytezEncoder;
import org.nustaq.serialization.coders.FSTMinBinDecoder;
import org.nustaq.serialization.coders.FSTMinBinEncoder;
import org.nustaq.serialization.coders.FSTStreamDecoder;
import org.nustaq.serialization.coders.FSTStreamEncoder;
import org.nustaq.serialization.serializers.FSTArrayListSerializer;
import org.nustaq.serialization.serializers.FSTBigNumberSerializers;
import org.nustaq.serialization.serializers.FSTCPEnumSetSerializer;
import org.nustaq.serialization.serializers.FSTCPThrowableSerializer;
import org.nustaq.serialization.serializers.FSTClassSerializer;
import org.nustaq.serialization.serializers.FSTCollectionSerializer;
import org.nustaq.serialization.serializers.FSTDateSerializer;
import org.nustaq.serialization.serializers.FSTEnumSetSerializer;
import org.nustaq.serialization.serializers.FSTMapSerializer;
import org.nustaq.serialization.serializers.FSTStringBufferSerializer;
import org.nustaq.serialization.serializers.FSTStringBuilderSerializer;
import org.nustaq.serialization.serializers.FSTStringSerializer;
import org.nustaq.serialization.serializers.FSTStructSerializer;
import org.nustaq.serialization.util.FSTInputStream;
import org.nustaq.serialization.util.FSTUtil;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public class FSTConfiguration {
    StreamCoderFactory streamCoderFactory = new StreamCoderFactory(){

        @Override
        public FSTEncoder createStreamEncoder() {
            return new FSTStreamEncoder(FSTConfiguration.this);
        }

        @Override
        public FSTDecoder createStreamDecoder() {
            return new FSTStreamDecoder(FSTConfiguration.this);
        }
    };
    ConfType type = ConfType.DEFAULT;
    FSTClazzInfoRegistry serializationInfoRegistry = new FSTClazzInfoRegistry(this);
    HashMap<Class, List<SoftReference>> cachedObjects = new HashMap(97);
    FSTClazzNameRegistry classRegistry = new FSTClazzNameRegistry(null, this);
    boolean preferSpeed = false;
    boolean shareReferences = true;
    ClassLoader classLoader = this.getClass().getClassLoader();
    boolean forceSerializable = false;
    FSTClassInstantiator instantiator = new FSTDefaultClassInstantiator();
    boolean forceClzInit = false;
    int cpAttrIdCount = 0;
    private HashMap<String, String> minbinNames = new HashMap();
    private HashMap<String, byte[]> minBinNamesBytez = new HashMap();
    private HashMap<String, String> minbinNamesReverse = new HashMap();
    private boolean crossPlatform = false;
    public static boolean isAndroid = System.getProperty("java.runtime.name", "no").toLowerCase().contains("android");
    static AtomicBoolean conflock = new AtomicBoolean(false);
    static FSTConfiguration singleton;
    AtomicBoolean cacheLock = new AtomicBoolean(false);
    ThreadLocal<FSTObjectOutput> output = new ThreadLocal<FSTObjectOutput>(){

        @Override
        protected FSTObjectOutput initialValue() {
            if (FSTConfiguration.this.type == ConfType.DEFAULT) {
                return new FSTObjectOutput(FSTConfiguration.this){
                    FSTStreamEncoder st;

                    @Override
                    protected void setCodec(FSTEncoder codec) {
                        this.st = (FSTStreamEncoder)codec;
                    }

                    @Override
                    public FSTStreamEncoder getCodec() {
                        return this.st;
                    }
                };
            }
            if (FSTConfiguration.this.type == ConfType.UNSAFE) {
                return new FSTObjectOutput(FSTConfiguration.this){
                    FSTBytezEncoder st;

                    @Override
                    protected void setCodec(FSTEncoder codec) {
                        this.st = (FSTBytezEncoder)codec;
                    }

                    @Override
                    public FSTBytezEncoder getCodec() {
                        return this.st;
                    }
                };
            }
            return new FSTObjectOutput(FSTConfiguration.this);
        }
    };
    ThreadLocal<FSTObjectInput> input = new ThreadLocal<FSTObjectInput>(){

        @Override
        protected FSTObjectInput initialValue() {
            try {
                if (FSTConfiguration.this.type == ConfType.DEFAULT) {
                    return new FSTObjectInput(FSTConfiguration.this){
                        FSTStreamDecoder st;

                        @Override
                        void setCodec(FSTDecoder codec) {
                            this.st = (FSTStreamDecoder)codec;
                        }

                        @Override
                        public FSTStreamDecoder getCodec() {
                            return this.st;
                        }
                    };
                }
                if (FSTConfiguration.this.type == ConfType.UNSAFE) {
                    return new FSTObjectInput(FSTConfiguration.this){
                        FSTBytezDecoder st;

                        @Override
                        void setCodec(FSTDecoder codec) {
                            this.st = (FSTBytezDecoder)codec;
                        }

                        @Override
                        public FSTBytezDecoder getCodec() {
                            return this.st;
                        }
                    };
                }
                return new FSTObjectInput(FSTConfiguration.this);
            }
            catch (Exception e) {
                throw FSTUtil.rethrow(e);
            }
        }
    };
    AtomicBoolean cplock = new AtomicBoolean(false);

    public boolean isForceClzInit() {
        return this.forceClzInit;
    }

    public FSTConfiguration setForceClzInit(boolean forceClzInit) {
        this.forceClzInit = forceClzInit;
        return this;
    }

    public FSTClassInstantiator getInstantiator(Class clazz) {
        return this.instantiator;
    }

    public void setInstantiator(FSTClassInstantiator instantiator) {
        this.instantiator = instantiator;
    }

    public static FSTConfiguration getDefaultConfiguration() {
        while (!conflock.compareAndSet(false, true)) {
        }
        try {
            if (singleton == null) {
                singleton = FSTConfiguration.createDefaultConfiguration();
            }
            FSTConfiguration fSTConfiguration = singleton;
            return fSTConfiguration;
        }
        finally {
            conflock.set(false);
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static FSTConfiguration createMinBinConfiguration() {
        final FSTConfiguration res = FSTConfiguration.createDefaultConfiguration();
        res.setCrossPlatform(true);
        res.type = ConfType.MINBIN;
        res.setStreamCoderFactory(new StreamCoderFactory(){

            @Override
            public FSTEncoder createStreamEncoder() {
                return new FSTMinBinEncoder(res);
            }

            @Override
            public FSTDecoder createStreamDecoder() {
                return new FSTMinBinDecoder(res);
            }
        });
        FSTSerializerRegistry reg = res.serializationInfoRegistry.serializerRegistry;
        reg.putSerializer(EnumSet.class, new FSTCPEnumSetSerializer(), true);
        reg.putSerializer(Throwable.class, new FSTCPThrowableSerializer(), true);
        reg.putSerializer(AbstractCollection.class, new FSTCollectionSerializer(), true);
        reg.putSerializer(AbstractMap.class, new FSTMapSerializer(), true);
        res.registerCrossPlatformClassMapping(new String[][]{{"map", HashMap.class.getName()}, {"list", ArrayList.class.getName()}, {"long", Long.class.getName()}, {"integer", Integer.class.getName()}, {"short", Short.class.getName()}, {"byte", Byte.class.getName()}, {"char", Character.class.getName()}, {"float", Float.class.getName()}, {"double", Double.class.getName()}, {"date", Date.class.getName()}, {"enumSet", "java.util.RegularEnumSet"}, {"array", "[Ljava.lang.Object;"}, {"String[]", "[Ljava.lang.String;"}, {"Double[]", "[Ljava.lang.Double;"}, {"Float[]", "[Ljava.lang.Float;"}, {"double[]", "[D"}, {"float[]", "[F"}});
        return res;
    }

    public static FSTConfiguration createAndroidDefaultConfiguration() {
        ObjenesisStd genesis = new ObjenesisStd();
        FSTConfiguration conf = new FSTConfiguration((Objenesis)genesis){
            final /* synthetic */ Objenesis val$genesis;
            {
                this.val$genesis = objenesis;
            }

            @Override
            public FSTClassInstantiator getInstantiator(Class clazz) {
                return new FSTObjenesisInstantiator(this.val$genesis, clazz);
            }
        };
        FSTConfiguration.initDefaultFstConfigurationInternal(conf);
        return conf;
    }

    public static FSTConfiguration createDefaultConfiguration() {
        if (isAndroid) {
            return FSTConfiguration.createAndroidDefaultConfiguration();
        }
        FSTConfiguration conf = new FSTConfiguration();
        return FSTConfiguration.initDefaultFstConfigurationInternal(conf);
    }

    protected static FSTConfiguration initDefaultFstConfigurationInternal(FSTConfiguration conf) {
        conf.addDefaultClazzes();
        FSTSerializerRegistry reg = conf.serializationInfoRegistry.serializerRegistry;
        reg.putSerializer(Class.class, new FSTClassSerializer(), false);
        reg.putSerializer(String.class, new FSTStringSerializer(), false);
        reg.putSerializer(Byte.class, new FSTBigNumberSerializers.FSTByteSerializer(), false);
        reg.putSerializer(Character.class, new FSTBigNumberSerializers.FSTCharSerializer(), false);
        reg.putSerializer(Short.class, new FSTBigNumberSerializers.FSTShortSerializer(), false);
        reg.putSerializer(Float.class, new FSTBigNumberSerializers.FSTFloatSerializer(), false);
        reg.putSerializer(Double.class, new FSTBigNumberSerializers.FSTDoubleSerializer(), false);
        reg.putSerializer(Date.class, new FSTDateSerializer(), false);
        reg.putSerializer(StringBuffer.class, new FSTStringBufferSerializer(), true);
        reg.putSerializer(StringBuilder.class, new FSTStringBuilderSerializer(), true);
        reg.putSerializer(EnumSet.class, new FSTEnumSetSerializer(), true);
        reg.putSerializer(ArrayList.class, new FSTArrayListSerializer(), false);
        reg.putSerializer(Vector.class, new FSTCollectionSerializer(), false);
        reg.putSerializer(LinkedList.class, new FSTCollectionSerializer(), false);
        reg.putSerializer(HashSet.class, new FSTCollectionSerializer(), false);
        reg.putSerializer(HashMap.class, new FSTMapSerializer(), false);
        reg.putSerializer(LinkedHashMap.class, new FSTMapSerializer(), false);
        reg.putSerializer(Hashtable.class, new FSTMapSerializer(), true);
        reg.putSerializer(ConcurrentHashMap.class, new FSTMapSerializer(), true);
        reg.putSerializer(FSTStruct.class, new FSTStructSerializer(), true);
        return conf;
    }

    public static FSTConfiguration createFastBinaryConfiguration() {
        if (isAndroid) {
            throw new RuntimeException("not supported under android platform, use default configuration");
        }
        final FSTConfiguration conf = FSTConfiguration.createDefaultConfiguration();
        conf.type = ConfType.UNSAFE;
        conf.setStreamCoderFactory(new StreamCoderFactory(){

            @Override
            public FSTEncoder createStreamEncoder() {
                return new FSTBytezEncoder(conf, new HeapBytez(new byte[4096]));
            }

            @Override
            public FSTDecoder createStreamDecoder() {
                return new FSTBytezDecoder(conf);
            }
        });
        return conf;
    }

    public void registerSerializer(Class clazz, FSTObjectSerializer ser, boolean alsoForAllSubclasses) {
        this.serializationInfoRegistry.serializerRegistry.putSerializer(clazz, ser, alsoForAllSubclasses);
    }

    public static FSTConfiguration createStructConfiguration() {
        FSTConfiguration conf = new FSTConfiguration();
        conf.setStructMode(true);
        return conf;
    }

    protected FSTConfiguration() {
    }

    public StreamCoderFactory getStreamCoderFactory() {
        return this.streamCoderFactory;
    }

    public void setStreamCoderFactory(StreamCoderFactory streamCoderFactory) {
        this.streamCoderFactory = streamCoderFactory;
    }

    public void returnObject(Object cached) {
        try {
            while (!this.cacheLock.compareAndSet(false, true)) {
            }
            List<SoftReference> li = this.cachedObjects.get(cached.getClass());
            if (li == null) {
                li = new ArrayList<SoftReference>();
                this.cachedObjects.put(cached.getClass(), li);
            }
            if (li.size() < 5) {
                li.add(new SoftReference<Object>(cached));
            }
        }
        finally {
            this.cacheLock.set(false);
        }
    }

    public boolean isPreferSpeed() {
        return this.preferSpeed;
    }

    public void setPreferSpeed(boolean preferSpeed) {
        this.preferSpeed = preferSpeed;
    }

    public int calcObjectSizeBytesNotAUtility(Object obj) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        FSTObjectOutput ou = new FSTObjectOutput(bout, this);
        ou.writeObject(obj, obj.getClass());
        ou.close();
        return bout.toByteArray().length;
    }

    public void setSerializerRegistryDelegate(FSTSerializerRegistryDelegate del) {
        this.serializationInfoRegistry.setSerializerRegistryDelegate(del);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCachedObject(Class cl) {
        try {
            while (!this.cacheLock.compareAndSet(false, true)) {
            }
            List<SoftReference> li = this.cachedObjects.get(cl);
            if (li == null) {
                Object var3_3 = null;
                return var3_3;
            }
            for (int i = li.size() - 1; i >= 0; --i) {
                SoftReference softReference = li.get(i);
                Object res = softReference.get();
                li.remove(i);
                if (res == null) continue;
                Object t = res;
                return t;
            }
        }
        finally {
            this.cacheLock.set(false);
        }
        return null;
    }

    public boolean isForceSerializable() {
        return this.forceSerializable;
    }

    public FSTConfiguration setForceSerializable(boolean forceSerializable) {
        this.forceSerializable = forceSerializable;
        return this;
    }

    public void clearCaches() {
        try {
            FSTInputStream.cachedBuffer.set(null);
            while (!this.cacheLock.compareAndSet(false, true)) {
            }
            this.cachedObjects.clear();
        }
        finally {
            this.cacheLock.set(false);
        }
    }

    public boolean isShareReferences() {
        return this.shareReferences;
    }

    public void setShareReferences(boolean shareReferences) {
        this.shareReferences = shareReferences;
    }

    public void registerClass(Class ... c) {
        for (int i = 0; i < c.length; ++i) {
            this.classRegistry.registerClass(c[i]);
            try {
                Class<?> ac = Class.forName("[L" + c[i].getName() + ";");
                this.classRegistry.registerClass(ac);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    void addDefaultClazzes() {
        this.classRegistry.registerClass(String.class);
        this.classRegistry.registerClass(Byte.class);
        this.classRegistry.registerClass(Short.class);
        this.classRegistry.registerClass(Integer.class);
        this.classRegistry.registerClass(Long.class);
        this.classRegistry.registerClass(Float.class);
        this.classRegistry.registerClass(Double.class);
        this.classRegistry.registerClass(BigDecimal.class);
        this.classRegistry.registerClass(BigInteger.class);
        this.classRegistry.registerClass(Character.class);
        this.classRegistry.registerClass(Boolean.class);
        this.classRegistry.registerClass(TreeMap.class);
        this.classRegistry.registerClass(HashMap.class);
        this.classRegistry.registerClass(ArrayList.class);
        this.classRegistry.registerClass(ConcurrentHashMap.class);
        this.classRegistry.registerClass(URL.class);
        this.classRegistry.registerClass(Date.class);
        this.classRegistry.registerClass(java.sql.Date.class);
        this.classRegistry.registerClass(SimpleDateFormat.class);
        this.classRegistry.registerClass(TreeSet.class);
        this.classRegistry.registerClass(LinkedList.class);
        this.classRegistry.registerClass(SimpleTimeZone.class);
        this.classRegistry.registerClass(GregorianCalendar.class);
        this.classRegistry.registerClass(Vector.class);
        this.classRegistry.registerClass(Hashtable.class);
        this.classRegistry.registerClass(BitSet.class);
        this.classRegistry.registerClass(Locale.class);
        this.classRegistry.registerClass(StringBuffer.class);
        this.classRegistry.registerClass(StringBuilder.class);
        this.classRegistry.registerClass(Object.class);
        this.classRegistry.registerClass(Object[].class);
        this.classRegistry.registerClass(Object[][].class);
        this.classRegistry.registerClass(Object[][][].class);
        this.classRegistry.registerClass(Object[][][][].class);
        this.classRegistry.registerClass(Object[][][][][].class);
        this.classRegistry.registerClass(Object[][][][][][].class);
        this.classRegistry.registerClass(Object[][][][][][][].class);
        this.classRegistry.registerClass(byte[].class);
        this.classRegistry.registerClass(byte[][].class);
        this.classRegistry.registerClass(byte[][][].class);
        this.classRegistry.registerClass(byte[][][][].class);
        this.classRegistry.registerClass(byte[][][][][].class);
        this.classRegistry.registerClass(byte[][][][][][].class);
        this.classRegistry.registerClass(byte[][][][][][][].class);
        this.classRegistry.registerClass(char[].class);
        this.classRegistry.registerClass(char[][].class);
        this.classRegistry.registerClass(char[][][].class);
        this.classRegistry.registerClass(char[][][][].class);
        this.classRegistry.registerClass(char[][][][][].class);
        this.classRegistry.registerClass(char[][][][][][].class);
        this.classRegistry.registerClass(char[][][][][][][].class);
        this.classRegistry.registerClass(short[].class);
        this.classRegistry.registerClass(short[][].class);
        this.classRegistry.registerClass(short[][][].class);
        this.classRegistry.registerClass(short[][][][].class);
        this.classRegistry.registerClass(short[][][][][].class);
        this.classRegistry.registerClass(short[][][][][][].class);
        this.classRegistry.registerClass(short[][][][][][][].class);
        this.classRegistry.registerClass(int[].class);
        this.classRegistry.registerClass(int[][].class);
        this.classRegistry.registerClass(int[][][].class);
        this.classRegistry.registerClass(int[][][][].class);
        this.classRegistry.registerClass(int[][][][][].class);
        this.classRegistry.registerClass(int[][][][][][].class);
        this.classRegistry.registerClass(int[][][][][][][].class);
        this.classRegistry.registerClass(float[].class);
        this.classRegistry.registerClass(float[][].class);
        this.classRegistry.registerClass(float[][][].class);
        this.classRegistry.registerClass(float[][][][].class);
        this.classRegistry.registerClass(float[][][][][].class);
        this.classRegistry.registerClass(float[][][][][][].class);
        this.classRegistry.registerClass(float[][][][][][][].class);
        this.classRegistry.registerClass(double[].class);
        this.classRegistry.registerClass(double[][].class);
        this.classRegistry.registerClass(double[][][].class);
        this.classRegistry.registerClass(double[][][][].class);
        this.classRegistry.registerClass(double[][][][][].class);
        this.classRegistry.registerClass(double[][][][][][].class);
        this.classRegistry.registerClass(double[][][][][][][].class);
    }

    public FSTClazzNameRegistry getClassRegistry() {
        return this.classRegistry;
    }

    public FSTClazzInfoRegistry getCLInfoRegistry() {
        return this.serializationInfoRegistry;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public FSTClazzInfo getClassInfo(Class type) {
        return this.serializationInfoRegistry.getCLInfo(type);
    }

    public FSTObjectInput getObjectInput(InputStream in) {
        FSTObjectInput fstObjectInput = this.input.get();
        try {
            fstObjectInput.resetForReuse(in);
            return fstObjectInput;
        }
        catch (IOException e) {
            throw FSTUtil.rethrow(e);
        }
    }

    public FSTObjectInput getObjectInput() {
        return this.getObjectInput((InputStream)null);
    }

    public FSTObjectInput getObjectInput(byte[] arr) {
        return this.getObjectInput(arr, arr.length);
    }

    public FSTObjectInput getObjectInput(byte[] arr, int len) {
        FSTObjectInput fstObjectInput = this.input.get();
        try {
            fstObjectInput.resetForReuseUseArray(arr, len);
            return fstObjectInput;
        }
        catch (IOException e) {
            throw FSTUtil.rethrow(e);
        }
    }

    public FSTObjectOutput getObjectOutput(OutputStream out) {
        FSTObjectOutput fstObjectOutput = this.output.get();
        fstObjectOutput.resetForReUse(out);
        return fstObjectOutput;
    }

    public FSTObjectOutput getObjectOutput() {
        return this.getObjectOutput((OutputStream)null);
    }

    public FSTObjectOutput getObjectOutput(byte[] outByte) {
        FSTObjectOutput fstObjectOutput = this.output.get();
        fstObjectOutput.resetForReUse(outByte);
        return fstObjectOutput;
    }

    public void setStructMode(boolean ignoreSerialInterfaces) {
        this.serializationInfoRegistry.setStructMode(ignoreSerialInterfaces);
    }

    public boolean isStructMode() {
        return this.serializationInfoRegistry.isStructMode();
    }

    public FSTClazzInfo getClazzInfo(Class rowClass) {
        return this.getCLInfoRegistry().getCLInfo(rowClass);
    }

    public void setCrossPlatform(boolean crossPlatform) {
        this.crossPlatform = crossPlatform;
    }

    public boolean isCrossPlatform() {
        return this.crossPlatform;
    }

    public <T> T deepCopy(T metadata) {
        return (T)this.asObject(this.asByteArray(metadata));
    }

    public FSTEncoder createStreamEncoder() {
        return this.streamCoderFactory.createStreamEncoder();
    }

    public FSTDecoder createStreamDecoder() {
        return this.streamCoderFactory.createStreamDecoder();
    }

    public void registerCrossPlatformClassBinaryCache(String fulLQName, byte[] binary) {
        try {
            while (this.cplock.compareAndSet(false, true)) {
            }
            this.minBinNamesBytez.put(fulLQName, binary);
        }
        finally {
            this.cplock.set(false);
        }
    }

    public byte[] getCrossPlatformBinaryCache(String symbolicName) {
        try {
            while (this.cplock.compareAndSet(false, true)) {
            }
            byte[] byArray = this.minBinNamesBytez.get(symbolicName);
            return byArray;
        }
        finally {
            this.cplock.set(false);
        }
    }

    public void registerCrossPlatformClassMapping(String[][] keysAndVals) {
        for (int i = 0; i < keysAndVals.length; ++i) {
            String[] keysAndVal = keysAndVals[i];
            this.registerCrossPlatformClassMapping(keysAndVal[0], keysAndVal[1]);
        }
    }

    public void registerCrossPlatformClassMapping(String shortName, String fqName) {
        this.minbinNames.put(shortName, fqName);
        this.minbinNamesReverse.put(fqName, shortName);
    }

    public void registerCrossPlatformClassMappingUseSimpleName(Class[] classes) {
        this.registerCrossPlatformClassMappingUseSimpleName(new ArrayList<Class>(Arrays.asList(classes)));
    }

    public void registerCrossPlatformClassMappingUseSimpleName(List<Class> classes) {
        for (int i = 0; i < classes.size(); ++i) {
            Class clz = classes.get(i);
            this.minbinNames.put(clz.getSimpleName(), clz.getName());
            this.minbinNamesReverse.put(clz.getName(), clz.getSimpleName());
        }
    }

    public String getCPNameForClass(Class cl) {
        String res = this.minbinNamesReverse.get(cl.getName());
        if (res == null) {
            return cl.getName();
        }
        return res;
    }

    public String getClassForCPName(String name) {
        String res = this.minbinNames.get(name);
        if (res == null) {
            return name;
        }
        return res;
    }

    public Object asObject(byte[] b) {
        try {
            return this.getObjectInput(b).readObject();
        }
        catch (Exception e) {
            throw FSTUtil.rethrow(e);
        }
    }

    public byte[] asByteArray(Object object) {
        FSTObjectOutput objectOutput = this.getObjectOutput();
        try {
            objectOutput.writeObject(object);
            return objectOutput.getCopyOfWrittenBuffer();
        }
        catch (IOException e) {
            throw FSTUtil.rethrow(e);
        }
    }

    public byte[] asSharedByteArray(Object object, int[] length) {
        FSTObjectOutput objectOutput = this.getObjectOutput();
        try {
            objectOutput.writeObject(object);
            length[0] = objectOutput.getWritten();
            return objectOutput.getBuffer();
        }
        catch (IOException e) {
            throw FSTUtil.rethrow(e);
        }
    }

    public static interface StreamCoderFactory {
        public FSTEncoder createStreamEncoder();

        public FSTDecoder createStreamDecoder();
    }

    static enum ConfType {
        DEFAULT,
        UNSAFE,
        MINBIN;

    }
}

