/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kson;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.nustaq.kson.ArgTypes;
import org.nustaq.kson.Kson;
import org.nustaq.kson.KsonArgTypesResolver;
import org.nustaq.kson.KsonCharInput;
import org.nustaq.kson.KsonParseException;
import org.nustaq.kson.KsonStringCharInput;
import org.nustaq.kson.KsonTypeMapper;
import org.nustaq.serialization.FSTClazzInfo;

public class KsonDeserializer {
    public static boolean DEBUG_STACK = false;
    protected KsonCharInput in;
    protected KsonTypeMapper mapper;
    protected Stack<ParseStep> stack;
    private KsonArgTypesResolver argTypesRessolver;

    public KsonDeserializer(KsonCharInput in, KsonTypeMapper mapper) {
        this.in = in;
        this.mapper = mapper;
        if (DEBUG_STACK) {
            this.stack = new Stack();
            if (in instanceof KsonStringCharInput) {
                ((KsonStringCharInput)in).stack = this.stack;
            }
        }
    }

    public void skipWS() {
        int ch = this.in.readChar();
        while (ch >= 0 && Character.isWhitespace(ch)) {
            ch = this.in.readChar();
        }
        if (ch == 35) {
            ch = this.in.readChar();
            while (ch >= 0 && ch != 10) {
                ch = this.in.readChar();
            }
            this.skipWS();
        } else if (ch > 0) {
            this.in.back(1);
        }
    }

    public Object readObject(Class expect, Class genericKeyType, Class genericValueType) throws Exception {
        try {
            int ch;
            this.skipWS();
            if (this.in.isEof()) {
                return null;
            }
            String type = this.readId();
            Object literal = this.mapper.mapLiteral(type);
            if (literal != null) {
                return literal == KsonTypeMapper.NULL_LITERAL ? null : literal;
            }
            this.skipWS();
            Class mappedClass = null;
            mappedClass = "".equals(type) ? expect : this.mapper.getType(type);
            if (mappedClass == null) {
                if ("".equals(type)) {
                    int position = this.in.position();
                    String clz = this.huntType();
                    if (clz != null) {
                        mappedClass = this.mapper.getType(clz);
                    }
                    this.in.back(this.in.position() - position);
                } else {
                    return type;
                }
            }
            if (mappedClass == List.class || mappedClass == Collection.class) {
                mappedClass = ArrayList.class;
            }
            if (mappedClass == Map.class) {
                mappedClass = HashMap.class;
            }
            FSTClazzInfo clInfo = Kson.conf.getCLInfoRegistry().getCLInfo(mappedClass);
            if (DEBUG_STACK) {
                if (clInfo != null) {
                    this.stack.push(new ParseStep("try reading type " + clInfo.getClazz().getName(), this.in));
                } else {
                    this.stack.push(new ParseStep("try reading unknown object type", this.in));
                }
            }
            if ((ch = this.in.readChar()) != 123 && ch != 91) {
                throw new KsonParseException("expected '{' or '['", this.in);
            }
            Object res = null;
            if (Map.class.isAssignableFrom(clInfo.getClazz())) {
                res = clInfo.newInstance(true);
                if (DEBUG_STACK) {
                    this.stack.push(new ParseStep("read map " + clInfo.getClazz().getName() + "<" + genericKeyType + "," + genericValueType + ">", this.in));
                }
                List keyVals = this.readList(genericKeyType, genericValueType);
                for (int i = 0; i < keyVals.size(); i += 2) {
                    Object fi = keyVals.get(i);
                    Object val = keyVals.get(i + 1);
                    ((Map)res).put(fi, val);
                }
                if (DEBUG_STACK) {
                    this.stack.pop();
                }
            } else if (Collection.class.isAssignableFrom(clInfo.getClazz())) {
                List keyVals = this.readList(genericKeyType, genericKeyType);
                res = clInfo.getClazz() == ArrayList.class ? new ArrayList(keyVals.size()) : (clInfo.getClazz() == HashSet.class ? new HashSet(keyVals.size()) : clInfo.newInstance(true));
                if (DEBUG_STACK) {
                    this.stack.push(new ParseStep("read list " + clInfo.getClazz().getName() + "<" + genericKeyType + "|" + genericValueType + ">", this.in));
                }
                for (int i = 0; i < keyVals.size(); ++i) {
                    Object o = keyVals.get(i);
                    ((Collection)res).add(o);
                }
                if (DEBUG_STACK) {
                    this.stack.pop();
                }
            } else if (clInfo.getClazz().isArray()) {
                Class<?> componentType = clInfo.getClazz().getComponentType();
                if (componentType.isArray()) {
                    throw new KsonParseException("nested arrays not supported", this.in);
                }
                if (DEBUG_STACK) {
                    this.stack.push(new ParseStep("read array of type " + clInfo.getClazz().getComponentType().getName(), this.in));
                }
                List keyVals = this.readList(componentType, componentType);
                res = Array.newInstance(componentType, keyVals.size());
                for (int i = 0; i < keyVals.size(); ++i) {
                    Array.set(res, i, keyVals.get(i));
                }
                if (DEBUG_STACK) {
                    this.stack.pop();
                }
            } else {
                res = clInfo.newInstance(true);
                if (res == null) {
                    throw new RuntimeException(clInfo.getClazz().getName() + " misses a default constructor. Instantiation failed.");
                }
                List keyVals = this.readObjectFields(clInfo);
                for (int i = 0; i < keyVals.size(); i += 2) {
                    String fi = (String)keyVals.get(i);
                    Object val = keyVals.get(i + 1);
                    Field field = clInfo.getFieldInfo(fi, null).getField();
                    if (field.getType().isEnum() && val instanceof String) {
                        val = Enum.valueOf(field.getType(), (String)val);
                    }
                    field.set(res, val);
                }
            }
            if (DEBUG_STACK) {
                this.stack.pop();
            }
            return res;
        }
        catch (Exception ex) {
            throw new KsonParseException("unexpected error, tried reading object", this.in, ex);
        }
    }

    protected String huntType() {
        int ch;
        this.skipWS();
        while ((ch = this.in.readChar()) != 58 && ch != 125 && ch > 0) {
        }
        this.skipWS();
        return this.readString();
    }

    private String readString() {
        return this.readString(this.in.peekChar() == 34 || this.in.peekChar() == 39);
    }

    protected List readObjectFields(FSTClazzInfo targetClz) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        this.skipWS();
        if (DEBUG_STACK) {
            this.stack.push(new ParseStep("read object of type " + targetClz.getClazz().getName(), this.in));
        }
        while (this.in.peekChar() > 0 && this.in.peekChar() != 125 && this.in.peekChar() != 93) {
            Class[] argTypes;
            FSTClazzInfo.FSTFieldInfo fieldInfo;
            Class type;
            String field;
            if (this.in.peekChar() == 58 || this.in.peekChar() == 44) {
                this.in.readChar();
                this.skipWS();
            }
            if ("_type".equals(field = (String)this.readValue(String.class, null, null))) {
                this.skipWS();
                this.in.readChar();
                this.skipWS();
                this.readString();
                this.skipWS();
                continue;
            }
            result.add(field);
            this.skipWS();
            if (this.in.peekChar() == 58 || this.in.peekChar() == 44) {
                this.in.readChar();
                this.skipWS();
            }
            Class clazz = type = (fieldInfo = targetClz.getFieldInfo(field, null)) == null ? null : fieldInfo.getType();
            if (this.argTypesRessolver != null && type == Object[].class && fieldInfo.getField().getAnnotation(ArgTypes.class) != null && (argTypes = this.argTypesRessolver.getArgTypes(targetClz.getClazz(), result)) != null) {
                this.skipWS();
                int ch = this.in.readChar();
                if (ch != 123 && ch != 91) {
                    throw new KsonParseException("expected { or [ ", this.in);
                }
                result.add(this.readList(argTypes, argTypes).toArray());
                this.skipWS();
                continue;
            }
            if (fieldInfo != null) {
                if (DEBUG_STACK) {
                    this.stack.push(new ParseStep("read field '" + fieldInfo.getField().getName() + "' of type " + type.getName(), this.in));
                }
                result.add(this.readValue(type, Kson.fumbleOutGenericKeyType(fieldInfo.getField()), Kson.fumbleOutGenericValueType(fieldInfo.getField())));
                if (DEBUG_STACK) {
                    this.stack.pop();
                }
            } else {
                System.out.println("No such field '" + field + "' on class " + targetClz.getClazz().getName());
            }
            this.skipWS();
        }
        this.in.readChar();
        if (DEBUG_STACK) {
            this.stack.pop();
        }
        return result;
    }

    public KsonArgTypesResolver getArgTypesRessolver() {
        return this.argTypesRessolver;
    }

    public KsonDeserializer setArgTypesRessolver(KsonArgTypesResolver argTypesRessolver) {
        this.argTypesRessolver = argTypesRessolver;
        return this;
    }

    protected List readList(Class[] keyType, Class[] valueType) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        this.skipWS();
        boolean expectKey = true;
        int index = 0;
        while (this.in.peekChar() > 0 && this.in.peekChar() != 125 && this.in.peekChar() != 93) {
            this.skipWS();
            if (expectKey) {
                result.add(this.readValue(keyType[index], null, null));
                expectKey = !expectKey;
            } else {
                if (this.in.peekChar() == 58 || this.in.peekChar() == 44) {
                    this.in.readChar();
                    this.skipWS();
                }
                result.add(this.readValue(valueType[index], null, null));
                expectKey = !expectKey;
                this.skipWS();
                if (this.in.peekChar() == 58 || this.in.peekChar() == 44) {
                    this.in.readChar();
                }
            }
            this.skipWS();
            ++index;
        }
        this.in.readChar();
        return result;
    }

    protected List readList(Class keyType, Class valueType) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        this.skipWS();
        boolean expectKey = true;
        while (this.in.peekChar() > 0 && this.in.peekChar() != 125 && this.in.peekChar() != 93) {
            this.skipWS();
            if (expectKey) {
                result.add(this.readValue(keyType, null, null));
                expectKey = !expectKey;
            } else {
                if (this.in.peekChar() == 58 || this.in.peekChar() == 44) {
                    this.in.readChar();
                    this.skipWS();
                }
                if (DEBUG_STACK) {
                    this.stack.push(new ParseStep("read value for key '" + result.get(result.size() - 1) + "'", this.in));
                }
                result.add(this.readValue(valueType, null, null));
                if (DEBUG_STACK) {
                    this.stack.pop();
                }
                expectKey = !expectKey;
                this.skipWS();
                if (this.in.peekChar() == 58 || this.in.peekChar() == 44) {
                    this.in.readChar();
                }
            }
            this.skipWS();
        }
        this.in.readChar();
        return result;
    }

    protected Object readValue(Class expected, Class genericKeyType, Class genericValueType) throws Exception {
        this.skipWS();
        int ch = this.in.peekChar();
        if (ch == 34 || ch == 39 || this.isFromStringValue(expected)) {
            return this.mapper.coerceReading(expected, this.readString(ch == 34 || ch == 39));
        }
        if (Character.isLetter(ch) || ch == 123 || ch == 91) {
            if (ch == 91 && (expected == null || expected == Object.class || expected.isInterface())) {
                this.in.readChar();
                if (expected != null && !Map.class.isAssignableFrom(expected) && Collection.class.isAssignableFrom(expected) && genericValueType == null) {
                    genericValueType = genericKeyType;
                }
                return this.readList(genericKeyType, genericValueType);
            }
            return this.readObject(expected, genericKeyType, genericValueType);
        }
        if (Character.isDigit(ch) || ch == 43 || ch == 45 || ch == 46) {
            Class type = expected;
            if (type == Float.TYPE || type == Double.TYPE) {
                String num = this.readNums();
                double val = Double.parseDouble(num);
                if (type == Double.TYPE) {
                    return val;
                }
                if (type == Float.TYPE) {
                    return Float.valueOf((float)val);
                }
                if (type == String.class) {
                    return "" + val;
                }
                throw new KsonParseException("cannot assign floating point to " + type.getName(), this.in);
            }
            boolean neg = false;
            if (ch == 43) {
                this.in.readChar();
            } else if (ch == 45) {
                neg = true;
                this.in.readChar();
            }
            long l = this.readLong() * (long)(neg ? -1 : 1);
            if (this.in.peekChar() == 46) {
                String dotValue = this.readString(false);
                if (type == Float.TYPE || type == Float.class) {
                    return Float.valueOf(Float.parseFloat(l + dotValue));
                }
                return Double.parseDouble(l + dotValue);
            }
            if (type == Boolean.TYPE) {
                return l != 0L;
            }
            if (type == Byte.TYPE || type == Byte.class) {
                byte b = (byte)((l + 256L & 0xFFL) - 256L);
                return b;
            }
            if (type == Character.TYPE || type == Character.class) {
                return Character.valueOf((char)l);
            }
            if (type == Short.TYPE || type == Short.class) {
                return (short)l;
            }
            if (type == Integer.TYPE || type == Integer.class) {
                return (int)l;
            }
            if (type == Long.TYPE || type == Long.class) {
                return l;
            }
            if (type == String.class) {
                return "" + l;
            }
            return l;
        }
        if (Character.isJavaIdentifierStart(ch)) {
            return this.readString(false);
        }
        throw new KsonParseException("value expected", this.in);
    }

    private boolean isContainer(Class expected) {
        return expected != null && (expected.isArray() || Collection.class.isAssignableFrom(expected));
    }

    protected boolean isFromStringValue(Class type) {
        return type == String.class;
    }

    protected long readLong() {
        int read = 0;
        long res = 0L;
        long fak = 1L;
        int ch = this.in.readChar();
        boolean empty = true;
        while (Character.isDigit(ch) || ch == 95) {
            if (ch == 95) {
                ch = this.in.readChar();
            }
            ++read;
            empty = false;
            res += (long)(ch - 48) * fak;
            fak *= 10L;
            ch = this.in.readChar();
        }
        this.in.back(1);
        long reverse = 0L;
        while (read-- != 0) {
            reverse = reverse * 10L + res % 10L;
            res /= 10L;
        }
        if (empty) {
            throw new KsonParseException("expected int type number", this.in);
        }
        return reverse;
    }

    protected String readString(boolean quoted) {
        StringBuilder b = new StringBuilder(15);
        int end = quoted ? this.in.readChar() : 32;
        int ch = this.in.readChar();
        while (quoted && ch != end || !quoted && ch > 32 && ch != 35 && ch != 125 && ch != 93 && ch != 58 && ch != 44 && !Character.isWhitespace(ch)) {
            block14: {
                block13: {
                    if (ch != 92) break block13;
                    ch = this.in.readChar();
                    switch (ch) {
                        case 92: {
                            b.append(ch);
                            break block14;
                        }
                        case 34: {
                            b.append('\"');
                            break block14;
                        }
                        case 47: {
                            b.append('/');
                            break block14;
                        }
                        case 98: {
                            b.append('\b');
                            break block14;
                        }
                        case 102: {
                            b.append('\f');
                            break block14;
                        }
                        case 110: {
                            b.append('\n');
                            break block14;
                        }
                        case 114: {
                            b.append('\r');
                            break block14;
                        }
                        case 116: {
                            b.append('\t');
                            break block14;
                        }
                        case 117: {
                            b.append("\\u").append((char)this.in.readChar()).append((char)this.in.readChar()).append((char)this.in.readChar()).append((char)this.in.readChar());
                            break block14;
                        }
                        default: {
                            throw new RuntimeException("unknown escape " + (char)ch + " in " + this.in.position());
                        }
                    }
                }
                b.append((char)ch);
            }
            ch = this.in.readChar();
        }
        if (!quoted) {
            this.in.back(1);
        }
        return b.toString();
    }

    protected String readNums() {
        this.skipWS();
        int pos = this.in.position();
        int ch = this.in.readChar();
        while (Character.isDigit(ch) || ch == 46 || ch == 69 || ch == 101 || ch == 43 || ch == 45 || ch == 95) {
            ch = this.in.readChar();
        }
        this.in.back(1);
        return this.in.getString(pos, this.in.position() - pos).replace("_", "");
    }

    protected String readId() {
        this.skipWS();
        int pos = this.in.position();
        int ch = this.in.readChar();
        while (this.isIdPart(ch) && ch != 58 && ch != 44) {
            ch = this.in.readChar();
        }
        this.in.back(1);
        return this.in.getString(pos, this.in.position() - pos);
    }

    protected boolean isIdPart(int ch) {
        return Character.isLetterOrDigit(ch) || ch == 36 || ch == 35 || ch == 95 || ch == 46;
    }

    protected boolean isIdStart(int ch) {
        return Character.isLetter(ch) || ch == 36 || ch == 35 || ch == 95;
    }

    static class ParseStep {
        KsonCharInput in;
        int position;
        String action;

        ParseStep(KsonCharInput in, int position, String action) {
            this.in = in;
            this.position = position;
            this.action = action;
        }

        ParseStep(String action, KsonCharInput in) {
            this(in, in.position(), action);
        }

        public String toString() {
            return "" + this.action + " at pos:" + this.position;
        }
    }
}

