/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.HashMap;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTDecoder;
import org.nustaq.serialization.minbin.MBIn;
import org.nustaq.serialization.minbin.MBObject;
import org.nustaq.serialization.minbin.MinBin;
import org.nustaq.serialization.util.FSTUtil;

public class FSTMinBinDecoder
implements FSTDecoder {
    FSTConfiguration conf;
    MBIn input;
    private InputStream inputStream;
    int lastObjectLen;
    Class lastDirectClass;
    Object lastReadDirectObject;
    HashMap<String, Class> clzCache = new HashMap();

    public FSTMinBinDecoder(FSTConfiguration conf) {
        this.conf = conf;
        this.input = new MBIn(null, 0);
    }

    @Override
    public String readStringUTF() throws IOException {
        Object read = this.input.readObject();
        if (read instanceof String) {
            return (String)read;
        }
        if (read instanceof byte[]) {
            return new String((byte[])read, 0, 0, ((byte[])read).length);
        }
        if (read instanceof char[]) {
            return new String((char[])read, 0, ((char[])read).length);
        }
        if (MinBin.END_MARKER == read) {
            return null;
        }
        if (read == null) {
            return null;
        }
        throw new RuntimeException("Expected String, byte[], char[] or tupel end");
    }

    @Override
    public String readStringAsc() throws IOException {
        return (String)this.input.readObject();
    }

    @Override
    public Object readFPrimitiveArray(Object array, Class componentType, int len) {
        if (componentType == Double.TYPE) {
            double[] da = (double[])array;
            for (int i = 0; i < da.length; ++i) {
                da[i] = (Double)this.input.readTag(this.input.readIn());
            }
            return da;
        }
        if (componentType == Float.TYPE) {
            float[] da = (float[])array;
            for (int i = 0; i < da.length; ++i) {
                da[i] = ((Float)this.input.readTag(this.input.readIn())).floatValue();
            }
            return da;
        }
        Object arr = array;
        int length = Array.getLength(arr);
        if (len != -1 && len != length) {
            throw new RuntimeException("unexpected arrays size");
        }
        byte type = 0;
        if (componentType == Boolean.TYPE) {
            type = (byte)(type | 1);
        } else if (componentType == Byte.TYPE) {
            type = (byte)(type | 1);
        } else if (componentType == Short.TYPE) {
            type = (byte)(type | 2);
        } else if (componentType == Character.TYPE) {
            type = (byte)(type | 0xA);
        } else if (componentType == Integer.TYPE) {
            type = (byte)(type | 3);
        } else if (componentType == Long.TYPE) {
            type = (byte)(type | 4);
        } else {
            throw new RuntimeException("unsupported type " + componentType.getName());
        }
        this.input.readArrayRaw(type, len, array);
        return arr;
    }

    @Override
    public void readFIntArr(int len, int[] arr) throws IOException {
        int[] res = (int[])this.input.readObject();
        for (int i = 0; i < len; ++i) {
            arr[i] = res[i];
        }
    }

    @Override
    public int readFInt() throws IOException {
        return (int)this.input.readInt();
    }

    @Override
    public double readFDouble() throws IOException {
        return (Double)this.input.readObject();
    }

    @Override
    public float readFFloat() throws IOException {
        return ((Float)this.input.readObject()).floatValue();
    }

    @Override
    public byte readFByte() throws IOException {
        return (byte)this.input.readInt();
    }

    @Override
    public long readFLong() throws IOException {
        return this.input.readInt();
    }

    @Override
    public char readFChar() throws IOException {
        return (char)this.input.readInt();
    }

    @Override
    public short readFShort() throws IOException {
        return (short)this.input.readInt();
    }

    @Override
    public int readPlainInt() throws IOException {
        throw new RuntimeException("not supported");
    }

    @Override
    public byte[] getBuffer() {
        return this.input.getBuffer();
    }

    @Override
    public int getInputPos() {
        return this.input.getPos();
    }

    @Override
    public void moveTo(int position) {
        throw new RuntimeException("not supported");
    }

    @Override
    public void setInputStream(InputStream in) {
        this.inputStream = in;
        if (in != null) {
            try {
                int count = 0;
                int chunk_size = 1000;
                byte[] buf = this.input.getBuffer();
                if (buf == null) {
                    buf = new byte[chunk_size];
                }
                int read = in.read(buf);
                count += read;
                while (read != -1) {
                    try {
                        if (buf.length < count + chunk_size) {
                            byte[] tmp = new byte[buf.length * 2];
                            System.arraycopy(buf, 0, tmp, 0, count);
                            buf = tmp;
                        }
                        if ((read = in.read(buf, count, chunk_size)) <= 0) continue;
                        count += read;
                    }
                    catch (IndexOutOfBoundsException iex) {
                        read = -1;
                    }
                }
                in.close();
                this.input.setBuffer(buf, count);
            }
            catch (IOException e) {
                throw FSTUtil.rethrow(e);
            }
        }
    }

    @Override
    public void ensureReadAhead(int bytes) {
    }

    @Override
    public void reset() {
        this.input.reset();
    }

    @Override
    public void resetToCopyOf(byte[] bytes, int off, int len) {
        if (off != 0) {
            throw new RuntimeException("not supported");
        }
        this.input.setBuffer(bytes, len);
    }

    @Override
    public void resetWith(byte[] bytes, int len) {
        this.input.setBuffer(bytes, len);
    }

    @Override
    public int getObjectHeaderLen() {
        if (this.lastObjectLen < 0) {
            return (int)this.input.readInt();
        }
        return this.lastObjectLen;
    }

    @Override
    public byte readObjectHeaderTag() throws IOException {
        this.lastObjectLen = -1;
        byte tag = this.input.peekIn();
        this.lastDirectClass = null;
        if (MinBin.isTag(tag)) {
            if (MinBin.getTagId(tag) == 9) {
                this.input.readIn();
                return -7;
            }
            if (MinBin.getTagId(tag) == 0) {
                return -4;
            }
            if (MinBin.getTagId(tag) == 8) {
                Boolean b = (Boolean)this.input.readObject();
                return b != false ? (byte)-16 : -17;
            }
            if (MinBin.getTagId(tag) == 2 || MinBin.getTagId(tag) == 3 || MinBin.getTagId(tag) == 4 || MinBin.getTagId(tag) == 1) {
                this.lastReadDirectObject = this.input.readObject();
                return -2;
            }
            this.input.readIn();
            if (MinBin.getTagId(tag) == 6) {
                try {
                    String cln = (String)this.input.readObject();
                    this.lastDirectClass = this.conf.getClassRegistry().classForName(this.conf.getClassForCPName(cln));
                }
                catch (ClassNotFoundException e) {
                    throw FSTUtil.rethrow(e);
                }
                if (this.lastDirectClass.isEnum()) {
                    this.input.readInt();
                    String enumString = (String)this.input.readObject();
                    this.lastReadDirectObject = Enum.valueOf(this.lastDirectClass, enumString);
                    this.lastDirectClass = null;
                    return -2;
                }
                if (this.lastDirectClass.isArray()) {
                    return -5;
                }
                this.input.readInt();
                return 0;
            }
            if (MinBin.getTagId(tag) == 7) {
                return -1;
            }
            return 0;
        }
        this.lastReadDirectObject = this.input.readObject();
        return -2;
    }

    @Override
    public Object getDirectObject() {
        Object tmp = this.lastReadDirectObject;
        this.lastReadDirectObject = null;
        return tmp;
    }

    @Override
    public FSTClazzInfo readClass() throws IOException, ClassNotFoundException {
        if (this.lastDirectClass != null) {
            FSTClazzInfo clInfo = this.conf.getCLInfoRegistry().getCLInfo(this.lastDirectClass);
            this.lastDirectClass = null;
            return clInfo;
        }
        Object read = this.input.readObject();
        String name = (String)read;
        String clzName = this.conf.getClassForCPName(name);
        return this.conf.getCLInfoRegistry().getCLInfo(this.classForName(clzName));
    }

    @Override
    public Class classForName(String name) throws ClassNotFoundException {
        if ("Object".equals(name)) {
            return MBObject.class;
        }
        Class<?> aClass = this.clzCache.get(name);
        if (aClass != null) {
            return aClass;
        }
        aClass = Class.forName(name);
        this.clzCache.put(name, aClass);
        return aClass;
    }

    @Override
    public void registerClass(Class possible) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void close() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void skip(int n) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void readPlainBytes(byte[] b, int off, int len) {
        for (int i = 0; i < len; ++i) {
            b[i + off] = this.input.readIn();
        }
    }

    @Override
    public boolean isMapBased() {
        return true;
    }

    @Override
    public void consumeEndMarker() {
        byte type = this.input.peekIn();
        if (type == 6) {
            this.input.readIn();
        }
    }

    @Override
    public Class readArrayHeader() throws Exception {
        byte tag = this.input.peekIn();
        if (MinBin.getTagId(tag) == 7) {
            this.input.readIn();
            this.lastDirectClass = null;
            return null;
        }
        if (this.lastDirectClass != null) {
            return this.readClass().getClazz();
        }
        if (MinBin.getTagId(tag) == 6) {
            this.input.readIn();
        } else if (MinBin.isPrimitive(tag)) {
            this.input.readIn();
            switch (MinBin.getBaseType(tag)) {
                case 1: {
                    return byte[].class;
                }
                case 2: {
                    if (MinBin.isSigned(tag)) {
                        return short[].class;
                    }
                    return char[].class;
                }
                case 3: {
                    return int[].class;
                }
                case 4: {
                    return long[].class;
                }
            }
        }
        return this.readClass().getClazz();
    }

    @Override
    public void readExternalEnd() {
        if (this.input.peekIn() == 6) {
            this.input.readIn();
        }
    }

    @Override
    public boolean isEndMarker(String s) {
        return MinBin.END_MARKER == s;
    }

    @Override
    public int readVersionTag() throws IOException {
        return 0;
    }
}

