/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.offheap.structs.unsafeimpl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javassist.CannotCompileException;
import javassist.ClassMap;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Loader;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import org.nustaq.offheap.bytez.Bytez;
import org.nustaq.offheap.bytez.BytezAllocator;
import org.nustaq.offheap.bytez.onheap.HeapBytezAllocator;
import org.nustaq.offheap.structs.FSTArrayElementSizeCalculator;
import org.nustaq.offheap.structs.FSTEmbeddedBinary;
import org.nustaq.offheap.structs.FSTStruct;
import org.nustaq.offheap.structs.NoAssist;
import org.nustaq.offheap.structs.Templated;
import org.nustaq.offheap.structs.structtypes.StructArray;
import org.nustaq.offheap.structs.structtypes.StructString;
import org.nustaq.offheap.structs.unsafeimpl.FSTByteArrayUnsafeStructGeneration;
import org.nustaq.offheap.structs.unsafeimpl.FSTStructGeneration;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.util.FSTInt2ObjectMap;
import org.nustaq.serialization.util.FSTUtil;

public class FSTStructFactory {
    public static int SIZE_ALIGN = 2;
    static FSTStructFactory instance;
    public static final int MAX_CLASSES = 1000;
    static FSTConfiguration conf;
    ClassPool defaultPool = new ClassPool(null){

        public CtClass get(String classname) throws NotFoundException {
            if (FSTStructFactory.this.rawByteClassDefs.containsKey(classname)) {
                try {
                    return this.makeClass(new ByteArrayInputStream(FSTStructFactory.this.rawByteClassDefs.get(classname)));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return super.get(classname);
        }
    };
    Loader proxyLoader;
    ClassLoader parentLoader;
    ConcurrentHashMap<Class, Class> proxyClzMap;
    FSTStructGeneration structGen;
    ConcurrentHashMap<String, byte[]> rawByteClassDefs;
    boolean autoRegister;
    BytezAllocator allocator;
    ThreadLocal<Object[]> cachedWrapperMap;
    FSTInt2ObjectMap<Class> mIntToClz;
    HashMap<Class, Integer> mClzToInt;
    int idCount;

    public static FSTStructFactory getInstance() {
        if (instance == null) {
            instance = new FSTStructFactory();
        }
        return instance;
    }

    public FSTStructFactory() {
        this.defaultPool.appendSystemPath();
        this.proxyLoader = new Loader(FSTStructFactory.class.getClassLoader(), this.defaultPool);
        this.proxyClzMap = new ConcurrentHashMap();
        this.structGen = new FSTByteArrayUnsafeStructGeneration();
        this.rawByteClassDefs = new ConcurrentHashMap();
        this.autoRegister = true;
        this.allocator = new HeapBytezAllocator();
        this.cachedWrapperMap = new ThreadLocal<Object[]>(){

            @Override
            protected Object[] initialValue() {
                return new Object[1000];
            }
        };
        this.mIntToClz = new FSTInt2ObjectMap(97);
        this.mClzToInt = new HashMap();
        this.idCount = 1;
        this.registerClz(FSTStruct.class);
        this.registerClz(StructString.class);
        this.registerClz(StructArray.class);
        this.registerClz(StructArray.StructArrIterator.class);
    }

    public void registerRawClass(String name, byte[] bytes) {
        this.rawByteClassDefs.put(name, bytes);
    }

    public <T> Class<T> createStructClz(Class<T> clazz) throws Exception {
        if (Modifier.isFinal((int)clazz.getModifiers()) || Modifier.isAbstract((int)clazz.getModifiers())) {
            throw new RuntimeException("Cannot add final classes to structs");
        }
        if (clazz.getName().endsWith("_Struct")) {
            throw new RuntimeException("cannot create Struct on Struct class. Class " + clazz + " is already instrumented");
        }
        String proxyName = clazz.getName() + "_Struct";
        Class present = null;
        try {
            present = this.proxyLoader.loadClass(proxyName);
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        if (present != null) {
            return present;
        }
        ClassPool pool = this.defaultPool;
        CtClass newClz = pool.makeClass(proxyName);
        CtClass orig = null;
        orig = this.rawByteClassDefs.get(clazz.getName()) != null ? pool.makeClass((InputStream)new ByteArrayInputStream(this.rawByteClassDefs.get(clazz.getName()))) : pool.getOrNull(clazz.getName());
        newClz.setSuperclass(orig);
        final FSTClazzInfo clInfo = conf.getClassInfo(clazz);
        CtMethod[] methods = orig.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            CtMethod method = methods[i];
            Class<?> curClz = Class.forName(method.getDeclaringClass().getName());
            boolean allowed = (method.getModifiers() & 0x400) == 0 && (method.getModifiers() & 0x100) == 0 && (method.getModifiers() & 0x10) == 0 && (!method.getDeclaringClass().getName().equals(FSTStruct.class.getName()) || method.getName().equals("getFieldValues")) && !method.getDeclaringClass().getName().equals(Object.class.getName());
            allowed &= method.getAnnotation(NoAssist.class) == null;
            if ((allowed &= (method.getModifiers() & 8) == 0) && (method.getModifiers() & 0x10) != 0 && !method.getDeclaringClass().getName().equals("java.lang.Object")) {
                throw new RuntimeException("final methods are not allowed for struct classes:" + method.getName());
            }
            if (allowed && (method.getModifiers() & 2) != 0 && !method.getDeclaringClass().getName().equals("java.lang.Object")) {
                throw new RuntimeException("private methods are not allowed for struct classes:" + method.getName());
            }
            if (!allowed) continue;
            ClassMap mp = new ClassMap();
            mp.fix(clazz.getName());
            mp.fix(clazz.getSuperclass().getName());
            method = new CtMethod(method, newClz, mp);
            String methName = method.getName();
            FSTClazzInfo.FSTFieldInfo arrayFi = this.checkForSpecialArrayMethod(clInfo, method, "", null, null);
            FSTClazzInfo.FSTFieldInfo lenfi = this.checkForSpecialArrayMethod(clInfo, method, "Len", CtClass.intType, new CtClass[0]);
            FSTClazzInfo.FSTFieldInfo indexfi = this.checkForSpecialArrayMethod(clInfo, method, "Index", CtClass.intType, new CtClass[0]);
            FSTClazzInfo.FSTFieldInfo elemlen = this.checkForSpecialArrayMethod(clInfo, method, "ElementSize", CtClass.intType, new CtClass[0]);
            FSTClazzInfo.FSTFieldInfo pointerfi = this.checkForSpecialArrayMethod(clInfo, method, "Pointer", null, null);
            FSTClazzInfo.FSTFieldInfo structIndex = this.checkForSpecialMethod(clInfo, method, "StructIndex", CtClass.intType, new CtClass[0], false);
            FSTClazzInfo.FSTFieldInfo casAcc = this.checkForSpecialMethod(clInfo, method, "CAS", CtClass.booleanType, null, false);
            if (casAcc != null) {
                this.structGen.defineStructSetCAS(casAcc, clInfo, method);
                newClz.addMethod(method);
                continue;
            }
            if (pointerfi != null) {
                this.structGen.defineArrayPointer(pointerfi, clInfo, method);
                newClz.addMethod(method);
                continue;
            }
            if (structIndex != null) {
                this.structGen.defineFieldStructIndex(structIndex, clInfo, method);
                newClz.addMethod(method);
                continue;
            }
            if (indexfi != null) {
                this.structGen.defineArrayIndex(indexfi, clInfo, method);
                newClz.addMethod(method);
                continue;
            }
            if (elemlen != null) {
                this.structGen.defineArrayElementSize(elemlen, clInfo, method);
                newClz.addMethod(method);
                continue;
            }
            if (arrayFi != null) {
                this.structGen.defineArrayAccessor(arrayFi, clInfo, method);
                newClz.addMethod(method);
                continue;
            }
            if (methName.endsWith("Len") && lenfi != null) {
                this.structGen.defineArrayLength(lenfi, clInfo, method);
                newClz.addMethod(method);
                continue;
            }
            if (methName.equals("getFieldValues") && (clInfo.getClazz().getSuperclass().getName().equals("de.nustaq.reallive.impl.RLStructRow") || curClz != FSTStruct.class)) {
                FSTClazzInfo.FSTFieldInfo[] fieldInfo = clInfo.getFieldInfo();
                StringBuilder body = new StringBuilder("{  return new Object[] { ");
                for (int j = 0; j < fieldInfo.length; ++j) {
                    FSTClazzInfo.FSTFieldInfo fstFieldInfo = fieldInfo[j];
                    int modifiers = fstFieldInfo.getField().getModifiers();
                    if (!java.lang.reflect.Modifier.isProtected(modifiers) && !java.lang.reflect.Modifier.isPublic(modifiers) || java.lang.reflect.Modifier.isStatic(modifiers)) continue;
                    body.append("\"" + fstFieldInfo.getField().getName() + "\", ");
                    Class type = fstFieldInfo.getType();
                    if (FSTStruct.class.isAssignableFrom(type)) {
                        body.append(fstFieldInfo.getField().getName() + ".getFieldValues()");
                    } else if (type.isPrimitive()) {
                        if (Long.TYPE == type) {
                            body.append("new Long(" + fstFieldInfo.getField().getName() + ")");
                        } else if (Float.TYPE == type || Double.TYPE == type) {
                            body.append("new Double(" + fstFieldInfo.getField().getName() + ")");
                        } else {
                            body.append("new Integer(" + fstFieldInfo.getField().getName() + ")");
                        }
                    } else {
                        body.append(fstFieldInfo.getField().getName());
                    }
                    if (j == fieldInfo.length - 1) continue;
                    body.append(",");
                }
                body.append("}; }");
                method.setBody(body.toString());
            }
            newClz.addMethod(method);
            method.instrument(new ExprEditor(){

                public void edit(FieldAccess f) throws CannotCompileException {
                    try {
                        if (!f.isStatic()) {
                            CtClass type = null;
                            type = f.getField().getType();
                            FSTClazzInfo.FSTFieldInfo fieldInfo = clInfo.getFieldInfo(f.getFieldName(), null);
                            if (fieldInfo == null) {
                                return;
                            }
                            if (f.isReader()) {
                                FSTStructFactory.this.structGen.defineStructReadAccess(f, type, fieldInfo);
                            } else if (f.isWriter()) {
                                FSTStructFactory.this.structGen.defineStructWriteAccess(f, type, fieldInfo);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return this.loadProxyClass(clazz, pool, newClz);
    }

    FSTClazzInfo.FSTFieldInfo checkForSpecialArrayMethod(FSTClazzInfo clzInfo, CtMethod method, String postFix, Object returnType, CtClass[] requiredArgs) {
        return this.checkForSpecialMethod(clzInfo, method, postFix, returnType, requiredArgs, true);
    }

    FSTClazzInfo.FSTFieldInfo checkForSpecialMethod(FSTClazzInfo clzInfo, CtMethod method, String postFix, Object returnType, CtClass[] requiredArgs, boolean array) {
        int len = postFix.length();
        String methName = method.getName();
        if (!methName.endsWith(postFix)) {
            return null;
        }
        FSTClazzInfo.FSTFieldInfo res = clzInfo.getFieldInfo(methName.substring(0, methName.length() - len), null);
        if (res == null) {
            return null;
        }
        if (array && res.isArray() && res.getArrayType().isArray()) {
            throw new RuntimeException("nested arrays not supported " + res.getDesc());
        }
        if (array && !res.isArray()) {
            return null;
        }
        if (res.isArray() || !array) {
            if (returnType instanceof Class) {
                try {
                    if (!method.getReturnType().getName().equals(((Class)returnType).getName())) {
                        throw new RuntimeException("expected method " + method + " to return " + returnType);
                    }
                }
                catch (NotFoundException e) {
                    e.printStackTrace();
                }
            } else if (returnType instanceof CtClass) {
                try {
                    if (!method.getReturnType().equals(returnType)) {
                        throw new RuntimeException("expected method " + method + " to return " + returnType);
                    }
                }
                catch (NotFoundException e) {
                    e.printStackTrace();
                }
            }
            return res;
        }
        return null;
    }

    private <T> Class loadProxyClass(Class<T> clazz, ClassPool pool, final CtClass cc) throws ClassNotFoundException {
        Loader cl = new Loader(clazz.getClassLoader(), pool){

            protected Class loadClassByDelegation(String name) throws ClassNotFoundException {
                if (name.equals(cc.getName())) {
                    return null;
                }
                return this.delegateToParent(name);
            }
        };
        Class ccClz = cl.loadClass(cc.getName());
        return ccClz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getProxyClass(Class clz) throws Exception {
        FSTStructFactory fSTStructFactory = this;
        synchronized (fSTStructFactory) {
            Class res = this.proxyClzMap.get(clz);
            if (res == null) {
                res = this.createStructClz(clz);
                this.proxyClzMap.put(clz, res);
            }
            return res;
        }
    }

    public <T extends FSTStruct> T createWrapper(Class<T> onHeap, Bytez bytes, int index) throws Exception {
        Class proxy = this.getProxyClass(onHeap);
        FSTStruct res = (FSTStruct)FSTUtil.getUnsafe().allocateInstance(proxy);
        res.baseOn(bytes, (long)index, this);
        return (T)res;
    }

    public FSTStruct createStructWrapper(Bytez b, int index) {
        int clzId = b.getInt(index + 4);
        return this.createStructPointer(b, index, clzId);
    }

    public FSTStruct createStructPointer(Bytez b, int index, int clzId) {
        FSTStructFactory fSTStructFactory = this;
        synchronized (fSTStructFactory) {
            Class clazz = this.mIntToClz.get(clzId);
            if (clazz == null) {
                throw new RuntimeException("unregistered class " + clzId);
            }
            try {
                return this.createWrapper(clazz, b, index);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public FSTStruct createTypedArrayBasePointer(Bytez base, long objectBaseOffset, int arrayStructIndex) {
        int arrayElementZeroindex = base.getInt(objectBaseOffset + (long)arrayStructIndex);
        int elemSiz = base.getInt(objectBaseOffset + (long)arrayStructIndex + 8L);
        int len = base.getInt(objectBaseOffset + (long)arrayStructIndex + 4L);
        int clId = base.getInt(objectBaseOffset + (long)arrayStructIndex + 12L);
        FSTStruct structPointer = null;
        if (clId <= 0) {
            structPointer = new FSTStruct();
            structPointer.baseOn(base, objectBaseOffset + (long)arrayElementZeroindex, this);
        } else {
            structPointer = this.createStructPointer(base, (int)(objectBaseOffset + (long)arrayElementZeroindex), clId);
        }
        structPointer.___elementSize = elemSiz;
        return structPointer;
    }

    public void fillTypedArrayBasePointer(FSTStruct result, Bytez base, long objectBaseOffset, int arrayStructIndex) {
        int arrayElementZeroindex = base.getInt(objectBaseOffset + (long)arrayStructIndex);
        int elemSiz = base.getInt(objectBaseOffset + (long)arrayStructIndex + 8L);
        result.baseOn(base, objectBaseOffset + (long)arrayElementZeroindex, this);
        result.___elementSize = elemSiz;
    }

    public void fillPrimitiveArrayBasePointer(FSTStruct result, Bytez base, long objectBaseOffset, int arrayStructIndex) {
        int arrayElementZeroindex = base.getInt(objectBaseOffset + (long)arrayStructIndex);
        result.baseOn(base, objectBaseOffset + (long)arrayElementZeroindex, this);
    }

    public FSTStruct createPrimitiveArrayBasePointer(Bytez base, long objectBaseOffset, int arrayStructIndex) {
        int arrayElementZeroindex = base.getInt(objectBaseOffset + (long)arrayStructIndex);
        FSTStruct structPointer = new FSTStruct();
        structPointer.baseOn(base, objectBaseOffset + (long)arrayElementZeroindex, this);
        return structPointer;
    }

    public <T extends FSTStruct> StructArray<T> toStructArray(int size, T onHeap) {
        StructArray<T> arr = new StructArray<T>(size, onHeap);
        return this.toStruct(arr);
    }

    public <T extends FSTStruct> T toStruct(T onHeap) {
        return this.toStruct(onHeap, this.allocator);
    }

    public <T extends FSTStruct> T toStruct(T onHeap, BytezAllocator alloc) {
        if (onHeap.isOffHeap()) {
            return onHeap;
        }
        try {
            Bytez b = this.toByteArray(onHeap, alloc);
            return (T)this.createWrapper(onHeap.getClass(), b, 0);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public void detach(FSTStruct structPointer) {
        int id = structPointer.getClzId();
        Object o = this.cachedWrapperMap.get()[id];
        if (o == structPointer) {
            this.cachedWrapperMap.get()[id] = null;
        }
    }

    public FSTStruct getStructPointerByOffset(Bytez b, long offset) {
        if (b.length() < offset + 8L) {
            throw new RuntimeException("array to short " + b.length() + " offset " + offset);
        }
        int clzId = b.getInt(offset + 4L);
        int ptr = b.getInt(offset);
        if (clzId <= 0) {
            return null;
        }
        Object[] wrapperMap = this.cachedWrapperMap.get();
        Object res = wrapperMap[clzId];
        if (res != null) {
            ((FSTStruct)res).baseOn(b, offset, this);
            return (FSTStruct)res;
        }
        wrapperMap[clzId] = res = this.createStructPointer(b, (int)offset, clzId);
        return (FSTStruct)res;
    }

    public FSTStruct getStructPointer(Bytez b, int index) {
        return this.getStructPointerByOffset(b, index);
    }

    public static int align(int val, int align) {
        while (val % align != 0) {
            ++val;
        }
        return val;
    }

    public int calcStructSize(FSTStruct onHeapStruct) {
        try {
            if (onHeapStruct == null) {
                return 0;
            }
            if (onHeapStruct.isOffHeap()) {
                return onHeapStruct.getByteSize();
            }
            int siz = 8;
            FSTClazzInfo clInfo = conf.getClassInfo(onHeapStruct.getClass());
            FSTClazzInfo.FSTFieldInfo[] fis = clInfo.getFieldInfo();
            for (int i = 0; i < fis.length; ++i) {
                FSTClazzInfo.FSTFieldInfo fi = fis[i];
                if (fi.getField().getDeclaringClass() == FSTStruct.class) continue;
                int modifiers = fi.getField().getModifiers();
                if (!Modifier.isProtected((int)modifiers) && !Modifier.isPublic((int)modifiers)) {
                    throw new RuntimeException("all fields of a structable class must be public or protected. Field:" + fi.getField().getName() + " in class " + fi.getField().getDeclaringClass().getName());
                }
                if (fi.getType().isArray()) {
                    Object[] objectValue;
                    if (fi.getType().getComponentType().isArray()) {
                        throw new RuntimeException("nested arrays not supported");
                    }
                    if (fi.isIntegral()) {
                        objectValue = fi.getObjectValue(onHeapStruct);
                        if (objectValue == null) {
                            throw new RuntimeException("arrays in struct templates must not be null !");
                        }
                        siz += Array.getLength(objectValue) * fi.getComponentStructSize() + fi.getStructSize() + fi.getAlignPad() + (fi.getAlign() > 0 ? fi.getAlign() - 1 : 0);
                        continue;
                    }
                    objectValue = (Object[])fi.getObjectValue(onHeapStruct);
                    if (objectValue == null) {
                        siz += fi.getStructSize() + fi.getAlignPad() + (fi.getAlign() > 0 ? fi.getAlign() - 1 : 0);
                        continue;
                    }
                    int elemSiz = this.computeElemSize(onHeapStruct, objectValue, fi);
                    siz += Array.getLength(objectValue) * elemSiz + fi.getStructSize() + fi.getAlignPad() + (fi.getAlign() > 0 ? fi.getAlign() - 1 : 0);
                    continue;
                }
                if (fi.isIntegral()) {
                    siz += fi.getStructSize();
                    continue;
                }
                FSTStruct obj = (FSTStruct)fi.getObjectValue(onHeapStruct);
                siz += fi.getStructSize() + this.calcStructSize(obj) + fi.getAlignPad();
            }
            if (onHeapStruct instanceof FSTEmbeddedBinary) {
                siz += ((FSTEmbeddedBinary)((Object)onHeapStruct)).getEmbeddedSizeAdditon(this);
            }
            return siz;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected int computeElemSize(Object container, Object[] objectValue, FSTClazzInfo.FSTFieldInfo fi) {
        int res;
        if (container instanceof FSTArrayElementSizeCalculator && (res = ((FSTArrayElementSizeCalculator)container).getElementSize(fi.getField(), this)) >= 0) {
            return res;
        }
        Templated annotation = fi.getField().getAnnotation(Templated.class);
        if (annotation != null) {
            Object template = objectValue[0];
            return FSTStructFactory.align(this.calcStructSize((FSTStruct)template), SIZE_ALIGN);
        }
        int elemSiz = 0;
        for (int j = 0; j < objectValue.length; ++j) {
            Object o = objectValue[j];
            if (o == null) continue;
            elemSiz = Math.max(elemSiz, this.calcStructSize((FSTStruct)o));
        }
        return FSTStructFactory.align(elemSiz, SIZE_ALIGN);
    }

    public void registerClz(Class ... classes) {
        for (int i = 0; i < classes.length; ++i) {
            int id;
            Class c = classes[i];
            if (this.mClzToInt.containsKey(c)) continue;
            ++this.idCount;
            this.mIntToClz.put(id, c);
            this.mClzToInt.put(c, id);
        }
    }

    public void registerSystemClz(byte startVal, Class ... classes) {
        for (int i = 0; i < classes.length; ++i) {
            Class c = classes[i];
            if (this.mClzToInt.containsKey(c)) continue;
            byte by = startVal;
            startVal = (byte)(startVal - 1);
            byte id = by;
            this.mIntToClz.put(id, c);
            this.mClzToInt.put(c, Integer.valueOf(id));
        }
    }

    public void registerClzId(Class c, int id) {
        this.mIntToClz.put(id, c);
        this.mClzToInt.put(c, id);
    }

    public int getClzId(Class c) {
        Integer integer = this.mClzToInt.get(c);
        if (this.autoRegister && integer == null && c != null) {
            if (c.getName().endsWith("_Struct")) {
                return this.getClzId(c.getSuperclass());
            }
            this.registerClz(c);
            return this.getClzId(c);
        }
        return integer == null ? 0 : integer;
    }

    public Class getClazz(int clzId) {
        return this.mIntToClz.get(clzId);
    }

    public Bytez toByteArray(FSTStruct onHeapStruct) {
        return this.toByteArray(onHeapStruct, this.allocator);
    }

    public Bytez toByteArray(FSTStruct onHeapStruct, BytezAllocator allocator) {
        try {
            int sz = FSTStructFactory.align(this.calcStructSize(onHeapStruct), SIZE_ALIGN);
            Bytez b = allocator.alloc(sz);
            this.toByteArray(onHeapStruct, b, 0);
            return b;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public int toByteArray(FSTStruct onHeapStruct, Bytez bytes, int index) throws Exception {
        int i;
        ArrayList<ForwardEntry> positions = new ArrayList<ForwardEntry>();
        if (onHeapStruct == null) {
            return index;
        }
        if (onHeapStruct.isOffHeap()) {
            onHeapStruct.___bytes.copyTo(bytes, index, onHeapStruct.___offset, onHeapStruct.getByteSize());
            return onHeapStruct.getByteSize();
        }
        int initialIndex = index;
        Class<?> aClass = onHeapStruct.getClass();
        int clzId = this.getClzId(aClass);
        bytes.putInt(index + 4, clzId);
        index += 8;
        FSTClazzInfo clInfo = conf.getClassInfo(aClass);
        FSTClazzInfo.FSTFieldInfo[] fis = clInfo.getFieldInfo();
        for (i = 0; i < fis.length; ++i) {
            FSTClazzInfo.FSTFieldInfo fi = fis[i];
            if (fi.getField().getDeclaringClass() == FSTStruct.class) continue;
            index += fi.getAlignPad();
            if (fi.getType().isArray()) {
                if (fi.getType().getComponentType().isArray()) {
                    throw new RuntimeException("nested arrays not supported");
                }
                if (fi.isIntegral()) {
                    Object objectValue = fi.getObjectValue(onHeapStruct);
                    positions.add(new ForwardEntry(index, objectValue, fi));
                    index += fi.getStructSize();
                    continue;
                }
                Object[] objArr = (Object[])fi.getObjectValue(onHeapStruct);
                if (objArr == null) {
                    bytes.putInt(index, -1);
                    index += fi.getStructSize();
                    continue;
                }
                Templated takeFirst = fi.getField().getAnnotation(Templated.class);
                ForwardEntry fe = new ForwardEntry(index, objArr, fi);
                if (takeFirst != null) {
                    fe.template = (FSTStruct)objArr[0];
                }
                positions.add(fe);
                int elemSiz = this.computeElemSize(onHeapStruct, objArr, fi);
                bytes.putInt((index += fi.getStructSize()) - 8, elemSiz);
                continue;
            }
            if (fi.isIntegral()) {
                Class type = fi.getType();
                int structIndex = fi.getStructOffset();
                if (index != structIndex + initialIndex) {
                    throw new RuntimeException("internal error. please file an issue");
                }
                if (type == Boolean.TYPE) {
                    bytes.putBool(index, fi.getBooleanValue(onHeapStruct));
                } else if (type == Byte.TYPE) {
                    bytes.put(index, (byte)fi.getByteValue(onHeapStruct));
                } else if (type == Character.TYPE) {
                    bytes.putChar(index, (char)fi.getCharValue(onHeapStruct));
                } else if (type == Short.TYPE) {
                    bytes.putShort(index, (short)fi.getShortValue(onHeapStruct));
                } else if (type == Integer.TYPE) {
                    bytes.putInt(index, fi.getIntValue(onHeapStruct));
                } else if (type == Long.TYPE) {
                    bytes.putLong(index, fi.getLongValue(onHeapStruct));
                } else if (type == Float.TYPE) {
                    bytes.putFloat(index, fi.getFloatValue(onHeapStruct));
                } else if (type == Double.TYPE) {
                    bytes.putDouble(index, fi.getDoubleValue(onHeapStruct));
                } else {
                    throw new RuntimeException("this is an error");
                }
                index += fi.getStructSize();
                continue;
            }
            Object obj = fi.getObjectValue(onHeapStruct);
            int structIndex = fi.getStructOffset();
            if (index != structIndex + initialIndex) {
                throw new RuntimeException("internal error. please file an issue");
            }
            if (obj == null) {
                bytes.putInt(index, -1);
                bytes.putInt(index + 4, -1);
                index += fi.getStructSize();
                continue;
            }
            Object objectValue = fi.getObjectValue(onHeapStruct);
            positions.add(new ForwardEntry(index, objectValue, fi));
            index += fi.getStructSize();
        }
        for (i = 0; i < positions.size(); ++i) {
            ForwardEntry en = (ForwardEntry)positions.get(i);
            Object o = en.forwardObject;
            if (o == null) {
                throw new RuntimeException("this is a bug");
            }
            Class<?> c = o.getClass();
            if (c.isArray()) {
                if (en.fi.getAlign() > 0) {
                    while (index % en.fi.getAlign() != 0) {
                        ++index;
                    }
                }
                long siz = 0L;
                if (c == byte[].class) {
                    siz = Array.getLength(o);
                    bytes.set(index, (byte[])o, 0, (int)siz);
                } else if (c == boolean[].class) {
                    siz = Array.getLength(o);
                    bytes.setBoolean(index, (boolean[])o, 0, (int)siz);
                } else if (c == char[].class) {
                    siz = Array.getLength(o);
                    bytes.setChar(index, (char[])o, 0, (int)siz);
                    siz *= 2L;
                } else if (c == short[].class) {
                    siz = Array.getLength(o);
                    bytes.setShort(index, (short[])o, 0, (int)siz);
                    siz *= 2L;
                } else if (c == int[].class) {
                    siz = Array.getLength(o);
                    bytes.setInt(index, (int[])o, 0, (int)siz);
                    siz *= 4L;
                } else if (c == long[].class) {
                    siz = Array.getLength(o);
                    bytes.setLong(index, (long[])o, 0, (int)siz);
                    siz *= 8L;
                } else if (c == float[].class) {
                    siz = Array.getLength(o);
                    bytes.setFloat(index, (float[])o, 0, (int)siz);
                    siz *= 4L;
                } else if (c == double[].class) {
                    siz = Array.getLength(o);
                    bytes.setDouble(index, (double[])o, 0, (int)siz);
                    siz *= 8L;
                } else {
                    Class<? extends FSTStruct> elemClz;
                    Object[] objArr = (Object[])o;
                    int elemSiz = bytes.getInt(en.pointerPos + 8);
                    siz = Array.getLength(o) * elemSiz;
                    int tmpIndex = index;
                    Bytez templatearr = null;
                    boolean hasClzId = false;
                    if (onHeapStruct instanceof FSTArrayElementSizeCalculator && (elemClz = ((FSTArrayElementSizeCalculator)((Object)onHeapStruct)).getElementType(en.fi.getField(), this)) != null) {
                        int clid = this.getClzId(elemClz);
                        bytes.putInt(en.pointerPos + 12, clid);
                        hasClzId = true;
                    }
                    if (en.template != null) {
                        templatearr = this.toByteArray(en.template);
                        if (!hasClzId) {
                            bytes.putInt(en.pointerPos + 12, this.getClzId(en.template.getClass()));
                            hasClzId = true;
                        }
                    }
                    for (int j = 0; j < objArr.length; ++j) {
                        Object objectValue = objArr[j];
                        if (templatearr != null) {
                            templatearr.copyTo(bytes, tmpIndex, 0L, templatearr.length());
                            tmpIndex += elemSiz;
                            continue;
                        }
                        if (objectValue == null) {
                            bytes.putInt(tmpIndex + 4, -1);
                            tmpIndex += elemSiz;
                            continue;
                        }
                        this.toByteArray((FSTStruct)objectValue, bytes, tmpIndex);
                        bytes.putInt(tmpIndex, elemSiz);
                        tmpIndex += elemSiz;
                        if (hasClzId) continue;
                        bytes.putInt(en.pointerPos + 12, this.getClzId(en.fi.getArrayType()));
                        hasClzId = true;
                    }
                }
                bytes.putInt(en.pointerPos, index - initialIndex);
                bytes.putInt(en.pointerPos + 4, Array.getLength(o));
                index = (int)((long)index + siz);
                continue;
            }
            int newoffset = this.toByteArray((FSTStruct)o, bytes, index);
            bytes.putInt(en.pointerPos, index - initialIndex);
            index = newoffset;
        }
        if (onHeapStruct instanceof FSTEmbeddedBinary) {
            FSTEmbeddedBinary embeddedBinary = (FSTEmbeddedBinary)((Object)onHeapStruct);
            index = embeddedBinary.insertEmbedded(this, bytes, index);
        }
        bytes.putInt(initialIndex, index - initialIndex);
        return index;
    }

    public int getShallowStructSize(Class clz) {
        return conf.getClassInfo(clz).getStructSize();
    }

    Class classForName(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            if (this.parentLoader != null) {
                return this.parentLoader.loadClass(name);
            }
            throw ex;
        }
    }

    public ClassLoader getParentLoader() {
        return this.parentLoader;
    }

    public void setParentLoader(ClassLoader parentLoader) {
        this.parentLoader = parentLoader;
    }

    static {
        conf = FSTConfiguration.createStructConfiguration();
    }

    static class ForwardEntry {
        FSTClazzInfo.FSTFieldInfo fi;
        int pointerPos;
        Object forwardObject;
        FSTStruct template;

        ForwardEntry(int pointerPos, Object forwardObject, FSTClazzInfo.FSTFieldInfo fsfi) {
            this.pointerPos = pointerPos;
            this.forwardObject = forwardObject;
            this.fi = fsfi;
        }
    }
}

