/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.offheap;

import java.io.Serializable;
import org.nustaq.offheap.FSTCodedOffheapMap;
import org.nustaq.offheap.bytez.ByteSource;
import org.nustaq.offheap.bytez.bytesource.ByteArrayByteSource;
import org.nustaq.offheap.bytez.bytesource.BytezByteSource;
import org.nustaq.serialization.FSTConfiguration;

public abstract class FSTSerializedOffheapMap<K, V>
extends FSTCodedOffheapMap<K, V> {
    ByteArrayByteSource tmpVal;
    FSTConfiguration conf;

    public FSTSerializedOffheapMap(int keyLen, long sizeBytes, int numberOfElems, FSTConfiguration conf) {
        super(keyLen, sizeBytes, numberOfElems);
        this.conf = conf;
        this.tmpVal = new ByteArrayByteSource(null, 0, 0);
    }

    public FSTSerializedOffheapMap(String mappedFile, int keyLen, long sizeMemBytes, int numberOfElems, FSTConfiguration conf) throws Exception {
        super(mappedFile, keyLen, sizeMemBytes, numberOfElems);
        this.conf = conf;
        this.tmpVal = new ByteArrayByteSource(null, 0, 0);
    }

    @Override
    public ByteSource encodeValue(V value) {
        byte[] bytes = this.conf.asByteArray((Serializable)value);
        this.tmpVal.setArr(bytes);
        this.tmpVal.setOff(0);
        this.tmpVal.setLen(bytes.length);
        return this.tmpVal;
    }

    @Override
    protected int getEntryLengthForContentLength(long lengthOfEntry) {
        return (int)(lengthOfEntry * 2L);
    }

    @Override
    public V decodeValue(BytezByteSource val) {
        byte[] bytes = this.memory.toBytes(val.getOff(), val.getLen());
        return (V)this.conf.asObject(bytes);
    }
}

