/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.nustaq.offheap.structs.FSTStruct;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTClazzInfoRegistry;
import org.nustaq.serialization.FSTClazzNameRegistry;
import org.nustaq.serialization.FSTDecoder;
import org.nustaq.serialization.FSTEncoder;
import org.nustaq.serialization.FSTMinBinDecoder;
import org.nustaq.serialization.FSTMinBinEncoder;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.nustaq.serialization.FSTObjectSerializer;
import org.nustaq.serialization.FSTSerializerRegistry;
import org.nustaq.serialization.FSTSerializerRegistryDelegate;
import org.nustaq.serialization.FSTStreamDecoder;
import org.nustaq.serialization.FSTStreamEncoder;
import org.nustaq.serialization.serializers.FSTArrayListSerializer;
import org.nustaq.serialization.serializers.FSTBigNumberSerializers;
import org.nustaq.serialization.serializers.FSTCPEnumSetSerializer;
import org.nustaq.serialization.serializers.FSTCPThrowableSerializer;
import org.nustaq.serialization.serializers.FSTClassSerializer;
import org.nustaq.serialization.serializers.FSTCollectionSerializer;
import org.nustaq.serialization.serializers.FSTDateSerializer;
import org.nustaq.serialization.serializers.FSTEnumSetSerializer;
import org.nustaq.serialization.serializers.FSTMapSerializer;
import org.nustaq.serialization.serializers.FSTStringBufferSerializer;
import org.nustaq.serialization.serializers.FSTStringBuilderSerializer;
import org.nustaq.serialization.serializers.FSTStringSerializer;
import org.nustaq.serialization.serializers.FSTStructSerializer;
import org.nustaq.serialization.util.FSTInputStream;
import org.nustaq.serialization.util.FSTUtil;

public final class FSTConfiguration {
    StreamCoderFactory streamCoderFactory = new StreamCoderFactory(){

        @Override
        public FSTEncoder createStreamEncoder() {
            return new FSTStreamEncoder(FSTConfiguration.this);
        }

        @Override
        public FSTDecoder createStreamDecoder() {
            return new FSTStreamDecoder(FSTConfiguration.this);
        }
    };
    FSTClazzInfoRegistry serializationInfoRegistry = new FSTClazzInfoRegistry(this);
    HashMap<Class, List<SoftReference>> cachedObjects = new HashMap(97);
    FSTClazzNameRegistry classRegistry = new FSTClazzNameRegistry(null, this);
    boolean preferSpeed = false;
    boolean shareReferences = true;
    ClassLoader classLoader = this.getClass().getClassLoader();
    boolean forceSerializable = false;
    int cpAttrIdCount = 0;
    HashMap<String, Integer> crossPlatformAttrIds = new HashMap();
    HashMap<Integer, String> crossPlatformAttrIdsReverse = new HashMap();
    private HashMap<String, String> crossPlatformNames = new HashMap();
    private HashMap<String, byte[]> crossPlatformNamesBytez = new HashMap();
    private HashMap<String, String> crossPlatformNamesReverse = new HashMap();
    private boolean crossPlatform = false;
    public static Integer[] intObjects;
    static AtomicBoolean conflock;
    static FSTConfiguration singleton;
    ThreadLocal<FSTObjectOutput> output;
    ThreadLocal<FSTObjectInput> input;
    AtomicBoolean cplock;

    public static Integer getInt(int i) {
        if (i >= 0 && i < intObjects.length) {
            return intObjects[i];
        }
        return new Integer(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSTConfiguration getDefaultConfiguration() {
        while (!conflock.compareAndSet(false, true)) {
        }
        try {
            if (singleton == null) {
                singleton = FSTConfiguration.createDefaultConfiguration();
            }
            FSTConfiguration fSTConfiguration = singleton;
            return fSTConfiguration;
        }
        finally {
            conflock.set(false);
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static FSTConfiguration createCrossPlatformConfiguration() {
        final FSTConfiguration res = FSTConfiguration.createDefaultConfiguration();
        res.setCrossPlatform(true);
        res.setStreamCoderFactory(new StreamCoderFactory(){

            @Override
            public FSTEncoder createStreamEncoder() {
                return new FSTMinBinEncoder(res);
            }

            @Override
            public FSTDecoder createStreamDecoder() {
                return new FSTMinBinDecoder(res);
            }
        });
        FSTSerializerRegistry reg = res.serializationInfoRegistry.serializerRegistry;
        reg.putSerializer(EnumSet.class, new FSTCPEnumSetSerializer(), true);
        reg.putSerializer(Throwable.class, new FSTCPThrowableSerializer(), true);
        reg.putSerializer(AbstractCollection.class, new FSTCollectionSerializer(), true);
        reg.putSerializer(AbstractMap.class, new FSTMapSerializer(), true);
        res.registerCrossPlatformClassMapping(new String[][]{{"map", HashMap.class.getName()}, {"list", ArrayList.class.getName()}, {"long", Long.class.getName()}, {"integer", Integer.class.getName()}, {"short", Short.class.getName()}, {"byte", Byte.class.getName()}, {"char", Character.class.getName()}, {"float", Float.class.getName()}, {"double", Double.class.getName()}, {"date", java.util.Date.class.getName()}, {"enumSet", "java.util.RegularEnumSet"}, {"array", "[Ljava.lang.Object;"}, {"String[]", "[Ljava.lang.String;"}, {"Double[]", "[Ljava.lang.Double;"}, {"Float[]", "[Ljava.lang.Float;"}, {"double[]", "[D"}, {"float[]", "[F"}});
        return res;
    }

    public static FSTConfiguration createDefaultConfiguration() {
        FSTConfiguration conf = new FSTConfiguration();
        conf.addDefaultClazzes();
        FSTSerializerRegistry reg = conf.serializationInfoRegistry.serializerRegistry;
        reg.putSerializer(Class.class, new FSTClassSerializer(), false);
        reg.putSerializer(String.class, new FSTStringSerializer(), false);
        reg.putSerializer(Byte.class, new FSTBigNumberSerializers.FSTByteSerializer(), false);
        reg.putSerializer(Character.class, new FSTBigNumberSerializers.FSTCharSerializer(), false);
        reg.putSerializer(Short.class, new FSTBigNumberSerializers.FSTShortSerializer(), false);
        reg.putSerializer(Float.class, new FSTBigNumberSerializers.FSTFloatSerializer(), false);
        reg.putSerializer(Double.class, new FSTBigNumberSerializers.FSTDoubleSerializer(), false);
        reg.putSerializer(java.util.Date.class, new FSTDateSerializer(), false);
        reg.putSerializer(StringBuffer.class, new FSTStringBufferSerializer(), true);
        reg.putSerializer(StringBuilder.class, new FSTStringBuilderSerializer(), true);
        reg.putSerializer(EnumSet.class, new FSTEnumSetSerializer(), true);
        reg.putSerializer(ArrayList.class, new FSTArrayListSerializer(), false);
        reg.putSerializer(Vector.class, new FSTCollectionSerializer(), false);
        reg.putSerializer(LinkedList.class, new FSTCollectionSerializer(), false);
        reg.putSerializer(HashSet.class, new FSTCollectionSerializer(), false);
        reg.putSerializer(HashMap.class, new FSTMapSerializer(), false);
        reg.putSerializer(LinkedHashMap.class, new FSTMapSerializer(), false);
        reg.putSerializer(Hashtable.class, new FSTMapSerializer(), false);
        reg.putSerializer(ConcurrentHashMap.class, new FSTMapSerializer(), true);
        reg.putSerializer(FSTStruct.class, new FSTStructSerializer(), true);
        return conf;
    }

    public void registerSerializer(Class clazz, FSTObjectSerializer ser, boolean alsoForAllSubclasses) {
        this.serializationInfoRegistry.serializerRegistry.putSerializer(clazz, ser, alsoForAllSubclasses);
    }

    public static FSTConfiguration createStructConfiguration() {
        FSTConfiguration conf = new FSTConfiguration();
        conf.setStructMode(true);
        return conf;
    }

    private FSTConfiguration() {
        if (intObjects == null) {
            intObjects = new Integer[30000];
            for (int i = 0; i < intObjects.length; ++i) {
                FSTConfiguration.intObjects[i] = new Integer(i);
            }
        }
        this.output = new ThreadLocal<FSTObjectOutput>(){

            @Override
            protected FSTObjectOutput initialValue() {
                return new FSTObjectOutput(FSTConfiguration.this);
            }
        };
        this.input = new ThreadLocal<FSTObjectInput>(){

            @Override
            protected FSTObjectInput initialValue() {
                try {
                    return new FSTObjectInput(FSTConfiguration.this);
                }
                catch (Exception e) {
                    throw FSTUtil.rethrow(e);
                }
            }
        };
        this.cplock = new AtomicBoolean(false);
    }

    public StreamCoderFactory getStreamCoderFactory() {
        return this.streamCoderFactory;
    }

    public void setStreamCoderFactory(StreamCoderFactory streamCoderFactory) {
        this.streamCoderFactory = streamCoderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object cached) {
        HashMap<Class, List<SoftReference>> hashMap = this.cachedObjects;
        synchronized (hashMap) {
            List<SoftReference> li = this.cachedObjects.get(cached.getClass());
            if (li == null) {
                li = new ArrayList<SoftReference>();
                this.cachedObjects.put(cached.getClass(), li);
            }
            li.add(new SoftReference<Object>(cached));
        }
    }

    public boolean isPreferSpeed() {
        return this.preferSpeed;
    }

    public void setPreferSpeed(boolean preferSpeed) {
        this.preferSpeed = preferSpeed;
    }

    public int calcObjectSizeBytesNotAUtility(Object obj) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        FSTObjectOutput ou = new FSTObjectOutput(bout, this);
        ou.writeObject(obj, obj.getClass());
        ou.close();
        return bout.toByteArray().length;
    }

    public void setSerializerRegistryDelegate(FSTSerializerRegistryDelegate del) {
        this.serializationInfoRegistry.setSerializerRegistryDelegate(del);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCachedObject(Class cl) {
        HashMap<Class, List<SoftReference>> hashMap = this.cachedObjects;
        synchronized (hashMap) {
            List<SoftReference> li = this.cachedObjects.get(cl);
            if (li == null) {
                return null;
            }
            for (int i = li.size() - 1; i >= 0; --i) {
                SoftReference softReference = li.get(i);
                Object res = softReference.get();
                li.remove(i);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    public boolean isForceSerializable() {
        return this.forceSerializable;
    }

    public FSTConfiguration setForceSerializable(boolean forceSerializable) {
        this.forceSerializable = forceSerializable;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        FSTInputStream.cachedBuffer.set(null);
        HashMap<Class, List<SoftReference>> hashMap = this.cachedObjects;
        synchronized (hashMap) {
            this.cachedObjects.clear();
        }
    }

    public boolean isShareReferences() {
        return this.shareReferences;
    }

    public void setShareReferences(boolean shareReferences) {
        this.shareReferences = shareReferences;
    }

    public void registerClass(Class ... c) {
        for (int i = 0; i < c.length; ++i) {
            this.classRegistry.registerClass(c[i]);
        }
    }

    void addDefaultClazzes() {
        this.classRegistry.registerClass(String.class);
        this.classRegistry.registerClass(Byte.class);
        this.classRegistry.registerClass(Short.class);
        this.classRegistry.registerClass(Integer.class);
        this.classRegistry.registerClass(Long.class);
        this.classRegistry.registerClass(Float.class);
        this.classRegistry.registerClass(Double.class);
        this.classRegistry.registerClass(BigDecimal.class);
        this.classRegistry.registerClass(BigInteger.class);
        this.classRegistry.registerClass(Character.class);
        this.classRegistry.registerClass(Boolean.class);
        this.classRegistry.registerClass(TreeMap.class);
        this.classRegistry.registerClass(HashMap.class);
        this.classRegistry.registerClass(ArrayList.class);
        this.classRegistry.registerClass(ConcurrentHashMap.class);
        this.classRegistry.registerClass(Color.class);
        this.classRegistry.registerClass(Dimension.class);
        this.classRegistry.registerClass(Point.class);
        this.classRegistry.registerClass(Rectangle.class);
        this.classRegistry.registerClass(Font.class);
        this.classRegistry.registerClass(URL.class);
        this.classRegistry.registerClass(java.util.Date.class);
        this.classRegistry.registerClass(Date.class);
        this.classRegistry.registerClass(SimpleDateFormat.class);
        this.classRegistry.registerClass(TreeSet.class);
        this.classRegistry.registerClass(LinkedList.class);
        this.classRegistry.registerClass(SimpleTimeZone.class);
        this.classRegistry.registerClass(GregorianCalendar.class);
        this.classRegistry.registerClass(Vector.class);
        this.classRegistry.registerClass(Hashtable.class);
        this.classRegistry.registerClass(BitSet.class);
        this.classRegistry.registerClass(Locale.class);
        this.classRegistry.registerClass(StringBuffer.class);
        this.classRegistry.registerClass(StringBuilder.class);
        this.classRegistry.registerClass(Object.class);
        this.classRegistry.registerClass(Object[].class);
        this.classRegistry.registerClass(Object[][].class);
        this.classRegistry.registerClass(Object[][][].class);
        this.classRegistry.registerClass(Object[][][][].class);
        this.classRegistry.registerClass(Object[][][][][].class);
        this.classRegistry.registerClass(Object[][][][][][].class);
        this.classRegistry.registerClass(Object[][][][][][][].class);
        this.classRegistry.registerClass(byte[].class);
        this.classRegistry.registerClass(byte[][].class);
        this.classRegistry.registerClass(byte[][][].class);
        this.classRegistry.registerClass(byte[][][][].class);
        this.classRegistry.registerClass(byte[][][][][].class);
        this.classRegistry.registerClass(byte[][][][][][].class);
        this.classRegistry.registerClass(byte[][][][][][][].class);
        this.classRegistry.registerClass(char[].class);
        this.classRegistry.registerClass(char[][].class);
        this.classRegistry.registerClass(char[][][].class);
        this.classRegistry.registerClass(char[][][][].class);
        this.classRegistry.registerClass(char[][][][][].class);
        this.classRegistry.registerClass(char[][][][][][].class);
        this.classRegistry.registerClass(char[][][][][][][].class);
        this.classRegistry.registerClass(short[].class);
        this.classRegistry.registerClass(short[][].class);
        this.classRegistry.registerClass(short[][][].class);
        this.classRegistry.registerClass(short[][][][].class);
        this.classRegistry.registerClass(short[][][][][].class);
        this.classRegistry.registerClass(short[][][][][][].class);
        this.classRegistry.registerClass(short[][][][][][][].class);
        this.classRegistry.registerClass(int[].class);
        this.classRegistry.registerClass(int[][].class);
        this.classRegistry.registerClass(int[][][].class);
        this.classRegistry.registerClass(int[][][][].class);
        this.classRegistry.registerClass(int[][][][][].class);
        this.classRegistry.registerClass(int[][][][][][].class);
        this.classRegistry.registerClass(int[][][][][][][].class);
        this.classRegistry.registerClass(float[].class);
        this.classRegistry.registerClass(float[][].class);
        this.classRegistry.registerClass(float[][][].class);
        this.classRegistry.registerClass(float[][][][].class);
        this.classRegistry.registerClass(float[][][][][].class);
        this.classRegistry.registerClass(float[][][][][][].class);
        this.classRegistry.registerClass(float[][][][][][][].class);
        this.classRegistry.registerClass(double[].class);
        this.classRegistry.registerClass(double[][].class);
        this.classRegistry.registerClass(double[][][].class);
        this.classRegistry.registerClass(double[][][][].class);
        this.classRegistry.registerClass(double[][][][][].class);
        this.classRegistry.registerClass(double[][][][][][].class);
        this.classRegistry.registerClass(double[][][][][][][].class);
    }

    public FSTClazzNameRegistry getClassRegistry() {
        return this.classRegistry;
    }

    public FSTClazzInfoRegistry getCLInfoRegistry() {
        return this.serializationInfoRegistry;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public FSTClazzInfo getClassInfo(Class type) {
        return this.serializationInfoRegistry.getCLInfo(type);
    }

    public FSTObjectInput getObjectInput(InputStream in) {
        FSTObjectInput fstObjectInput = this.input.get();
        try {
            fstObjectInput.resetForReuse(in);
            return fstObjectInput;
        }
        catch (IOException e) {
            throw FSTUtil.rethrow(e);
        }
    }

    public FSTObjectInput getObjectInput(byte[] arr) {
        return this.getObjectInput(arr, arr.length);
    }

    public FSTObjectInput getObjectInput(byte[] arr, int len) {
        FSTObjectInput fstObjectInput = this.input.get();
        try {
            fstObjectInput.resetForReuseUseArray(arr, len);
            return fstObjectInput;
        }
        catch (IOException e) {
            throw FSTUtil.rethrow(e);
        }
    }

    public FSTObjectOutput getObjectOutput(OutputStream out) {
        FSTObjectOutput fstObjectOutput = this.output.get();
        fstObjectOutput.resetForReUse(out);
        return fstObjectOutput;
    }

    public FSTObjectOutput getObjectOutput() {
        return this.getObjectOutput((OutputStream)null);
    }

    public FSTObjectOutput getObjectOutput(byte[] outByte) {
        FSTObjectOutput fstObjectOutput = this.output.get();
        fstObjectOutput.resetForReUse(outByte);
        return fstObjectOutput;
    }

    public void setStructMode(boolean ignoreSerialInterfaces) {
        this.serializationInfoRegistry.setStructMode(ignoreSerialInterfaces);
    }

    public boolean isStructMode() {
        return this.serializationInfoRegistry.isStructMode();
    }

    public FSTClazzInfo getClazzInfo(Class rowClass) {
        return this.getCLInfoRegistry().getCLInfo(rowClass);
    }

    public void setCrossPlatform(boolean crossPlatform) {
        this.crossPlatform = crossPlatform;
    }

    public boolean isCrossPlatform() {
        return this.crossPlatform;
    }

    public <T> T deepCopy(T metadata) {
        return (T)this.asObject(this.asByteArray(metadata));
    }

    public FSTEncoder createStreamEncoder() {
        return this.streamCoderFactory.createStreamEncoder();
    }

    public FSTDecoder createStreamDecoder() {
        return this.streamCoderFactory.createStreamDecoder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCrossPlatformClassBinaryCache(String fulLQName, byte[] binary) {
        try {
            while (this.cplock.compareAndSet(false, true)) {
            }
            this.crossPlatformNamesBytez.put(fulLQName, binary);
        }
        finally {
            this.cplock.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getCrossPlatformBinaryCache(String symbolicName) {
        try {
            while (this.cplock.compareAndSet(false, true)) {
            }
            byte[] byArray = this.crossPlatformNamesBytez.get(symbolicName);
            return byArray;
        }
        finally {
            this.cplock.set(false);
        }
    }

    public void registerCrossPlatformClassMapping(String[][] keysAndVals) {
        for (int i = 0; i < keysAndVals.length; ++i) {
            String[] keysAndVal = keysAndVals[i];
            this.crossPlatformNames.put(keysAndVal[0], keysAndVal[1]);
            this.crossPlatformNamesReverse.put(keysAndVal[1], keysAndVal[0]);
        }
    }

    public void registerCrossPlatformClassMappingUseSimpleName(Class[] classes) {
        this.registerCrossPlatformClassMappingUseSimpleName(new ArrayList<Class>(Arrays.asList(classes)));
    }

    public void registerCrossPlatformClassMappingUseSimpleName(List<Class> classes) {
        for (int i = 0; i < classes.size(); ++i) {
            Class clz = classes.get(i);
            this.crossPlatformNames.put(clz.getSimpleName(), clz.getName());
            this.crossPlatformNamesReverse.put(clz.getName(), clz.getSimpleName());
        }
    }

    public void registerCrossPlatformAttributeNames(String ... names) {
        for (int i = 0; i < names.length; ++i) {
            this.crossPlatformAttrIds.put(names[i], this.cpAttrIdCount);
            this.crossPlatformAttrIdsReverse.put(this.cpAttrIdCount, names[i]);
        }
    }

    public String getCrossPlatformAttributeName(Integer id) {
        return this.crossPlatformAttrIdsReverse.get(id);
    }

    public Integer getCrossPlatformAttributeId(String id) {
        return this.crossPlatformAttrIds.get(id);
    }

    public String getCPNameForClass(Class cl) {
        String res = this.crossPlatformNamesReverse.get(cl.getName());
        if (res == null) {
            return cl.getName();
        }
        return res;
    }

    public String getClassForCPName(String name) {
        String res = this.crossPlatformNames.get(name);
        if (res == null) {
            return name;
        }
        return res;
    }

    public Object asObject(byte[] b) {
        try {
            return this.getObjectInput(b).readObject();
        }
        catch (Exception e) {
            throw FSTUtil.rethrow(e);
        }
    }

    public byte[] asByteArray(Object object) {
        FSTObjectOutput objectOutput = this.getObjectOutput();
        try {
            objectOutput.writeObject(object);
            return objectOutput.getCopyOfWrittenBuffer();
        }
        catch (IOException e) {
            throw FSTUtil.rethrow(e);
        }
    }

    static {
        conflock = new AtomicBoolean(false);
    }

    public static interface StreamCoderFactory {
        public FSTEncoder createStreamEncoder();

        public FSTDecoder createStreamDecoder();
    }
}

