/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.minbin;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.Iterator;
import org.nustaq.serialization.minbin.MBIn;
import org.nustaq.serialization.minbin.MBObject;
import org.nustaq.serialization.minbin.MBSequence;

public class MBPrinter {
    public static void printMessage(Object readMessageObject, PrintStream out) {
        new MBPrinter().prettyPrintStreamObject(readMessageObject, out, "");
        out.println();
    }

    public static void printMessage(byte[] message, PrintStream out) {
        MBIn in = new MBIn(message, 0);
        MBPrinter.printMessage(in.readObject(), out);
    }

    protected void prettyPrintStreamObject(Object o, PrintStream out, String indent) {
        if (o instanceof MBObject) {
            this.prettyPrintObject((MBObject)o, out, indent + "  ");
        } else if (o instanceof MBSequence) {
            this.prettyPrintSequence((MBSequence)o, out, indent + "  ");
        } else {
            out.print(this.objectToString(o));
        }
    }

    protected void prettyPrintObject(MBObject t, PrintStream out, String indent) {
        this.prettyPrintStreamObject(t.getTypeInfo(), out, indent);
        out.println(" {");
        Iterator<String> iterator = t.keyIterator();
        while (iterator.hasNext()) {
            String next = iterator.next();
            out.print(indent + "  ");
            this.prettyPrintStreamObject(next, out, indent);
            out.print(" : ");
            this.prettyPrintStreamObject(t.get(next), out, indent);
            out.println();
        }
        out.print(indent + "}");
    }

    protected void prettyPrintSequence(MBSequence t, PrintStream out, String indent) {
        this.prettyPrintStreamObject(t.getTypeInfo(), out, indent);
        out.println(" [");
        for (int i = 0; i < t.size(); ++i) {
            out.print(indent + "  ");
            this.prettyPrintStreamObject(t.get(i), out, indent);
            out.println();
        }
        out.print(indent + "]");
    }

    protected String arrayToString(Object o) {
        int len = Array.getLength(o);
        Class<?> c = o.getClass().getComponentType();
        String res = "[ ";
        for (int i = 0; i < len; ++i) {
            if (c == Byte.TYPE) {
                res = res + Array.getByte(o, i);
            }
            if (c == Boolean.TYPE) {
                res = res + Array.getBoolean(o, i);
            }
            if (c == Character.TYPE) {
                res = res + Array.getChar(o, i);
            }
            if (c == Short.TYPE) {
                res = res + Array.getShort(o, i);
            }
            if (c == Integer.TYPE) {
                res = res + Array.getInt(o, i);
            }
            if (c == Long.TYPE) {
                res = res + Array.getLong(o, i);
            }
            if (c == Float.TYPE) {
                res = res + Array.getFloat(o, i);
            }
            if (c == Double.TYPE) {
                res = res + Array.getDouble(o, i);
            }
            if (i >= len - 1) continue;
            res = res + ",";
        }
        res = res + " ]";
        return res;
    }

    protected String objectToString(Object o) {
        if (o == null) {
            return "NULL";
        }
        if (o.getClass().isArray()) {
            return this.arrayToString(o);
        }
        if (o instanceof String) {
            return "\"" + o + "\"";
        }
        if (o instanceof Character) {
            return "'" + o + "'(" + ((Character)o).charValue() + ")";
        }
        return "" + o;
    }

    public static void printMessage(byte[] binarMsg) {
        MBPrinter.printMessage(binarMsg, System.out);
    }
}

