/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTClazzInfoRegistry;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTEncoder;
import org.nustaq.serialization.FSTObjectRegistry;
import org.nustaq.serialization.FSTObjectSerializer;
import org.nustaq.serialization.util.FSTUtil;

public class FSTObjectOutput
implements ObjectOutput {
    static final byte ONE_OF = -18;
    static final byte BIG_BOOLEAN_FALSE = -17;
    static final byte BIG_BOOLEAN_TRUE = -16;
    static final byte BIG_LONG = -10;
    static final byte BIG_INT = -9;
    static final byte HANDLE = -7;
    static final byte ENUM = -6;
    static final byte ARRAY = -5;
    static final byte STRING = -4;
    static final byte TYPED = -3;
    static final byte DIRECT_OBJECT = -2;
    static final byte NULL = -1;
    static final byte OBJECT = 0;
    protected FSTEncoder codec;
    protected FSTConfiguration conf;
    protected FSTObjectRegistry objects;
    protected int curDepth = 0;
    protected int writeExternalWriteAhead = 8000;
    static ByteArrayOutputStream empty = new ByteArrayOutputStream(0);
    boolean closed = false;
    FSTClazzInfo.FSTFieldInfo[] refs = new FSTClazzInfo.FSTFieldInfo[20];
    int[] tmp = new int[]{0};

    public FSTObjectOutput(OutputStream out) {
        this(out, FSTConfiguration.getDefaultConfiguration());
    }

    public FSTObjectOutput(OutputStream out, FSTConfiguration conf) {
        this.conf = conf;
        this.codec = conf.createStreamEncoder();
        this.codec.setOutstream(out);
        this.objects = (FSTObjectRegistry)conf.getCachedObject(FSTObjectRegistry.class);
        if (this.objects == null) {
            this.objects = new FSTObjectRegistry(conf);
            this.objects.disabled = !conf.isShareReferences();
        } else {
            this.objects.clearForWrite();
        }
    }

    public FSTObjectOutput(FSTConfiguration conf) {
        this(null, conf);
        this.codec.setOutstream(null);
    }

    public FSTObjectOutput() {
        this(null, FSTConfiguration.getDefaultConfiguration());
        this.codec.setOutstream(null);
    }

    @Override
    public void flush() throws IOException {
        this.codec.flush();
        this.resetAndClearRefs();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.closed = true;
        this.codec.close();
        this.resetAndClearRefs();
        this.conf.returnObject(this.objects);
    }

    public int getWriteExternalWriteAhead() {
        return this.writeExternalWriteAhead;
    }

    public void setWriteExternalWriteAhead(int writeExternalWriteAhead) {
        this.writeExternalWriteAhead = writeExternalWriteAhead;
    }

    public void ensureFree(int bytes) throws IOException {
        this.codec.ensureFree(bytes);
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        this.writeObject(obj, null);
    }

    @Override
    public void write(int b) throws IOException {
        this.codec.writeFByte(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.codec.writePrimitiveArray(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.codec.writePrimitiveArray(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.codec.writeFByte(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.codec.writeFByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.codec.writeFShort((short)v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.codec.writeFChar((char)v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.codec.writeFInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.codec.writeFLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.codec.writeFFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.codec.writeFDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        byte[] bytes = s.getBytes();
        this.codec.writePrimitiveArray(bytes, 0, bytes.length);
    }

    @Override
    public void writeChars(String s) throws IOException {
        char[] chars = s.toCharArray();
        this.codec.writePrimitiveArray(chars, 0, chars.length);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.codec.writeStringUTF(s);
    }

    public void writeObject(Object obj, Class ... possibles) throws IOException {
        ++this.curDepth;
        if (this.conf.isCrossPlatform()) {
            this.writeObjectInternal(obj, null);
        }
        if (possibles != null && possibles.length > 1) {
            for (int i = 0; i < possibles.length; ++i) {
                Class possible = possibles[i];
                this.codec.registerClass(possible);
            }
        }
        this.writeObjectInternal(obj, possibles);
    }

    FSTClazzInfo.FSTFieldInfo getCachedFI(Class ... possibles) {
        if (this.curDepth >= this.refs.length) {
            return new FSTClazzInfo.FSTFieldInfo(possibles, null, true);
        }
        FSTClazzInfo.FSTFieldInfo inf = this.refs[this.curDepth];
        if (inf == null) {
            this.refs[this.curDepth] = inf = new FSTClazzInfo.FSTFieldInfo(possibles, null, true);
            return inf;
        }
        inf.setPossibleClasses(possibles);
        return inf;
    }

    public void writeObjectInternal(Object obj, Class ... possibles) throws IOException {
        if (this.curDepth == 0) {
            throw new RuntimeException("not intended to be called from external application. Use public writeObject instead");
        }
        FSTClazzInfo.FSTFieldInfo info = this.getCachedFI(possibles);
        ++this.curDepth;
        this.writeObjectWithContext(info, obj);
        --this.curDepth;
    }

    protected void objectWillBeWritten(Object obj, int streamPosition) {
    }

    protected void objectHasBeenWritten(Object obj, int oldStreamPosition, int streamPosition) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeObjectWithContext(FSTClazzInfo.FSTFieldInfo referencee, Object toWrite) throws IOException {
        block43: {
            int startPosition = this.codec.getWritten();
            boolean dontShare = this.objects.disabled;
            this.objectWillBeWritten(toWrite, startPosition);
            try {
                int handle;
                if (toWrite == null) {
                    this.codec.writeTag((byte)-1, null, 0L, toWrite);
                    return;
                }
                Class<?> clazz = toWrite.getClass();
                if (clazz == String.class) {
                    String[] oneOf = referencee.getOneOf();
                    if (oneOf != null) {
                        for (int i = 0; i < oneOf.length; ++i) {
                            String s = oneOf[i];
                            if (!s.equals(toWrite)) continue;
                            this.codec.writeTag((byte)-18, oneOf, i, toWrite);
                            this.codec.writeFByte(i);
                            return;
                        }
                    }
                    if (dontShare) {
                        this.codec.writeTag((byte)-4, toWrite, 0L, toWrite);
                        this.codec.writeStringUTF((String)toWrite);
                        return;
                    }
                } else {
                    if (clazz == Integer.class) {
                        this.codec.writeTag((byte)-9, null, 0L, toWrite);
                        this.codec.writeFInt((Integer)toWrite);
                        return;
                    }
                    if (clazz == Long.class) {
                        this.codec.writeTag((byte)-10, null, 0L, toWrite);
                        this.codec.writeFLong((Long)toWrite);
                        return;
                    }
                    if (clazz == Boolean.class) {
                        this.codec.writeTag((Boolean)toWrite != false ? (byte)-16 : -17, null, 0L, toWrite);
                        return;
                    }
                    if (referencee.getType() != null && referencee.getType().isEnum() || toWrite instanceof Enum) {
                        if (!this.codec.writeTag((byte)-6, toWrite, 0L, toWrite)) {
                            boolean isEnumClass = toWrite.getClass().isEnum();
                            if (!isEnumClass) {
                                Class<?> c = toWrite.getClass();
                                while (c != null && !c.isEnum()) {
                                    c = toWrite.getClass().getEnclosingClass();
                                }
                                if (c == null) {
                                    throw new RuntimeException("Can't handle this enum: " + toWrite.getClass());
                                }
                                this.codec.writeClass(c);
                            } else {
                                this.codec.writeClass(this.getFstClazzInfo(referencee, toWrite.getClass()));
                            }
                            this.codec.writeFInt(((Enum)toWrite).ordinal());
                        }
                        return;
                    }
                }
                FSTClazzInfo serializationInfo = this.getFstClazzInfo(referencee, clazz);
                FSTObjectSerializer ser = serializationInfo.getSer();
                if (!(dontShare || referencee.isFlat() || serializationInfo.isFlat() || ser != null && ser.alwaysCopy() || (handle = this.objects.registerObjectForWrite(toWrite, this.codec.getWritten(), serializationInfo, this.tmp)) < 0)) {
                    boolean isIdentical;
                    boolean bl = isIdentical = this.tmp[0] == 0;
                    if (isIdentical) {
                        if (!this.codec.writeTag((byte)-7, null, handle, toWrite)) {
                            this.codec.writeFInt(handle);
                        }
                        return;
                    }
                }
                if (clazz.isArray()) {
                    if (this.codec.writeTag((byte)-5, toWrite, 0L, toWrite)) {
                        return;
                    }
                    this.writeArray(referencee, toWrite);
                    break block43;
                }
                if (ser == null) {
                    if (!dontShare) {
                        if (serializationInfo.getWriteReplaceMethod() != null) {
                            Object replaced = null;
                            try {
                                replaced = serializationInfo.getWriteReplaceMethod().invoke(toWrite, new Object[0]);
                            }
                            catch (Exception e) {
                                throw FSTUtil.rethrow(e);
                            }
                            if (replaced != toWrite) {
                                toWrite = replaced;
                                serializationInfo = this.getClassInfoRegistry().getCLInfo(toWrite.getClass());
                            }
                        }
                        if (serializationInfo.useCompatibleMode()) {
                            this.writeObjectCompatible(referencee, toWrite, serializationInfo);
                            return;
                        }
                    }
                    if (!this.writeObjectHeader(serializationInfo, referencee, toWrite)) {
                        this.defaultWriteObject(toWrite, serializationInfo);
                        if (serializationInfo.isExternalizable()) {
                            this.codec.externalEnd(serializationInfo);
                        }
                    }
                    break block43;
                }
                int pos = this.codec.getWritten();
                if (!this.writeObjectHeader(serializationInfo, referencee, toWrite)) {
                    ser.writeObject(this, toWrite, serializationInfo, referencee, pos);
                    this.codec.externalEnd(serializationInfo);
                }
            }
            finally {
                this.objectHasBeenWritten(toWrite, startPosition, this.codec.getWritten());
            }
        }
    }

    protected FSTClazzInfo getFstClazzInfo(FSTClazzInfo.FSTFieldInfo referencee, Class clazz) {
        FSTClazzInfo serializationInfo = null;
        FSTClazzInfo lastInfo = referencee.lastInfo;
        if (lastInfo != null && lastInfo.getClazz() == clazz) {
            serializationInfo = lastInfo;
        } else {
            referencee.lastInfo = serializationInfo = this.getClassInfoRegistry().getCLInfo(clazz);
        }
        return serializationInfo;
    }

    public void defaultWriteObject(Object toWrite, FSTClazzInfo serializationInfo) throws IOException {
        if (serializationInfo.isExternalizable()) {
            this.codec.ensureFree(this.writeExternalWriteAhead);
            ((Externalizable)toWrite).writeExternal(this);
        } else {
            FSTClazzInfo.FSTFieldInfo[] fieldInfo = serializationInfo.getFieldInfo();
            this.writeObjectFields(toWrite, serializationInfo, fieldInfo, 0, 0);
        }
    }

    protected void writeObjectCompatible(FSTClazzInfo.FSTFieldInfo referencee, Object toWrite, FSTClazzInfo serializationInfo) throws IOException {
        this.writeObjectHeader(serializationInfo, referencee, toWrite);
        Class cl = serializationInfo.getClazz();
        this.writeObjectCompatibleRecursive(referencee, toWrite, serializationInfo, cl);
    }

    private void writeObjectCompatibleRecursive(FSTClazzInfo.FSTFieldInfo referencee, Object toWrite, FSTClazzInfo serializationInfo, Class cl) throws IOException {
        FSTClazzInfo.FSTCompatibilityInfo fstCompatibilityInfo = serializationInfo.compInfo.get(cl);
        if (!Serializable.class.isAssignableFrom(cl)) {
            return;
        }
        this.writeObjectCompatibleRecursive(referencee, toWrite, serializationInfo, cl.getSuperclass());
        if (fstCompatibilityInfo != null && fstCompatibilityInfo.getWriteMethod() != null) {
            try {
                this.writeByte(55);
                fstCompatibilityInfo.getWriteMethod().invoke(toWrite, this.getObjectOutputStream(cl, serializationInfo, referencee, toWrite));
            }
            catch (Exception e) {
                throw FSTUtil.rethrow(e);
            }
        } else if (fstCompatibilityInfo != null) {
            this.writeByte(66);
            this.writeObjectFields(toWrite, serializationInfo, fstCompatibilityInfo.getFieldArray(), 0, 0);
        }
    }

    private void writeObjectFields(Object toWrite, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo[] fieldInfo, int startIndex, int version) throws IOException {
        try {
            int booleanMask = 0;
            int boolcount = 0;
            int length = fieldInfo.length;
            int j = startIndex;
            if (!this.codec.isWritingAttributes()) {
                while (true) {
                    if (j == length || fieldInfo[j].getVersion() != version) {
                        if (boolcount <= 0) break;
                        this.codec.writeFByte(booleanMask << 8 - boolcount);
                        break;
                    }
                    FSTClazzInfo.FSTFieldInfo subInfo = fieldInfo[j];
                    if (subInfo.getIntegralType() != 1) {
                        if (boolcount <= 0) break;
                        this.codec.writeFByte(booleanMask << 8 - boolcount);
                        break;
                    }
                    if (boolcount == 8) {
                        this.codec.writeFByte(booleanMask << 8 - boolcount);
                        boolcount = 0;
                        booleanMask = 0;
                    }
                    boolean booleanValue = subInfo.getBooleanValue(toWrite);
                    booleanMask <<= 1;
                    booleanMask |= booleanValue ? 1 : 0;
                    ++boolcount;
                    ++j;
                }
            }
            for (int i = j; i < length; ++i) {
                FSTClazzInfo.FSTFieldInfo subInfo = fieldInfo[i];
                if (subInfo.getVersion() != version) {
                    this.codec.writeVersionTag(subInfo.getVersion());
                    this.writeObjectFields(toWrite, serializationInfo, fieldInfo, i, subInfo.getVersion());
                    return;
                }
                this.codec.writeAttributeName(subInfo);
                if (subInfo.isPrimitive()) {
                    int integralType = subInfo.getIntegralType();
                    switch (integralType) {
                        case 1: {
                            this.codec.writeFByte(subInfo.getBooleanValue(toWrite) ? 1 : 0);
                            break;
                        }
                        case 2: {
                            this.codec.writeFByte(subInfo.getByteValue(toWrite));
                            break;
                        }
                        case 3: {
                            this.codec.writeFChar((char)subInfo.getCharValue(toWrite));
                            break;
                        }
                        case 4: {
                            this.codec.writeFShort((short)subInfo.getShortValue(toWrite));
                            break;
                        }
                        case 5: {
                            this.codec.writeFInt(subInfo.getIntValue(toWrite));
                            break;
                        }
                        case 6: {
                            this.codec.writeFLong(subInfo.getLongValue(toWrite));
                            break;
                        }
                        case 7: {
                            this.codec.writeFFloat(subInfo.getFloatValue(toWrite));
                            break;
                        }
                        case 8: {
                            this.codec.writeFDouble(subInfo.getDoubleValue(toWrite));
                        }
                    }
                    continue;
                }
                if (subInfo.isConditional()) {
                    int conditional = this.codec.getWritten();
                    this.codec.skip(4);
                    Object subObject = subInfo.getObjectValue(toWrite);
                    if (subObject == null) {
                        this.codec.writeTag((byte)-1, null, 0L, toWrite);
                    } else {
                        this.writeObjectWithContext(subInfo, subObject);
                    }
                    int v = this.codec.getWritten();
                    this.codec.writeInt32At(conditional, v);
                    continue;
                }
                Object subObject = subInfo.getObjectValue(toWrite);
                if (subObject == null) {
                    this.codec.writeTag((byte)-1, null, 0L, toWrite);
                    continue;
                }
                this.writeObjectWithContext(subInfo, subObject);
            }
            this.codec.writeVersionTag(0);
        }
        catch (IllegalAccessException ex) {
            throw FSTUtil.rethrow(ex);
        }
    }

    private void writeCompatibleObjectFields(Object toWrite, Map fields, FSTClazzInfo.FSTFieldInfo[] fieldInfo) throws IOException {
        int booleanMask = 0;
        int boolcount = 0;
        for (int i = 0; i < fieldInfo.length; ++i) {
            try {
                FSTClazzInfo.FSTFieldInfo subInfo = fieldInfo[i];
                boolean isarr = subInfo.isArray();
                Class subInfType = subInfo.getType();
                if ((subInfType != Boolean.TYPE || isarr) && boolcount > 0) {
                    this.codec.writeFByte(booleanMask << 8 - boolcount);
                    boolcount = 0;
                    booleanMask = 0;
                }
                if (subInfo.isIntegral() && !isarr) {
                    if (subInfType == Boolean.TYPE) {
                        if (boolcount == 8) {
                            this.codec.writeFByte(booleanMask << 8 - boolcount);
                            boolcount = 0;
                            booleanMask = 0;
                        }
                        boolean booleanValue = (Boolean)fields.get(subInfo.getField().getName());
                        booleanMask <<= 1;
                        booleanMask |= booleanValue ? 1 : 0;
                        ++boolcount;
                        continue;
                    }
                    if (subInfType == Integer.TYPE) {
                        this.codec.writeFInt(((Number)fields.get(subInfo.getField().getName())).intValue());
                        continue;
                    }
                    if (subInfType == Long.TYPE) {
                        this.codec.writeFLong(((Number)fields.get(subInfo.getField().getName())).longValue());
                        continue;
                    }
                    if (subInfType == Byte.TYPE) {
                        this.codec.writeFByte(((Number)fields.get(subInfo.getField().getName())).byteValue());
                        continue;
                    }
                    if (subInfType == Character.TYPE) {
                        this.codec.writeFChar((char)((Number)fields.get(subInfo.getField().getName())).intValue());
                        continue;
                    }
                    if (subInfType == Short.TYPE) {
                        this.codec.writeFShort(((Number)fields.get(subInfo.getField().getName())).shortValue());
                        continue;
                    }
                    if (subInfType == Float.TYPE) {
                        this.codec.writeFFloat(((Number)fields.get(subInfo.getField().getName())).floatValue());
                        continue;
                    }
                    if (subInfType != Double.TYPE) continue;
                    this.codec.writeFDouble(((Number)fields.get(subInfo.getField().getName())).doubleValue());
                    continue;
                }
                Object subObject = fields.get(subInfo.getField().getName());
                this.writeObjectWithContext(subInfo, subObject);
                continue;
            }
            catch (Exception ex) {
                throw FSTUtil.rethrow(ex);
            }
        }
        if (boolcount > 0) {
            this.codec.writeFByte(booleanMask << 8 - boolcount);
        }
    }

    protected boolean writeObjectHeader(FSTClazzInfo clsInfo, FSTClazzInfo.FSTFieldInfo referencee, Object toWrite) throws IOException {
        if (toWrite.getClass() == referencee.getType() && !clsInfo.useCompatibleMode()) {
            return this.codec.writeTag((byte)-3, clsInfo, 0L, toWrite);
        }
        Class[] possibleClasses = referencee.getPossibleClasses();
        if (possibleClasses == null) {
            if (!this.codec.writeTag((byte)0, clsInfo, 0L, toWrite)) {
                this.codec.writeClass(clsInfo);
                return false;
            }
            return true;
        }
        int length = possibleClasses.length;
        for (int j = 0; j < length; ++j) {
            Class possibleClass = possibleClasses[j];
            if (possibleClass != toWrite.getClass()) continue;
            this.codec.writeFByte(j + 1);
            return false;
        }
        if (!this.codec.writeTag((byte)0, clsInfo, 0L, toWrite)) {
            this.codec.writeClass(clsInfo);
            return false;
        }
        return true;
    }

    protected void writeArray(FSTClazzInfo.FSTFieldInfo referencee, Object array) throws IOException {
        if (array == null) {
            this.codec.writeClass(Object.class);
            this.codec.writeFInt(-1);
            return;
        }
        int len = Array.getLength(array);
        Class<?> componentType = array.getClass().getComponentType();
        this.codec.writeClass(array.getClass());
        this.codec.writeFInt(len);
        if (!componentType.isArray()) {
            if (this.codec.isPrimitiveArray(array, componentType)) {
                this.codec.writePrimitiveArray(array, 0, len);
            } else {
                Object[] arr = (Object[])array;
                for (int i = 0; i < len; ++i) {
                    Object toWrite = arr[i];
                    this.writeObjectWithContext(referencee, toWrite);
                }
            }
        } else {
            Object[] arr = (Object[])array;
            FSTClazzInfo.FSTFieldInfo ref1 = new FSTClazzInfo.FSTFieldInfo(referencee.getPossibleClasses(), null, this.conf.getCLInfoRegistry().isIgnoreAnnotations());
            for (int i = 0; i < len; ++i) {
                Object subArr = arr[i];
                boolean needsWrite = true;
                if (this.codec.isTagMultiDimSubArrays()) {
                    if (subArr == null) {
                        needsWrite = !this.codec.writeTag((byte)-1, null, 0L, null);
                    } else {
                        boolean bl = needsWrite = !this.codec.writeTag((byte)-5, subArr, 0L, subArr);
                    }
                }
                if (!needsWrite) continue;
                this.writeArray(ref1, subArr);
            }
        }
    }

    public void writeStringUTF(String str) throws IOException {
        this.codec.writeStringUTF(str);
    }

    void resetAndClearRefs() {
        this.codec.reset();
        this.objects.clearForWrite();
    }

    public void resetForReUse(OutputStream out) {
        if (this.closed) {
            throw new RuntimeException("Can't reuse closed stream");
        }
        this.codec.reset();
        if (out != null) {
            this.codec.setOutstream(out);
        }
        this.objects.clearForWrite();
    }

    public void resetForReUse() {
        this.resetForReUse((OutputStream)null);
    }

    public void resetForReUse(byte[] out) {
        if (this.closed) {
            throw new RuntimeException("Can't reuse closed stream");
        }
        this.codec.reset();
        this.codec.reset(out);
        this.objects.clearForWrite();
    }

    public FSTClazzInfoRegistry getClassInfoRegistry() {
        return this.conf.getCLInfoRegistry();
    }

    public ObjectOutputStream getObjectOutputStream(final Class cl, final FSTClazzInfo clinfo, final FSTClazzInfo.FSTFieldInfo referencee, final Object toWrite) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(){
            ObjectOutputStream.PutField pf;
            HashMap<String, Object> fields = new HashMap();

            @Override
            public void useProtocolVersion(int version) throws IOException {
            }

            @Override
            protected void writeObjectOverride(Object obj) throws IOException {
                FSTObjectOutput.this.writeObjectInternal(obj, referencee.getPossibleClasses());
            }

            @Override
            public void writeUnshared(Object obj) throws IOException {
                this.writeObjectOverride(obj);
            }

            @Override
            public void defaultWriteObject() throws IOException {
                this.writeByte(99);
                FSTClazzInfo newInfo = clinfo;
                Object replObj = toWrite;
                if (newInfo.getWriteReplaceMethod() != null) {
                    System.out.println("WARNING: WRITE REPLACE NOT FULLY SUPPORTED");
                    try {
                        Object replaced = newInfo.getWriteReplaceMethod().invoke(replObj, new Object[0]);
                        if (replaced != null && replaced != toWrite) {
                            replObj = replaced;
                            newInfo = FSTObjectOutput.this.getClassInfoRegistry().getCLInfo(replObj.getClass());
                        }
                    }
                    catch (Exception e) {
                        throw FSTUtil.rethrow(e);
                    }
                }
                FSTObjectOutput.this.writeObjectFields(replObj, newInfo, newInfo.compInfo.get(cl).getFieldArray(), 0, 0);
            }

            @Override
            public ObjectOutputStream.PutField putFields() throws IOException {
                if (this.pf == null) {
                    this.pf = new ObjectOutputStream.PutField(){

                        @Override
                        public void put(String name, boolean val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void put(String name, byte val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void put(String name, char val) {
                            fields.put(name, Character.valueOf(val));
                        }

                        @Override
                        public void put(String name, short val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void put(String name, int val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void put(String name, long val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void put(String name, float val) {
                            fields.put(name, Float.valueOf(val));
                        }

                        @Override
                        public void put(String name, double val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void put(String name, Object val) {
                            fields.put(name, val);
                        }

                        @Override
                        public void write(ObjectOutput out) throws IOException {
                            throw new IOException("cannot act compatible, use a custom serializer for this class");
                        }
                    };
                }
                return this.pf;
            }

            @Override
            public void writeFields() throws IOException {
                this.writeByte(77);
                FSTObjectOutput.this.writeObjectInternal(this.fields, HashMap.class);
            }

            @Override
            public void reset() throws IOException {
                throw new IOException("cannot act compatible, use a custom serializer for this class");
            }

            @Override
            public void write(int val) throws IOException {
                FSTObjectOutput.this.codec.writeFByte(val);
            }

            @Override
            public void write(byte[] buf) throws IOException {
                FSTObjectOutput.this.write(buf);
            }

            @Override
            public void write(byte[] buf, int off, int len) throws IOException {
                FSTObjectOutput.this.write(buf, off, len);
            }

            @Override
            public void flush() throws IOException {
                FSTObjectOutput.this.flush();
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public void writeBoolean(boolean val) throws IOException {
                FSTObjectOutput.this.writeBoolean(val);
            }

            @Override
            public void writeByte(int val) throws IOException {
                FSTObjectOutput.this.codec.writeFByte(val);
            }

            @Override
            public void writeShort(int val) throws IOException {
                FSTObjectOutput.this.codec.writeFShort((short)val);
            }

            @Override
            public void writeChar(int val) throws IOException {
                FSTObjectOutput.this.codec.writeFChar((char)val);
            }

            @Override
            public void writeInt(int val) throws IOException {
                FSTObjectOutput.this.codec.writeFInt(val);
            }

            @Override
            public void writeLong(long val) throws IOException {
                FSTObjectOutput.this.codec.writeFLong(val);
            }

            @Override
            public void writeFloat(float val) throws IOException {
                FSTObjectOutput.this.codec.writeFFloat(val);
            }

            @Override
            public void writeDouble(double val) throws IOException {
                FSTObjectOutput.this.codec.writeFDouble(val);
            }

            @Override
            public void writeBytes(String str) throws IOException {
                FSTObjectOutput.this.writeBytes(str);
            }

            @Override
            public void writeChars(String str) throws IOException {
                FSTObjectOutput.this.writeChars(str);
            }

            @Override
            public void writeUTF(String str) throws IOException {
                FSTObjectOutput.this.codec.writeStringUTF(str);
            }
        };
        return out;
    }

    public FSTObjectRegistry getObjectMap() {
        return this.objects;
    }

    public byte[] getBuffer() {
        return this.codec.getBuffer();
    }

    public byte[] getCopyOfWrittenBuffer() {
        byte[] res = new byte[this.codec.getWritten()];
        byte[] buffer = this.getBuffer();
        System.arraycopy(buffer, 0, res, 0, this.codec.getWritten());
        return res;
    }

    public FSTConfiguration getConf() {
        return this.conf;
    }

    public int getWritten() {
        return this.codec.getWritten();
    }

    public void writeClassTag(Class aClass) {
        this.codec.writeClass(aClass);
    }
}

