/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import java.io.IOException;
import java.io.OutputStream;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectOutput;
import org.nustaq.serialization.FSTObjectSerializer;

public class FSTObjectOutputNoShared
extends FSTObjectOutput {
    public FSTObjectOutputNoShared(OutputStream out) {
        super(out);
        this.objects.disabled = true;
    }

    public FSTObjectOutputNoShared(OutputStream out, FSTConfiguration conf) {
        super(out, conf);
        conf.setShareReferences(false);
        this.objects.disabled = true;
    }

    public FSTObjectOutputNoShared(FSTConfiguration conf) {
        super(conf);
        conf.setShareReferences(false);
        this.objects.disabled = true;
    }

    public FSTObjectOutputNoShared() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeObjectWithContext(FSTClazzInfo.FSTFieldInfo referencee, Object toWrite) throws IOException {
        int startPosition = this.codec.getWritten();
        boolean dontShare = true;
        this.objectWillBeWritten(toWrite, startPosition);
        try {
            if (toWrite == null) {
                this.codec.writeTag((byte)-1, null, 0L, toWrite);
                return;
            }
            Class<?> clazz = toWrite.getClass();
            if (clazz == String.class) {
                String[] oneOf = referencee.getOneOf();
                if (oneOf != null) {
                    for (int i = 0; i < oneOf.length; ++i) {
                        String s = oneOf[i];
                        if (!s.equals(toWrite)) continue;
                        this.codec.writeTag((byte)-18, oneOf, i, toWrite);
                        this.codec.writeFByte(i);
                        return;
                    }
                }
                if (dontShare) {
                    this.codec.writeTag((byte)-4, toWrite, 0L, toWrite);
                    this.codec.writeStringUTF((String)toWrite);
                    return;
                }
            } else {
                if (clazz == Integer.class) {
                    this.codec.writeTag((byte)-9, null, 0L, toWrite);
                    this.codec.writeFInt((Integer)toWrite);
                    return;
                }
                if (clazz == Long.class) {
                    this.codec.writeTag((byte)-10, null, 0L, toWrite);
                    this.codec.writeFLong((Long)toWrite);
                    return;
                }
                if (clazz == Boolean.class) {
                    this.codec.writeTag((Boolean)toWrite != false ? (byte)-16 : -17, null, 0L, toWrite);
                    return;
                }
                if (referencee.getType() != null && referencee.getType().isEnum() || toWrite instanceof Enum) {
                    if (!this.codec.writeTag((byte)-6, toWrite, 0L, toWrite)) {
                        boolean isEnumClass = toWrite.getClass().isEnum();
                        if (!isEnumClass) {
                            Class<?> c = toWrite.getClass();
                            while (c != null && !c.isEnum()) {
                                c = toWrite.getClass().getEnclosingClass();
                            }
                            if (c == null) {
                                throw new RuntimeException("Can't handle this enum: " + toWrite.getClass());
                            }
                            this.codec.writeClass(c);
                        } else {
                            this.codec.writeClass(this.getFstClazzInfo(referencee, toWrite.getClass()));
                        }
                        this.codec.writeFInt(((Enum)toWrite).ordinal());
                    }
                    return;
                }
            }
            FSTClazzInfo serializationInfo = this.getFstClazzInfo(referencee, clazz);
            FSTObjectSerializer ser = serializationInfo.getSer();
            if (clazz.isArray()) {
                if (this.codec.writeTag((byte)-5, toWrite, 0L, toWrite)) {
                    return;
                }
                this.writeArray(referencee, toWrite);
            } else if (ser == null) {
                if (!this.writeObjectHeader(serializationInfo, referencee, toWrite)) {
                    this.defaultWriteObject(toWrite, serializationInfo);
                    if (serializationInfo.isExternalizable()) {
                        this.codec.externalEnd(serializationInfo);
                    }
                }
            } else {
                int pos = this.codec.getWritten();
                if (!this.writeObjectHeader(serializationInfo, referencee, toWrite)) {
                    ser.writeObject(this, toWrite, serializationInfo, referencee, pos);
                    this.codec.externalEnd(serializationInfo);
                }
            }
        }
        finally {
            this.objectHasBeenWritten(toWrite, startPosition, this.codec.getWritten());
        }
    }

    @Override
    public void resetForReUse(OutputStream out) {
        if (this.closed) {
            throw new RuntimeException("Can't reuse closed stream");
        }
        this.codec.reset();
        if (out != null) {
            this.codec.setOutstream(out);
        }
    }

    @Override
    public void resetForReUse(byte[] out) {
        if (this.closed) {
            throw new RuntimeException("Can't reuse closed stream");
        }
        this.codec.reset();
        this.codec.reset(out);
    }
}

