/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization.serializers;

import de.ruedigermoeller.serialization.FSTBasicObjectSerializer;
import de.ruedigermoeller.serialization.FSTClazzInfo;
import de.ruedigermoeller.serialization.FSTObjectInput;
import de.ruedigermoeller.serialization.FSTObjectOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class FSTMapSerializer
extends FSTBasicObjectSerializer {
    @Override
    public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
        Map col = (Map)toWrite;
        out.writeCInt(col.size());
        Class[] possibleClasses = referencedBy.getPossibleClasses();
        if (possibleClasses == null || possibleClasses.length == 0) {
            Class[] possibleKeys = new Class[]{null};
            Class[] possibleVals = new Class[]{null};
            Iterator iterator = col.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry next = o = iterator.next();
                Object key = next.getKey();
                Object value = next.getValue();
                out.writeObjectInternal(key, possibleKeys);
                out.writeObjectInternal(value, possibleVals);
                if (key != null) {
                    possibleKeys[0] = key.getClass();
                }
                if (value == null) continue;
                possibleVals[0] = value.getClass();
            }
        } else {
            for (Map.Entry next : col.entrySet()) {
                out.writeObjectInternal(next.getKey(), possibleClasses);
                out.writeObjectInternal(next.getValue(), possibleClasses);
            }
        }
    }

    @Override
    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPositioin) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Map res = null;
        int len = in.readCInt();
        res = objectClass == HashMap.class ? new HashMap(len) : (objectClass == Hashtable.class ? new Hashtable(len) : objectClass.newInstance());
        in.registerObject(res, streamPositioin, serializationInfo, referencee);
        Map col = res;
        Class[] possibleClasses = referencee.getPossibleClasses();
        if (possibleClasses == null || possibleClasses.length == 0) {
            Class[] possibleKeys = new Class[]{null};
            Class[] possibleVals = new Class[]{null};
            for (int i = 0; i < len; ++i) {
                Object key = in.readObjectInternal(possibleKeys);
                Object val = in.readObjectInternal(possibleVals);
                if (key != null) {
                    possibleKeys[0] = key.getClass();
                }
                if (val != null) {
                    possibleVals[0] = val.getClass();
                }
                col.put(key, val);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                Object key = in.readObjectInternal(possibleClasses);
                Object val = in.readObjectInternal(possibleClasses);
                col.put(key, val);
            }
        }
        return res;
    }
}

