/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization.dson;

import de.ruedigermoeller.serialization.dson.DsonDeserializer;
import de.ruedigermoeller.serialization.dson.DsonSerializer;
import de.ruedigermoeller.serialization.dson.DsonStringCharInput;
import de.ruedigermoeller.serialization.dson.DsonStringOutput;
import de.ruedigermoeller.serialization.dson.DsonTypeMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;

public class Dson {
    public static Dson singleton;
    public static AtomicBoolean lock;
    public static DsonTypeMapper defaultMapper;

    public static Dson getInstance() {
        if (singleton != null) {
            return singleton;
        }
        while (!lock.compareAndSet(false, true)) {
        }
        if (singleton == null) {
            singleton = new Dson();
        }
        lock.set(false);
        return singleton;
    }

    public Object readObject(String dson) throws Exception {
        DsonStringCharInput in = new DsonStringCharInput(dson);
        return new DsonDeserializer(in, defaultMapper).readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readObject(File file) throws Exception {
        FileInputStream fin = new FileInputStream(file);
        try {
            Object object = this.readObject(fin, "UTF-8");
            return object;
        }
        finally {
            fin.close();
        }
    }

    public Object readObject(InputStream stream, String encoding) throws Exception {
        return this.readObject(new Scanner(stream, encoding).useDelimiter("\\A").next());
    }

    public String writeObject(Object toWrite) {
        DsonStringOutput out = new DsonStringOutput();
        try {
            new DsonSerializer(out, defaultMapper).writeObject(toWrite);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out.toString();
    }

    public void writeObject(File file, Object toWrite) {
    }

    public void writeObject(OutputStream stream, Object toWrite) {
    }

    static {
        lock = new AtomicBoolean(false);
        defaultMapper = new DsonTypeMapper();
    }
}

