/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;

public class FSTOrderedConcurrentJobExecutor {
    ExecutorService pool = Executors.newFixedThreadPool((threads *= 2) / 2);
    ExecutorService orderedPool = Executors.newSingleThreadExecutor();
    FSTRunnable[] jobs;
    OrderedRunnable[] orderedRunnableCache;
    Semaphore[] sems;
    int curIdx = 0;
    private int threads;
    Semaphore gateway;

    public FSTOrderedConcurrentJobExecutor(int threads) {
        this.threads = threads;
        this.jobs = new FSTRunnable[threads];
        this.gateway = new Semaphore(threads);
        this.orderedRunnableCache = new OrderedRunnable[threads];
        this.sems = new Semaphore[threads];
        for (int i = 0; i < this.jobs.length; ++i) {
            this.orderedRunnableCache[i] = new OrderedRunnable();
            this.sems[i] = new Semaphore(1);
        }
    }

    public void addCall(FSTRunnable toRun) throws InterruptedException {
        this.gateway.acquire();
        if (this.jobs[this.curIdx] == null) {
            this.jobs[this.curIdx] = toRun;
        } else {
            this.jobs[this.curIdx].sem.acquire();
            this.jobs[this.curIdx].sem.release();
            this.jobs[this.curIdx] = toRun;
        }
        toRun.sem = this.sems[this.curIdx];
        toRun.sem.acquire();
        OrderedRunnable ord = this.orderedRunnableCache[this.curIdx];
        ord.toRun = toRun;
        this.curIdx = (this.curIdx + 1) % this.threads;
        this.orderedPool.execute(ord);
        this.pool.execute(toRun);
    }

    public void waitForFinish() throws InterruptedException {
        final Semaphore sem = new Semaphore(0);
        this.orderedPool.execute(new Runnable(){

            @Override
            public void run() {
                sem.release();
            }
        });
        sem.acquire();
    }

    public int getNumThreads() {
        return this.sems.length / 2;
    }

    public static void main(String[] args) throws InterruptedException {
        FSTOrderedConcurrentJobExecutor jex = new FSTOrderedConcurrentJobExecutor(8);
        long sumtim = System.currentTimeMillis();
        int i = 0;
        while (i < 4) {
            final int finalI = i++;
            FSTRunnable job = new FSTRunnable(){
                int count;
                {
                    this.count = finalI;
                }

                @Override
                public void runConcurrent() {
                    long tim = System.currentTimeMillis();
                    for (int j = 0; j < 99999999; ++j) {
                        String s = "asdipo" + j + "oij";
                        int idx = s.indexOf("oij");
                        for (int k = 0; k < 1; ++k) {
                            String ss = "asdipo" + k + "oij";
                            idx = s.indexOf("oij");
                        }
                    }
                    System.out.println("tim " + this.count + " " + (System.currentTimeMillis() - tim));
                }

                @Override
                public void runInOrder() {
                    System.out.println(finalI);
                }
            };
            jex.addCall(job);
        }
        jex.waitForFinish();
        System.out.println("all time " + (System.currentTimeMillis() - sumtim));
    }

    class OrderedRunnable
    implements Runnable {
        FSTRunnable toRun;

        OrderedRunnable() {
        }

        @Override
        public void run() {
            try {
                this.toRun.sem.acquire();
                this.toRun.runInOrder();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                this.toRun.sem.release();
                FSTOrderedConcurrentJobExecutor.this.gateway.release();
            }
        }
    }

    public static abstract class FSTRunnable
    implements Runnable {
        Semaphore sem;
        FSTRunnable next;

        @Override
        public final void run() {
            this.runConcurrent();
            this.sem.release();
        }

        public abstract void runConcurrent();

        public abstract void runInOrder();
    }
}

