/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization.dson;

import de.ruedigermoeller.serialization.FSTClazzInfo;
import de.ruedigermoeller.serialization.FSTConfiguration;
import de.ruedigermoeller.serialization.dson.DsonCharOutput;
import de.ruedigermoeller.serialization.dson.DsonTypeMapper;
import java.lang.reflect.Array;
import java.util.Map;

public class DsonSerializer {
    protected DsonCharOutput out;
    protected DsonTypeMapper mapper;
    protected boolean pretty = true;
    protected boolean writeNull = false;
    static Character zeroC = new Character('\u0000');

    public DsonSerializer(DsonCharOutput out, DsonTypeMapper mapper) {
        this.out = out;
        this.mapper = mapper;
    }

    public void writeObject(Object o) throws Exception {
        this.writeObjectInternal(o, 0);
    }

    protected void writeObjectInternal(Object o, int indent) throws Exception {
        if (o == null) {
            this.out.writeString("null");
            return;
        }
        if (o instanceof Character) {
            this.out.writeString(o.toString());
            return;
        }
        if (o instanceof Number || o instanceof Boolean) {
            this.out.writeString(o.toString());
            return;
        }
        if (o instanceof String) {
            this.writeString((String)o);
            return;
        }
        if (!(o instanceof Map)) {
            if (o.getClass().isArray()) {
                this.writeArray(o, indent + 1);
                return;
            }
            this.writeln();
            this.writeIndent(indent);
            String stringForType = this.mapper.getStringForType(o.getClass());
            this.out.writeString(stringForType);
            FSTClazzInfo clInfo = FSTConfiguration.getDefaultConfiguration().getCLInfoRegistry().getCLInfo(o.getClass());
            FSTClazzInfo.FSTFieldInfo[] fieldInfo = clInfo.getFieldInfo();
            for (int i = 0; i < fieldInfo.length; ++i) {
                FSTClazzInfo.FSTFieldInfo fstFieldInfo = fieldInfo[i];
                Object fieldValue = fstFieldInfo.getObjectValue(o);
                if (!this.isNullValue(fieldValue = this.mapper.coerceWriting(fieldValue)) && !this.writeNull) continue;
                this.writeln();
                this.writeIndent(indent + 1);
                this.out.writeString(fstFieldInfo.getField().getName());
                this.out.writeChar(':');
                this.writeObjectInternal(fieldValue, indent + 2);
            }
            this.out.writeChar(';');
        }
    }

    private boolean isNullValue(Object fieldValue) {
        if (this.writeNull) {
            return false;
        }
        if (fieldValue instanceof Number) {
            return ((Number)fieldValue).doubleValue() != 0.0;
        }
        return fieldValue != null && !fieldValue.equals(zeroC) && !fieldValue.equals(Boolean.FALSE);
    }

    protected void writeln() {
        if (this.pretty) {
            this.out.writeChar('\n');
        }
    }

    protected void writeArray(Object array, int indent) throws Exception {
        if (array == null) {
            this.writeObject(null);
            return;
        }
        int len = Array.getLength(array);
        this.out.writeChar('[');
        this.out.writeChar(' ');
        boolean hadObj = false;
        for (int ii = 0; ii < len; ++ii) {
            Object val = Array.get(array, ii);
            if (!((val = this.mapper.coerceWriting(val)) instanceof Number) && !(val instanceof String)) {
                hadObj = true;
            }
            this.writeObjectInternal(val, indent);
            this.out.writeChar(' ');
        }
        this.out.writeChar(']');
    }

    public void writeString(String string) {
        if (string == null) {
            this.out.writeString("null");
            return;
        }
        if (string.length() == 0) {
            this.out.writeString("\"\"");
            return;
        }
        char c = '\u0000';
        int len = string.length();
        this.out.writeChar('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    this.out.writeChar('\\');
                    this.out.writeChar(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        this.out.writeChar('\\');
                    }
                    this.out.writeChar(c);
                    continue block9;
                }
                case '\b': {
                    this.out.writeString("\\b");
                    continue block9;
                }
                case '\t': {
                    this.out.writeString("\\t");
                    continue block9;
                }
                case '\n': {
                    this.out.writeString("\\n");
                    continue block9;
                }
                case '\f': {
                    this.out.writeString("\\f");
                    continue block9;
                }
                case '\r': {
                    this.out.writeString("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        this.out.writeString("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    this.out.writeChar(c);
                }
            }
        }
        this.out.writeChar('\"');
    }

    protected void writeIndent(int indent) {
        if (this.pretty) {
            for (int i = 0; i < indent * 2; ++i) {
                this.out.writeChar(' ');
            }
        }
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    public boolean isWriteNull() {
        return this.writeNull;
    }

    public void setWriteNull(boolean writeNull) {
        this.writeNull = writeNull;
    }
}

