/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization.util;

import java.util.HashMap;

public class FSTMap {
    public static final int INIT_SIZ = 65536;
    final int GAP = 4;
    Object[] keys;
    int[] hash;
    int siz = 0;
    int collisionIndex;
    int mask;
    public static final int LOOP = 1000;

    public FSTMap() {
        this.allocWithSize(65536);
    }

    void allocWithSize(int siz) {
        this.siz = siz;
        int len = siz * 4 + siz * 4 / 2;
        this.keys = new Object[len * 2];
        this.hash = new int[len];
        this.mask = siz - 1;
    }

    public Object get(Object key) {
        int hc = key.hashCode();
        int hashIdx = (hc & this.mask) * 4 << 1;
        int loopCnt = 0;
        while (this.keys[hashIdx] != null) {
            int hidx2 = hashIdx >>> 1;
            if (hc == this.hash[hidx2]) {
                if (this.keys[hashIdx].equals(key)) {
                    return this.keys[hashIdx + 1];
                }
                hashIdx += 2;
                if (++loopCnt != 4) continue;
                hashIdx = this.siz * 4;
                continue;
            }
            hashIdx += 2;
            if (++loopCnt != 4) continue;
            hashIdx = this.siz * 4;
        }
        return null;
    }

    public void put(Object key, Object val) {
        int hc = key.hashCode();
        int hashIdx = (hc & this.mask) * 4 << 1;
        int loopCnt = 0;
        while (true) {
            if (this.keys[hashIdx] == null) {
                this.keys[hashIdx + 1] = val;
                this.keys[hashIdx] = key;
                this.hash[hashIdx / 2] = hc;
                return;
            }
            if (hc == this.hash[hashIdx / 2]) {
                if (this.keys[hashIdx].equals(key)) {
                    this.keys[hashIdx + 1] = val;
                    return;
                }
                hashIdx += 2;
                if (++loopCnt != 4) continue;
                hashIdx = this.siz * 4;
                continue;
            }
            hashIdx += 2;
            if (++loopCnt != 4) continue;
            hashIdx = this.siz * 4;
        }
    }

    public static void main(String[] arg) {
        int i;
        int jj;
        int count = 32768;
        FSTMap map = new FSTMap();
        HashMap<Object, Integer> hm = new HashMap<Object, Integer>(65536);
        Object[] obs = new Object[count];
        Object[] obs1 = new Object[count];
        for (int i2 = 0; i2 < count; ++i2) {
            obs[i2] = "" + i2;
            obs1[i2] = "POK" + i2 + "POK";
        }
        System.out.println("---");
        long tim = System.currentTimeMillis();
        for (jj = 0; jj < 1000; ++jj) {
            for (i = 0; i < count; ++i) {
                map.put(obs[i], obs1[i]);
            }
        }
        System.out.println("fst add" + (System.currentTimeMillis() - tim));
        tim = System.currentTimeMillis();
        for (jj = 0; jj < 1000; ++jj) {
            for (i = 0; i < count; ++i) {
                hm.put(obs[i], i);
            }
        }
        System.out.println("hmap add" + (System.currentTimeMillis() - tim));
        tim = System.currentTimeMillis();
        for (jj = 0; jj < 1000; ++jj) {
            for (i = 0; i < count; ++i) {
                if (map.get(obs[i]) != null) continue;
                System.out.println("bug " + i);
            }
        }
        System.out.println("fst read " + (System.currentTimeMillis() - tim));
        tim = System.currentTimeMillis();
        for (jj = 0; jj < 1000; ++jj) {
            for (i = 0; i < count; ++i) {
                if (hm.get(obs[i]) != null) continue;
                System.out.println("bug " + i);
            }
        }
        System.out.println("hmap read " + (System.currentTimeMillis() - tim));
    }
}

