/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization.util;

import de.ruedigermoeller.serialization.util.FSTUtil;
import java.io.IOException;
import java.io.InputStream;

public final class FSTInputStream
extends InputStream {
    public int chunk_size = 1000;
    public static ThreadLocal<byte[]> cachedBuffer = new ThreadLocal();
    public byte[] buf;
    public int pos;
    public int off;
    public int count;
    InputStream in;
    byte[][] streamStack = new byte[30][];
    int[] countStack = new int[30];
    int[] posStack = new int[30];
    int[] offStack = new int[30];
    int sp = 0;

    public FSTInputStream(InputStream in) {
        this.initFromStream(in);
    }

    public void initFromStream(InputStream in) {
        try {
            this.in = in;
            if (this.buf == null) {
                this.buf = cachedBuffer.get();
                if (this.buf == null) {
                    this.buf = new byte[this.chunk_size];
                    cachedBuffer.set(this.buf);
                }
            }
            int read = in.read(this.buf);
            this.count += read;
            while (read != -1) {
                try {
                    if (this.buf.length < this.count + this.chunk_size) {
                        this.ensureCapacity(this.buf.length * 2);
                    }
                    if ((read = in.read(this.buf, this.count, this.chunk_size)) <= 0) continue;
                    this.count += read;
                }
                catch (IndexOutOfBoundsException iex) {
                    read = -1;
                }
            }
            in.close();
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
    }

    public void ensureCapacity(int siz) {
        if (this.buf.length < siz) {
            byte[] newBuf = new byte[siz];
            System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
            this.buf = newBuf;
            if (siz < 0xA00000) {
                cachedBuffer.set(this.buf);
            }
        }
    }

    public FSTInputStream(byte[] buf) {
        this.buf = buf;
        this.pos = 0;
        this.count = buf.length;
    }

    public FSTInputStream(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.pos = offset;
        this.count = Math.min(offset + length, buf.length);
    }

    public void push(byte[] inb, int newpos, int newCount) {
        this.streamStack[this.sp] = this.buf;
        this.countStack[this.sp] = this.count;
        this.posStack[this.sp] = this.pos;
        this.offStack[this.sp] = this.off;
        ++this.sp;
        this.buf = inb;
        this.pos = newpos;
        this.count = newCount;
    }

    public void pop() {
        --this.sp;
        this.buf = this.streamStack[this.sp];
        this.count = this.countStack[this.sp];
        this.pos = this.posStack[this.sp];
        this.off = this.posStack[this.sp];
    }

    @Override
    public int read() {
        if (this.pos < this.count) {
            return this.buf[this.pos++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (this.pos >= this.count) {
            return -1;
        }
        int avail = this.count - this.pos;
        if (len > avail) {
            len = avail;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public long skip(long n) {
        long k = this.count - this.pos;
        if (n < k) {
            k = n < 0L ? 0L : n;
        }
        this.pos = (int)((long)this.pos + k);
        return k;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) {
    }

    @Override
    public void reset() {
        this.count = 0;
        this.pos = 0;
        this.off = 0;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

