/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization;

import de.ruedigermoeller.serialization.FSTClazzInfo;
import de.ruedigermoeller.serialization.FSTObjectInput;
import de.ruedigermoeller.serialization.FSTObjectOutput;
import de.ruedigermoeller.serialization.FSTObjectSerializer;
import de.ruedigermoeller.serialization.FSTSerializerRegistryDelegate;
import java.util.HashMap;

public class FSTSerializerRegistry {
    private FSTSerializerRegistryDelegate delegate;
    public static FSTObjectSerializer NULL = new NULLSerializer();
    HashMap<Class, SerEntry> map = new HashMap(97);

    public void setDelegate(FSTSerializerRegistryDelegate delegate) {
        this.delegate = delegate;
    }

    public FSTSerializerRegistryDelegate getDelegate() {
        return this.delegate;
    }

    public final FSTObjectSerializer getSerializer(Class cl) {
        FSTObjectSerializer ser;
        if (cl.isPrimitive()) {
            return null;
        }
        if (this.delegate != null && (ser = this.delegate.getSerializer(cl)) != null) {
            return ser;
        }
        return this.getSerializer(cl, cl);
    }

    final FSTObjectSerializer getSerializer(Class cl, Class lookupStart) {
        if (cl == null) {
            return null;
        }
        SerEntry serEntry = this.map.get(cl);
        if (serEntry != null) {
            if (cl == lookupStart && serEntry.ser.willHandleClass(cl)) {
                return serEntry.ser;
            }
            if (serEntry.forSubClasses && serEntry.ser.willHandleClass(cl)) {
                this.putSerializer(lookupStart, serEntry.ser, false);
                return serEntry.ser;
            }
        }
        if (cl != Object.class && cl != null) {
            return this.getSerializer(cl.getSuperclass(), lookupStart);
        }
        return null;
    }

    public void putSerializer(Class cl, FSTObjectSerializer ser, boolean includeSubclasses) {
        this.map.put(cl, new SerEntry(includeSubclasses, ser));
    }

    static final class SerEntry {
        boolean forSubClasses = false;
        FSTObjectSerializer ser;

        SerEntry(boolean forSubClasses, FSTObjectSerializer ser) {
            this.forSubClasses = forSubClasses;
            this.ser = ser;
        }
    }

    static class NULLSerializer
    implements FSTObjectSerializer {
        NULLSerializer() {
        }

        public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) {
        }

        public void readObject(FSTObjectInput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy) {
        }

        public boolean willHandleClass(Class cl) {
            return true;
        }

        public boolean alwaysCopy() {
            return false;
        }

        public Object instantiate(Class objectClass, FSTObjectInput fstObjectInput, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPositioin) {
            return null;
        }
    }
}

