/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization;

import de.ruedigermoeller.serialization.FSTClazzInfo;
import de.ruedigermoeller.serialization.FSTClazzInfoRegistry;
import de.ruedigermoeller.serialization.FSTClazzNameRegistry;
import de.ruedigermoeller.serialization.FSTConfiguration;
import de.ruedigermoeller.serialization.FSTObjectOutput;
import de.ruedigermoeller.serialization.FSTObjectRegistry;
import de.ruedigermoeller.serialization.FSTObjectSerializer;
import de.ruedigermoeller.serialization.util.FSTInputStream;
import de.ruedigermoeller.serialization.util.FSTInt2ObjectMap;
import de.ruedigermoeller.serialization.util.FSTUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import sun.misc.Unsafe;

public class FSTObjectInput
extends DataInputStream
implements ObjectInput {
    private static final boolean UNSAFE_COPY_ARRAY_LONG = true;
    private static final boolean UNSAFE_COPY_ARRAY_INT = true;
    private static final boolean UNSAFE_READ_CINT_ARR = true;
    private static final boolean UNSAFE_READ_CINT = true;
    private static final boolean UNSAFE_READ_FINT = true;
    private static final boolean UNSAFE_READ_FLONG = true;
    private static final boolean UNSAFE_READ_UTF = true;
    static final long bufoff;
    static final long choff;
    static final long intoff;
    static final long longoff;
    static final long intscal;
    static final long longscal;
    static final long chscal;
    public FSTClazzNameRegistry clnames;
    FSTObjectRegistry objects;
    Stack<String> debugStack;
    int curDepth;
    ArrayList<CallbackEntry> callbacks;
    FSTConfiguration conf;
    FSTInputStream input = (FSTInputStream)this.in;
    boolean ignoreAnnotations;
    FSTClazzInfoRegistry clInfoRegistry;
    boolean preferSpeed;
    ConditionalCallback conditionalCallback;
    int readExternalReadAHead = 8000;
    static ByteArrayInputStream empty;
    FSTClazzInfo.FSTFieldInfo infoCache;
    ByteArrayOutputStream copyStream;
    FSTInt2ObjectMap<byte[]> mCopyHash;
    char[] chBufS;
    boolean closed = false;
    MyObjectStream fakeWrapper;

    public FSTConfiguration getConf() {
        return this.conf;
    }

    public FSTObjectInput() throws IOException {
        this(empty, FSTConfiguration.getDefaultConfiguration());
    }

    public FSTObjectInput(FSTConfiguration conf) {
        this(empty, conf);
    }

    public FSTObjectInput(InputStream in) throws IOException {
        this(in, FSTConfiguration.getDefaultConfiguration());
    }

    public FSTObjectInput(InputStream in, FSTConfiguration conf) {
        super(new FSTInputStream(in));
        this.conf = conf;
        this.initRegistries();
    }

    public Class getClassForName(String name) throws ClassNotFoundException {
        return this.clnames.classForName(name);
    }

    void initRegistries() {
        this.ignoreAnnotations = this.conf.getCLInfoRegistry().isIgnoreAnnotations();
        this.clInfoRegistry = this.conf.getCLInfoRegistry();
        this.preferSpeed = this.conf.isPreferSpeed();
        this.objects = (FSTObjectRegistry)this.conf.getCachedObject(FSTObjectRegistry.class);
        if (this.objects == null) {
            this.objects = new FSTObjectRegistry(this.conf);
        } else {
            this.objects.clearForRead();
        }
        this.clnames = (FSTClazzNameRegistry)this.conf.getCachedObject(FSTClazzNameRegistry.class);
        if (this.clnames == null) {
            this.clnames = new FSTClazzNameRegistry(this.conf.getClassRegistry(), this.conf);
        } else {
            this.clnames.clear();
        }
    }

    public ConditionalCallback getConditionalCallback() {
        return this.conditionalCallback;
    }

    public void setConditionalCallback(ConditionalCallback conditionalCallback) {
        this.conditionalCallback = conditionalCallback;
    }

    public int getReadExternalReadAHead() {
        return this.readExternalReadAHead;
    }

    public void setReadExternalReadAHead(int readExternalReadAHead) {
        this.readExternalReadAHead = readExternalReadAHead;
    }

    public Object readObject() throws ClassNotFoundException, IOException {
        try {
            return this.readObject(null);
        }
        catch (Exception e) {
            this.dumpDebugStack();
            throw new IOException(e);
        }
    }

    void processValidation() throws InvalidObjectException {
        if (this.callbacks == null) {
            return;
        }
        Collections.sort(this.callbacks, new Comparator<CallbackEntry>(){

            @Override
            public int compare(CallbackEntry o1, CallbackEntry o2) {
                return o2.prio - o1.prio;
            }
        });
        for (int i = 0; i < this.callbacks.size(); ++i) {
            CallbackEntry callbackEntry = this.callbacks.get(i);
            try {
                callbackEntry.cb.validateObject();
                continue;
            }
            catch (Exception ex) {
                throw FSTUtil.rethrow(ex);
            }
        }
    }

    private void dumpDebugStack() {
    }

    public Object readObject(Class ... possibles) throws Exception {
        ++this.curDepth;
        try {
            if (possibles != null) {
                for (int i = 0; i < possibles.length; ++i) {
                    Class possible = possibles[i];
                    this.clnames.registerClass(possible);
                }
            }
            Object res = this.readObjectInternal(possibles);
            this.processValidation();
            Object object = res;
            return object;
        }
        catch (Throwable th) {
            this.dumpDebugStack();
            throw FSTUtil.rethrow(th);
        }
        finally {
            --this.curDepth;
        }
    }

    public Object readObjectInternal(Class ... expected) throws ClassNotFoundException, IOException, IllegalAccessException, InstantiationException {
        try {
            FSTClazzInfo.FSTFieldInfo info = this.infoCache;
            this.infoCache = null;
            if (info == null) {
                info = new FSTClazzInfo.FSTFieldInfo(expected, null, this.ignoreAnnotations);
            } else {
                info.possibleClasses = expected;
            }
            Object res = this.readObjectWithHeader(info);
            this.infoCache = info;
            return res;
        }
        catch (Throwable t) {
            throw FSTUtil.rethrow(t);
        }
    }

    public Object readObjectWithHeader(FSTClazzInfo.FSTFieldInfo referencee) throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException {
        Class c;
        FSTClazzInfo clzSerInfo;
        int readPos = this.input.pos - this.input.off;
        byte code = this.readFByte();
        if (code == 0) {
            clzSerInfo = this.readClass();
            c = clzSerInfo.getClazz();
        } else if (code == -3) {
            c = referencee.getType();
            clzSerInfo = this.getClazzInfo(c, referencee);
        } else if (code >= 1) {
            c = referencee.getPossibleClasses()[code - 1];
            clzSerInfo = this.getClazzInfo(c, referencee);
        } else {
            return this.instantiateSpecialTag(referencee, readPos, code);
        }
        try {
            FSTObjectSerializer ser = clzSerInfo.getSer();
            if (ser != null) {
                return this.instantiateAndReadWithSer(c, ser, clzSerInfo, referencee, readPos);
            }
            return this.instantiateAndReadNoSer(c, clzSerInfo, referencee, readPos);
        }
        catch (Exception e) {
            throw FSTUtil.rethrow(e);
        }
    }

    private Object instantiateSpecialTag(FSTClazzInfo.FSTFieldInfo referencee, int readPos, byte code) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (code == -4) {
            return this.readStringUTFDef();
        }
        if (code == -6) {
            return this.instantiateEnum(referencee, readPos);
        }
        if (code == -1) {
            return null;
        }
        switch (code) {
            case -9: {
                return this.instantiateBigInt();
            }
            case -10: {
                return new Long(this.readCLong());
            }
            case -17: {
                return Boolean.FALSE;
            }
            case -16: {
                return Boolean.TRUE;
            }
            case -18: {
                return referencee.getOneOf()[this.readFByte()];
            }
            case -1: {
                return null;
            }
            case -4: {
                return this.readStringUTFDef();
            }
            case -7: {
                return this.instantiateHandle(referencee);
            }
            case -8: {
                return this.instantiateCopyHandle();
            }
            case -5: {
                return this.instantiateArray(referencee, readPos);
            }
            case -6: {
                return this.instantiateEnum(referencee, readPos);
            }
        }
        throw new RuntimeException("unknown object tag " + code);
    }

    private FSTClazzInfo getClazzInfo(Class c, FSTClazzInfo.FSTFieldInfo referencee) {
        FSTClazzInfo clzSerInfo = referencee.lastInfo != null && referencee.lastInfo.clazz == c ? referencee.lastInfo : this.clInfoRegistry.getCLInfo(c);
        return clzSerInfo;
    }

    private Object instantiateHandle(FSTClazzInfo.FSTFieldInfo referencee) throws IOException {
        int handle = this.readCInt();
        Object res = this.objects.getReadRegisteredObject(handle);
        if (res == null) {
            throw new IOException("unable to ressolve handle " + handle + " " + referencee.getDesc() + " " + this.input.pos);
        }
        return res;
    }

    private Object instantiateCopyHandle() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        int handle = this.readCInt();
        Object res = this.objects.getReadRegisteredObject(handle);
        if (res == null) {
            throw new IOException("unable to ressolve handle " + handle);
        }
        Object copy = this.copy(res, handle);
        return copy;
    }

    private Object instantiateArray(FSTClazzInfo.FSTFieldInfo referencee, int readPos) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Object res = this.readArray(referencee);
        if (!referencee.isFlat()) {
            this.objects.registerObjectForRead(res, readPos);
        }
        return res;
    }

    private Object instantiateEnum(FSTClazzInfo.FSTFieldInfo referencee, int readPos) throws IOException, ClassNotFoundException {
        FSTClazzInfo clzSerInfo = this.readClass();
        Class c = clzSerInfo.getClazz();
        int ordinal = this.readCInt();
        Object[] enumConstants = clzSerInfo.getEnumConstants();
        if (enumConstants == null) {
            return null;
        }
        Object res = enumConstants[ordinal];
        if (!referencee.isFlat()) {
            this.objects.registerObjectForRead(res, readPos);
        }
        return res;
    }

    private Object instantiateBigInt() throws IOException {
        int val = this.readCInt();
        if (val >= 0 && val < FSTConfiguration.intObjects.length) {
            return FSTConfiguration.intObjects[val];
        }
        return new Integer(val);
    }

    private Object instantiateAndReadWithSer(Class c, FSTObjectSerializer ser, FSTClazzInfo clzSerInfo, FSTClazzInfo.FSTFieldInfo referencee, int readPos) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        boolean serInstance = false;
        Object newObj = ser.instantiate(c, this, clzSerInfo, referencee, readPos);
        if (newObj == null) {
            newObj = clzSerInfo.newInstance();
        } else {
            serInstance = true;
        }
        if (newObj == null) {
            throw new IOException(referencee.getDesc() + ":Failed to instantiate '" + c.getName() + "'. Register a custom serializer implementing instantiate.");
        }
        if (newObj.getClass() != c) {
            c = newObj.getClass();
            clzSerInfo = this.clInfoRegistry.getCLInfo(c);
        }
        if (!(referencee.isFlat() || clzSerInfo.isFlat() || ser.alwaysCopy())) {
            this.objects.registerObjectForRead(newObj, readPos);
        }
        if (!serInstance) {
            ser.readObject(this, newObj, clzSerInfo, referencee);
        }
        return newObj;
    }

    private Object instantiateAndReadNoSer(Class c, FSTClazzInfo clzSerInfo, FSTClazzInfo.FSTFieldInfo referencee, int readPos) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Object newObj = clzSerInfo.newInstance();
        if (newObj == null) {
            throw new IOException(referencee.getDesc() + ":Failed to instantiate '" + c.getName() + "'. Register a custom serializer implementing instantiate.");
        }
        if (!referencee.isFlat() && !clzSerInfo.isFlat()) {
            this.objects.registerObjectForRead(newObj, readPos);
        }
        if (clzSerInfo.isExternalizable()) {
            this.ensureReadAhead(this.readExternalReadAHead);
            ((Externalizable)newObj).readExternal(this);
        } else if (clzSerInfo.useCompatibleMode()) {
            Object replaced = this.readObjectCompatible(referencee, clzSerInfo, newObj);
            if (replaced != null && replaced != newObj) {
                this.objects.replace(newObj, replaced, readPos);
                newObj = replaced;
            }
        } else {
            FSTClazzInfo.FSTFieldInfo[] fieldInfo = clzSerInfo.getFieldInfo();
            this.readObjectFields(referencee, clzSerInfo, fieldInfo, newObj);
        }
        return newObj;
    }

    protected Object copy(Object res, int streamPosition) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object copy = this.conf.getCopier().copy(res, this.conf);
        if (copy == null) {
            return this.defaultCopy(res, streamPosition);
        }
        return copy;
    }

    protected Object defaultCopy(Object toCopy, int streamPosition) throws IOException, ClassNotFoundException {
        byte[] buf = this.input.buf;
        int pos = streamPosition;
        try {
            this.input.push(buf, pos, buf.length);
            Object res = this.readObject(null);
            this.input.pop();
            return res;
        }
        catch (Exception e) {
            throw FSTUtil.rethrow(e);
        }
    }

    protected Object readObjectCompatible(FSTClazzInfo.FSTFieldInfo referencee, FSTClazzInfo serializationInfo, Object newObj) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class cl = serializationInfo.getClazz();
        this.readObjectCompatibleRecursive(referencee, newObj, serializationInfo, cl);
        if (newObj != null && serializationInfo.getReadResolveMethod() != null) {
            Object rep = null;
            try {
                rep = serializationInfo.getReadResolveMethod().invoke(newObj, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw FSTUtil.rethrow(e);
            }
            newObj = rep;
        }
        return newObj;
    }

    protected void readObjectCompatibleRecursive(FSTClazzInfo.FSTFieldInfo referencee, Object toRead, FSTClazzInfo serializationInfo, Class cl) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        FSTClazzInfo.FSTCompatibilityInfo fstCompatibilityInfo = serializationInfo.compInfo.get(cl);
        if (!Serializable.class.isAssignableFrom(cl)) {
            return;
        }
        this.readObjectCompatibleRecursive(referencee, toRead, serializationInfo, cl.getSuperclass());
        if (fstCompatibilityInfo != null && fstCompatibilityInfo.getReadMethod() != null) {
            try {
                ObjectInputStream objectInputStream = this.getObjectInputStream(cl, serializationInfo, referencee, toRead);
                fstCompatibilityInfo.getReadMethod().invoke(toRead, objectInputStream);
                this.fakeWrapper.pop();
            }
            catch (Exception e) {
                throw FSTUtil.rethrow(e);
            }
        } else if (fstCompatibilityInfo != null) {
            this.readObjectFields(referencee, serializationInfo, fstCompatibilityInfo.getFieldArray(), toRead);
        }
    }

    public void defaultReadObject(FSTClazzInfo.FSTFieldInfo referencee, FSTClazzInfo serializationInfo, Object newObj) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.readObjectFields(referencee, serializationInfo, serializationInfo.getFieldInfo(), newObj);
    }

    void readObjectFields(FSTClazzInfo.FSTFieldInfo referencee, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo[] fieldInfo, Object newObj) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (FSTUtil.unsafe != null) {
            if (this.preferSpeed) {
                this.readObjectFieldsUnsafeSpeed(referencee, serializationInfo, fieldInfo, newObj);
            } else {
                this.readObjectFieldsUnsafeCompact(referencee, serializationInfo, fieldInfo, newObj);
            }
        } else {
            this.readObjectFieldsSafe(referencee, serializationInfo, fieldInfo, newObj);
        }
    }

    void readObjectFieldsUnsafeCompact(FSTClazzInfo.FSTFieldInfo referencee, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo[] fieldInfo, Object newObj) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        int booleanMask = 0;
        int boolcount = 8;
        int length = fieldInfo.length;
        int conditional = 0;
        try {
            for (int i = 0; i < length; ++i) {
                FSTClazzInfo.FSTFieldInfo subInfo = fieldInfo[i];
                if (subInfo.isPrimitive()) {
                    Class subInfTzpe = subInfo.getType();
                    if (subInfTzpe == Boolean.TYPE) {
                        if (boolcount == 8) {
                            booleanMask = this.readFByte() + 256 & 0xFF;
                            boolcount = 0;
                        }
                        boolean val = (booleanMask & 0x80) != 0;
                        booleanMask <<= 1;
                        ++boolcount;
                        subInfo.setBooleanValue(newObj, val);
                        continue;
                    }
                    if (subInfTzpe == Integer.TYPE) {
                        subInfo.setIntValueUnsafe(newObj, this.readCIntUnsafe());
                        continue;
                    }
                    if (subInfTzpe == Long.TYPE) {
                        subInfo.setLongValueUnsafe(newObj, this.readCLong());
                        continue;
                    }
                    if (subInfTzpe == Byte.TYPE) {
                        subInfo.setByteValue(newObj, this.readFByte());
                        continue;
                    }
                    if (subInfTzpe == Character.TYPE) {
                        subInfo.setCharValue(newObj, this.readCChar());
                        continue;
                    }
                    if (subInfTzpe == Short.TYPE) {
                        subInfo.setShortValue(newObj, this.readCShort());
                        continue;
                    }
                    if (subInfTzpe == Double.TYPE) {
                        subInfo.setDoubleValueUnsafe(newObj, this.readCDouble());
                        continue;
                    }
                    if (subInfTzpe != Float.TYPE) continue;
                    subInfo.setFloatValue(newObj, this.readCFloat());
                    continue;
                }
                if (subInfo.isConditional() && conditional == 0 && this.skipConditional(newObj, conditional = this.readFIntUnsafe(), subInfo)) {
                    this.input.pos = conditional;
                    continue;
                }
                Object subObject = this.readObjectWithHeader(subInfo);
                subInfo.setObjectValueUnsafe(newObj, subObject);
            }
        }
        catch (IllegalAccessException ex) {
            throw new IOException(ex);
        }
    }

    void readObjectFieldsUnsafeSpeed(FSTClazzInfo.FSTFieldInfo referencee, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo[] fieldInfo, Object newObj) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        int booleanMask = 0;
        int boolcount = 8;
        int length = fieldInfo.length;
        int conditional = 0;
        Unsafe unsafe = FSTUtil.unsafe;
        try {
            for (int i = 0; i < length; ++i) {
                FSTClazzInfo.FSTFieldInfo subInfo = fieldInfo[i];
                if (subInfo.isPrimitive()) {
                    Class subInfTzpe = subInfo.getType();
                    if (subInfTzpe == Boolean.TYPE) {
                        if (boolcount == 8) {
                            booleanMask = this.readFByte() + 256 & 0xFF;
                            boolcount = 0;
                        }
                        boolean val = (booleanMask & 0x80) != 0;
                        booleanMask <<= 1;
                        ++boolcount;
                        subInfo.setBooleanValue(newObj, val);
                        continue;
                    }
                    if (subInfTzpe == Integer.TYPE) {
                        this.ensureReadAhead(4);
                        int res = unsafe.getInt(this.input.buf, (long)this.input.pos + bufoff);
                        this.input.pos += 4;
                        FSTUtil.unsafe.putInt(newObj, subInfo.memOffset, res);
                        continue;
                    }
                    if (subInfTzpe == Long.TYPE) {
                        this.ensureReadAhead(8);
                        long res = unsafe.getLong(this.input.buf, (long)this.input.pos + bufoff);
                        this.input.pos += 8;
                        FSTUtil.unsafe.putLong(newObj, subInfo.memOffset, res);
                        continue;
                    }
                    if (subInfTzpe == Byte.TYPE) {
                        subInfo.setByteValue(newObj, this.readFByte());
                        continue;
                    }
                    if (subInfTzpe == Character.TYPE) {
                        subInfo.setCharValue(newObj, this.readFChar());
                        continue;
                    }
                    if (subInfTzpe == Short.TYPE) {
                        subInfo.setShortValue(newObj, this.readFShort());
                        continue;
                    }
                    if (subInfTzpe == Double.TYPE) {
                        subInfo.setDoubleValueUnsafe(newObj, this.readFDoubleUnsafe());
                        continue;
                    }
                    if (subInfTzpe != Float.TYPE) continue;
                    subInfo.setFloatValue(newObj, this.readFFloat());
                    continue;
                }
                if (subInfo.isConditional() && conditional == 0 && this.skipConditional(newObj, conditional = this.readFIntUnsafe(), subInfo)) {
                    this.input.pos = conditional;
                    continue;
                }
                Object subObject = this.readObjectWithHeader(subInfo);
                subInfo.setObjectValueUnsafe(newObj, subObject);
            }
        }
        catch (IllegalAccessException ex) {
            throw new IOException(ex);
        }
    }

    void readObjectFieldsSafe(FSTClazzInfo.FSTFieldInfo referencee, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo[] fieldInfo, Object newObj) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        int booleanMask = 0;
        int boolcount = 8;
        int length = fieldInfo.length;
        int conditional = 0;
        for (int i = 0; i < length; ++i) {
            try {
                FSTClazzInfo.FSTFieldInfo subInfo = fieldInfo[i];
                if (subInfo.isPrimitive()) {
                    Class subInfTzpe = subInfo.getType();
                    if (subInfTzpe == Boolean.TYPE) {
                        if (boolcount == 8) {
                            booleanMask = this.readFByte() + 256 & 0xFF;
                            boolcount = 0;
                        }
                        boolean val = (booleanMask & 0x80) != 0;
                        booleanMask <<= 1;
                        ++boolcount;
                        subInfo.setBooleanValue(newObj, val);
                        continue;
                    }
                    if (this.preferSpeed) {
                        if (subInfTzpe == Integer.TYPE) {
                            subInfo.setIntValue(newObj, this.readFInt());
                            continue;
                        }
                        if (subInfTzpe == Long.TYPE) {
                            subInfo.setLongValue(newObj, this.readFLong());
                            continue;
                        }
                        if (subInfTzpe == Byte.TYPE) {
                            subInfo.setByteValue(newObj, this.readFByte());
                            continue;
                        }
                        if (subInfTzpe == Character.TYPE) {
                            subInfo.setCharValue(newObj, this.readFChar());
                            continue;
                        }
                        if (subInfTzpe == Short.TYPE) {
                            subInfo.setShortValue(newObj, this.readFShort());
                            continue;
                        }
                        if (subInfTzpe == Double.TYPE) {
                            subInfo.setDoubleValue(newObj, this.readFDouble());
                            continue;
                        }
                        if (subInfTzpe != Float.TYPE) continue;
                        subInfo.setFloatValue(newObj, this.readFFloat());
                        continue;
                    }
                    if (subInfTzpe == Integer.TYPE) {
                        subInfo.setIntValue(newObj, this.readCInt());
                        continue;
                    }
                    if (subInfTzpe == Long.TYPE) {
                        subInfo.setLongValue(newObj, this.readCLong());
                        continue;
                    }
                    if (subInfTzpe == Byte.TYPE) {
                        subInfo.setByteValue(newObj, this.readFByte());
                        continue;
                    }
                    if (subInfTzpe == Character.TYPE) {
                        subInfo.setCharValue(newObj, this.readCChar());
                        continue;
                    }
                    if (subInfTzpe == Short.TYPE) {
                        subInfo.setShortValue(newObj, this.readCShort());
                        continue;
                    }
                    if (subInfTzpe == Double.TYPE) {
                        subInfo.setDoubleValue(newObj, this.readCDouble());
                        continue;
                    }
                    if (subInfTzpe != Float.TYPE) continue;
                    subInfo.setFloatValue(newObj, this.readCFloat());
                    continue;
                }
                if (subInfo.isConditional() && conditional == 0 && this.skipConditional(newObj, conditional = this.readFInt(), subInfo)) {
                    this.input.pos = conditional;
                    continue;
                }
                Object subObject = this.readObjectWithHeader(subInfo);
                subInfo.setObjectValue(newObj, subObject);
                continue;
            }
            catch (IllegalAccessException ex) {
                throw new IOException(ex);
            }
        }
    }

    private boolean skipConditional(Object newObj, int conditional, FSTClazzInfo.FSTFieldInfo subInfo) {
        if (this.conditionalCallback != null) {
            return this.conditionalCallback.shouldSkip(newObj, conditional, subInfo.getField());
        }
        return false;
    }

    protected void readCompatibleObjectFields(FSTClazzInfo.FSTFieldInfo referencee, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo[] fieldInfo, Map res) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        int booleanMask = 0;
        int boolcount = 8;
        for (int i = 0; i < fieldInfo.length; ++i) {
            try {
                FSTClazzInfo.FSTFieldInfo subInfo = fieldInfo[i];
                if (subInfo.isIntegral() && !subInfo.isArray()) {
                    Class subInfoType = subInfo.getType();
                    if (subInfoType == Boolean.TYPE) {
                        if (boolcount == 8) {
                            booleanMask = this.readFByte() + 256 & 0xFF;
                            boolcount = 0;
                        }
                        boolean val = (booleanMask & 0x80) != 0;
                        booleanMask <<= 1;
                        ++boolcount;
                        res.put(subInfo.getField().getName(), val);
                    }
                    if (subInfoType == Byte.TYPE) {
                        res.put(subInfo.getField().getName(), this.readFByte());
                        continue;
                    }
                    if (subInfoType == Character.TYPE) {
                        res.put(subInfo.getField().getName(), Character.valueOf(this.readCChar()));
                        continue;
                    }
                    if (subInfoType == Short.TYPE) {
                        res.put(subInfo.getField().getName(), this.readCShort());
                        continue;
                    }
                    if (subInfoType == Integer.TYPE) {
                        res.put(subInfo.getField().getName(), this.readCInt());
                        continue;
                    }
                    if (subInfoType == Double.TYPE) {
                        res.put(subInfo.getField().getName(), this.readCDouble());
                        continue;
                    }
                    if (subInfoType == Float.TYPE) {
                        res.put(subInfo.getField().getName(), Float.valueOf(this.readCFloat()));
                        continue;
                    }
                    if (subInfoType != Long.TYPE) continue;
                    res.put(subInfo.getField().getName(), this.readCLong());
                    continue;
                }
                Object subObject = this.readObjectWithHeader(subInfo);
                res.put(subInfo.getField().getName(), subObject);
                continue;
            }
            catch (IllegalAccessException ex) {
                throw new IOException(ex);
            }
        }
    }

    final void ensureReadAhead(int bytes) throws IOException {
    }

    public String readStringCompressed() throws IOException {
        int len = this.readCInt();
        char[] charBuf = this.getCharBuf(len * 3);
        this.ensureReadAhead(len * 3);
        byte[] buf = this.input.buf;
        int count = this.input.pos;
        int chcount = 0;
        while (chcount < len) {
            char head;
            if ((head = (char)(buf[count++] + 256 & 0xFF)) >= '\u0000' && head < '\u00fe') {
                charBuf[chcount++] = head;
                continue;
            }
            if (head == '\u00fe') {
                int nibbles = buf[count++] + 256 & 0xFF;
                for (int ii = 0; ii < nibbles; ++ii) {
                    int bufVal = buf[count] + 256 & 0xFF;
                    if ((ii & 1) == 0) {
                        charBuf[chcount++] = FSTObjectOutput.enc.charAt(bufVal & 0xF);
                        if (ii != nibbles - 1) continue;
                        ++count;
                        continue;
                    }
                    charBuf[chcount++] = FSTObjectOutput.enc.charAt(bufVal >>> 4 & 0xF);
                    ++count;
                }
                continue;
            }
            int ch1 = buf[count++] + 256 & 0xFF;
            int ch2 = buf[count++] + 256 & 0xFF;
            charBuf[chcount++] = (char)((ch1 << 8) + (ch2 << 0));
        }
        this.input.pos = count;
        return new String(charBuf, 0, chcount);
    }

    private char[] getCharBuf(int siz) {
        char[] chars = this.chBufS;
        if (chars == null || chars.length < siz) {
            this.chBufS = chars = new char[Math.max(siz, 15)];
        }
        return chars;
    }

    public String readStringUTF() throws IOException {
        if (this.preferSpeed) {
            return this.readStringUTFSpeed();
        }
        if (FSTUtil.unsafe != null) {
            return this.readStringUTFUnsafe();
        }
        return this.readStringUTFDef();
    }

    private String readStringUTFDef() throws IOException {
        int len = this.readCInt();
        char[] charBuf = this.getCharBuf(len * 3);
        this.ensureReadAhead(len * 3);
        byte[] buf = this.input.buf;
        int count = this.input.pos;
        int chcount = 0;
        for (int i = 0; i < len; ++i) {
            char head;
            if ((head = (char)(buf[count++] + 256 & 0xFF)) < '\u00ff') {
                charBuf[chcount++] = head;
                continue;
            }
            int ch1 = buf[count++] + 256 & 0xFF;
            int ch2 = buf[count++] + 256 & 0xFF;
            charBuf[chcount++] = (char)((ch1 << 8) + (ch2 << 0));
        }
        this.input.pos = count;
        return new String(charBuf, 0, chcount);
    }

    public String readStringUTFSpeed() throws IOException {
        if (FSTUtil.unsafe != null) {
            Unsafe unsafe = FSTUtil.unsafe;
            int len = this.readFIntUnsafe();
            char[] charBuf = this.getCharBuf(len * 2);
            this.ensureReadAhead(len * 2);
            byte[] buf = this.input.buf;
            int count = (int)((long)this.input.pos + bufoff);
            int chcount = (int)choff;
            unsafe.copyMemory(buf, count, charBuf, chcount, (long)len * chscal);
            this.input.pos = (int)((long)this.input.pos + (long)len * chscal);
            return new String(charBuf, 0, len);
        }
        int len = this.readFInt();
        char[] charBuf = this.getCharBuf(len * 2);
        this.ensureReadAhead(len * 2);
        byte[] buf = this.input.buf;
        int count = this.input.pos;
        int chcount = 0;
        for (int i = 0; i < len; ++i) {
            int ch2 = buf[count++] + 256 & 0xFF;
            int ch1 = buf[count++] + 256 & 0xFF;
            charBuf[chcount++] = (char)((ch1 << 8) + (ch2 << 0));
        }
        this.input.pos = count;
        return new String(charBuf, 0, chcount);
    }

    private String readStringUTFUnsafe() throws IOException {
        Unsafe unsafe = FSTUtil.unsafe;
        int len = 0;
        len = this.readCIntUnsafe();
        char[] charBuf = this.getCharBuf(len * 3);
        this.ensureReadAhead(len * 3);
        byte[] buf = this.input.buf;
        long count = (long)this.input.pos + bufoff;
        long chcount = choff;
        for (int i = 0; i < len; ++i) {
            char head;
            if ((head = (char)(unsafe.getByte(buf, count++) + 256 & 0xFF)) >= '\u0000' && head < '\u00ff') {
                unsafe.putChar(charBuf, chcount, head);
                chcount += chscal;
                continue;
            }
            int ch1 = unsafe.getByte(buf, count++) + 256 & 0xFF;
            int ch2 = unsafe.getByte(buf, count++) + 256 & 0xFF;
            unsafe.putChar(charBuf, chcount, (char)((ch1 << 8) + (ch2 << 0)));
            chcount += chscal;
        }
        this.input.pos = (int)(count - bufoff);
        return new String(charBuf, 0, (int)((chcount - choff) / chscal));
    }

    public Object readFPrimitiveArray(Class componentType, int len) {
        try {
            Object array = Array.newInstance(componentType, len);
            if (componentType == Byte.TYPE) {
                byte[] arr = (byte[])array;
                this.ensureReadAhead(arr.length);
                this.read(arr);
                return arr;
            }
            if (componentType == Character.TYPE) {
                char[] arr = (char[])array;
                for (int j = 0; j < len; ++j) {
                    arr[j] = this.readCChar();
                }
                return arr;
            }
            if (componentType == Short.TYPE) {
                short[] arr = (short[])array;
                this.ensureReadAhead(arr.length * 2);
                for (int j = 0; j < len; ++j) {
                    arr[j] = this.readFShort();
                }
                return arr;
            }
            if (componentType == Integer.TYPE) {
                int[] arr = (int[])array;
                if (FSTUtil.unsafe != null) {
                    this.readPlainIntArrUnsafe(arr);
                } else {
                    this.readFIntArr(len, arr);
                }
                return arr;
            }
            if (componentType == Float.TYPE) {
                float[] arr = (float[])array;
                this.ensureReadAhead(arr.length * 4);
                for (int j = 0; j < len; ++j) {
                    arr[j] = this.readFFloat();
                }
                return arr;
            }
            if (componentType == Double.TYPE) {
                double[] arr = (double[])array;
                this.ensureReadAhead(arr.length * 8);
                for (int j = 0; j < len; ++j) {
                    arr[j] = this.readFDouble();
                }
                return arr;
            }
            if (componentType == Long.TYPE) {
                long[] arr = (long[])array;
                this.ensureReadAhead(arr.length * 8);
                if (FSTUtil.unsafe != null) {
                    this.readLongArrUnsafe(arr);
                } else {
                    for (int j = 0; j < len; ++j) {
                        arr[j] = this.readFLong();
                    }
                }
                return arr;
            }
            if (componentType == Boolean.TYPE) {
                boolean[] arr = (boolean[])array;
                this.ensureReadAhead(arr.length);
                for (int j = 0; j < len; ++j) {
                    arr[j] = this.readBoolean();
                }
                return arr;
            }
            throw new RuntimeException("unexpected primitive type " + componentType);
        }
        catch (IOException e) {
            throw FSTUtil.rethrow(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object readArray(FSTClazzInfo.FSTFieldInfo referencee) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class arrCl = this.readClass().getClazz();
        int len = this.readCInt();
        if (len == -1) {
            return null;
        }
        Class<?> arrType = arrCl.getComponentType();
        if (!arrCl.getComponentType().isArray()) {
            Object array = Array.newInstance(arrType, len);
            this.objects.registerObjectForRead(array, this.input.pos - this.input.off);
            if (arrCl.getComponentType().isPrimitive()) {
                if (arrType == Byte.TYPE) {
                    byte[] arr = (byte[])array;
                    this.ensureReadAhead(arr.length);
                    this.read(arr);
                    return array;
                } else if (arrType == Character.TYPE) {
                    char[] arr = (char[])array;
                    for (int j = 0; j < len; ++j) {
                        arr[j] = this.readCChar();
                    }
                    return array;
                } else if (arrType == Short.TYPE) {
                    short[] arr = (short[])array;
                    this.ensureReadAhead(arr.length * 2);
                    for (int j = 0; j < len; ++j) {
                        arr[j] = this.readFShort();
                    }
                    return array;
                } else if (arrType == Integer.TYPE) {
                    int[] arr = (int[])array;
                    if (referencee.isThin()) {
                        this.readThinArray(len, arr);
                        return array;
                    } else if (referencee.isCompressed()) {
                        this.readCompressedArray(len, arr);
                        return array;
                    } else if (FSTUtil.unsafe != null) {
                        this.readPlainIntArrUnsafe(arr);
                        return array;
                    } else {
                        this.readFIntArr(len, arr);
                    }
                    return array;
                } else if (arrType == Float.TYPE) {
                    float[] arr = (float[])array;
                    this.ensureReadAhead(arr.length * 4);
                    for (int j = 0; j < len; ++j) {
                        arr[j] = this.readFFloat();
                    }
                    return array;
                } else if (arrType == Double.TYPE) {
                    double[] arr = (double[])array;
                    this.ensureReadAhead(arr.length * 8);
                    for (int j = 0; j < len; ++j) {
                        arr[j] = this.readFDouble();
                    }
                    return array;
                } else if (arrType == Long.TYPE) {
                    long[] arr = (long[])array;
                    this.ensureReadAhead(arr.length * 8);
                    if (FSTUtil.unsafe != null) {
                        this.readLongArrUnsafe(arr);
                        return array;
                    } else {
                        for (int j = 0; j < len; ++j) {
                            arr[j] = this.readFLong();
                        }
                    }
                    return array;
                } else {
                    if (arrType != Boolean.TYPE) throw new RuntimeException("unexpected primitive type " + arrType);
                    boolean[] arr = (boolean[])array;
                    this.ensureReadAhead(arr.length);
                    for (int j = 0; j < len; ++j) {
                        arr[j] = this.readBoolean();
                    }
                }
                return array;
            } else {
                Object[] arr = (Object[])array;
                if (referencee.isThin()) {
                    int idx;
                    for (int i = 0; i < len && (idx = this.readCInt()) != len; ++i) {
                        Object subArray;
                        arr[idx] = subArray = this.readObjectWithHeader(referencee);
                    }
                    return array;
                } else {
                    for (int i = 0; i < len; ++i) {
                        Object value;
                        arr[i] = value = this.readObjectWithHeader(referencee);
                    }
                }
            }
            return array;
        }
        Object[] array = (Object[])Array.newInstance(arrType, len);
        if (!FSTUtil.isPrimitiveArray(arrType) && !referencee.isFlat()) {
            this.objects.registerObjectForRead(array, this.input.pos - this.input.off);
        }
        FSTClazzInfo.FSTFieldInfo ref1 = new FSTClazzInfo.FSTFieldInfo(referencee.getPossibleClasses(), null, this.clInfoRegistry.isIgnoreAnnotations());
        for (int i = 0; i < len; ++i) {
            Object subArray;
            array[i] = subArray = this.readArray(ref1);
        }
        return array;
    }

    public void readLongArrUnsafe(long[] arr) {
        byte[] buf = this.input.buf;
        int siz = (int)((long)arr.length * longscal);
        FSTUtil.unsafe.copyMemory(buf, (long)this.input.pos + bufoff, arr, longoff, siz);
        this.input.pos += siz;
    }

    public void readPlainIntArrUnsafe(int[] arr) {
        byte[] buf = this.input.buf;
        int siz = (int)((long)arr.length * intscal);
        FSTUtil.unsafe.copyMemory(buf, (long)this.input.pos + bufoff, arr, intoff, siz);
        this.input.pos += siz;
    }

    public void readCompressedArray(int len, int[] arr) throws IOException {
        byte type = this.readFByte();
        switch (type) {
            case 0: {
                this.readDiffArr(len, arr);
                break;
            }
            case 1: {
                this.readCIntArr(len, arr);
                break;
            }
            case 2: {
                this.readThinArray(len, arr);
                break;
            }
            case 3: {
                this.readOffsShortArr(len, arr);
            }
        }
    }

    private void readOffsShortArr(int len, int[] arr) throws IOException {
        int min = this.readCInt();
        for (int i = 0; i < len; ++i) {
            arr[i] = min + this.readShort();
        }
    }

    private void readDiffArr(int len, int[] arr) throws IOException {
        int start;
        arr[0] = start = this.readCInt();
        for (int i = 1; i < len; ++i) {
            arr[i] = arr[i - 1] + this.readCInt();
        }
    }

    private void readThinArray(int len, int[] arr) throws IOException {
        int index;
        for (int i = 0; i < len && (index = this.readCInt()) != len; ++i) {
            int val;
            arr[index] = val = this.readCInt();
        }
    }

    public void registerObject(Object o, int streamPosition, FSTClazzInfo info, FSTClazzInfo.FSTFieldInfo referencee) {
        if (!(this.objects.disabled || referencee.isFlat() || info.isFlat())) {
            this.objects.registerObjectForRead(o, streamPosition);
        }
    }

    public FSTClazzInfo readClass() throws IOException, ClassNotFoundException {
        return this.clnames.decodeClass(this);
    }

    public int _readCInt() throws IOException {
        byte head = this.readFByte();
        if (head > -127 && head <= 127) {
            return head;
        }
        if (head == -128) {
            return this.readShort();
        }
        return this.readFInt();
    }

    void resetAndClearRefs() {
        try {
            this.reset();
            this.objects.clearForRead();
            this.clnames.clear();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reset() throws IOException {
        this.input.reset();
    }

    public void resetForReuse(InputStream in) throws IOException {
        if (this.closed) {
            throw new RuntimeException("can't reuse closed stream");
        }
        this.input.reset();
        this.clnames.clear();
        this.input.initFromStream(in);
        this.objects.clearForRead();
        this.clnames.clear();
    }

    public void resetForReuseCopyArray(byte[] bytes, int off, int len) throws IOException {
        if (this.closed) {
            throw new RuntimeException("can't reuse closed stream");
        }
        this.input.reset();
        this.objects.clearForRead();
        this.clnames.clear();
        this.input.ensureCapacity(len);
        this.input.count = len;
        System.arraycopy(bytes, off, this.input.buf, 0, len);
    }

    public void resetForReuseUseArray(byte[] bytes) throws IOException {
        this.resetForReuseUseArray(bytes, 0, bytes.length);
    }

    public void resetForReuseUseArray(byte[] bytes, int off, int len) throws IOException {
        if (this.closed) {
            throw new RuntimeException("can't reuse closed stream");
        }
        this.input.reset();
        this.objects.clearForRead();
        this.clnames.clear();
        this.input.count = len + off;
        this.input.buf = bytes;
        this.input.pos = off;
        this.input.off = off;
    }

    public final int readFIntUnsafe() throws IOException {
        this.ensureReadAhead(8);
        Unsafe unsafe = FSTUtil.unsafe;
        byte[] buf = this.input.buf;
        int res = unsafe.getInt(buf, (long)this.input.pos + bufoff);
        this.input.pos += 4;
        return res;
    }

    public final int readFInt() throws IOException {
        if (FSTUtil.unsafe != null) {
            return this.readFIntUnsafe();
        }
        this.ensureReadAhead(4);
        int count = this.input.pos;
        byte[] buf = this.input.buf;
        int ch4 = buf[count++] + 256 & 0xFF;
        int ch3 = buf[count++] + 256 & 0xFF;
        int ch2 = buf[count++] + 256 & 0xFF;
        int ch1 = buf[count++] + 256 & 0xFF;
        this.input.pos = count;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public void readFIntArr(int len, int[] arr) throws IOException {
        this.ensureReadAhead(4 * len);
        byte[] buf = this.input.buf;
        int count = this.input.pos;
        for (int j = 0; j < len; ++j) {
            int ch4 = buf[count++] + 256 & 0xFF;
            int ch3 = buf[count++] + 256 & 0xFF;
            int ch2 = buf[count++] + 256 & 0xFF;
            int ch1 = buf[count++] + 256 & 0xFF;
            arr[j] = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        }
        this.input.pos = count;
    }

    private void readCIntArr(int len, int[] arr) throws IOException {
        if (FSTUtil.unsafe != null) {
            this.readCIntArrUnsafe(len, arr);
            return;
        }
        this.ensureReadAhead(5 * len);
        byte[] buf = this.input.buf;
        int count = this.input.pos;
        for (int j = 0; j < len; ++j) {
            int ch2;
            int ch1;
            int head;
            if ((head = buf[count++]) > -127 && head <= 127) {
                arr[j] = head;
                continue;
            }
            if (head == -128) {
                ch1 = buf[count++] + 256 & 0xFF;
                ch2 = buf[count++] + 256 & 0xFF;
                arr[j] = (short)((ch1 << 8) + (ch2 << 0));
                continue;
            }
            ch1 = buf[count++] + 256 & 0xFF;
            ch2 = buf[count++] + 256 & 0xFF;
            int ch3 = buf[count++] + 256 & 0xFF;
            int ch4 = buf[count++] + 256 & 0xFF;
            arr[j] = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        }
        this.input.pos = count;
    }

    private void readCIntArrUnsafe(int len, int[] arr) throws IOException {
        Unsafe unsafe = FSTUtil.unsafe;
        this.ensureReadAhead(5 * len);
        byte[] buf = this.input.buf;
        long count = (long)this.input.pos + bufoff;
        int max = (int)((long)len * intscal + intoff);
        int cn = this.input.pos;
        for (long j = intoff; j < (long)max; j += intscal) {
            int ch2;
            int ch1;
            byte head = unsafe.getByte(buf, count++);
            ++cn;
            if (head > -127 && head <= 127) {
                unsafe.putInt(arr, j, head);
                continue;
            }
            if (head == -128) {
                ch1 = unsafe.getByte(buf, count++) + 256 & 0xFF;
                ch2 = unsafe.getByte(buf, count++) + 256 & 0xFF;
                unsafe.putInt(arr, j, (short)((ch1 << 8) + (ch2 << 0)));
                cn += 2;
                continue;
            }
            ch1 = unsafe.getByte(buf, count++) + 256 & 0xFF;
            ch2 = unsafe.getByte(buf, count++) + 256 & 0xFF;
            int ch3 = unsafe.getByte(buf, count++) + 256 & 0xFF;
            int ch4 = unsafe.getByte(buf, count++) + 256 & 0xFF;
            cn += 4;
            unsafe.putInt(arr, j, (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0));
        }
        this.input.pos = cn;
    }

    public final int readCInt() throws IOException {
        if (FSTUtil.unsafe != null) {
            return this.readCIntUnsafe();
        }
        this.ensureReadAhead(5);
        byte[] buf = this.input.buf;
        int count = this.input.pos;
        byte head = buf[count++];
        if (head > -127 && head <= 127) {
            this.input.pos = count;
            return head;
        }
        if (head == -128) {
            int ch1 = buf[count++] + 256 & 0xFF;
            int ch2 = buf[count++] + 256 & 0xFF;
            this.input.pos = count;
            return (short)((ch1 << 8) + (ch2 << 0));
        }
        int ch1 = buf[count++] + 256 & 0xFF;
        int ch2 = buf[count++] + 256 & 0xFF;
        int ch3 = buf[count++] + 256 & 0xFF;
        int ch4 = buf[count++] + 256 & 0xFF;
        this.input.pos = count;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    private final int readCIntUnsafe() throws IOException {
        Unsafe unsafe = FSTUtil.unsafe;
        this.ensureReadAhead(5);
        byte[] buf = this.input.buf;
        long count = (long)this.input.pos + bufoff;
        byte head = unsafe.getByte(buf, count++);
        if (head > -127 && head <= 127) {
            this.input.pos = (int)(count - bufoff);
            return head;
        }
        if (head == -128) {
            int ch1 = unsafe.getByte(buf, count++) + 256 & 0xFF;
            int ch2 = unsafe.getByte(buf, count++) + 256 & 0xFF;
            this.input.pos = (int)(count - bufoff);
            return (short)((ch1 << 8) + (ch2 << 0));
        }
        int ch1 = unsafe.getByte(buf, count++) + 256 & 0xFF;
        int ch2 = unsafe.getByte(buf, count++) + 256 & 0xFF;
        int ch3 = unsafe.getByte(buf, count++) + 256 & 0xFF;
        int ch4 = unsafe.getByte(buf, count++) + 256 & 0xFF;
        this.input.pos = (int)(count - bufoff);
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public double readFDouble() throws IOException {
        return Double.longBitsToDouble(this.readFLong());
    }

    public double readFDoubleUnsafe() throws IOException {
        this.ensureReadAhead(8);
        Unsafe unsafe = FSTUtil.unsafe;
        byte[] buf = this.input.buf;
        double res = unsafe.getDouble(buf, (long)this.input.pos + bufoff);
        this.input.pos += 8;
        return res;
    }

    public final byte readFByte() throws IOException {
        this.ensureReadAhead(1);
        return this.input.buf[this.input.pos++];
    }

    public long readFLongUnsafe() throws IOException {
        this.ensureReadAhead(8);
        Unsafe unsafe = FSTUtil.unsafe;
        byte[] buf = this.input.buf;
        long res = unsafe.getLong(buf, (long)this.input.pos + bufoff);
        this.input.pos += 8;
        return res;
    }

    public long readFLong() throws IOException {
        if (FSTUtil.unsafe != null) {
            return this.readFLongUnsafe();
        }
        this.ensureReadAhead(8);
        int count = this.input.pos;
        byte[] buf = this.input.buf;
        long ch8 = buf[count++] + 256 & 0xFF;
        long ch7 = buf[count++] + 256 & 0xFF;
        long ch6 = buf[count++] + 256 & 0xFF;
        long ch5 = buf[count++] + 256 & 0xFF;
        long ch4 = buf[count++] + 256 & 0xFF;
        long ch3 = buf[count++] + 256 & 0xFF;
        long ch2 = buf[count++] + 256 & 0xFF;
        long ch1 = buf[count++] + 256 & 0xFF;
        this.input.pos = count;
        return (ch1 << 56) + (ch2 << 48) + (ch3 << 40) + (ch4 << 32) + (ch5 << 24) + (ch6 << 16) + (ch7 << 8) + (ch8 << 0);
    }

    public long readCLong() throws IOException {
        this.ensureReadAhead(9);
        byte head = this.readFByte();
        if (head > -126 && head <= 127) {
            return head;
        }
        if (head == -128) {
            return this.readShort();
        }
        if (head == -127) {
            return this.readFInt();
        }
        return this.readFLong();
    }

    public char readFChar() throws IOException {
        this.ensureReadAhead(2);
        int count = this.input.pos;
        byte[] buf = this.input.buf;
        int ch2 = buf[count++] + 256 & 0xFF;
        int ch1 = buf[count++] + 256 & 0xFF;
        this.input.pos = count;
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public char readCChar() throws IOException {
        this.ensureReadAhead(3);
        char head = (char)(this.readFByte() + 256 & 0xFF);
        if (head >= '\u0000' && head < '\u00ff') {
            return head;
        }
        return this.readChar();
    }

    public float readCFloat() throws IOException {
        return Float.intBitsToFloat(this.readFInt());
    }

    public float readFFloat() throws IOException {
        return Float.intBitsToFloat(this.readFInt());
    }

    public double readCDouble() throws IOException {
        this.ensureReadAhead(8);
        return Double.longBitsToDouble(this.readFLong());
    }

    public short readFShort() throws IOException {
        this.ensureReadAhead(2);
        int count = this.input.pos;
        byte[] buf = this.input.buf;
        int ch1 = buf[count++] + 256 & 0xFF;
        int ch2 = buf[count++] + 256 & 0xFF;
        this.input.pos = count;
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public short readCShort() throws IOException {
        this.ensureReadAhead(3);
        int head = this.readFByte() + 256 & 0xFF;
        if (head >= 0 && head < 255) {
            return (short)head;
        }
        return this.readShort();
    }

    public void close() throws IOException {
        super.close();
        this.closed = true;
        this.resetAndClearRefs();
        this.conf.returnObject(this.objects, this.clnames);
    }

    ObjectInputStream getObjectInputStream(final Class cl, final FSTClazzInfo clInfo, final FSTClazzInfo.FSTFieldInfo referencee, final Object toRead) throws IOException {
        ObjectInputStream wrapped = new ObjectInputStream(){
            HashMap<String, Object> fieldMap;

            public Object readObjectOverride() throws IOException, ClassNotFoundException {
                try {
                    return FSTObjectInput.this.readObjectInternal(referencee.getPossibleClasses());
                }
                catch (IllegalAccessException e) {
                    throw new IOException(e);
                }
                catch (InstantiationException e) {
                    throw new IOException(e);
                }
            }

            public Object readUnshared() throws IOException, ClassNotFoundException {
                try {
                    return FSTObjectInput.this.readObjectInternal(referencee.getPossibleClasses());
                }
                catch (IllegalAccessException e) {
                    throw new IOException(e);
                }
                catch (InstantiationException e) {
                    throw new IOException(e);
                }
            }

            public void defaultReadObject() throws IOException, ClassNotFoundException {
                try {
                    FSTObjectInput.this.readObjectFields(referencee, clInfo, clInfo.compInfo.get(cl).getFieldArray(), toRead);
                }
                catch (IllegalAccessException e) {
                    throw new IOException(e);
                }
                catch (InstantiationException e) {
                    throw new IOException(e);
                }
            }

            public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
                try {
                    FSTClazzInfo.FSTCompatibilityInfo fstCompatibilityInfo = clInfo.compInfo.get(cl);
                    if (fstCompatibilityInfo.isAsymmetric()) {
                        this.fieldMap = new HashMap();
                        FSTObjectInput.this.readCompatibleObjectFields(referencee, clInfo, fstCompatibilityInfo.getFieldArray(), this.fieldMap);
                    } else {
                        this.fieldMap = (HashMap)FSTObjectInput.this.readObjectInternal(HashMap.class);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new IOException(e);
                }
                catch (InstantiationException e) {
                    throw new IOException(e);
                }
                return new ObjectInputStream.GetField(){

                    public ObjectStreamClass getObjectStreamClass() {
                        return ObjectStreamClass.lookup(cl);
                    }

                    public boolean defaulted(String name) throws IOException {
                        return fieldMap.get(name) == null;
                    }

                    public boolean get(String name, boolean val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return (Boolean)fieldMap.get(name);
                    }

                    public byte get(String name, byte val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return (Byte)fieldMap.get(name);
                    }

                    public char get(String name, char val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return ((Character)fieldMap.get(name)).charValue();
                    }

                    public short get(String name, short val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return (Short)fieldMap.get(name);
                    }

                    public int get(String name, int val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return (Integer)fieldMap.get(name);
                    }

                    public long get(String name, long val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return (Long)fieldMap.get(name);
                    }

                    public float get(String name, float val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return ((Float)fieldMap.get(name)).floatValue();
                    }

                    public double get(String name, double val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return (Double)fieldMap.get(name);
                    }

                    public Object get(String name, Object val) throws IOException {
                        Object res = fieldMap.get(name);
                        if (res == null) {
                            return val;
                        }
                        return res;
                    }
                };
            }

            public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
                if (FSTObjectInput.this.callbacks == null) {
                    FSTObjectInput.this.callbacks = new ArrayList();
                }
                FSTObjectInput.this.callbacks.add(new CallbackEntry(obj, prio));
            }

            public int read() throws IOException {
                FSTObjectInput.this.ensureReadAhead(1);
                return FSTObjectInput.this.readFByte();
            }

            public int read(byte[] buf, int off, int len) throws IOException {
                FSTObjectInput.this.ensureReadAhead(len);
                return FSTObjectInput.this.read(buf, off, len);
            }

            public int available() throws IOException {
                return FSTObjectInput.this.available();
            }

            public void close() throws IOException {
            }

            public boolean readBoolean() throws IOException {
                FSTObjectInput.this.ensureReadAhead(1);
                return FSTObjectInput.this.readBoolean();
            }

            public byte readByte() throws IOException {
                FSTObjectInput.this.ensureReadAhead(1);
                return FSTObjectInput.this.readFByte();
            }

            public int readUnsignedByte() throws IOException {
                FSTObjectInput.this.ensureReadAhead(1);
                return FSTObjectInput.this.readUnsignedByte();
            }

            public char readChar() throws IOException {
                FSTObjectInput.this.ensureReadAhead(2);
                return FSTObjectInput.this.readChar();
            }

            public short readShort() throws IOException {
                FSTObjectInput.this.ensureReadAhead(2);
                return FSTObjectInput.this.readShort();
            }

            public int readUnsignedShort() throws IOException {
                FSTObjectInput.this.ensureReadAhead(2);
                return FSTObjectInput.this.readUnsignedShort();
            }

            public int readInt() throws IOException {
                return FSTObjectInput.this.readFInt();
            }

            public long readLong() throws IOException {
                FSTObjectInput.this.ensureReadAhead(8);
                return FSTObjectInput.this.readFLong();
            }

            public float readFloat() throws IOException {
                FSTObjectInput.this.ensureReadAhead(4);
                return FSTObjectInput.this.readFloat();
            }

            public double readDouble() throws IOException {
                FSTObjectInput.this.ensureReadAhead(8);
                return FSTObjectInput.this.readDouble();
            }

            public void readFully(byte[] buf) throws IOException {
                FSTObjectInput.this.ensureReadAhead(buf.length);
                FSTObjectInput.this.readFully(buf);
            }

            public void readFully(byte[] buf, int off, int len) throws IOException {
                FSTObjectInput.this.ensureReadAhead(len);
                FSTObjectInput.this.readFully(buf, off, len);
            }

            public int skipBytes(int len) throws IOException {
                FSTObjectInput.this.ensureReadAhead(len);
                return FSTObjectInput.this.skipBytes(len);
            }

            public String readUTF() throws IOException {
                return FSTObjectInput.this.readStringUTF();
            }

            public String readLine() throws IOException {
                FSTObjectInput.this.ensureReadAhead(1000);
                return FSTObjectInput.this.readLine();
            }

            public int read(byte[] b) throws IOException {
                FSTObjectInput.this.ensureReadAhead(b.length);
                return FSTObjectInput.this.read(b);
            }

            public long skip(long n) throws IOException {
                FSTObjectInput.this.ensureReadAhead((int)n);
                return FSTObjectInput.this.skip(n);
            }

            public void mark(int readlimit) {
                FSTObjectInput.this.mark(readlimit);
            }

            public void reset() throws IOException {
                FSTObjectInput.this.reset();
            }

            public boolean markSupported() {
                return FSTObjectInput.this.markSupported();
            }
        };
        if (this.fakeWrapper == null) {
            this.fakeWrapper = new MyObjectStream();
        }
        this.fakeWrapper.push(wrapped);
        return this.fakeWrapper;
    }

    public FSTInputStream getInput() {
        return this.input;
    }

    static {
        Unsafe unsafe = FSTUtil.getUnsafe();
        if (unsafe != null) {
            bufoff = unsafe.arrayBaseOffset(byte[].class);
            intoff = unsafe.arrayBaseOffset(int[].class);
            longoff = unsafe.arrayBaseOffset(long[].class);
            longscal = unsafe.arrayIndexScale(long[].class);
            intscal = unsafe.arrayIndexScale(int[].class);
            chscal = unsafe.arrayIndexScale(char[].class);
            choff = unsafe.arrayBaseOffset(char[].class);
        } else {
            longoff = 0L;
            longscal = 0L;
            bufoff = 0L;
            intoff = 0L;
            intscal = 0L;
            choff = 0L;
            chscal = 0L;
        }
        empty = new ByteArrayInputStream(new byte[0]);
    }

    static class MyObjectStream
    extends ObjectInputStream {
        ObjectInputStream wrapped;
        ObjectInputStream[] wrappedArr = new ObjectInputStream[30];
        int idx = 0;

        public void push(ObjectInputStream in) {
            this.wrappedArr[this.idx++] = in;
            this.wrapped = in;
        }

        public void pop() {
            --this.idx;
            this.wrapped = this.wrappedArr[this.idx];
        }

        MyObjectStream() throws IOException, SecurityException {
            this.wrapped = this.wrapped;
        }

        public Object readObjectOverride() throws IOException, ClassNotFoundException {
            return this.wrapped.readObject();
        }

        public Object readUnshared() throws IOException, ClassNotFoundException {
            return this.wrapped.readUnshared();
        }

        public void defaultReadObject() throws IOException, ClassNotFoundException {
            this.wrapped.defaultReadObject();
        }

        public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
            return this.wrapped.readFields();
        }

        public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
            this.wrapped.registerValidation(obj, prio);
        }

        public int read() throws IOException {
            return this.wrapped.read();
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            return this.wrapped.read(buf, off, len);
        }

        public int available() throws IOException {
            return this.wrapped.available();
        }

        public void close() throws IOException {
            this.wrapped.close();
        }

        public boolean readBoolean() throws IOException {
            return this.wrapped.readBoolean();
        }

        public byte readByte() throws IOException {
            return this.wrapped.readByte();
        }

        public int readUnsignedByte() throws IOException {
            return this.wrapped.readUnsignedByte();
        }

        public char readChar() throws IOException {
            return this.wrapped.readChar();
        }

        public short readShort() throws IOException {
            return this.wrapped.readShort();
        }

        public int readUnsignedShort() throws IOException {
            return this.wrapped.readUnsignedShort();
        }

        public int readInt() throws IOException {
            return this.wrapped.readInt();
        }

        public long readLong() throws IOException {
            return this.wrapped.readLong();
        }

        public float readFloat() throws IOException {
            return this.wrapped.readFloat();
        }

        public double readDouble() throws IOException {
            return this.wrapped.readDouble();
        }

        public void readFully(byte[] buf) throws IOException {
            this.wrapped.readFully(buf);
        }

        public void readFully(byte[] buf, int off, int len) throws IOException {
            this.wrapped.readFully(buf, off, len);
        }

        public int skipBytes(int len) throws IOException {
            return this.wrapped.skipBytes(len);
        }

        public String readUTF() throws IOException {
            return this.wrapped.readUTF();
        }

        public String readLine() throws IOException {
            return this.wrapped.readLine();
        }

        public int read(byte[] b) throws IOException {
            return this.wrapped.read(b);
        }

        public long skip(long n) throws IOException {
            return this.wrapped.skip(n);
        }

        public void mark(int readlimit) {
            this.wrapped.mark(readlimit);
        }

        public void reset() throws IOException {
            this.wrapped.reset();
        }

        public boolean markSupported() {
            return this.wrapped.markSupported();
        }
    }

    public static interface ConditionalCallback {
        public boolean shouldSkip(Object var1, int var2, Field var3);
    }

    static class CallbackEntry {
        ObjectInputValidation cb;
        int prio;

        CallbackEntry(ObjectInputValidation cb, int prio) {
            this.cb = cb;
            this.prio = prio;
        }
    }
}

