/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.heapoff.bytez.malloc;

import de.ruedigermoeller.heapoff.bytez.Bytez;
import de.ruedigermoeller.heapoff.bytez.malloc.MallocBytezAllocator;
import de.ruedigermoeller.heapoff.bytez.onheap.HeapBytez;
import de.ruedigermoeller.serialization.util.FSTUtil;
import sun.misc.Unsafe;

public class MallocBytez
implements Bytez {
    static Unsafe unsafe = FSTUtil.getUnsafe();
    static long byteoff = FSTUtil.bufoff;
    static long caoff = FSTUtil.choff;
    static long saoff = FSTUtil.choff;
    static long iaoff = FSTUtil.intoff;
    static long laoff = FSTUtil.longoff;
    static long daoff = FSTUtil.doubleoff;
    static long faoff = FSTUtil.floatoff;
    long baseAdress;
    long length;

    public MallocBytez(long adr, long size) {
        this.baseAdress = adr;
        this.length = size;
    }

    public byte get(long byteIndex) {
        return unsafe.getByte(this.baseAdress + byteIndex);
    }

    public boolean getBool(long byteIndex) {
        return unsafe.getByte(this.baseAdress + byteIndex) != 0;
    }

    public char getChar(long byteIndex) {
        return unsafe.getChar(this.baseAdress + byteIndex);
    }

    public short getShort(long byteIndex) {
        return unsafe.getShort(this.baseAdress + byteIndex);
    }

    public int getInt(long byteIndex) {
        int res = unsafe.getInt(this.baseAdress + byteIndex);
        return res;
    }

    public long getLong(long byteIndex) {
        return unsafe.getLong(this.baseAdress + byteIndex);
    }

    public float getFloat(long byteIndex) {
        return unsafe.getFloat(this.baseAdress + byteIndex);
    }

    public double getDouble(long byteIndex) {
        return unsafe.getDouble(this.baseAdress + byteIndex);
    }

    public void put(long byteIndex, byte value) {
        unsafe.putByte(this.baseAdress + byteIndex, value);
    }

    public void putBool(long byteIndex, boolean val) {
        this.put(byteIndex, (byte)(val ? 1 : 0));
    }

    public void putChar(long byteIndex, char c) {
        unsafe.putChar(this.baseAdress + byteIndex, c);
    }

    public void putShort(long byteIndex, short s) {
        unsafe.putShort(this.baseAdress + byteIndex, s);
    }

    public void putInt(long byteIndex, int i) {
        unsafe.putInt(this.baseAdress + byteIndex, i);
    }

    public void putLong(long byteIndex, long l) {
        unsafe.putLong(this.baseAdress + byteIndex, l);
    }

    public void putFloat(long byteIndex, float f) {
        unsafe.putFloat(this.baseAdress + byteIndex, f);
    }

    public void putDouble(long byteIndex, double d) {
        unsafe.putDouble(this.baseAdress + byteIndex, d);
    }

    public long length() {
        return this.length;
    }

    public void getArr(long byteIndex, byte[] target, int elemoff, int numElems) {
        unsafe.copyMemory(null, this.baseAdress + byteIndex, target, byteoff + (long)elemoff, numElems);
    }

    public void getCharArr(long byteIndex, char[] target, int elemoff, int numElems) {
        unsafe.copyMemory(null, this.baseAdress + byteIndex, target, caoff + (long)(elemoff * 2), numElems * 2);
    }

    public void getShortArr(long byteIndex, short[] target, int elemoff, int numElems) {
        unsafe.copyMemory(null, this.baseAdress + byteIndex, target, saoff + (long)(elemoff * 2), numElems * 2);
    }

    public void getIntArr(long byteIndex, int[] target, int elemoff, int numElems) {
        unsafe.copyMemory(null, this.baseAdress + byteIndex, target, iaoff + (long)(elemoff * 4), numElems * 4);
    }

    public void getLongArr(long byteIndex, long[] target, int elemoff, int numElems) {
        unsafe.copyMemory(null, this.baseAdress + byteIndex, target, laoff + (long)(elemoff * 8), numElems * 8);
    }

    public void getFloatArr(long byteIndex, float[] target, int elemoff, int numElems) {
        unsafe.copyMemory(null, this.baseAdress + byteIndex, target, faoff + (long)(elemoff * 4), numElems * 4);
    }

    public void getDoubleArr(long byteIndex, double[] target, int elemoff, int numElems) {
        unsafe.copyMemory(null, this.baseAdress + byteIndex, target, daoff + (long)(elemoff * 8), numElems * 8);
    }

    public void set(long byteIndex, byte[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, byteoff + (long)elemoff, null, this.baseAdress + byteIndex, numElems);
    }

    public void setChar(long byteIndex, char[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, caoff + (long)(elemoff * 2), null, this.baseAdress + byteIndex, numElems * 2);
    }

    public void setShort(long byteIndex, short[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, caoff + (long)(elemoff * 2), null, this.baseAdress + byteIndex, numElems * 2);
    }

    public void setInt(long byteIndex, int[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, iaoff + (long)(elemoff * 4), null, this.baseAdress + byteIndex, numElems * 4);
    }

    public void setLong(long byteIndex, long[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, laoff + (long)(elemoff * 8), null, this.baseAdress + byteIndex, numElems * 8);
    }

    public void setFloat(long byteIndex, float[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, faoff + (long)(elemoff * 4), null, this.baseAdress + byteIndex, numElems * 4);
    }

    public void setDouble(long byteIndex, double[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, daoff + (long)(elemoff * 8), null, this.baseAdress + byteIndex, numElems * 8);
    }

    public void setBoolean(int byteIndex, boolean[] o, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            this.put(byteIndex + i, (byte)(o[i + elemoff] ? 1 : 0));
        }
    }

    public void copyTo(Bytez other, long otherByteIndex, long myByteIndex, long lenBytes) {
        if (other instanceof HeapBytez) {
            HeapBytez hp = (HeapBytez)other;
            unsafe.copyMemory(null, this.baseAdress + myByteIndex, hp.getBase(), hp.getOff() + otherByteIndex, lenBytes);
        } else {
            for (long i = 0L; i < lenBytes; ++i) {
                other.put(otherByteIndex + i, this.get(myByteIndex + i));
            }
        }
    }

    public Bytez newInstance(long size) {
        return new MallocBytez(unsafe.allocateMemory(size), size);
    }

    public boolean compareAndSwapInt(long offset, int expect, int newVal) {
        return unsafe.compareAndSwapInt(null, this.baseAdress + offset, expect, newVal);
    }

    public boolean compareAndSwapLong(long offset, long expect, long newVal) {
        return unsafe.compareAndSwapLong(null, this.baseAdress + offset, expect, newVal);
    }

    public byte[] toBytes(int startIndex, int len) {
        byte[] res = new byte[len];
        unsafe.copyMemory(null, this.baseAdress + (long)startIndex, res, FSTUtil.bufoff, len);
        return res;
    }

    public byte[] asByteArray() {
        throw new RuntimeException("malloc bytez do not support this");
    }

    public int getBAOffsetIndex() {
        throw new RuntimeException("malloc bytez do not support this");
    }

    public int getBALength() {
        throw new RuntimeException("malloc bytez do not support this");
    }

    public int hashCode() {
        return (int)(this.baseAdress ^ this.baseAdress >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MallocBytez) {
            return this.baseAdress == ((MallocBytez)obj).baseAdress && this.length == ((MallocBytez)obj).length;
        }
        return false;
    }

    public boolean getBoolVolatile(long byteIndex) {
        return this.getVolatile(byteIndex) != 0;
    }

    public byte getVolatile(long byteIndex) {
        return unsafe.getByteVolatile(null, this.baseAdress + byteIndex);
    }

    public char getCharVolatile(long byteIndex) {
        return unsafe.getCharVolatile(null, this.baseAdress + byteIndex);
    }

    public short getShortVolatile(long byteIndex) {
        return unsafe.getShortVolatile(null, this.baseAdress + byteIndex);
    }

    public int getIntVolatile(long byteIndex) {
        return unsafe.getIntVolatile(null, this.baseAdress + byteIndex);
    }

    public long getLongVolatile(long byteIndex) {
        return unsafe.getLongVolatile(null, this.baseAdress + byteIndex);
    }

    public float getFloatVolatile(long byteIndex) {
        return unsafe.getFloatVolatile(null, this.baseAdress + byteIndex);
    }

    public double getDoubleVolatile(long byteIndex) {
        return unsafe.getDoubleVolatile(null, this.baseAdress + byteIndex);
    }

    public void putBoolVolatile(long byteIndex, boolean value) {
        this.putVolatile(byteIndex, (byte)(value ? 1 : 0));
    }

    public void putVolatile(long byteIndex, byte value) {
        unsafe.putByteVolatile(null, this.baseAdress + byteIndex, value);
    }

    public void putCharVolatile(long byteIndex, char c) {
        unsafe.putCharVolatile(null, this.baseAdress + byteIndex, c);
    }

    public void putShortVolatile(long byteIndex, short s) {
        unsafe.putShortVolatile(null, this.baseAdress + byteIndex, s);
    }

    public void putIntVolatile(long byteIndex, int i) {
        unsafe.putIntVolatile(null, this.baseAdress + byteIndex, i);
    }

    public void putLongVolatile(long byteIndex, long l) {
        unsafe.putLongVolatile(null, this.baseAdress + byteIndex, l);
    }

    public void putFloatVolatile(long byteIndex, float f) {
        unsafe.putFloatVolatile(null, this.baseAdress + byteIndex, f);
    }

    public void putDoubleVolatile(long byteIndex, double d) {
        unsafe.putDoubleVolatile(null, this.baseAdress + byteIndex, d);
    }

    void free() {
        unsafe.freeMemory(this.baseAdress);
        MallocBytezAllocator.alloced.addAndGet(-this.length);
    }

    public long getBaseAdress() {
        return this.baseAdress;
    }

    public long getLength() {
        return this.length;
    }
}

