/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization;

import de.ruedigermoeller.heapoff.structs.Align;
import de.ruedigermoeller.serialization.FSTClazzInfoRegistry;
import de.ruedigermoeller.serialization.FSTObjectSerializer;
import de.ruedigermoeller.serialization.FSTSerializerRegistry;
import de.ruedigermoeller.serialization.annotations.Compress;
import de.ruedigermoeller.serialization.annotations.Conditional;
import de.ruedigermoeller.serialization.annotations.EqualnessIsBinary;
import de.ruedigermoeller.serialization.annotations.EqualnessIsIdentity;
import de.ruedigermoeller.serialization.annotations.Flat;
import de.ruedigermoeller.serialization.annotations.OneOf;
import de.ruedigermoeller.serialization.annotations.Predict;
import de.ruedigermoeller.serialization.annotations.Serialize;
import de.ruedigermoeller.serialization.annotations.Thin;
import de.ruedigermoeller.serialization.annotations.Transient;
import de.ruedigermoeller.serialization.util.FSTUtil;
import java.io.Externalizable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FSTClazzInfo {
    public static final Comparator<FSTFieldInfo> defFieldComparator = new Comparator<FSTFieldInfo>(){

        @Override
        public int compare(FSTFieldInfo o1, FSTFieldInfo o2) {
            int res = 0;
            if (o1.getType() == Boolean.TYPE && o2.getType() != Boolean.TYPE) {
                return -1;
            }
            if (o1.getType() != Boolean.TYPE && o2.getType() == Boolean.TYPE) {
                return 1;
            }
            if (o1.isConditional() && !o2.isConditional()) {
                res = 1;
            } else if (!o1.isConditional() && o2.isConditional()) {
                res = -1;
            } else if (o1.isPrimitive() && !o2.isPrimitive()) {
                res = -1;
            } else if (!o1.isPrimitive() && o2.isPrimitive()) {
                res = 1;
            }
            if (res == 0) {
                res = o1.getType().getSimpleName().compareTo(o2.getType().getSimpleName());
            }
            if (res == 0) {
                res = o1.getField().getName().compareTo(o2.getField().getName());
            }
            if (res == 0) {
                return o1.getField().getDeclaringClass().getName().compareTo(o2.getField().getDeclaringClass().getName());
            }
            return res;
        }
    };
    Class[] predict;
    private boolean ignoreAnn;
    HashMap<String, FSTFieldInfo> fieldMap = new HashMap(15);
    Method writeReplaceMethod;
    Method readResolveMethod;
    HashMap<Class, FSTCompatibilityInfo> compInfo = new HashMap(7);
    boolean requiresCompatibleMode;
    boolean equalIsIdentity;
    boolean equalIsBinary;
    boolean externalizable;
    boolean flat;
    FSTObjectSerializer ser;
    FSTFieldInfo[] fieldInfo;
    Class clazz;
    Constructor cons;
    int structSize = 0;
    FSTClazzInfoRegistry reg;

    public FSTClazzInfo(Class clazz, FSTClazzInfoRegistry infoRegistry, boolean ignoreAnnotations) {
        this.clazz = clazz;
        this.reg = infoRegistry;
        this.ignoreAnn = ignoreAnnotations;
        this.createFields(clazz);
        if (!this.reg.isStructMode()) {
            if (Externalizable.class.isAssignableFrom(clazz)) {
                this.externalizable = true;
                this.cons = FSTUtil.findConstructorForExternalize(clazz);
            } else {
                this.externalizable = false;
                this.cons = FSTUtil.findConstructorForSerializable(clazz);
            }
            if (!ignoreAnnotations) {
                Predict annotation = clazz.getAnnotation(Predict.class);
                if (annotation != null) {
                    this.predict = annotation.value();
                }
                this.equalIsIdentity = clazz.isAnnotationPresent(EqualnessIsIdentity.class);
                this.equalIsBinary = clazz.isAnnotationPresent(EqualnessIsBinary.class);
                this.flat = clazz.isAnnotationPresent(Flat.class);
            }
        }
        if (this.cons != null) {
            this.cons.setAccessible(true);
        }
    }

    public int getNumBoolFields() {
        FSTFieldInfo[] fis = this.getFieldInfo();
        for (int i = 0; i < fis.length; ++i) {
            FSTFieldInfo fstFieldInfo = fis[i];
            if (fstFieldInfo.getType() == Boolean.TYPE) continue;
            return i;
        }
        return fis.length;
    }

    public boolean isExternalizable() {
        return this.externalizable;
    }

    public final boolean isEqualIsBinary() {
        return this.equalIsBinary;
    }

    public final boolean isEqualIsIdentity() {
        return this.equalIsIdentity;
    }

    public final boolean isFlat() {
        return this.flat;
    }

    public final Class[] getPredict() {
        return this.predict;
    }

    public final Object newInstance() {
        try {
            if (FSTUtil.unsafe != null) {
                return FSTUtil.unsafe.allocateInstance(this.clazz);
            }
            return this.cons.newInstance(new Object[0]);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public final List<Field> getAllFields(Class c, List<Field> res) {
        Field field;
        int i;
        if (res == null) {
            res = new ArrayList<Field>();
        }
        if (c == null) {
            return res;
        }
        List<Field> c1 = Arrays.asList(c.getDeclaredFields());
        Collections.reverse(c1);
        for (i = 0; i < c1.size(); ++i) {
            field = c1.get(i);
            res.add(0, field);
        }
        for (i = 0; i < res.size(); ++i) {
            field = res.get(i);
            if (!Modifier.isStatic(field.getModifiers()) && !this.isTransient(c, field)) continue;
            res.remove(i);
            --i;
        }
        return this.getAllFields(c.getSuperclass(), res);
    }

    private boolean isTransient(Class c, Field field) {
        if (Modifier.isTransient(field.getModifiers())) {
            return true;
        }
        while (c.getName().indexOf("$") >= 0) {
            c = c.getSuperclass();
        }
        return c.getAnnotation(Transient.class) != null && field.getAnnotation(Serialize.class) == null;
    }

    public final FSTFieldInfo[] getFieldInfo() {
        return this.fieldInfo;
    }

    public final FSTFieldInfo[] getFieldInfoFiltered(Class ... toRemove) {
        FSTFieldInfo[] fis = this.getFieldInfo();
        int count = 0;
        for (int i = 0; i < fis.length; ++i) {
            FSTFieldInfo fi = fis[i];
            boolean skip = false;
            for (int j = 0; j < toRemove.length; ++j) {
                Class aClass = toRemove[j];
                if (fi.getField().getDeclaringClass() != aClass) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            ++count;
        }
        FSTFieldInfo[] res = new FSTFieldInfo[count];
        count = 0;
        for (int i = 0; i < fis.length; ++i) {
            FSTFieldInfo fi = fis[i];
            boolean skip = false;
            for (int j = 0; j < toRemove.length; ++j) {
                Class aClass = toRemove[j];
                if (fi.getField().getDeclaringClass() != aClass) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            res[count++] = fis[i];
        }
        return res;
    }

    public final FSTFieldInfo getFieldInfo(String name, Class declaringClass) {
        if (declaringClass == null) {
            return this.fieldMap.get(name);
        }
        return this.fieldMap.get(declaringClass.getName() + "#" + name);
    }

    private void createFields(Class c) {
        if (c.isInterface() || c.isPrimitive()) {
            return;
        }
        List<Field> fields = this.getAllFields(c, null);
        this.fieldInfo = new FSTFieldInfo[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            this.fieldInfo[i] = this.createFieldInfo(field);
            this.fieldMap.put(field.getDeclaringClass().getName() + "#" + field.getName(), this.fieldInfo[i]);
            this.fieldMap.put(field.getName(), this.fieldInfo[i]);
        }
        Comparator<FSTFieldInfo> infocomp = new Comparator<FSTFieldInfo>(){

            @Override
            public int compare(FSTFieldInfo o1, FSTFieldInfo o2) {
                int res = 0;
                res = o1.getType().getSimpleName().compareTo(o2.getType().getSimpleName());
                if (res == 0) {
                    res = o1.getType().getName().compareTo(o2.getType().getName());
                }
                if (res == 0) {
                    Class<?> declaringClass = o1.getType().getDeclaringClass();
                    Class<?> declaringClass1 = o2.getType().getDeclaringClass();
                    if (declaringClass == null && declaringClass1 == null) {
                        return 0;
                    }
                    if (declaringClass != null && declaringClass1 == null) {
                        return 1;
                    }
                    if (declaringClass == null && declaringClass1 != null) {
                        return -1;
                    }
                    if (res == 0) {
                        return declaringClass.getName().compareTo(declaringClass1.getName());
                    }
                }
                return res;
            }
        };
        if (!this.reg.isStructMode()) {
            fields.clear();
            for (Class curCl = c; curCl != Object.class; curCl = curCl.getSuperclass()) {
                ObjectStreamClass os = null;
                try {
                    os = ObjectStreamClass.lookup(curCl);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (os == null) continue;
                ObjectStreamField[] fi = os.getFields();
                ArrayList<FSTFieldInfo> curClzFields = new ArrayList<FSTFieldInfo>();
                if (fi != null) {
                    for (int i = 0; i < fi.length; ++i) {
                        ObjectStreamField objectStreamField = fi[i];
                        String ff = objectStreamField.getName();
                        FSTFieldInfo fstFieldInfo = this.fieldMap.get(curCl.getName() + "#" + ff);
                        if (fstFieldInfo == null || fstFieldInfo.getField() == null) continue;
                        curClzFields.add(fstFieldInfo);
                        fields.add(fstFieldInfo.getField());
                    }
                }
                Collections.sort(curClzFields, infocomp);
                FSTCompatibilityInfo info = new FSTCompatibilityInfo(curClzFields, curCl);
                this.compInfo.put(curCl, info);
                if (!info.needsCompatibleMode()) continue;
                this.requiresCompatibleMode = true;
            }
        }
        Comparator<FSTFieldInfo> comp = defFieldComparator;
        if (!this.reg.isStructMode()) {
            Arrays.sort(this.fieldInfo, comp);
        }
        int off = 8;
        for (int i = 0; i < this.fieldInfo.length; ++i) {
            FSTFieldInfo fstFieldInfo = this.fieldInfo[i];
            Align al = fstFieldInfo.getField().getAnnotation(Align.class);
            if (al != null) {
                fstFieldInfo.align = al.value();
                int alignOff = fstFieldInfo.align(off);
                fstFieldInfo.alignPad = alignOff - off;
                off = alignOff;
            }
            fstFieldInfo.setStructOffset(off);
            off += fstFieldInfo.getStructSize();
        }
        this.structSize = off;
        this.writeReplaceMethod = FSTUtil.findDerivedMethod(c, "writeReplace", null, Object.class);
        this.readResolveMethod = FSTUtil.findDerivedMethod(c, "readResolve", null, Object.class);
        if (this.writeReplaceMethod != null) {
            this.writeReplaceMethod.setAccessible(true);
        }
        if (this.readResolveMethod != null) {
            this.readResolveMethod.setAccessible(true);
        }
    }

    public int getStructSize() {
        return this.structSize;
    }

    public boolean useCompatibleMode() {
        return this.requiresCompatibleMode || this.writeReplaceMethod != null || this.readResolveMethod != null;
    }

    private FSTFieldInfo createFieldInfo(Field field) {
        field.setAccessible(true);
        Predict predict = field.getAnnotation(Predict.class);
        return new FSTFieldInfo(predict != null ? predict.value() : null, field, this.ignoreAnn);
    }

    public final Method getReadResolveMethod() {
        return this.readResolveMethod;
    }

    public final Method getWriteReplaceMethod() {
        return this.writeReplaceMethod;
    }

    public final Class getClazz() {
        return this.clazz;
    }

    public FSTObjectSerializer getSer() {
        if (this.ser == null) {
            if (this.clazz == null) {
                return null;
            }
            this.ser = this.reg.serializerRegistry.getSerializer(this.clazz);
            if (this.ser == null) {
                this.ser = FSTSerializerRegistry.NULL;
            }
        }
        if (this.ser == FSTSerializerRegistry.NULL) {
            return null;
        }
        return this.ser;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FSTCompatibilityInfo {
        Method writeMethod;
        Method readMethod;
        ObjectStreamClass objectStreamClass;
        List<FSTFieldInfo> infos;
        Class clazz;
        FSTFieldInfo[] infoArr;

        public FSTCompatibilityInfo(List<FSTFieldInfo> inf, Class c) {
            this.readClazz(c);
            this.infos = inf;
            this.clazz = c;
        }

        public List<FSTFieldInfo> getFields() {
            return this.infos;
        }

        public FSTFieldInfo[] getFieldArray() {
            if (this.infoArr == null) {
                List<FSTFieldInfo> fields = this.getFields();
                FSTFieldInfo[] fstFieldInfos = new FSTFieldInfo[fields.size()];
                fields.toArray(fstFieldInfos);
                Arrays.sort(fstFieldInfos, defFieldComparator);
                this.infoArr = fstFieldInfos;
            }
            return this.infoArr;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public boolean needsCompatibleMode() {
            return this.writeMethod != null || this.readMethod != null;
        }

        public void readClazz(Class c) {
            this.writeMethod = FSTUtil.findPrivateMethod(c, "writeObject", new Class[]{ObjectOutputStream.class}, Void.TYPE);
            this.readMethod = FSTUtil.findPrivateMethod(c, "readObject", new Class[]{ObjectInputStream.class}, Void.TYPE);
            if (this.writeMethod != null) {
                this.writeMethod.setAccessible(true);
            }
            if (this.readMethod != null) {
                this.readMethod.setAccessible(true);
            }
        }

        public Method getReadMethod() {
            return this.readMethod;
        }

        public void setReadMethod(Method readMethod) {
            this.readMethod = readMethod;
        }

        public Method getWriteMethod() {
            return this.writeMethod;
        }

        public void setWriteMethod(Method writeMethod) {
            this.writeMethod = writeMethod;
        }

        public boolean isAsymmetric() {
            return this.getReadMethod() == null && this.getWriteMethod() != null || this.getWriteMethod() == null && this.getReadMethod() != null;
        }
    }

    public static final class FSTFieldInfo {
        public static final int BOOL = 1;
        public static final int BYTE = 2;
        public static final int CHAR = 3;
        public static final int SHORT = 4;
        public static final int INT = 5;
        public static final int LONG = 6;
        public static final int FLOAT = 7;
        public static final int DOUBLE = 8;
        Class[] possibleClasses;
        FSTClazzInfo lastInfo;
        String[] oneOf = null;
        int arrayDim;
        Class arrayType;
        boolean flat = false;
        boolean thin = false;
        boolean isCompressed = false;
        boolean isConditional = false;
        final Field field;
        Class type;
        boolean integral = false;
        boolean primitive = false;
        boolean isArr = false;
        int integralType;
        long memOffset = -1L;
        int structOffset = 0;
        int align = 0;
        int alignPad = 0;

        public FSTFieldInfo(Class[] possibleClasses, Field fi, boolean ignoreAnnotations) {
            this.possibleClasses = possibleClasses;
            this.field = fi;
            if (fi == null) {
                this.isArr = false;
            } else {
                this.isArr = this.field.getType().isArray();
                this.type = fi.getType();
                this.primitive = this.type.isPrimitive();
                if (FSTUtil.unFlaggedUnsafe != null) {
                    fi.setAccessible(true);
                    if (!Modifier.isStatic(fi.getModifiers())) {
                        try {
                            this.memOffset = (int)FSTUtil.unFlaggedUnsafe.objectFieldOffset(fi);
                        }
                        catch (Throwable th) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.isArray()) {
                String clName = this.field.getType().getName();
                this.arrayDim = 1 + clName.lastIndexOf(91);
                this.arrayType = this.calcComponentType(this.field.getType());
            }
            this.calcIntegral();
            if (fi != null && !ignoreAnnotations) {
                OneOf annotation;
                this.flat = fi.isAnnotationPresent(Flat.class);
                this.thin = fi.isAnnotationPresent(Thin.class);
                this.isConditional = fi.isAnnotationPresent(Conditional.class);
                this.isCompressed = fi.isAnnotationPresent(Compress.class);
                if (this.isIntegral()) {
                    this.isConditional = false;
                }
                if ((annotation = fi.getAnnotation(OneOf.class)) != null) {
                    this.oneOf = annotation.value();
                }
            }
        }

        public int align(int off) {
            while (off / this.align * this.align != off) {
                ++off;
            }
            return off;
        }

        public int getStructOffset() {
            return this.structOffset;
        }

        public void setStructOffset(int structOffset) {
            this.structOffset = structOffset;
        }

        public String[] getOneOf() {
            return this.oneOf;
        }

        public long getMemOffset() {
            return this.memOffset;
        }

        public boolean isCompressed() {
            return this.isCompressed;
        }

        public int getAlign() {
            return this.align;
        }

        public int getAlignPad() {
            return this.alignPad;
        }

        public boolean isConditional() {
            return this.isConditional;
        }

        public FSTClazzInfo getLastInfo() {
            return this.lastInfo;
        }

        public void setLastInfo(FSTClazzInfo lastInfo) {
            this.lastInfo = lastInfo;
        }

        Class calcComponentType(Class c) {
            if (c.isArray()) {
                return this.calcComponentType(c.getComponentType());
            }
            return c;
        }

        public boolean isVolatile() {
            return Modifier.isVolatile(this.getField().getModifiers());
        }

        public final Class getType() {
            return this.type;
        }

        public boolean isThin() {
            return this.thin;
        }

        public boolean isArray() {
            return this.isArr;
        }

        public int getArrayDepth() {
            return this.arrayDim;
        }

        public Class getArrayType() {
            return this.arrayType;
        }

        public Class[] getPossibleClasses() {
            return this.possibleClasses;
        }

        public void setPossibleClasses(Class[] possibleClasses) {
            this.possibleClasses = possibleClasses;
        }

        public Field getField() {
            return this.field;
        }

        public void calcIntegral() {
            if (this.field == null) {
                return;
            }
            if (this.isArray()) {
                this.integral = this.isIntegral(this.getArrayType());
            } else {
                this.integral = this.isIntegral(this.field.getType());
                Class<?> type = this.field.getType();
                if (type == Boolean.TYPE) {
                    this.integralType = 1;
                } else if (type == Byte.TYPE) {
                    this.integralType = 2;
                } else if (type == Character.TYPE) {
                    this.integralType = 3;
                } else if (type == Short.TYPE) {
                    this.integralType = 4;
                } else if (type == Integer.TYPE) {
                    this.integralType = 5;
                } else if (type == Long.TYPE) {
                    this.integralType = 6;
                } else if (type == Float.TYPE) {
                    this.integralType = 7;
                } else if (type == Double.TYPE) {
                    this.integralType = 8;
                }
            }
        }

        public int getIntegralType() {
            return this.integralType;
        }

        public boolean isIntegral(Class type) {
            return type.isPrimitive();
        }

        public boolean isIntegral() {
            return this.integral;
        }

        public String getDesc() {
            return this.field != null ? "<" + this.field.getName() + " of " + this.field.getDeclaringClass().getSimpleName() + ">" : "<undefined referencee>";
        }

        public String toString() {
            return this.getDesc();
        }

        public boolean isFlat() {
            return this.flat;
        }

        public int getComponentStructSize() {
            if (this.arrayType == Boolean.TYPE || this.arrayType == Byte.TYPE) {
                return 1;
            }
            if (this.arrayType == Character.TYPE || this.arrayType == Short.TYPE) {
                return 2;
            }
            if (this.arrayType == Integer.TYPE || this.arrayType == Float.TYPE) {
                return 4;
            }
            if (this.arrayType == Long.TYPE || this.arrayType == Double.TYPE) {
                return 8;
            }
            return 0;
        }

        public int getStructSize() {
            if (this.type == Boolean.TYPE || this.type == Byte.TYPE) {
                return 1;
            }
            if (this.type == Character.TYPE || this.type == Short.TYPE) {
                return 2;
            }
            if (this.type == Integer.TYPE || this.type == Float.TYPE) {
                return 4;
            }
            if (this.type == Long.TYPE || this.type == Double.TYPE) {
                return 8;
            }
            if (this.isArray()) {
                if (this.isIntegral()) {
                    return 8;
                }
                return 16;
            }
            return 4;
        }

        public boolean isPrimitive() {
            return this.primitive;
        }

        public final int getByteValue(Object obj) throws IllegalAccessException {
            if (this.memOffset >= 0L && FSTUtil.unsafe != null) {
                return FSTUtil.unsafe.getByte(obj, this.memOffset);
            }
            return this.field.getByte(obj);
        }

        public final int getCharValue(Object obj) throws IllegalAccessException {
            if (this.memOffset >= 0L && FSTUtil.unsafe != null) {
                return FSTUtil.unsafe.getChar(obj, this.memOffset);
            }
            return this.field.getChar(obj);
        }

        public final int getShortValue(Object obj) throws IllegalAccessException {
            if (this.memOffset >= 0L && FSTUtil.unsafe != null) {
                return FSTUtil.unsafe.getShort(obj, this.memOffset);
            }
            return this.field.getShort(obj);
        }

        public final int getIntValueUnsafe(Object obj) throws IllegalAccessException {
            return FSTUtil.unsafe.getInt(obj, this.memOffset);
        }

        public final long getLongValueUnsafe(Object obj) throws IllegalAccessException {
            return FSTUtil.unsafe.getLong(obj, this.memOffset);
        }

        public final boolean getBooleanValue(Object obj) throws IllegalAccessException {
            if (FSTUtil.unsafe != null && this.memOffset >= 0L) {
                return FSTUtil.unsafe.getBoolean(obj, this.memOffset);
            }
            return this.field.getBoolean(obj);
        }

        public final Object getObjectValueUnsafe(Object obj) throws IllegalAccessException {
            return FSTUtil.unsafe.getObject(obj, this.memOffset);
        }

        public final Object getObjectValue(Object obj) throws IllegalAccessException {
            return this.field.get(obj);
        }

        public final float getFloatValue(Object obj) throws IllegalAccessException {
            if (FSTUtil.unsafe != null && this.memOffset >= 0L) {
                return FSTUtil.unsafe.getFloat(obj, this.memOffset);
            }
            return this.field.getFloat(obj);
        }

        public final double getDoubleValueUnsafe(Object obj) throws IllegalAccessException {
            return FSTUtil.unsafe.getDouble(obj, this.memOffset);
        }

        public final void setCharValue(Object newObj, char c) throws IllegalAccessException {
            if (FSTUtil.unsafe != null && this.memOffset >= 0L) {
                FSTUtil.unsafe.putChar(newObj, this.memOffset, c);
                return;
            }
            this.field.setChar(newObj, c);
        }

        public final void setShortValue(Object newObj, short i1) throws IllegalAccessException {
            if (FSTUtil.unsafe != null && this.memOffset >= 0L) {
                FSTUtil.unsafe.putShort(newObj, this.memOffset, i1);
                return;
            }
            this.field.setShort(newObj, i1);
        }

        public final void setObjectValueUnsafe(Object newObj, Object i1) throws IllegalAccessException {
            FSTUtil.unsafe.putObject(newObj, this.memOffset, i1);
        }

        public final void setObjectValue(Object newObj, Object i1) throws IllegalAccessException {
            this.field.set(newObj, i1);
        }

        public final void setFloatValue(Object newObj, float l) throws IllegalAccessException {
            if (FSTUtil.unsafe != null && this.memOffset >= 0L) {
                FSTUtil.unsafe.putFloat(newObj, this.memOffset, l);
                return;
            }
            this.field.setFloat(newObj, l);
        }

        public final void setDoubleValueUnsafe(Object newObj, double l) throws IllegalAccessException {
            FSTUtil.unsafe.putDouble(newObj, this.memOffset, l);
        }

        public final void setDoubleValue(Object newObj, double l) throws IllegalAccessException {
            this.field.setDouble(newObj, l);
        }

        public final void setIntValueUnsafe(Object newObj, int i1) throws IllegalAccessException {
            FSTUtil.unsafe.putInt(newObj, this.memOffset, i1);
        }

        public final void setLongValueUnsafe(Object newObj, long i1) throws IllegalAccessException {
            FSTUtil.unsafe.putLong(newObj, this.memOffset, i1);
        }

        public final void setLongValue(Object newObj, long i1) throws IllegalAccessException {
            this.field.setLong(newObj, i1);
        }

        public final long getLongValue(Object obj) throws IllegalAccessException {
            return this.field.getLong(obj);
        }

        public final double getDoubleValue(Object obj) throws IllegalAccessException {
            return this.field.getDouble(obj);
        }

        public final void setIntValue(Object newObj, int i1) throws IllegalAccessException {
            this.field.setInt(newObj, i1);
        }

        public final int getIntValue(Object obj) throws IllegalAccessException {
            return this.field.getInt(obj);
        }

        public final void setBooleanValue(Object newObj, boolean i1) throws IllegalAccessException {
            if (FSTUtil.unsafe != null && this.memOffset >= 0L) {
                FSTUtil.unsafe.putBoolean(newObj, this.memOffset, i1);
                return;
            }
            this.field.setBoolean(newObj, i1);
        }

        public final void setByteValue(Object newObj, byte b) throws IllegalAccessException {
            if (FSTUtil.unsafe != null && this.memOffset >= 0L) {
                FSTUtil.unsafe.putByte(newObj, this.memOffset, b);
                return;
            }
            this.field.setByte(newObj, b);
        }
    }
}

