/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.heapoff;

import de.ruedigermoeller.serialization.FSTBasicObjectSerializer;
import de.ruedigermoeller.serialization.FSTClazzInfo;
import de.ruedigermoeller.serialization.FSTConfiguration;
import de.ruedigermoeller.serialization.FSTObjectInput;
import de.ruedigermoeller.serialization.FSTObjectOutput;
import de.ruedigermoeller.serialization.annotations.Conditional;
import de.ruedigermoeller.serialization.annotations.Flat;
import de.ruedigermoeller.serialization.annotations.Predict;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class FSTByteBufferOffheap {
    static String DUMMY = "FSTDUMMY";
    public static final int HEADER_SIZE = 8;
    String lock = "Lock";
    ByteBuffer buffer;
    FSTConfiguration conf = null;
    int lastPosition = 0;
    int currPosition = 8;
    FSTObjectInput.ConditionalCallback alwaysSkip = new FSTObjectInput.ConditionalCallback(){

        @Override
        public boolean shouldSkip(Object halfDecoded, int streamPosition, Field field) {
            return true;
        }
    };

    public FSTByteBufferOffheap(int sizeMB) throws IOException {
        this(sizeMB, null);
    }

    public FSTByteBufferOffheap(int sizeMB, FSTConfiguration conf) throws IOException {
        this(ByteBuffer.allocateDirect(sizeMB * 1000 * 1000), conf);
    }

    public FSTByteBufferOffheap(ByteBuffer buffer) throws IOException {
        this(buffer, null);
    }

    public FSTByteBufferOffheap(ByteBuffer buffer, FSTConfiguration conf) throws IOException {
        this.buffer = buffer;
        if (conf == null) {
            conf = FSTConfiguration.createDefaultConfiguration();
            conf.setPreferSpeed(true);
        }
        this.conf = conf;
        conf.registerSerializer(ByteBufferEntry.class, new FSTBasicObjectSerializer(){

            @Override
            public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
                out.defaultWriteObject(toWrite, clzInfo);
            }

            @Override
            public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPositioin) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
                MyFSTInput inp = (MyFSTInput)in;
                ByteBufferEntry entry = inp.getAccess().currentEntry;
                entry.content = null;
                in.defaultReadObject(referencee, serializationInfo, entry);
                return entry;
            }
        }, false);
    }

    public FSTConfiguration getConf() {
        return this.conf;
    }

    public OffHeapAccess createAccess() {
        return new OffHeapAccess();
    }

    public int getLastPosition() {
        return this.lastPosition;
    }

    public int getSize() {
        return this.currPosition;
    }

    public OffHeapIterator iterator() {
        return new OffHeapIterator(this.lastPosition);
    }

    @Predict(value={ByteBufferEntry.class})
    @Flat
    public static class ByteBufferEntry
    implements Serializable {
        transient int length;
        transient int prevPosition;
        @Conditional
        public Object content;
        @Flat
        public Object tag;
    }

    public class OffHeapIterator
    extends OffHeapAccess
    implements Iterator {
        int position;
        int currentPosition;

        OffHeapIterator(int position) {
            this.position = position;
        }

        @Override
        public boolean hasNext() {
            return this.position > 0;
        }

        public Object getCurrentTag() {
            return this.currentEntry.tag;
        }

        public Object getCurrentEntry() {
            return this.currentEntry.content;
        }

        public int getCurrentPositiion() {
            return this.currentPosition;
        }

        public Object nextEntry(FSTObjectInput.ConditionalCallback callback) {
            try {
                this.in.setConditionalCallback(callback);
                this.currentEntry = this.getEntry(this.position);
                this.currentPosition = this.position;
                this.position = this.currentEntry.prevPosition;
                return this.currentEntry.tag;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Object next() {
            try {
                this.in.setConditionalCallback(FSTByteBufferOffheap.this.alwaysSkip);
                this.currentEntry = this.getEntry(this.position);
                this.position = this.currentEntry.prevPosition;
                return this.currentEntry.tag;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new RuntimeException("not implemented");
        }
    }

    public class OffHeapAccess {
        protected ByteBufferEntry currentEntry = new ByteBufferEntry();
        protected FSTObjectInput in;
        protected FSTObjectOutput out;
        byte[] tmpBuf;

        public OffHeapAccess() {
            try {
                this.in = new MyFSTInput(this, FSTByteBufferOffheap.this.conf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        byte[] getTmpBuf(int siz) {
            if (this.tmpBuf == null || this.tmpBuf.length < siz) {
                this.tmpBuf = new byte[siz];
            }
            return this.tmpBuf;
        }

        public void getObjectBuffer(int handle, GetObjectBufferResult res) {
            res.len = FSTByteBufferOffheap.this.buffer.getInt(handle);
            FSTByteBufferOffheap.this.buffer.position(handle + 8);
            res.buff = FSTByteBufferOffheap.this.buffer;
            res.lock = FSTByteBufferOffheap.this.lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteBufferEntry getEntry(int handle) throws Exception {
            this.currentEntry.length = FSTByteBufferOffheap.this.buffer.getInt(handle);
            this.currentEntry.prevPosition = FSTByteBufferOffheap.this.buffer.getInt(handle + 4);
            byte[] buf = this.getTmpBuf(this.currentEntry.length);
            String string = FSTByteBufferOffheap.this.lock;
            synchronized (string) {
                FSTByteBufferOffheap.this.buffer.position(handle + 8);
                FSTByteBufferOffheap.this.buffer.get(buf);
            }
            this.in.resetForReuseUseArray(buf, 0, this.currentEntry.length);
            return (ByteBufferEntry)this.in.readObject(ByteBufferEntry.class);
        }

        public Object getObject(int handle) throws Exception {
            this.in.setConditionalCallback(null);
            return this.getEntry((int)handle).content;
        }

        public Object getTag(int handle) throws Exception {
            this.in.setConditionalCallback(FSTByteBufferOffheap.this.alwaysSkip);
            return this.getEntry((int)handle).tag;
        }

        int prepareOut(Object toSave, Object tag) throws IOException {
            if (this.out == null) {
                this.out = new FSTObjectOutput(FSTByteBufferOffheap.this.conf);
            }
            this.currentEntry.tag = tag;
            this.currentEntry.content = toSave;
            this.out.resetForReUse(null);
            this.out.writeObject(this.currentEntry, this.currentEntry.getClass());
            return this.out.getWritten();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int add(Object toSave, Object tag) throws IOException {
            if (this.out == null) {
                this.out = new FSTObjectOutput(FSTByteBufferOffheap.this.conf);
            }
            this.prepareOut(toSave, tag);
            String string = FSTByteBufferOffheap.this.lock;
            synchronized (string) {
                int res = FSTByteBufferOffheap.this.currPosition;
                FSTByteBufferOffheap.this.buffer.putInt(res, this.out.getWritten());
                FSTByteBufferOffheap.this.buffer.putInt(res + 4, FSTByteBufferOffheap.this.lastPosition);
                FSTByteBufferOffheap.this.lastPosition = res;
                FSTByteBufferOffheap.this.buffer.position(FSTByteBufferOffheap.this.currPosition + 8);
                FSTByteBufferOffheap.this.buffer.put(this.out.getBuffer(), 0, this.out.getWritten());
                FSTByteBufferOffheap.this.currPosition = FSTByteBufferOffheap.this.buffer.position();
                return res;
            }
        }
    }

    public static class GetObjectBufferResult {
        int handle;
        int len;
        ByteBuffer buff;
        Object lock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteBuffer slice() {
            Object object = this.lock;
            synchronized (object) {
                this.buff.position(this.handle + 8);
                int prevLimit = this.buff.limit();
                this.buff.limit(this.handle + 8 + this.len);
                ByteBuffer slice = this.buff.slice();
                this.buff.limit(prevLimit);
                return slice;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void slice(byte[] toCopyTo, int offset) {
            Object object = this.lock;
            synchronized (object) {
                this.buff.position(this.handle + 8);
                this.buff.get(toCopyTo, offset, this.len);
            }
        }

        public int getPosition() {
            return this.handle + 8;
        }

        public int getLen() {
            return this.len;
        }
    }

    static class MyFSTInput
    extends FSTObjectInput {
        private final OffHeapAccess acc;

        public MyFSTInput(OffHeapAccess acc, FSTConfiguration conf) throws IOException {
            super(conf);
            this.acc = acc;
        }

        public OffHeapAccess getAccess() {
            return this.acc;
        }
    }
}

