/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization;

import de.ruedigermoeller.serialization.FSTClazzInfo;
import de.ruedigermoeller.serialization.FSTClazzInfoRegistry;
import de.ruedigermoeller.serialization.FSTClazzNameRegistry;
import de.ruedigermoeller.serialization.FSTObjectCopy;
import de.ruedigermoeller.serialization.FSTObjectInput;
import de.ruedigermoeller.serialization.FSTObjectOutput;
import de.ruedigermoeller.serialization.FSTObjectSerializer;
import de.ruedigermoeller.serialization.FSTSerializerRegistry;
import de.ruedigermoeller.serialization.FSTSerializerRegistryDelegate;
import de.ruedigermoeller.serialization.serializers.FSTBigNumberSerializers;
import de.ruedigermoeller.serialization.serializers.FSTClassSerializer;
import de.ruedigermoeller.serialization.serializers.FSTCollectionSerializer;
import de.ruedigermoeller.serialization.serializers.FSTDateSerializer;
import de.ruedigermoeller.serialization.serializers.FSTEnumSetSerializer;
import de.ruedigermoeller.serialization.serializers.FSTMapSerializer;
import de.ruedigermoeller.serialization.serializers.FSTStringBufferSerializer;
import de.ruedigermoeller.serialization.serializers.FSTStringBuilderSerializer;
import de.ruedigermoeller.serialization.serializers.FSTStringSerializer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public final class FSTConfiguration {
    FSTClazzInfoRegistry serializationInfoRegistry = new FSTClazzInfoRegistry();
    HashMap<Class, List<SoftReference>> cachedObjects = new HashMap(97);
    FSTClazzNameRegistry classRegistry = new FSTClazzNameRegistry(null, this);
    boolean preferSpeed = false;
    public static Integer[] intObjects;
    static AtomicBoolean lock;
    static FSTConfiguration singleton;
    FSTObjectCopy copier;
    boolean shareReferences;
    ThreadLocal<FSTObjectOutput> output;
    ThreadLocal<FSTObjectInput> input;

    public static Integer getInt(int i) {
        if (i >= 0 && i < intObjects.length) {
            return intObjects[i];
        }
        return new Integer(i);
    }

    public static FSTConfiguration getDefaultConfiguration() {
        while (!lock.compareAndSet(false, true)) {
        }
        if (singleton == null) {
            singleton = FSTConfiguration.createDefaultConfiguration();
        }
        lock.set(false);
        return singleton;
    }

    public static FSTConfiguration createDefaultConfiguration() {
        FSTConfiguration conf = new FSTConfiguration();
        conf.addDefaultClazzes();
        conf.copier = new FSTObjectCopy(){

            @Override
            public Object copy(Object toCopy, FSTConfiguration conf) throws IOException, ClassNotFoundException {
                if (toCopy instanceof java.util.Date) {
                    java.util.Date i = (java.util.Date)toCopy;
                    return new java.util.Date(i.getTime());
                }
                if (toCopy instanceof Rectangle) {
                    Rectangle i = (Rectangle)toCopy;
                    return new Rectangle(i.x, i.y, i.width, i.height);
                }
                if (toCopy instanceof Point) {
                    Point i = (Point)toCopy;
                    return new Point(i.x, i.y);
                }
                if (toCopy instanceof Dimension) {
                    Dimension i = (Dimension)toCopy;
                    return new Dimension(i.width, i.height);
                }
                return null;
            }
        };
        FSTSerializerRegistry reg = conf.serializationInfoRegistry.serializerRegistry;
        reg.putSerializer(Class.class, new FSTClassSerializer(), false);
        reg.putSerializer(String.class, new FSTStringSerializer(), false);
        reg.putSerializer(Byte.class, new FSTBigNumberSerializers.FSTByteSerializer(), false);
        reg.putSerializer(Character.class, new FSTBigNumberSerializers.FSTCharSerializer(), false);
        reg.putSerializer(Short.class, new FSTBigNumberSerializers.FSTShortSerializer(), false);
        reg.putSerializer(Float.class, new FSTBigNumberSerializers.FSTFloatSerializer(), false);
        reg.putSerializer(Double.class, new FSTBigNumberSerializers.FSTDoubleSerializer(), false);
        reg.putSerializer(java.util.Date.class, new FSTDateSerializer(), false);
        reg.putSerializer(StringBuffer.class, new FSTStringBufferSerializer(), true);
        reg.putSerializer(StringBuilder.class, new FSTStringBuilderSerializer(), true);
        reg.putSerializer(EnumSet.class, new FSTEnumSetSerializer(), true);
        reg.putSerializer(ArrayList.class, new FSTCollectionSerializer(), false);
        reg.putSerializer(Vector.class, new FSTCollectionSerializer(), false);
        reg.putSerializer(LinkedList.class, new FSTCollectionSerializer(), false);
        reg.putSerializer(HashSet.class, new FSTCollectionSerializer(), false);
        reg.putSerializer(HashMap.class, new FSTMapSerializer(), false);
        reg.putSerializer(Hashtable.class, new FSTMapSerializer(), false);
        reg.putSerializer(ConcurrentHashMap.class, new FSTMapSerializer(), false);
        return conf;
    }

    public void registerSerializer(Class clazz, FSTObjectSerializer ser, boolean alsoForAllSubclasses) {
        this.serializationInfoRegistry.serializerRegistry.putSerializer(clazz, ser, alsoForAllSubclasses);
    }

    public static FSTConfiguration createStructConfiguration() {
        FSTConfiguration conf = new FSTConfiguration();
        conf.setIgnoreSerialInterfaces(true);
        return conf;
    }

    private FSTConfiguration() {
        if (intObjects == null) {
            intObjects = new Integer[30000];
            for (int i = 0; i < intObjects.length; ++i) {
                FSTConfiguration.intObjects[i] = new Integer(i);
            }
        }
        this.copier = new FSTObjectCopy(){

            @Override
            public Object copy(Object toCopy, FSTConfiguration conf) throws IOException, ClassNotFoundException {
                return null;
            }
        };
        this.shareReferences = true;
        this.output = new ThreadLocal<FSTObjectOutput>(){

            @Override
            protected FSTObjectOutput initialValue() {
                return new FSTObjectOutput(FSTConfiguration.this);
            }
        };
        this.input = new ThreadLocal<FSTObjectInput>(){

            @Override
            protected FSTObjectInput initialValue() {
                try {
                    return new FSTObjectInput(FSTConfiguration.this);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object ... cachedObs) {
        HashMap<Class, List<SoftReference>> hashMap = this.cachedObjects;
        synchronized (hashMap) {
            for (int i = 0; i < cachedObs.length; ++i) {
                Object cached = cachedObs[i];
                List<SoftReference> li = this.cachedObjects.get(cached.getClass());
                if (li == null) {
                    li = new ArrayList<SoftReference>();
                    this.cachedObjects.put(cached.getClass(), li);
                }
                li.add(new SoftReference<Object>(cached));
            }
        }
    }

    public boolean isPreferSpeed() {
        return this.preferSpeed;
    }

    public void setPreferSpeed(boolean preferSpeed) {
        this.preferSpeed = preferSpeed;
    }

    public int calcObjectSizeBytesNotAUtility(Object obj) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        FSTObjectOutput ou = new FSTObjectOutput(bout, this);
        ou.writeObject(obj, obj.getClass());
        ou.close();
        return bout.toByteArray().length;
    }

    public void setSerializerRegistryDelegate(FSTSerializerRegistryDelegate del) {
        this.serializationInfoRegistry.setSerializerRegistryDelegate(del);
    }

    public int calcObjectWriteTimeNotAUtility(int iterations, Object obj) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        FSTObjectOutput ou = new FSTObjectOutput(bout, this);
        long tim = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            ou.writeObject(obj, obj.getClass());
            ou.getObjectMap().clearForWrite();
            bout.reset();
        }
        long dur = System.currentTimeMillis() - tim;
        return (int)(dur * 1000000L / (long)iterations);
    }

    public int calcObjectReadTimeNotAUtility(int iterations, Object obj) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        FSTObjectOutput ou = new FSTObjectOutput(bout, this);
        ou.writeObject(obj, obj.getClass());
        ou.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        FSTObjectInput in = new FSTObjectInput(bin, this);
        long tim = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            Object res = in.readObject(obj.getClass());
            bin.reset();
            in.input.reset();
            in.input.initFromStream(bin);
        }
        long dur = System.currentTimeMillis() - tim;
        return (int)(dur * 1000000L / (long)iterations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCachedObject(Class cl) {
        HashMap<Class, List<SoftReference>> hashMap = this.cachedObjects;
        synchronized (hashMap) {
            List<SoftReference> li = this.cachedObjects.get(cl);
            if (li == null) {
                return null;
            }
            for (int i = li.size() - 1; i >= 0; --i) {
                SoftReference softReference = li.get(i);
                Object res = softReference.get();
                li.remove(i);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    public FSTObjectCopy getCopier() {
        return this.copier;
    }

    public boolean isShareReferences() {
        return this.shareReferences;
    }

    public void setShareReferences(boolean shareReferences) {
        this.shareReferences = shareReferences;
    }

    public void registerClass(Class c) {
        this.classRegistry.registerClass(c);
    }

    void addDefaultClazzes() {
        this.classRegistry.registerClass(String.class);
        this.classRegistry.registerClass(Byte.class);
        this.classRegistry.registerClass(Short.class);
        this.classRegistry.registerClass(Integer.class);
        this.classRegistry.registerClass(Long.class);
        this.classRegistry.registerClass(Float.class);
        this.classRegistry.registerClass(Double.class);
        this.classRegistry.registerClass(BigDecimal.class);
        this.classRegistry.registerClass(BigInteger.class);
        this.classRegistry.registerClass(Character.class);
        this.classRegistry.registerClass(Boolean.class);
        this.classRegistry.registerClass(TreeMap.class);
        this.classRegistry.registerClass(HashMap.class);
        this.classRegistry.registerClass(ArrayList.class);
        this.classRegistry.registerClass(ConcurrentHashMap.class);
        this.classRegistry.registerClass(Color.class);
        this.classRegistry.registerClass(Dimension.class);
        this.classRegistry.registerClass(Point.class);
        this.classRegistry.registerClass(Rectangle.class);
        this.classRegistry.registerClass(Font.class);
        this.classRegistry.registerClass(URL.class);
        this.classRegistry.registerClass(java.util.Date.class);
        this.classRegistry.registerClass(Date.class);
        this.classRegistry.registerClass(SimpleDateFormat.class);
        this.classRegistry.registerClass(TreeSet.class);
        this.classRegistry.registerClass(LinkedList.class);
        this.classRegistry.registerClass(SimpleTimeZone.class);
        this.classRegistry.registerClass(GregorianCalendar.class);
        this.classRegistry.registerClass(Vector.class);
        this.classRegistry.registerClass(Hashtable.class);
        this.classRegistry.registerClass(BitSet.class);
        this.classRegistry.registerClass(Locale.class);
        this.classRegistry.registerClass(StringBuffer.class);
        this.classRegistry.registerClass(StringBuilder.class);
        this.classRegistry.registerClass(Object.class);
        this.classRegistry.registerClass(Object[].class);
        this.classRegistry.registerClass(Object[][].class);
        this.classRegistry.registerClass(Object[][][].class);
        this.classRegistry.registerClass(Object[][][][].class);
        this.classRegistry.registerClass(byte[].class);
        this.classRegistry.registerClass(byte[][].class);
        this.classRegistry.registerClass(byte[][][].class);
        this.classRegistry.registerClass(byte[][][][].class);
        this.classRegistry.registerClass(byte[][][][][].class);
        this.classRegistry.registerClass(char[].class);
        this.classRegistry.registerClass(char[][].class);
        this.classRegistry.registerClass(char[][][].class);
        this.classRegistry.registerClass(char[][][][].class);
        this.classRegistry.registerClass(char[][][][][].class);
        this.classRegistry.registerClass(char[][][][][][].class);
        this.classRegistry.registerClass(short[].class);
        this.classRegistry.registerClass(short[][].class);
        this.classRegistry.registerClass(short[][][].class);
        this.classRegistry.registerClass(short[][][][].class);
        this.classRegistry.registerClass(short[][][][][].class);
        this.classRegistry.registerClass(short[][][][][][].class);
        this.classRegistry.registerClass(short[][][][][][][].class);
        this.classRegistry.registerClass(short[][][][][][][][].class);
        this.classRegistry.registerClass(int[].class);
        this.classRegistry.registerClass(int[][].class);
        this.classRegistry.registerClass(int[][][].class);
        this.classRegistry.registerClass(int[][][][].class);
        this.classRegistry.registerClass(int[][][][][].class);
        this.classRegistry.registerClass(int[][][][][][].class);
        this.classRegistry.registerClass(int[][][][][][][].class);
        this.classRegistry.registerClass(int[][][][][][][][].class);
        this.classRegistry.registerClass(int[][][][][][][][][].class);
        this.classRegistry.registerClass(int[][][][][][][][][][].class);
        this.classRegistry.registerClass(float[].class);
        this.classRegistry.registerClass(float[][].class);
        this.classRegistry.registerClass(float[][][].class);
        this.classRegistry.registerClass(float[][][][].class);
        this.classRegistry.registerClass(float[][][][][].class);
        this.classRegistry.registerClass(float[][][][][][].class);
        this.classRegistry.registerClass(float[][][][][][][].class);
        this.classRegistry.registerClass(float[][][][][][][][].class);
        this.classRegistry.registerClass(float[][][][][][][][][].class);
        this.classRegistry.registerClass(double[].class);
        this.classRegistry.registerClass(double[][].class);
        this.classRegistry.registerClass(double[][][].class);
        this.classRegistry.registerClass(double[][][][].class);
        this.classRegistry.registerClass(double[][][][][].class);
        this.classRegistry.registerClass(double[][][][][][].class);
        this.classRegistry.registerClass(double[][][][][][][].class);
        this.classRegistry.addSingleSnippet("java.lang");
        this.classRegistry.addSingleSnippet("java.util");
        this.classRegistry.addSingleSnippet("java.awt");
        this.classRegistry.addSingleSnippet("javax.swing");
        this.classRegistry.addSingleSnippet("java.net");
        this.classRegistry.addSingleSnippet("java.sql");
        this.classRegistry.addSingleSnippet("org");
        this.classRegistry.addSingleSnippet("sun");
        this.classRegistry.addSingleSnippet("sunw");
        this.classRegistry.addSingleSnippet("com.oracle");
        this.classRegistry.addSingleSnippet("com.sun");
    }

    public FSTClazzNameRegistry getClassRegistry() {
        return this.classRegistry;
    }

    public FSTClazzInfoRegistry getCLInfoRegistry() {
        return this.serializationInfoRegistry;
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public FSTClazzInfo getClassInfo(Class type) {
        return this.serializationInfoRegistry.getCLInfo(type);
    }

    public FSTObjectInput getObjectInput(InputStream in) {
        FSTObjectInput fstObjectInput = this.input.get();
        try {
            fstObjectInput.resetForReuse(in);
            return fstObjectInput;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public FSTObjectInput getObjectInput(byte[] arr, int off, int len) {
        FSTObjectInput fstObjectInput = this.input.get();
        try {
            fstObjectInput.resetForReuseUseArray(arr, off, len);
            return fstObjectInput;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public FSTObjectOutput getObjectOutput(OutputStream out) {
        FSTObjectOutput fstObjectOutput = this.output.get();
        fstObjectOutput.resetForReUse(out);
        return fstObjectOutput;
    }

    public void setIgnoreSerialInterfaces(boolean ignoreSerialInterfaces) {
        this.serializationInfoRegistry.setStructMode(ignoreSerialInterfaces);
    }

    public boolean isIgnoreSerialInterfaces() {
        return this.serializationInfoRegistry.isStructMode();
    }

    static {
        lock = new AtomicBoolean(false);
    }
}

