/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization.util;

import de.ruedigermoeller.serialization.util.FSTUtil;
import java.util.HashMap;

public class FSTObject2IntMap<K> {
    static int[] prim = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 37, 67, 97, 139, 211, 331, 641, 1097, 1531, 2207, 3121, 5059, 7607, 10891, 15901, 19993, 30223, 50077, 74231, 99991, 150001, 300017, 1000033, 1500041, 200033, 3000077, 5000077, 10000019};
    private static final int GROFAC = 2;
    public Object[] mKeys;
    public int[] mValues;
    public int mNumberOfElements;
    FSTObject2IntMap<K> next;
    boolean checkClazzOnEquals = false;
    static int miss = 0;
    static int hit = 0;

    static int adjustSize(int size) {
        for (int i = 0; i < prim.length - 1; ++i) {
            if (size >= prim[i]) continue;
            return prim[i];
        }
        return size;
    }

    public FSTObject2IntMap(int initialSize, boolean checkClassOnequals) {
        if (initialSize < 2) {
            initialSize = 2;
        }
        initialSize = FSTObject2IntMap.adjustSize(initialSize * 2);
        this.mKeys = new Object[initialSize];
        this.mValues = new int[initialSize];
        this.mNumberOfElements = 0;
        this.checkClazzOnEquals = checkClassOnequals;
    }

    public int size() {
        return this.mNumberOfElements + (this.next != null ? this.next.size() : 0);
    }

    public final void put(K key, int value) {
        int hash = key.hashCode() & Integer.MAX_VALUE;
        this.putHash(key, value, hash, this);
    }

    final void putHash(K key, int value, int hash, FSTObject2IntMap<K> parent) {
        int idx;
        if (this.mNumberOfElements * 2 > this.mKeys.length) {
            if (parent != null) {
                if ((parent.mNumberOfElements + this.mNumberOfElements) * 2 > parent.mKeys.length) {
                    parent.resize(parent.mKeys.length * 2);
                    parent.put(key, value);
                    return;
                }
                this.resize(this.mKeys.length * 2);
            } else {
                this.resize(this.mKeys.length * 2);
            }
        }
        if (this.mKeys[idx = hash % this.mKeys.length] == null) {
            ++this.mNumberOfElements;
            this.mValues[idx] = value;
            this.mKeys[idx] = key;
        } else if (this.mKeys[idx].equals(key) && (!this.checkClazzOnEquals || this.mKeys[idx].getClass() == key.getClass())) {
            this.mValues[idx] = value;
        } else {
            this.putNext(hash, key, value);
        }
    }

    final K removeHash(K key, int hash) {
        int idx = hash % this.mKeys.length;
        Object mKey = this.mKeys[idx];
        if (mKey == null) {
            return null;
        }
        if (mKey.equals(key) && (!this.checkClazzOnEquals || this.mKeys[idx].getClass() == key.getClass())) {
            Object val = this.mKeys[idx];
            this.mValues[idx] = 0;
            this.mKeys[idx] = null;
            --this.mNumberOfElements;
            return (K)val;
        }
        if (this.next == null) {
            return null;
        }
        return this.next.removeHash(key, hash);
    }

    final void putNext(int hash, K key, int value) {
        if (this.next == null) {
            int newSiz = this.mNumberOfElements / 3;
            this.next = new FSTObject2IntMap<K>(newSiz, this.checkClazzOnEquals);
        }
        this.next.putHash(key, value, hash, this);
    }

    public final int get(K key) {
        int hash = key.hashCode() & Integer.MAX_VALUE;
        int idx = hash % this.mKeys.length;
        Object mapsKey = this.mKeys[idx];
        if (mapsKey == null) {
            return Integer.MIN_VALUE;
        }
        if (mapsKey.equals(key) && (!this.checkClazzOnEquals || mapsKey.getClass() == key.getClass())) {
            return this.mValues[idx];
        }
        if (this.next == null) {
            return Integer.MIN_VALUE;
        }
        int res = this.next.getHash(key, hash);
        return res;
    }

    final int getHash(K key, int hash) {
        int idx = hash % this.mKeys.length;
        Object mapsKey = this.mKeys[idx];
        if (mapsKey == null) {
            return Integer.MIN_VALUE;
        }
        if (mapsKey.equals(key) && (!this.checkClazzOnEquals || mapsKey.getClass() == key.getClass())) {
            return this.mValues[idx];
        }
        if (this.next == null) {
            return Integer.MIN_VALUE;
        }
        int res = this.next.getHash(key, hash);
        return res;
    }

    final void resize(int newSize) {
        newSize = FSTObject2IntMap.adjustSize(newSize);
        Object[] oldTabKey = this.mKeys;
        int[] oldTabVal = this.mValues;
        this.mKeys = new Object[newSize];
        this.mValues = new int[newSize];
        this.mNumberOfElements = 0;
        for (int n = 0; n < oldTabKey.length; ++n) {
            if (oldTabKey[n] == null) continue;
            this.put(oldTabKey[n], oldTabVal[n]);
        }
        if (this.next != null) {
            FSTObject2IntMap<K> oldNext = this.next;
            this.next = null;
            super.rePut(this);
        }
    }

    private void rePut(FSTObject2IntMap<K> kfstObject2IntMap) {
        for (int i = 0; i < this.mKeys.length; ++i) {
            Object mKey = this.mKeys[i];
            if (mKey == null) continue;
            kfstObject2IntMap.put(mKey, this.mValues[i]);
        }
        if (this.next != null) {
            super.rePut(kfstObject2IntMap);
        }
    }

    public void clear() {
        if (this.size() == 0) {
            return;
        }
        FSTUtil.clear(this.mKeys);
        FSTUtil.clear(this.mValues);
        this.mNumberOfElements = 0;
        if (this.next != null) {
            this.next.clear();
        }
    }

    public static void main(String[] arg) {
        for (int jj = 0; jj < 100; ++jj) {
            int i;
            int j;
            int i2;
            int count = 500000;
            miss = 0;
            hit = 0;
            FSTObject2IntMap<Object> map = new FSTObject2IntMap<Object>(count / 10, false);
            HashMap<Object, Integer> hm = new HashMap<Object, Integer>(count / 10);
            Object[] obs = new Object[count];
            for (int i3 = 0; i3 < count; ++i3) {
                obs[i3] = "" + Math.random();
            }
            long tim = System.currentTimeMillis();
            for (i2 = 0; i2 < count; ++i2) {
                map.put(obs[i2], i2);
            }
            System.out.println("-----------fst PUT " + (System.currentTimeMillis() - tim));
            tim = System.currentTimeMillis();
            for (i2 = 0; i2 < count; ++i2) {
                hm.put(obs[i2], i2);
            }
            System.out.println("hmap PUT " + (System.currentTimeMillis() - tim));
            tim = System.currentTimeMillis();
            for (j = 0; j < 10; ++j) {
                for (i = 0; i < count; ++i) {
                    if (map.get(obs[i]) == i) continue;
                }
            }
            System.out.println("fst GET " + (System.currentTimeMillis() - tim) + " " + map.size());
            tim = System.currentTimeMillis();
            for (j = 0; j < 10; ++j) {
                for (i = 0; i < count; ++i) {
                    if ((Integer)hm.get(obs[i]) == i) continue;
                }
            }
            System.out.println("hmap GET " + (System.currentTimeMillis() - tim));
            tim = System.currentTimeMillis();
            for (j = 0; j < 10; ++j) {
                for (i = 0; i < count; ++i) {
                    if (map.get("Poki") != i) continue;
                }
            }
            System.out.println("fst FAIL " + (System.currentTimeMillis() - tim));
            tim = System.currentTimeMillis();
            Integer someInt = -134;
            for (int j2 = 0; j2 < 10; ++j2) {
                for (int i4 = 0; i4 < count; ++i4) {
                    if (hm.get("Poki") != someInt) continue;
                }
            }
            System.out.println("hmap FAIL " + (System.currentTimeMillis() - tim));
        }
    }
}

