/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization.serializers;

import de.ruedigermoeller.serialization.FSTBasicObjectSerializer;
import de.ruedigermoeller.serialization.FSTClazzInfo;
import de.ruedigermoeller.serialization.FSTObjectInput;
import de.ruedigermoeller.serialization.FSTObjectOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.EnumSet;

public class FSTEnumSetSerializer
extends FSTBasicObjectSerializer {
    Field elemType;

    @Override
    public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
        EnumSet enset = (EnumSet)toWrite;
        int count = 0;
        out.writeCInt(enset.size());
        if (enset.isEmpty()) {
            EnumSet compl = EnumSet.complementOf(enset);
            out.writeClass(compl.iterator().next());
        } else {
            for (Object element : enset) {
                if (count == 0) {
                    out.writeClass(element);
                }
                out.writeObjectInternal(element, Enum.class);
                ++count;
            }
        }
    }

    @Override
    public boolean alwaysCopy() {
        return false;
    }

    @Override
    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPositioin) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        int len = in.readCInt();
        Class elemCl = in.readClass().getClazz();
        EnumSet<Object> enSet = EnumSet.noneOf(elemCl);
        in.registerObject(enSet, streamPositioin, serializationInfo, referencee);
        for (int i = 0; i < len; ++i) {
            enSet.add(in.readObjectInternal(Enum.class));
        }
        return enSet;
    }
}

